package gov.va.caret.security.util;

//import java.util.Base64;
import org.apache.commons.codec.binary.Base64;

import gov.va.caret.ApplicationWorkFlowException;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES256Crypto {

	 
	 private static AES256Crypto sngleton = null;
	 private String this_key = null;
	 
	 
	 
	 private String key_pad = "G535JiUTTE3boGB1i3FjFhDPDvXgsqxOlPQ9nQXYamhx";//this is used in case short keys get passed - don't change it or nothing will unencrypt
	 private String vector = "835dfcc7bc9964a3";
	 private SecretKeySpec skeySpec;
	 private IvParameterSpec iv;
	 private Cipher encrypt_cipher;
	 private Cipher decrypt_cipher;

	 
	 public static AES256Crypto instance() throws Exception
	 {
		 if(sngleton == null)
			 throw new Exception("AES256Crypto must be initialized prior to use");
		 else		 
			 return sngleton;
	 }
	 
	 public static void init(String key)
	 {
		 
		 sngleton = new AES256Crypto(key);
		 
		 
	 }
	
	 private AES256Crypto(String key)
	 {
		 try{
			 
 
			this_key = key;

			//I want everything to be AES 256.   So make sure the key is 256 bits.  This is 32 characters
			if(this_key.length() < 32)
				 this_key = this_key + key_pad.substring(0,32 - this_key.length());
			else
			if(this_key.length() > 32)
				this_key = this_key.substring(0,32);
		        	
	
			iv = new IvParameterSpec(vector.getBytes("UTF-8"));
        	skeySpec = new SecretKeySpec(this_key.getBytes("UTF-8"), "AES");
        	
        	encrypt_cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        	encrypt_cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);

        	decrypt_cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            decrypt_cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
        	
        	
        	
		 }catch(Exception e)
		 {
			 ApplicationWorkFlowException.handleException(e);
		 }
	 }

	 

 
 
public String encrypt(String value) throws Exception {

    // NOTE : AES256 will not work unless the the Unlimited Strength Jurisdiction Policy files are deployed in the local JRE\libe\security folder.
//    return Base64.getEncoder().encodeToString(encrypt_cipher.doFinal(value.getBytes()));
	return Base64.encodeBase64URLSafeString(value.getBytes());
    
}

public  byte[] decrypt(String value) throws Exception {
	// NOTE : AES256 will not work unless the the Unlimited Strength Jurisdiction Policy files are deployed in the local JRE\libe\security folder. 
//    return new String(decrypt_cipher.doFinal(Base64.getDecoder().decode(value)));
	return Base64.decodeBase64(value);
    
}
	    

}
