package gov.va.caret.security.sso;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.Persn;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;


public class SecuredHeaderLogin implements AutoLogin  {
	
	private static final Log _log = LogFactoryUtil.getLog( SecuredHeaderLogin.class );
	private static final String SITEMINDER_HEADER = "siteminder.user.header";
	private static final String VAAFI_HEADER = PropsUtil.get( "vaafi.user.header" );
	
	
	private void debugHeaders(HttpServletRequest request, HttpServletResponse response) {
		Enumeration<String> headerNames = request.getHeaderNames();
		int count = 0;
		while (headerNames.hasMoreElements()) {
			count++;
			String header = (String) headerNames.nextElement();
			_log.info("header >>> " +header);
			if ( _log.isDebugEnabled() ){
				_log.debug(header + " >>> " + request.getHeader(header));
			}
		}
		_log.info("count >>> " + count);
	}

	private long getCompanyId() {
		return CompanyThreadLocal.getCompanyId();
	}
	
	@Override
	public String[] login( HttpServletRequest request, HttpServletResponse response ) throws AutoLoginException {
		if ( _log.isInfoEnabled() ){
			debugHeaders(request,response);
		}
		try {
			if ( !Toolbox.isEmpty( request.getHeader( PropsUtil.get( SITEMINDER_HEADER ) ) ) ){ //SSOi
				_log.info("SSOi login...");
				siteMinderHeaders(request);
				request.setAttribute("groupSite", GroupLocalServiceUtil.getGroup( getCompanyId(), CaretUtil.getClinicSite() ) );
			} else {
				String screenNameHeader = request.getHeader( VAAFI_HEADER ); 
				if ( !Toolbox.isEmpty( screenNameHeader ) ){
					_log.info("SSOe login...");
					User user = vaafiHeaders(request, screenNameHeader );
					if ( user != null){
						request.setAttribute("groupSite", GroupLocalServiceUtil.getGroup( getCompanyId(), CaretUtil.getOnlineSite() ) );
						return new String[] { String.valueOf(user.getUserId()), user.getPassword(), StringPool.TRUE };
					}
				}
			}
		} catch (SystemException e) {
			e.printStackTrace();
		} catch (PortalException e) {
			e.printStackTrace();
		}
		_log.info("Standard login...");
		return null;
	}

	private User vaafiHeaders ( HttpServletRequest request, String screenNameHeader ) throws SystemException{
		String emailHeader = request.getHeader( "va_eauth_email" );
		String firstNameHeader = request.getHeader( "va_eauth_firstname" );
		String middleNameHeader = request.getHeader( "va_eauth_middlename" );
		String lastNameHeader = request.getHeader( "va_eauth_lastname" );
		String birthdayHeader = request.getHeader( "va_eauth_birthdate" );//YYYY-MM-DDT00:00:00-00:00
		int[] bDay;
		if ( !Toolbox.isEmpty( birthdayHeader) ){ 
			try {
				Date birthday = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader );
				Calendar c = Calendar.getInstance();
				c.setTime(birthday);
				bDay = new int[]{c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), c.get(Calendar.YEAR)};
			} catch (ParseException e) {
				ApplicationWorkFlowException.handleException(e);
				bDay = new int[]{10,15,1980};
			}
		} else {
			bDay = new int[]{10,15,1980};
			_log.warn("missing birthday, using default");
		}
		User user = findUser( screenNameHeader, emailHeader );
		if ( user == null ){
			_log.info("SSOe: didnt find user, attempt activation...");
			if ( ( user = setUser( CaretUtil.getOnlineSite( ), screenNameHeader, emailHeader, firstNameHeader, middleNameHeader, lastNameHeader, true, null, null, bDay ) ) != null )
			try {
				Persn persn = PersnLocalServiceUtil.getByUser( user.getUserId() );
				persn.setAddress( request.getHeader( "va_eauth_street" ) );
				persn.setAddress2( request.getHeader( "va_eauth_street1" ) );
				persn.setSuffix( request.getHeader( "va_eauth_suffix" ) );
				persn.setPrefix ( request.getHeader( "va_eauth_prefix" ) );
				persn.setGender( request.getHeader( "va_eauth_gender" ) );
				persn.setCity(  request.getHeader( "va_eauth_city" ) );
				persn.setState( request.getHeader( "va_eauth_state" ) );
				persn.setZip( request.getHeader( "va_eauth_postalcode" ) );
				persn.setCountry( request.getHeader( "va_eauth_country" ) );
				persn.setPhone( request.getHeader( "va_eauth_phone" ) );
				persn.setICN( request.getHeader( "va_eauth_icn" ) );
				CaretLocalServiceUtil.save(persn);
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		return user;
	}
	
	private void siteMinderHeaders ( HttpServletRequest request ) throws SystemException{
		
		String screenNameHeader = request.getHeader( PropsUtil.get( SITEMINDER_HEADER ) );
		String organization = request.getHeader( "HTTP_ORGANIZATION" );

		long orgId = 0;
		if ( !Toolbox.isEmpty(organization) ){
			try {
				Facil facil = FacilLocalServiceUtil.getByFacilityNumber( organization );
				orgId = facil.getGroupId();
				_log.info("Facility was" + organization );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException("Could not find ORG " + organization );
			}
		}
		
		if ( !Toolbox.isEmpty(screenNameHeader) ){
			String[] roles = request.getHeader( "HTTP_ROLE" ).split(StringPool.COMMA);
			Set<Long> newRoleIds = getRole( roles );

			String emailHeader = request.getHeader( "HTTP_ADEMAIL" );
			User user = findUser( screenNameHeader, emailHeader);

			if ( user == null ){
				String firstNameHeader = request.getHeader( "HTTP_FIRSTNAME" );
				String lastNameHeader = request.getHeader( "HTTP_LASTNAME" );
				setUser( CaretUtil.getClinicSite( ), screenNameHeader, emailHeader, 
					firstNameHeader, StringPool.BLANK, lastNameHeader,
					true, ArrayUtil.toLongArray(newRoleIds), new long[]{orgId}, new int[]{10,15,1980} );
			} else try {  //update the role and facility
				Set<Long> oldGroupIds = new LinkedHashSet<>();
				List<UserGroup> oldRoles = UserGroupLocalServiceUtil.getUserUserGroups( user.getUserId() );
				for (UserGroup oldRole : oldRoles) {
					oldGroupIds.add( oldRole.getUserGroupId() );
				}
				if (!oldGroupIds.equals(newRoleIds)) {
					_log.warn("WARNING: Role has changed from: " + oldRoles + " to " + newRoleIds );
					UserGroupLocalServiceUtil.setUserUserGroups( user.getUserId(), ArrayUtil.toLongArray(newRoleIds) );
				}
				//TODO: update the Facility membership
			} catch (SystemException e) {
				e.printStackTrace();
			} catch (PortalException e) {
				e.printStackTrace();
			}
		}
	}

	private Set<Long> getRole( String[] roleNameHeaders ) throws SystemException {
		Set<Long> roles = new LinkedHashSet<>();
		for ( String roleNameHeader : roleNameHeaders ){
			Role role = RoleLocalServiceUtil.fetchRole( getCompanyId(), CodifiedRole.getRoleName(roleNameHeader) );
			if ( role == null ) {
				ApplicationWorkFlowException.handleException("Could not find ROLE " + roleNameHeader );
			}else{
				roles.add( role.getRoleId() );
			}
		}
		return roles;
	}

	private User findUser( String screenNameHeader, String emailHeader ) throws SystemException {
		User user = null;
		try {
			user = UserLocalServiceUtil.getUserByScreenName( getCompanyId(), screenNameHeader );
		} catch (PortalException e) {} //ignoring exception thrown when the user does not exist... 
		if ( user == null && !Toolbox.isEmpty(emailHeader) ){
			try {
				user = UserLocalServiceUtil.getUserByEmailAddress( getCompanyId(), emailHeader );
			} catch (PortalException e) {} //ignoring exception thrown when the user does not exist... 
			if ( user != null ){
				_log.warn("WARNING: Could not find by SCREEN_NAME, found user by EMAIL: " + user.getEmailAddress() );
			}
		}
		return user;
	}
	
	private User setUser( String site, String screenNameHeader, String emailHeader, String firstName, String middleName, String lastName, 
				boolean isMale, long[] roleIds, long[] orgId, int[] bday  ) throws SystemException {

		_log.info("SSO: user creation..." );
		
		String password = screenNameHeader+".";
		try {
			User adm = UserLocalServiceUtil.getRoleUsers(RoleLocalServiceUtil.getRole(getCompanyId(), RoleConstants.ADMINISTRATOR).getRoleId()).get(0);
			PrincipalThreadLocal.setName( adm.getUserId() );
			PermissionThreadLocal.setPermissionChecker( PermissionCheckerFactoryUtil.create(adm) );
			
			User user = UserServiceUtil.addUser(getCompanyId(), true, password,
					password, false, screenNameHeader, emailHeader, 
					0l, StringPool.BLANK, LocaleUtil.getDefault(), firstName, middleName, 
					lastName, 0, 0, isMale, bday[0], bday[1], bday[2], "CareT User", 
					new long[]{ GroupLocalServiceUtil.getGroup( getCompanyId(), site ).getGroupId() }, orgId, 
					roleIds, new long[]{}, false, new ServiceContext());
			_log.info( "SSO: user creation finished..." + user.getScreenName() );
			return user;
		} catch (Exception e) {
			e.printStackTrace();
		}
		_log.info( "SSO: user creation failed..." );
		return null;
	}


	@Override
	public String[] handleException( HttpServletRequest request, HttpServletResponse response, Exception e )
			throws AutoLoginException {
		return new String[]{ "S-H-L Erred...",  e.getLocalizedMessage() };
	}

}
