package gov.va.caret.security;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.util.CaretStrPool;

import java.util.Arrays;
import java.util.Collection;

import javax.portlet.PortletRequest;

public class CAction {

	public static final String VIEW = "VIEW";
	
	//Role subtypes-----------------------
	public static final String CARET = "CareT";
	public static final String CARET_ONLINE = "Caret-Online";

	public static final String ACTION = "action.";
	public static final String CARET_PORTLET = "caret_WAR_caretportlet";
	
	public static final String SCOPE_DASHBOARD 	= "gov.va.caret.controller.dashboard.config.Dashboard";
	public static final String SCOPE_DASHBD_QS  = "gov.va.caret.view.GenericReport";
	public static final String SCOPE_CALLS 		= "gov.va.caret.model.Call";
	public static final String SCOPE_APPLICATIONS="gov.va.caret.model.VcgAn";
	public static final String SCOPE_VCGS		= "gov.va.caret.model.Vcg";
	public static final String SCOPE_MESSAGES  	= "gov.va.caret.model.PMMessage";
	public static final String SCOPE_UI_EXTRAS 	= "gov.va.caret.view.Extras";

	public static final String CREATE_APPLICATIONS = "CREATE_APPLICATIONS";


	public enum CaretCan {
		
		VIEW,
		IMPERSONATE_ROLE,
		VIEW_VETERANS,
		VIEW_VENDORS, 
		CREATE_VENDORS, 
		//---------------------------------------------------
		
		
		//----------- Dashboards --------------------
		CBOPC_FUNCTION(SCOPE_DASHBOARD),
		CBOPCFM_FUNCTION(SCOPE_DASHBOARD),
		CSC_FUNCTION(SCOPE_DASHBOARD),
		CSL_FUNCTION(SCOPE_DASHBOARD),
		HEALTH_FUNCTION(SCOPE_DASHBOARD),
		TECH_FUNCTION(SCOPE_DASHBOARD),
		VACO_FUNCTION(SCOPE_DASHBOARD),
		//---------------------------------------------------
		
		
		//----------- Queues --------------------
		CBOPC_REVIEW_Q(SCOPE_DASHBD_QS),
		CBOPC_VENDOR_Q(SCOPE_DASHBD_QS),
		CBOPC_VERIFY_Q(SCOPE_DASHBD_QS),
		CBOPC_CONSIDER_Q(SCOPE_DASHBD_QS),
		CBOPC_LOST_CK_Q(SCOPE_DASHBD_QS),
		CBOPC_REJ_PAY_Q(SCOPE_DASHBD_QS),
		CBOPC_DUPL_PAY_Q(SCOPE_DASHBD_QS),
		CBOPC_SUPERVISOR_Q(SCOPE_DASHBD_QS),
		CBOPC_CHAMPVA_Q(SCOPE_DASHBD_QS),
		CBOPC_MY_CSC_Q(SCOPE_DASHBD_QS),
		CBOPC_PRIM_HEALTH_INS_Q(SCOPE_DASHBD_QS),
		CBOPC_TIER_MOD_Q(SCOPE_DASHBD_QS),
		CBOPC_PRIM_REINST_Q(SCOPE_DASHBD_QS),
		CBOPC_VCG_INFO_MOD_Q(SCOPE_DASHBD_QS),
		VISN_CSC_WAIVER_Q(SCOPE_DASHBD_QS),
		//---------------------------------------------------
		
		
		//----------- UI Specific features --------------------
		IDENTITY_MATCHING(SCOPE_UI_EXTRAS),
		STIPEND_CALCULATOR(SCOPE_UI_EXTRAS),
		CSL_FAMILY_RELATIONSHIPS(SCOPE_UI_EXTRAS),
		LOD_QA(SCOPE_UI_EXTRAS),
		VIEW_BLS_RATES(SCOPE_UI_EXTRAS),
		APPROVE_TIU_REWRITE(SCOPE_UI_EXTRAS),
		PERFORM_TIU_REWRITE(SCOPE_UI_EXTRAS),
		
		//---------------------------------------------------
		
		//----------- TODO --------------------
//		VIEW_PAYMENTS,
//		CREATE_AD_HOC_PAYMENTS,
//		STOP_PAYMENTS,
//		FINANCE_PAYMENTS,
		//---------------------------------------------------
		
		//----------- Calls and Referrals --------------------
		VIEW_CALLS(SCOPE_CALLS),
		CREATE_CALLS(SCOPE_CALLS),
		DISPOSITION_CALLS(SCOPE_CALLS),
		ASSOCIATE_CALLS(SCOPE_CALLS),
		CREATE_CALL_TYPE(SCOPE_CALLS),
		CREATE_CESP(SCOPE_CALLS),
		CREATE_SOC(SCOPE_CALLS),
		VIEW_REFERRAL(SCOPE_CALLS),
		CREATE_REFERRAL(SCOPE_CALLS),
		ASSOCIATE_REFERRAL(SCOPE_CALLS),
		REFERRAL_ATTACHMENT(SCOPE_CALLS),
		ALTER_CALL_NOTES(SCOPE_CALLS),
		//---------------------------------------------------
		
		//----------- Messages --------------------
		READ_MESSAGES(SCOPE_MESSAGES),
		REPLY_MESSAGES(SCOPE_MESSAGES),
		INTERNAL_MESSAGE(SCOPE_MESSAGES),
		//---------------------------------------------------
		
		//----------- Applications --------------------
		CREATE_APPLICATIONS(SCOPE_APPLICATIONS),
		PROCESS_APPLICATIONS(SCOPE_APPLICATIONS),
		ASSOCIATE_APPLICATIONS(SCOPE_APPLICATIONS),
		//---------------------------------------------------
		
		//----------- VCGs --------------------
		CREATE_VCG(SCOPE_VCGS),
		MANAGE_VCG(SCOPE_VCGS),
		DISPOSITION_VCG(SCOPE_VCGS),
		UPDATE_TIER_LEVEL(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_ICN(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_ADDRESS(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_INSURANCE(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_FACILITY(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_VETERAN_LNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_VETERAN_FNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_PRIMARY_LNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_PRIMARY_FNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_CG_LNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_CG_FNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_MNAME(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_GENDER(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_BDAY(SCOPE_VCGS),
		UPDATE_ACTIVE_VCG_SSN(SCOPE_VCGS),
		SET_GENERAL_CG(SCOPE_VCGS),
		CREATE_CSC_WAIVER(SCOPE_VCGS),
		CREATE_VACO_WAIVER(SCOPE_VCGS),
		TRACK_ASSESSMENT(SCOPE_VCGS),
		VIEW_DELETED_DOCS(SCOPE_VCGS);
		//---------------------------------------------------

		

		
		String scopeName;
		CaretCan(){ 
			scopeName = CARET_PORTLET;
		}
		CaretCan(String scope){
			scopeName = scope;
		}
		
		public Collection<CaretCan> getCbopcQues (){
			return Arrays.asList( new CaretCan[] { CaretCan.CBOPC_REVIEW_Q,
					CaretCan.CBOPC_VENDOR_Q,
					CaretCan.CBOPC_VERIFY_Q,
					CaretCan.CBOPC_CONSIDER_Q,
					CaretCan.CBOPC_LOST_CK_Q,
					CaretCan.CBOPC_REJ_PAY_Q,
					CaretCan.CBOPC_DUPL_PAY_Q,
					CaretCan.CBOPC_SUPERVISOR_Q,
					CaretCan.CBOPC_PRIM_REINST_Q,
					CaretCan.CBOPC_MY_CSC_Q,
					CaretCan.CBOPC_PRIM_HEALTH_INS_Q,
					CaretCan.CBOPC_TIER_MOD_Q,
					CaretCan.CBOPC_CHAMPVA_Q } );
		}
		
		public String toString(){
			return ACTION + this.name();
		}
		
		public String getScopeName(){
			return scopeName;
		}
	}
	
	
	public enum OnlineCan {
		VETERAN_FUNCTION,
		CAREGIVER_FUNCTION,

		CREATE_APPLICATIONS,
		DOWNLOAD_APPLICATION_PDF,
		
		VIEW_STIPEND,
		UPLOAD_POA,
		
		SEARCH_MVI,
//		CREATE_MESSAGES,
		REPLY_MESSAGES
	}
	
	public static boolean canDoOnline ( PortletRequest request, String canDo ) {
		boolean ret = false;
		try {
			ThemeDisplay themeDisplay = getThemeDisplay( request );
			ret = PortletPermissionUtil.contains(  themeDisplay.getPermissionChecker(), themeDisplay.getLayout(), 
					PortalUtil.getPortletId( request ), 
					canDo );
			
		} catch (PortalException e) {
		} catch (SystemException e) {
		}
//		_log.info( canDo.name() + StringPool.COLON + ret );
		return ret;
	}
	public static ThemeDisplay getThemeDisplay ( PortletRequest request ){
		return (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	}
	public static PermissionChecker getPermissionChecker ( PortletRequest request ){
		return getThemeDisplay(request).getPermissionChecker();
	}
	
	public static boolean canDoCaret ( PortletRequest request, CaretCan canDo ) {
		return getPermissionChecker(request).hasPermission( getThemeDisplay(request).getScopeGroupId(), canDo.scopeName, StringPool.AT, canDo.name());
	}

	public static boolean canDoCaret ( PortletRequest request, String canDo ) {
		return canDoCaret(request, CaretCan.valueOf(canDo) );
//		_log.info( canDo.name() + StringPool.COLON + ret );
	}
	
	public static boolean canDoCaret ( PortletRequest request, CaretCan canDo, Long groupId ) {
		return getPermissionChecker(request).hasPermission(groupId, canDo.scopeName, StringPool.AT, canDo.name());
	}
	
	public static boolean canDoCaret ( PermissionChecker permissionChecker, CaretCan canDo, Long groupId ) {
		return permissionChecker.hasPermission(groupId, canDo.scopeName, StringPool.AT, canDo.name());
	}
//	
//	public static Map<String, Boolean> getMap ( PortletRequest request ) {
//		Map<String, Boolean> map = new CaretMap<String, Boolean>(false);
//		for ( CAction.CaretCan canDo : CAction.CaretCan.values() ){
//			try {
//				boolean ret = PortletPermissionUtil.contains( 
//						( (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY) ).getPermissionChecker(),
//						PortalUtil.getPortletId( request ),
//						canDo.name() );
////				_log.info( canDo.name() + StringPool.COLON + ret );
//				map.put(canDo.name(), ret);
//			} catch (PortalException e) {
//			} catch (SystemException e) {
//			}
//		}
//		return map;
//	}


	public static boolean isOmniAdmin(PortletRequest request) {
		return getThemeDisplay( request ).getPermissionChecker().isOmniadmin();
	}
	
	public static boolean canImpersonate(PortletRequest request) {
		return canDoCaret(request, CaretCan.IMPERSONATE_ROLE.name() );
	}

	public static OnlineDashboardConfig loadOnlineRoleId ( PortletRequest request ){
		return setOnlineRoleContext( request, null );
	}
	
	public static OnlineDashboardConfig setOnlineRoleContext ( PortletRequest request, OnlineDashboardConfig useRole ){
		if ( useRole == null ){
			OnlineDashboardConfig onlineDashboardConfig = 
					( OnlineDashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG );
			if ( onlineDashboardConfig == null ){
				for ( OnlineDashboardConfig onlineDashConfig : OnlineDashboardConfig.values() ){
					if ( canDoOnline( request, onlineDashConfig.name() ) ){
						request.getPortletSession().setAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG, onlineDashConfig);
						return onlineDashConfig;
					}
				}
				return null;
			}
			return onlineDashboardConfig;
		} else {
			if (  canDoOnline( request, useRole.name() ) ){
				request.getPortletSession().setAttribute( CaretStrPool.ONLINE_DASHBOARD_CONFIG, useRole);
				return useRole;
			}
			return null;
		}
	}
	
}
