package gov.va.caret.portlet.resource;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ProcessAction;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;

import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PushbuttonField;
import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Junction;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.bean.AttachmentBean;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.letters.CscLetterType;
import gov.va.caret.letters.LetterFields;
import gov.va.caret.letters.PopulateLettersImpl;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.VetVr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.AssmtImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.impl.VetVrImpl;
import gov.va.caret.model.support.CallSupport;
import gov.va.caret.model.support.General;
import gov.va.caret.model.support.ModelConfig;
import gov.va.caret.model.support.NoteSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Person.Changes;
import gov.va.caret.pdf.FileType;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.ServicePerson;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pm.portlet.PMPortlet;
import gov.va.caret.security.CAction;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BlsAeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.NoteLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.VetVrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.ctssh.CTSSHConstants;
import gov.va.caret.service.ctssh.CTSSHFacade;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

public class CaretResourceCommand extends ResourceCommand implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public String getCities ( ResourceRequest request, ResourceResponse response ){
		return super.getCities(request, response);
	}
	public String getZips ( ResourceRequest request, ResourceResponse response ){
		return super.getZips(request, response);
	}
	public void getUSPSZips ( ResourceRequest request, ResourceResponse response ){
		super.getUSPSZips(request, response);
	}
	public String getFacils ( ResourceRequest request, ResourceResponse response ){
		return super.getFacils(request, response);
	}
	
	public void getUserList ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		super.getUserList(request, response);
	}
	
	public boolean canImpersonate( PortletRequest request ){
		if ( CAction.canDoCaret(request, CAction.CaretCan.IMPERSONATE_ROLE.name() ) ){
			String impersonationMode = request.getParameter("impersonationMode");
			if ( impersonationMode != null && !impersonationMode.isEmpty() ) {
				request.getPortletSession().setAttribute(CaretStrPool.IMPERSONATE, impersonationMode);
				request.getPortletSession().setAttribute(CaretStrPool.IMPERSONATE_ID, ParamUtil.getLong( request, ReportParameter.userId.name() ) );
				request.getPortletSession().setAttribute(CaretStrPool.IMPERSONATE_ROLE_ID, ParamUtil.getLong( request, ReportParameter.roleId.name() ) );
			}
			return true;
		}
		_log.info("IMP=false");
		return false;
	}
		
	public String impersonate ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		return writeJson ( response, JSONFactoryUtil.createJSONObject().put( CaretStrPool.FORM, canImpersonate(request) ) );
	}
		
	public String getRoleUsers ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		JSONObject jsonUser, json = JSONFactoryUtil.createJSONObject();
		Long roleId = ParamUtil.getLong(request, "roleId");
		if ( roleId > 0 ) try {
			List<User> users = UserLocalServiceUtil.getRoleUsers(roleId);
			if ( !users.isEmpty() ){
				JSONArray jsonUsers = JSONFactoryUtil.createJSONArray();
				json.put("size", users.size());
				for ( User cont : users ){
					jsonUser = JSONFactoryUtil.createJSONObject();
					jsonUser.put( "userId", cont.getUserId() );
					jsonUser.put("fullName", cont.getFullName() );
					jsonUsers.put(jsonUser);
				}
				json.put("users", jsonUsers);
			} else {
				json.put("size", 0 );
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		return writeJson ( response, json );
	}
	
	public String searchMvi ( ResourceRequest request, ResourceResponse response ){
		
		try {
			Persn persn = new ServicePerson( request, new PersnImpl() );
			Map<String,Object> attributes = new HashMap<String,Object>();
			attributes.put(CaretStrPool.FIRSTNAME, request.getParameter(CaretStrPool.FIRSTNAME) );
			attributes.put(CaretStrPool.LASTNAME, request.getParameter(CaretStrPool.LASTNAME) );
			attributes.put(CaretStrPool.GENDER, request.getParameter(CaretStrPool.GENDER) );
			attributes.put(CaretStrPool.SSN, request.getParameter(CaretStrPool.SSN) );
			attributes.put(CaretStrPool.ADDRESS, request.getParameter(CaretStrPool.ADDRESS) );
			attributes.put(CaretStrPool.BIRTHDATE, request.getParameter(CaretStrPool.BIRTHDATE) );
			attributes.put(CaretStrPool.PHONE, request.getParameter(CaretStrPool.PHONE) );
			
			persn.setModelAttributes(attributes);
			JSONObject json = JSONFactoryUtil.createJSONObject();
			json.put("vcgs", (JSONArray) persn.getModelAttributes().get("doAttended") );
			return writeJson ( response, json );
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		return StringPool.BLANK;
	}
	
	public String searchMviOld ( ResourceRequest request, ResourceResponse response ){
		
		 
		JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
		JSONArray vcgs = JSONFactoryUtil.createJSONArray();
		
		Map<String, String> map = getMviMap( request );
		boolean skipSearch = Toolbox.isEmpty( map.get( CTSSHConstants.FLD_MVI_LASTNAME ) ) || 
				Toolbox.isEmpty( map.get( CTSSHConstants.FLD_MVI_FIRSTNAME ) );
		List<Person> list = null;
		int size = 0;
		if ( !skipSearch ){
			list = CTSSHFacade.getInstance().searchAttended( map, request );
			size = list.size();
			_log.info("user size vcgs.. " + size );
			json.put("size", size );
		}
			
		if ( skipSearch || list.size() == 0 ){
				vcg = JSONFactoryUtil.createJSONObject();
				vcg.put(CaretStrPool.PRIMARY_KEY, 0 );
				ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
				String noPersonsFound = LanguageUtil.get(themeDisplay.getLocale(), "no-persons-found", "No Persons found" );
				vcg.put("fullName", noPersonsFound );
				vcgs.put(vcg);
			} else {
				for ( Person p : list ){
					vcg = JSONFactoryUtil.createJSONObject();
					
					vcg.put("fullName", p.getFirstName() + " " + p.getMiddleName() + " " +  p.getLastName() );
					vcg.put( CaretStrPool.PRIMARY_KEY, p.getPrimaryKey() );
					vcg.put(CaretStrPool.SSN, p.getSsn() );
					vcg.put(CaretStrPool.BIRTHDATE, Toolbox.nullSafe( Toolbox.formatDateCprs( p.getBirthDate() ) ) );
					vcg.put(CaretStrPool.LASTNAME, p.getLastName() );
					vcg.put(CaretStrPool.FIRSTNAME, p.getFirstName() );
					vcg.put("middleName", Toolbox.nullSafe( p.getMiddleName() ) );
					vcg.put("suffix", Toolbox.nullSafe((p.getSuffix() )) );
					vcg.put("phone", Toolbox.nullSafe( p.getPhone() ));
//					vcg.put("phone2", Toolbox.nullSafe(p.getPhone2() ));
					vcg.put("email", Toolbox.nullSafe( p.getEmail() ) );
					vcg.put(CaretStrPool.ADDRESS, Toolbox.nullSafe( p.getAddress() ) );
					vcg.put(CaretStrPool.CITY, Toolbox.nullSafe( p.getCity() ) );
					vcg.put(CaretStrPool.ZIP, Toolbox.nullSafe( Toolbox.formatZip( p.getZip() ) ) );
					vcg.put(CaretStrPool.GENDER, Toolbox.nullSafe( p.getGender() ) );
					vcg.put(CaretStrPool.STATE, Toolbox.nullSafe(p.getState()) );
					vcg.put(CaretStrPool.GROUP_ID, p.getGroupId() );
					vcgs.put(vcg);
				}
			}
			
			json.put("vcgs", vcgs);
			
        
        
        return writeJson ( response, json );
	}
	
	public String searchVcg ( ResourceRequest request, ResourceResponse response ){
		String local = searchPerson(request, response, ParamUtil.getBoolean(request, "mviInclusion") );
		if ( CaretStrPool.EMPTY_ASSET.equals(local) && StringPool.TRUE.equals( CaretUtil.isMviEnabled() ) ) {
			return searchMvi(request, response);
		} 
		return StringPool.BLANK;
	}
	
	public String searchLocalVcg ( ResourceRequest request, ResourceResponse response ){
		return searchPerson(request, response, false);
	}
	
	public String searchPerson ( ResourceRequest request, ResourceResponse response, boolean restricted ){
		String NULL = null;
		String fname = ParamUtil.get(request, CaretStrPool.FIRSTNAME, NULL);
		 String lname = ParamUtil.get(request, CaretStrPool.LASTNAME, NULL);
			 String gender = ParamUtil.get(request, CaretStrPool.GENDER, NULL);
			 String ssn = ParamUtil.get(request, CaretStrPool.SSN, NULL);
			 String address = ParamUtil.get(request, CaretStrPool.ADDRESS, NULL );
			 String birthdate = ParamUtil.get(request, CaretStrPool.BIRTHDATE, NULL );
			 String phone = ParamUtil.get(request, CaretStrPool.PHONE, NULL );
			 String phone2 = ParamUtil.get(request, "phone2", NULL );
			 String searchType = getValue(request, "searchType" );
			 
			 _log.info ( "call Local search with :");

			 _log.info( "fname="+ fname + ", lname=" + lname  );
			 
//			 Boolean includeMulti = Boolean.valueOf( String.valueOf(request.getParameterMap().get("includeMulti") ) );
			 
			 boolean uniqueFactor = restricted || CaretStrPool.ACTIVE_VCG.equals( searchType ) ;
			 
			 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
			 if ( ! fname.isEmpty() ){
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).like(fname) );
			 }
			 
			 if ( ! lname.isEmpty() ){
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).like(lname) );
			 }
			 
			 if ( uniqueFactor ){
				 Junction junction = RestrictionsFactoryUtil.disjunction();
				 junction.add( PropertyFactoryUtil.forName("externalId").isNotNull() );
				 junction.add( PropertyFactoryUtil.forName("persnUserId").gt( Long.valueOf(0) ) );
				 dynamicQuery.add( junction );
//			 } else {
//				 dynamicQuery.setProjection(ProjectionFactoryUtil
//					 .distinct( ProjectionFactoryUtil.property(CaretStrPool.FIRSTNAME)) );
			 }
			 
//			try {
				JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
				JSONArray vcgs = JSONFactoryUtil.createJSONArray();

				boolean skipSearch = lname.isEmpty();
				List<Person> list = Collections.EMPTY_LIST;
				int size = 0;
				if ( !skipSearch ){
					
//					dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PERSN_USER_ID).gt(Long.valueOf(0)) );
					List<Persn> listLocal;
					try {
						listLocal = PersnLocalServiceUtil.dynamicQuery( dynamicQuery );
					} catch (SystemException e) {
						listLocal = Collections.emptyList();
					}
					if ( listLocal.isEmpty() && CaretUtil.isMviEnabled() ){
						try {
							ServicePerson sp = new ServicePerson(request, new PersnImpl() );
							Map<String,Object> attributes = new HashMap<String,Object>();
							attributes.put(CaretStrPool.FIRSTNAME, fname );
							attributes.put(CaretStrPool.LASTNAME, lname );
							attributes.put(CaretStrPool.BIRTHDATE, birthdate );
							attributes.put(CaretStrPool.SSN, ssn );
							attributes.put(CaretStrPool.GENDER, gender );
							attributes.put(CaretStrPool.ADDRESS, address );
							attributes.put(CaretStrPool.PHONE, phone );
							sp.setModelAttributes(attributes);
							Object o = sp.getModelAttributes().get("doAttended");
							if ( o != null && o instanceof List ){
								list = ( List ) o;
							}
						} catch (Exception e) {
							e.printStackTrace();
						}
//						list = CTSSHFacade.getInstance().searchAttended( getMviMap( request ), request );
					} else {
						list = new ArrayList<Person>();
						for ( Persn persn: listLocal ){
							list.add( new Person(persn) );
						}
					}
					
					size = list.size();
					_log.info("user size vcgs.. " + size );
					json.put("size", size );
				}
				
				Set<String> temp = new LinkedHashSet<String>();
				
				if ( skipSearch || list.size() == 0 ){
					vcg = JSONFactoryUtil.createJSONObject();
					vcg.put(CaretStrPool.PRIMARY_KEY, 0 );
					ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
					String noPersonsFound = LanguageUtil.get(themeDisplay.getLocale(), "no-persons-found", "No Persons found" );
					vcg.put("fullName", noPersonsFound );
					vcgs.put(vcg);
				} else {
					for ( Person p : list ){
						if ( !uniqueFactor && temp.contains( p.toSearchString() ) ){
							continue;
						}
						temp.add( p.toSearchString() );
						vcg = JSONFactoryUtil.createJSONObject();
						
						vcg.put( CaretStrPool.PRIMARY_KEY, p.getPrimaryKey() );
						vcg.put(CaretStrPool.SSN, p.getSsn() );
						vcg.put(CaretStrPool.BIRTHDATE, p.getBirthDateStr() );
						vcg.put(CaretStrPool.LASTNAME, p.getLastName() );
						vcg.put(CaretStrPool.FIRSTNAME, p.getFirstName() );
						vcg.put("middleName", Toolbox.nullSafe( p.getMiddleName() ) );
						vcg.put("suffix", Toolbox.nullSafe((p.getSuffix() )) );
						vcg.put("phone", Toolbox.nullSafe( p.getPhone() ));
//						vcg.put("phone2", Toolbox.nullSafe(p.getPhone2() ));
						vcg.put("email", Toolbox.nullSafe( p.getEmail() ) );
						vcg.put(CaretStrPool.ADDRESS, Toolbox.nullSafe( p.getAddress() ) );
						vcg.put(CaretStrPool.CITY, Toolbox.nullSafe( p.getCity() ) );
						vcg.put(CaretStrPool.ZIP, Toolbox.nullSafe( p.getZip() ) );
						vcg.put(CaretStrPool.GENDER, Toolbox.nullSafe( p.getGender() ) );
						vcg.put(CaretStrPool.STATE, Toolbox.nullSafe(p.getState()) );
						
						vcg.put(CaretStrPool.FOREIGNER, p.isForeigner() );
						vcg.put(CaretStrPool.VALID_USPS_ADDRESS, p.isValidUspsAddress() );
						
						vcg.put(CaretStrPool.GROUP_ID, p.getGroupId() );
						if ( CaretStrPool.ACTIVE_VCG.equals( searchType ) || CaretStrPool.VCG_CREATION.equals( searchType ) ){
							vcg.put(CaretStrPool.FACILITY_NAME, p.getFacilityName() );
							Veteran v = new Veteran(p);
							Object[] actives;
							if ( CaretStrPool.ACTIVE_VCG.equals( searchType ) ){
								actives = v.getActives();
							} else {
								actives = v.getVcgActives();
							}
							vcg.put(Veteran.VA_HEALTH_ENROLLED_ATTRIBUTE, v.getVaHealthEnrolled() );
							vcg.put(CaretStrPool.ACTIVE_VCG, !"0".equals( String.valueOf( actives[0]) ) ) ;
							vcg.put("linked",  !"0".equals( String.valueOf( actives[0]) ) );
							vcg.put("iCN",  Toolbox.nullSafe( p.getICN() ) );
							vcg.put("vcgId",  String.valueOf( actives[0] ) );
							vcg.put("fullName", p.getFullName() + ( "0".equals( String.valueOf( actives[0]) ) ? "(New VCG)" : "(Update VCG)" ) );
						} else {
							vcg.put("fullName", p.getFullName() );
						}
						vcgs.put(vcg);
					}
				}
				
				json.put("vcgs", vcgs);

				writeJson ( response, json );
				
				if ( size == 0 ){
					return CaretStrPool.EMPTY_ASSET;
				} else {
					return StringPool.BLANK;
				}

	}
	
	
	private Map<String, String> getMviMap(ResourceRequest request) {
		
		String fname = ParamUtil.get(request, CaretStrPool.FIRSTNAME, StringPool.BLANK);
		 String lname = ParamUtil.get(request, CaretStrPool.LASTNAME, StringPool.BLANK);
		 
		 String ssn = getValue(request, CaretStrPool.SSN);
		 if ( !Toolbox.isEmpty(ssn) ){
			 ssn = ssn.replace(StringPool.DASH, StringPool.BLANK);
		 }
		 
		 String birthdate = getValue(request, CaretStrPool.BIRTHDATE );
		 if (  !Toolbox.isEmpty(birthdate) ){
			 birthdate = Toolbox.formatDateOrient( Toolbox.parseDate(birthdate) );
		 }
		
		 Map<String,String> map = new HashMap<String,String>();
		 
		 map.put(CTSSHConstants.FLD_MVI_LASTNAME, lname );
		 map.put(CTSSHConstants.FLD_MVI_FIRSTNAME, fname );
		 map.put(CTSSHConstants.FLD_MVI_DOB, birthdate );
		 map.put(CTSSHConstants.FLD_MVI_SSN, ssn );
		 map.put(CTSSHConstants.FLD_MVI_MIDDLENAME, getValue(request, "middleName" ) );
		 map.put(CTSSHConstants.FLD_MVI_SUFFIX, getValue(request, "suffix") );
		 map.put(CTSSHConstants.FLD_MVI_PATIENT_TELEPHONE, getValue(request, "phone" ) );
		 map.put(CTSSHConstants.FLD_MVI_STREETADDRESS1, getValue(request, CaretStrPool.ADDRESS ) );
		 map.put(CTSSHConstants.FLD_MVI_CITY, getValue(request, CaretStrPool.CITY) );
		 map.put(CTSSHConstants.FLD_MVI_POSTALCODE, getValue(request, CaretStrPool.ZIP) );
		 map.put(CTSSHConstants.FLD_MVI_STATE, getValue(request, CaretStrPool.STATE) );
		 map.put(CTSSHConstants.FLD_MVI_GENDER, getValue(request, CaretStrPool.GENDER ) );
		return map;
	}
	
	public void getOutput( PortletRequest request ){
		CaretViewController.getViewController().getOutput(request);
	}
	
	private void validate( PortletRequest request, Person formPerson, Person vcgPerson, StringBuilder errorSb, StringBuilder warnSb, int level, boolean isActive){
		boolean changes[] = new boolean[5];
		for ( String error : CaretViewController.getViewController().setVcgPerson(request, formPerson, vcgPerson, changes) ){
			errorSb.append("<li>").append(error).append("</li>");
		}
		String notifier = isActive? "CBOPC Work Item :": "System Profile Update :";
		if ( level > 0 || isActive ){
			for ( int i = 0; i < Changes.values().length; i++){
				if ( changes[i] ){
					warnSb.append("<li>").append(notifier).append( vcgPerson.getRole() ).append(StringPool.DASH).append(Person.Changes.values()[i].name()).append("</li>");
				}
			}
		}
	}
	
	public String validateCreateVcg( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException {
		
		JSONObject json = JSONFactoryUtil.createJSONObject();
		long veteranId = ParamUtil.getLong(request, "vcg_veteranId", 0);
		if ( veteranId == 0 ){
			json.put("errors", "<li>VCG requires VeteranId</li>");
			json.put(CaretStrPool.FORM, true);
			return writeJson(response, json);
		}

//		getOutput(request);
		
		StringBuilder errorSb = new StringBuilder();
		StringBuilder warnSb = new StringBuilder();
		long primaryId = ParamUtil.getLong(request, "vcg_primaryId", 0);
		long secondaryId = ParamUtil.getLong(request, "vcg_secondaryId", 0);
		long secondaryTwoId = ParamUtil.getLong(request, "vcg_secondaryTwoId", 0);

		try {
			long vcgAnId = ParamUtil.getLong( request, CaretStrPool.VCGANID );
			VcgSupport vcg = VcgSupport.getVeteranVcg( veteranId );
//					LocalServiceUtil.getVeteranVcg( veteranId );
			VcgAn vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
			int level = 0;
			if ( StringPool.TRUE.equals( PortletProps.get("person.updates.warn") ) ){
				level++;
			}
			
			if ( vcgAn.getVeteranId() != veteranId ){
				Veteran appVeteran = new Veteran ( PersnLocalServiceUtil.getPersn( vcgAn.getVeteranId() ) );
				validate(request, appVeteran,
						new Veteran ( PersnLocalServiceUtil.getPersn( veteranId ) ),
						errorSb, warnSb, level, vcg.getVcgId() > 0 );
			}
			if ( vcgAn.getPrimaryId() > 0 && primaryId > 0 ){
				if ( vcg != null && vcg.getPrimaryId() > 0 && VcgSupport.isActive( vcg.getPrimaryDispReason() ) ){
					errorSb.append("<li>VCG - Primary Slot already reserved!</li>");
				} else if ( vcgAn.getPrimaryId() != primaryId ){  //from CSC App
					validate(request, new Primary ( PersnLocalServiceUtil.getPersn( vcgAn.getPrimaryId() ) ),
							new Primary ( PersnLocalServiceUtil.getPersn( primaryId ) ),
							errorSb, warnSb, level, VcgLocalServiceUtil.getVcgPrimaryCount( primaryId, "IN_PROCESS" ) > 0 );
				} 
			}
			if ( vcgAn.getSecondaryId() > 0  && secondaryId > 0 ){
				if ( vcg != null && vcg.getSecondaryId() > 0 && VcgSupport.isActive( vcg.getSecondaryDispReason() )  ){
					errorSb.append("<li>VCG - Secondary Slot already reserved!</li>");
				} else if ( vcgAn.getSecondaryId() != secondaryId ){  //from CSC App
					validate(request, new Secondary ( PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryId() ) ),
							new Secondary ( PersnLocalServiceUtil.getPersn( secondaryId ) ), 
							errorSb, warnSb, level, false );
				}
			}
			if ( vcgAn.getSecondaryTwoId() > 0 && secondaryTwoId > 0 ){
				if ( vcg != null && vcg.getSecondaryTwoId() > 0 && VcgSupport.isActive( vcg.getSecondaryTwoDispReason() ) ){
					errorSb.append("<li>VCG - Secondary II Slot already reserved!</li>");
				} else if ( vcgAn.getSecondaryTwoId() != secondaryTwoId ){  //from CSC App
					validate(request, new SecondaryTwo ( PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryTwoId() ) ),
							new SecondaryTwo ( PersnLocalServiceUtil.getPersn( secondaryTwoId ) ),
							errorSb, warnSb, level, false );
				}
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} 

		json.put("warnings", warnSb.toString());
		json.put("errors", errorSb.toString());
		json.put(CaretStrPool.FORM, true);
		
		return writeJson(response, json);
	}
	
	
	public String loadTier ( ResourceRequest request, ResourceResponse response ) {
		
		long persnId = ParamUtil.getLong(request, "persnId");
		long vcgId = ParamUtil.getLong(request, "vcgId");
		try {
			Person person = null;
			if (persnId > 0){
				person = new Person( PersnLocalServiceUtil.getPersn(persnId) );
			}
		
			Map<String,String> disabled = new CaretMap<String,String>("disabled");
			Map<String,Object> form = ResultMap.getForm(request);
			form.put( "person", person);
			
			form.put( "tierTypes", PortletProps.getArray("tier-types") );
			
			VcgSupport vcg = new VcgSupport ( VcgLocalServiceUtil.getVcg(vcgId) );
			if ( vcg.getPrimaryId() == persnId ){
				form.put( "tier", vcg.getTierLevel() );
				form.put( "tierEffectiveDate", Toolbox.formatDateCprs( vcg.getTierEffectiveDate() ) );
				try {
					VcgAn app = VcgAnLocalServiceUtil.getVcgAn( vcg.getPrimaryVcgAnId() );
					Date date = app.getReceivedDate();
					if ( date == null ){
						date = app.getSubmitDate();
					}
					form.put( "tierDateData", Collections.singletonMap("statusDate", Toolbox.formatDateCprs( date )) );
				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
//				if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_TIER_LEVEL.name() ) ){
					disabled.put("tierEffectiveDate", StringPool.BLANK );
					disabled.put("dispositionDate", StringPool.BLANK );
					disabled.put("tier", StringPool.BLANK );
//				}
			}

			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
			
			Map<String,String> dispositionDateData = new HashMap<String,String>();
			dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "disposition-date-info") );
			dispositionDateData.put("statusDate", Toolbox.formatDateCprs( vcg.getPrimaryVcgAn().getReceivedDate() ) );
			dispositionDateData.put("maxDate", Toolbox.formatDateCprs( Toolbox.adjustDate(30, new Date(), true) ) );
			form.put( "dispositionDateData", dispositionDateData );
			form.put( "appReceivedDate", Toolbox.formatDateCprs( vcg.getPrimaryVcgAn().getReceivedDate() ));
			form.put( "assessmentComplete", vcg.isPrimaryAssmtComplete() );
			form.put("disabled", disabled);
			request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );

		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return request.getParameter("page");
	}
	
	public String loadDisposition ( ResourceRequest request, ResourceResponse response ) {
		getOutput( request );
		
		long persnId = ParamUtil.getLong(request, "persnId");
		long vcgId = ParamUtil.getLong(request, "vcgId");
		String page = request.getParameter("page");
	
		Map<String,String> disabled = new CaretMap<String,String>(StringPool.BLANK);
		Map<String,Object> form = ResultMap.getForm(request);

		Person person = null;
	
		boolean vacoWaiver = false, waiver = false;
		
		if ( CAction.canDoCaret( request, CAction.CaretCan.DISPOSITION_VCG.name() ) ){
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
			VcgSupport vcg = VcgSupport.getVcgSupport(vcgId);
			String dispositionDate = null, 
					appReceivedDate = null,
					statusDate = null,
					maxDate = null,
					oldDispositionState = StringPool.BLANK;
			Map<String,String> dispositionDateData = new HashMap<String,String>();
			if ( vcg.getPrimaryId() == persnId ){
				person = vcg.getPrimary();
				oldDispositionState = vcg.getPrimaryDispReason();
				appReceivedDate = Toolbox.formatDateCprs( vcg.getPrimaryVcgAn().getApplicationDate() );
				dispositionDate = Toolbox.formatDateCprs( vcg.getPrimaryDispositionDate() );
				statusDate = appReceivedDate;
				if ( vcg.isInProcess( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "disposition-date-info") );
					setFormTier(form, disabled, vcg, appReceivedDate);
					if ( vcg.isVacoWaiverPrimary() ){
						vacoWaiver = true;
					} else {
						waiver = vcg.isWaiverPrimary();
					}
				} else if ( vcg.isRevoked( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "revocation-date-info") );
					Date today = new Date();
					Date backDate = Toolbox.adjustDate(1, vcg.getPrimaryRevocationDate( ), true);
					if ( today.before(backDate) ){
						backDate = today;
					}
					statusDate = Toolbox.formatDateCprs( backDate );
					Date lastDayBeforeAdmin = Toolbox.adjustBusinessDate(30, vcg.getPrimaryRevocationDate( ), true );
					if ( lastDayBeforeAdmin.after(today) ){
						lastDayBeforeAdmin = today;
					}
					maxDate = Toolbox.formatDateCprs( lastDayBeforeAdmin );
					form.put( "reinstateEnd", Toolbox.formatDateCprs( Toolbox.adjustDate(40, vcg.getPrimaryRevocationDate( ), true ) ) );
					form.put( "revocationDate", Toolbox.formatDateCprs( vcg.getPrimaryRevocationDate( ) )  );
					setFormTier(form, disabled, vcg, appReceivedDate);
				} else if ( vcg.isApproved( oldDispositionState ) ){
					statusDate = dispositionDate;
				}
				form.put( "dispositionChoices", vcg.getPrimaryDispChoices() );
				form.put( "dispositionReasons", vcg.getPrimaryDispReasons() );
				form.put( "assessmentComplete", vcg.isPrimaryAssmtComplete() );
			} else if ( vcg.getSecondaryId() == persnId ){
				person = vcg.getSecondary();
				oldDispositionState = vcg.getSecondaryDispReason();

				appReceivedDate = Toolbox.formatDateCprs( vcg.getSecondaryVcgAn().getReceivedDate() );
				dispositionDate = Toolbox.formatDateCprs( vcg.getSecondaryDispositionDate() );
				statusDate = appReceivedDate;
				if ( vcg.isInProcess( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "disposition-date-info") );
					if ( vcg.isVacoWaiverSecondary() ){
						vacoWaiver = true;
					} else {
						waiver = vcg.isWaiverSecondary();
					}
				} else if ( vcg.isRevoked( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "revocation-date-info") );
					Date today = new Date();
					Date backDate = Toolbox.adjustDate(1, vcg.getSecondaryRevocationDate( ), true);
					if ( today.before(backDate) ){
						backDate = today;
					}
					statusDate = Toolbox.formatDateCprs( backDate );
					Date lastDayBeforeAdmin = Toolbox.adjustBusinessDate(30, vcg.getSecondaryRevocationDate( ), true );
					if ( lastDayBeforeAdmin.after(today) ){
						lastDayBeforeAdmin = today;
					}
					maxDate = Toolbox.formatDateCprs( lastDayBeforeAdmin );
					form.put( "reinstateEnd", Toolbox.formatDateCprs( Toolbox.adjustBusinessDate(40, vcg.getSecondaryRevocationDate( ), true ) ) );
					form.put( "revocationDate", vcg.getSecondaryRevocationDate( ) );
				} else if ( vcg.isApproved( oldDispositionState ) ){
					statusDate = dispositionDate;
				}
				form.put( "dispositionChoices", vcg.getSecondaryDispChoices() );
				form.put( "dispositionReasons", vcg.getSecondaryDispReasons() );
				form.put( "assessmentComplete", vcg.isSecondaryAssmtComplete() );
			} else if ( vcg.getSecondaryTwoId() == persnId ){
				person = vcg.getSecondaryTwo();
				oldDispositionState = vcg.getSecondaryTwoDispReason();
				appReceivedDate = Toolbox.formatDateCprs( vcg.getSecondaryTwoVcgAn().getReceivedDate() );
				dispositionDate = Toolbox.formatDateCprs( vcg.getSecondaryTwoDispositionDate() );
				statusDate = appReceivedDate;
				if ( vcg.isInProcess( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "disposition-date-info") );
					if ( vcg.isVacoWaiverSecondaryTwo() ){
						vacoWaiver = true;
					} else {
						waiver = vcg.isWaiverSecondaryTwo();
					}
				} else if ( vcg.isRevoked( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "revocation-date-info") );
					Date today = new Date();
					Date backDate = Toolbox.adjustDate(1, vcg.getSecondaryTwoRevocationDate( ), true);
					if ( today.before(backDate) ){
						backDate = today;
					}
					statusDate = Toolbox.formatDateCprs( backDate );
					Date lastDayBeforeAdmin = Toolbox.adjustBusinessDate(30, vcg.getSecondaryTwoRevocationDate( ), true );
					if ( lastDayBeforeAdmin.after(today) ){
						lastDayBeforeAdmin = today;
					}
					maxDate = Toolbox.formatDateCprs( lastDayBeforeAdmin );
					form.put( "reinstateEnd", Toolbox.formatDateCprs( Toolbox.adjustBusinessDate(40, vcg.getSecondaryTwoRevocationDate( ), true ) ) );
					form.put( "revocationDate", vcg.getSecondaryTwoRevocationDate( ) );
				} else if ( vcg.isApproved( oldDispositionState ) ){
					statusDate = dispositionDate;
				}
				form.put( "dispositionChoices", vcg.getSecondaryTwoDispChoices() );
				form.put( "dispositionReasons", vcg.getSecondaryTwoDispReasons() );
				form.put( "assessmentComplete", vcg.isSecondaryTwoAssmtComplete() );
			} else if ( vcg.getGeneralId() == persnId ){
				person = vcg.getGeneral();
				
				oldDispositionState = vcg.getGeneralDispReason();
				dispositionDate = Toolbox.formatDateCprs( vcg.getGeneralDispositionDate() );
//				WorIm genWork = null;
//				try {
//					genWork = WorImLocalServiceUtil.findByVcgId(vcgId, persnId, WorkStatus.COMPLETE.name(),
//							WorkType.GENERAL_CG_ASSIGNMENT.name());
//				} catch (ApplicationWorkFlowException e) {
//					ApplicationWorkFlowException.handleException(e);
//				}
//				if ( genWork != null ){
//					statusDate = Toolbox.formatDateCprs( genWork.getCompletionDate() );
//				}
				if ( vcg.isInProcess( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "disposition-date-info") );
				} else if ( vcg.isRevoked( oldDispositionState ) ){
					dispositionDateData.put("custom-message",LanguageUtil.get(themeDisplay.getLocale(), "revocation-date-info") );
					statusDate = Toolbox.formatDateCprs( Toolbox.adjustBusinessDate(1, vcg.getGeneralRevocationDate( ), true ) );
					maxDate = Toolbox.formatDateCprs( new Date() );
					form.put( "reinstateEnd", Toolbox.formatDateCprs( Toolbox.adjustBusinessDate(40, vcg.getGeneralRevocationDate( ), true ) ) );
					form.put( "revocationDate", vcg.getGeneralRevocationDate( ) );
				} else if ( vcg.isApproved( oldDispositionState ) ){
					statusDate = dispositionDate;
				} else if ( vcg.isReinstated( oldDispositionState ) ){
					statusDate = Toolbox.formatDateCprs( vcg.getGeneralRevocationDate( ) );
				}
				if ( Toolbox.isEmpty(statusDate) ){
					statusDate = Toolbox.formatDateCprs( new Date() );
				}
				form.put( "dispositionChoices", vcg.getGeneralDispChoices() );
				form.put( "dispositionReasons", vcg.getGeneralDispReasons() );
				
				
//					form.put( "dispositionDate", Toolbox.formatDateCprs( vcg.getGeneralDispositionDate() ) ); 
//					form.put( "generalReasons", PortletProps.getArray("general-reasons") );
			}
			disabled.put("dispositionDate", StringPool.BLANK );	
			dispositionDateData.put("statusDate", statusDate );
			if ( Toolbox.isEmpty(maxDate) ){
				maxDate = Toolbox.formatDateCprs( new Date() );
			}
			dispositionDateData.put("maxDate", maxDate );

			form.put( "person", person);
			form.put( "appReceivedDate", appReceivedDate );
			form.put( "dispositionDateData", dispositionDateData );
			form.put( "dispositionDate", dispositionDate );
			form.put( "dispositionChoice", VcgSupport.getDisposition( oldDispositionState ) );
			form.put( "dispositionReason", oldDispositionState );
			form.put( "waiverReasons", PortletProps.getArray("csc-waiver-reasons") );
			form.put( "waiver", waiver);
			form.put( "vacoWaiver", vacoWaiver);
			try {
				WorIm appDelayApproval = WorImLocalServiceUtil.findByCgWorkLast ( vcgId, persnId, WorkType.APP_DELAY.name() );
				//TODO...
				if ( appDelayApproval != null && WorkType.APP_DELAY.getExpirationDate( appDelayApproval.getCompletionDate() ).after( new Date() ) ){
					form.put( "appDelayApproval", appDelayApproval );
				}
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			form.put( "vcg", vcg);
			
		}
		
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		request.setAttribute(CaretStrPool.NDX, StringPool.BLANK);
		request.setAttribute(CaretStrPool.FORM, form);
		
		form.put("disabled", disabled);

		
		return page;
	}
	
	private void setFormTier( Map form, Map disabled, Vcg vcg, String appReceivedDate ) {
		form.put( "tierTypes", PortletProps.getArray("tier-types") );
		form.put( "tier", vcg.getTierLevel() );
		form.put( "tierEffectiveDate", vcg.getTierEffectiveDate() );
		form.put( "tierDateData", Collections.singletonMap("statusDate", appReceivedDate ) );
		disabled.put("tierEffectiveDate", StringPool.BLANK );
		disabled.put("tier", StringPool.BLANK );
	}
	public String loadGeneral ( ResourceRequest request, ResourceResponse response ) {
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		try {
			VcgSupport vcg = VcgSupport.getVcgSupport( ParamUtil.getLong(request, "vcgId") );
			Person general = vcg.getGeneral();
			if ( general == null ){
				general = new General(new PersnImpl());
			}
			request.setAttribute("person", general );
			Map<String,Object> caret = ResultMap.getCaretMap(request);
			ResultMap.getCaretMap(request).put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			try {
				CaretViewController.getViewController().loadAddress ( caret, general, general.getRole().getLabel() );
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			CaretViewController.getViewController().loadRelationshipLists(request);
			CaretViewController.getViewController().loadRequiredInputs("required.vcg.input." + general.getRole().getLabel(), ResultMap.getForm(request));
			caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return request.getParameter("page");
	}
	
	public String loadVcgEntry ( ResourceRequest request, ResourceResponse response ) {
		
		long persnId = ParamUtil.getLong(request, "persnId");
		long vcgId = ParamUtil.getLong(request, "vcgId");
		Map<String,Object> form = ResultMap.getForm(request);
		Map<String,String> disabled = new CaretMap<String,String>("disabled");
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		
		
		try {

			Vcg vcg = VcgLocalServiceUtil.getVcg(vcgId);
			boolean isPrimary = vcg.getPrimaryId() == persnId;
			boolean isVeteran = vcg.getVeteranId() == persnId;
			boolean isSecondary = vcg.getSecondaryId() == persnId;
			boolean isSecondaryTwo = vcg.getSecondaryTwoId() == persnId;
			boolean isGeneral = vcg.getGeneralId() == persnId;
			
			Person person = null;
			if (persnId > 0){
				if ( isVeteran ){
					person = new Veteran( PersnLocalServiceUtil.getPersn(persnId) );
				} else if ( isPrimary ){
					person = new Primary( PersnLocalServiceUtil.getPersn(persnId) );
					form.put( "relationship", vcg.getPrimaryType() );
				} else if ( isSecondary ){
					person = new Secondary( PersnLocalServiceUtil.getPersn(persnId) );
					form.put( "relationship", vcg.getSecondaryType() );
				} else if ( isSecondaryTwo ){
					person = new SecondaryTwo( PersnLocalServiceUtil.getPersn(persnId) );
					form.put( "relationship", vcg.getSecondaryTwoType() );
				} else if ( isGeneral ){
					person = new General( PersnLocalServiceUtil.getPersn(persnId) );
					form.put( "relationship", vcg.getGeneralType() );
				}
			}
			
			CaretViewController.getViewController().loadRequiredInputs("required.vcg.input." + person.getRole().getLabel(), form);
			
			request.setAttribute("person", person);
			
			if ( person.isVeteranRole() ) {
				request.setAttribute("includeFacility", true );
				caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
				if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_VETERAN_LNAME.name() ) ){
					disabled.put("lastName", StringPool.BLANK);
				}
				if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_VETERAN_FNAME.name() ) ){
					disabled.put("firstName", StringPool.BLANK);
				}
				if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_FACILITY.name() ) ){
					disabled.put("groupId", StringPool.BLANK);
				}
				if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_INSURANCE.name() ) ){
					disabled.put("insurance", StringPool.BLANK );
				}
			} else {
				CaretViewController.getViewController().loadRelationshipLists(request);
				if ( person.isPrimaryRole() ){
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_INSURANCE.name() ) ){
						disabled.put("insurance", StringPool.BLANK );
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_PRIMARY_LNAME.name() ) ){
						disabled.put("lastName", StringPool.BLANK);
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_PRIMARY_FNAME.name() ) ){
						disabled.put("firstName", StringPool.BLANK);
					}
				} else {
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_CG_LNAME.name() ) ){
						disabled.put("lastName", StringPool.BLANK);
					}
					if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_CG_FNAME.name() ) ){
						disabled.put("firstName", StringPool.BLANK);
					}
				}
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_MNAME.name() ) ){
				disabled.put("middleName", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_GENDER.name() ) ){
				disabled.put("gender", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_BDAY.name() ) ){
				disabled.put("birthDate", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_SSN.name() ) ){
				disabled.put("ssn", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ADDRESS.name() ) ){
				disabled.put("address", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ICN.name() ) ){
				disabled.put("icn", StringPool.BLANK);
			}
			
			form.put("disabled", disabled);

			request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
			request.setAttribute(CaretStrPool.FORM, form);
			
			request.setAttribute(CaretStrPool.NDX, StringPool.BLANK);
			CaretViewController.getViewController().loadAddress ( caret, person, person.getRole().getLabel() );
			caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			
//			_log.info("generalCaregiver is :"+vcg.getGeneralCaregiver());
//			form.put("generalCaregiver", vcg.getGeneralCaregiver());
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
		return request.getParameter("page");
	}
	public String loadEligibility ( ResourceRequest request, ResourceResponse response ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.CLASS_PK);
		if (  primKey > 0 ){
			if ( !Toolbox.isEmpty( "USE_TEMP_ICN" ) ){ //vcg.getVeteran().getICN()
				try {
					Persn veteran = PersnLocalServiceUtil.getPersn(primKey);
					String eligibility = String.valueOf( new ServicePerson(request, veteran).getModelAttributes().get("doEESearchHTML") );
					if ( Toolbox.isEmpty( eligibility ) ){
						eligibility = "<div class='alert alert-info'> No Eligibility Information found </div>";
					}
					response.getWriter().write( eligibility );
				} catch (IOException e) {
					e.printStackTrace();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		
		return StringPool.BLANK;
	}
	
	public String getNote ( ResourceRequest request, ResourceResponse response ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.CLASS_PK);
		long noteId = ParamUtil.getLong(request, "noteId");
		
		JSONObject json = JSONFactoryUtil.createJSONObject();
		
		String noteValue;
		Note note = null;
		try {
			note = NoteLocalServiceUtil.getNote(noteId);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		if ( note == null ){
			noteId = 0;
			noteValue = StringPool.BLANK;
		} else {
			noteValue = note.getValue();
		}
		json.put("noteId", noteId);
		json.put("noteValue", noteValue);
		return writeJson ( response, json );
	}	
	
	public String newWorkNote ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException {
		String note = request.getParameter(CaretStrPool.WORK_COMMENT);
		if ( !Toolbox.isEmpty(note) ) try{
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			work.setNote("newWorkNote", note, sc.getUserId(), sc.getCreateDate() );
			CaretLocalServiceUtil.save(work);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
	}
	
	public String loadVcgNotes ( ResourceRequest request, ResourceResponse response ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.CLASS_PK);
		long noteId = ParamUtil.getLong(request, "noteId");
		int noteType = ParamUtil.getInteger(request, "noteType");
		String note = ParamUtil.get(request, "note", StringPool.BLANK );
		boolean alterNotes = NoteSupport.CALL == noteType && CAction.canDoCaret(request, CAction.CaretCan.ALTER_CALL_NOTES);
		if ( !Toolbox.isEmpty(note) && primKey > 0 ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				if ( noteId > 0 || NoteSupport.CALL == noteType ){
//					if ( alterNotes ){
						try {
							if ( noteId > 0 && alterNotes ){
								if ( "DELETE".equals(note) ){
									NoteLocalServiceUtil.deleteNote( NoteLocalServiceUtil.getNote(noteId) );
								} else {
									NoteSupport upNote = new NoteSupport ( NoteLocalServiceUtil.getNote(noteId) ); 
									upNote.setValue(note);
									NoteLocalServiceUtil.updateNote(upNote);
								}
							} else {
								CallSupport call = new CallSupport(CallLocalServiceUtil.getCall (primKey) );
								call.setNote("newNote", note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CUSTOM_NOTE.groupId() );
								CaretLocalServiceUtil.save( call );
							}
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
							noteId = -1;
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
							noteId = -1;
						}
//					}
					ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL );
				} else {
					VcgSupport vcg = VcgSupport.getVcgSupport(primKey);
					vcg.setNote("newNote", note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CUSTOM_NOTE.groupId() );
					CaretLocalServiceUtil.save( vcg );
					ResultMap.getCaretMap(request).put("noteContext", "vcg" );
				}
				
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
				noteId = -1;
			}
			ResultMap.getCaretMap(request).put("noteId", noteId );
		}
		ResultMap.getCaretMap(request).put("ALTER_NOTES", alterNotes);
		return loadList(request, response);
	}
	
	public String loadList ( ResourceRequest request, ResourceResponse response ){
		
		
		String page = request.getParameter("page"); //[advancedSearch, orderByType, keywords, page, orderByCol, delta, action, cur, andOperator]
		if ( _log.isDebugEnabled() ){ 
			_log.info(" inside loadList..." + page );
		}
		if ( page == null ){
			return StringPool.BLANK;
		}
		
		
		boolean fromParameter = ParamUtil.getBoolean(request, "fromParameter");
		
		if ( !page.isEmpty() ){
			int ndx = page.indexOf(StringPool.POUND);
			if ( ndx > -1 ){
				page = page.substring(ndx+1);
			}
		}
		DashboardConfig dashboardConfig = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		
		if ( dashboardConfig != null ){
			GenericReport report = dashboardConfig.getReport(page);
			if ( report != null ){
				
				int cur = ParamUtil.getInteger(request, SearchContainer.DEFAULT_CUR_PARAM );
				int delta = ParamUtil.getInteger(request, SearchContainer.DEFAULT_DELTA_PARAM, SearchContainer.DEFAULT_DELTA);
				int start = ( cur == 0 )? 0 : delta * ( cur-1 ) +1;
				int end = ( cur == 0 )? delta : ( delta * cur );
				page = report.getPageName();
				
				report.run(request, fromParameter, start, end);
				
				ResourceURL url = response.createResourceURL();
				url.setParameter("page", page);
				url.setParameter("action", "loadList");
				Long classPk = ParamUtil.getLong(request, "classPk" );
				if ( classPk > 0 ){
					url.setParameter("classPk", classPk.toString());
				}
				if ( fromParameter == true ){
					url.setParameter("fromParameter", StringPool.TRUE);
				}
				ResultMap.getResultUrlMap( request, url );
				ResultMap.getResultOrderDeltaMap( request ).put( report.getName(), delta );
				ResultMap.getResultOrderTypeMap( request ).put( report.getName(), report.isDesc()? "desc": "asc" );
				
				if ( dashboardConfig instanceof FacilityDashboardConfig ){
					ResultMap.getCaretMap(request).put( CaretStrPool.FACILITY_IDS, ((FacilityDashboardConfig)dashboardConfig).getFacilities() );
				}
			}
		}

		return page;
	}
		
	public String getDocum(ResourceRequest request, ResourceResponse response) {
		return super.getDocum(request, response);
	}
    
	

	public String previewLetter(ResourceRequest request, ResourceResponse response) {
		 //String documentName = "Veteran Requests CG Revocation_fields.pdf";
		 String letterName = request.getParameter(CaretStrPool.LETTER_NAME);
		 try {
	            _log.info("inside getPdf form... ");
	    		try {
	    			ByteArrayOutputStream output = new ByteArrayOutputStream();
	    			//new PopulateLettersImpl().generatePDF( request, output, letterName );
	    			//writeStream( response, output.toByteArray(), letterName);
	    			
	    			new PopulateLettersImpl().generateAndPopulatePDFWithEditedContent(request, letterName);
	    			String name = (String) request.getAttribute(CaretStrPool.LETTER_FILE);
	    			File uploadFile = new File( PortletProps.get(CaretStrPool.FILE_TEMP_STORE) + name );
	    			//InputStream inputStream = new FileInputStream( uploadFile );
	    			//OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
	    			
	    			ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute(WebKeys.THEME_DISPLAY);
	    			  PortletURL actionUrl =  PortletURLFactoryUtil.create(request, themeDisplay.getPortletDisplay().getId(), themeDisplay.getPlid(), PortletRequest.ACTION_PHASE);
	    			  actionUrl.setWindowState(LiferayWindowState.NORMAL);
	    			  actionUrl.setPortletMode(LiferayPortletMode.VIEW);
	    			  actionUrl.setParameter("javax.portlet.action", "doAction");
	    			  actionUrl.setParameter("action", "sendLetter");
	    			  actionUrl.setParameter(CaretStrPool.LETTER_NAME, letterName);
	    			  //request.setAttribute("actionUrlByJavaAPI", actionUrl.toString());
	    			  
	    			PdfReader reader = new PdfReader( PortletProps.get(CaretStrPool.FILE_TEMP_STORE) + name);
	    	        // create a stamper
	    	        PdfStamper stamper = new PdfStamper(reader,output);
	    	        // create a submit button that posts the form as an HTML query string
	    	        PushbuttonField button1 = new PushbuttonField(
	    	            stamper.getWriter(), new Rectangle(90, 660, 140, 690), "FDF");
	    	        button1.setText("Save & Send Letter");
	    	        button1.setBackgroundColor(new GrayColor(0.7f));
	    	        button1.setVisibility(PushbuttonField.VISIBLE_BUT_DOES_NOT_PRINT);
	    	        PdfFormField submit1 = button1.getField();
	    	        submit1.setAction(PdfAction.createSubmitForm(actionUrl.toString(), null,
	    	            PdfAction.SUBMIT_HTML_FORMAT | PdfAction.SUBMIT_EXCL_F_KEY));
	    	        // add the button
	    	        stamper.insertPage(reader.getNumberOfPages()+1,  reader.getPageSizeWithRotation(1));
	    	        stamper.addAnnotation(submit1, reader.getNumberOfPages());
	    	        // close the stamper
	    	        stamper.close();
	    	        reader.close();
	    	        writeStream( response, output.toByteArray(), letterName);

	    			request.getPortletSession().removeAttribute(CaretStrPool.LETTER_FILE);
	    			FileUtil.delete(uploadFile);
	    			
	    	        
	        	} catch (IOException e) {
	    			ApplicationWorkFlowException.handleException(e);
	    		} 
	        } catch(Exception e) {
	        	ApplicationWorkFlowException.handleException(e);
	        } 
	     return StringPool.BLANK;
	}
	
	public void saveLetter(ResourceRequest request, ResourceResponse response) {
		 //String documentName = "Veteran Requests CG Revocation_fields.pdf";
		 String letterContent = request.getParameter(CaretStrPool.EDITED_LETTER_CONTENT);
		 String val = "";
	}
	
	public void deleteDocum(ResourceRequest request, ResourceResponse response) {
		super.deleteDocum(request, response);
	}

	public String addCallType ( ResourceRequest request, ResourceResponse response ){
		
		String callType = request.getParameter(CaretStrPool.CALL_TYPE);
		_log.info("CALL_TYPE=" + callType );
		 boolean isValid = true;
		 String reason = StringPool.BLANK;
		 JSONObject json = JSONFactoryUtil.createJSONObject();
		 if ( callType.trim().isEmpty() ){
			 isValid = false;
			 reason = "Call Type cannot be blank";
		 } else {
			 if ( callType.trim().length() > ModelConfig.CALL_TYPE_LENGTH ) {
				 isValid = false;
				 reason = "Call Type label cannot be greater than "+ ModelConfig.CALL_TYPE_LENGTH + " characters";
			 } else {
				 
				 callType = callType.trim().replaceAll("\\s+", StringPool.SPACE);
				 
				 ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
				 try {
					 String subgroupCallType = callType.toLowerCase().replace(StringPool.SPACE, StringPool.DASH);
					 String standardCallTypes = PortletProps.get("call.type");
					 int standardTypesSize = 0;
					 String[] standardTypes = standardCallTypes.split(StringPool.COMMA);
					 standardTypesSize = standardTypes.length;
					 for ( String standardType : standardTypes ){
						 if ( subgroupCallType.equals(standardType) || 
								 callType.equals( LanguageUtil.get(themeDisplay.getLocale(), standardType) ) ) {
							 isValid = false;
							 reason = "Call Type already defined or too close to one already defined";
							 break;
						 }
					 }
					 
					 if ( isValid ){
						 List<BoxGp> customTypes = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES);
						 for ( BoxGp boxGp: customTypes ){
							 String subGroup = boxGp.getBoxSubGroup();
							 String label = boxGp.getLabel();
							 if ( label.equals(callType) ||
									 subGroup.equals(subgroupCallType) ){
								 isValid = false;
								 reason = "Call Type already defined or too close to one already defined";
								 break;
							 }
						 }
						 if ( isValid ){
							 BoxGp callTypeBoxGp = new BoxGpImpl();
							 callTypeBoxGp.setBoxGroup(CaretStrPool.CUSTOM_CALL_TYPES);
							 callTypeBoxGp.setBoxSubGroup(subgroupCallType);
							 callTypeBoxGp.setLabel(callType);
							 callTypeBoxGp.setViewSequence(customTypes.size()+standardTypesSize);
							 try {
								 BoxGpLocalServiceUtil.addBoxGp(callTypeBoxGp);
								 json.put( CaretStrPool.BOX_GROUP_ID, callTypeBoxGp.getBoxGpId() );
							 } catch (SystemException e) {
								 ApplicationWorkFlowException.handleException(e);
								 isValid = false;
								 reason = "System Error";
							 }
						 }
					 }
					 
					 
				 } catch (ApplicationWorkFlowException e) {
					 ApplicationWorkFlowException.handleException(e);
				 }
			 }
		 }
		 
		json.put(CaretStrPool.FORM, isValid);
		json.put(CaretStrPool.CALL_TYPE, reason);
		return writeJson ( response, json );
	}
	
	public String createVendrPayment ( ResourceRequest request, ResourceResponse response ){
		_log.info("inside createVendrPayment... ");
		 String blsRate = ParamUtil.get(request, "blsRate", ""); 
		 
//		 long blsrateId = ParamUtil.getLong(request, "blsRate", 0); 
		 Date now = new Date();
		 _log.info("blsRate=" + blsRate );
		 
		 String tier = getValue(request, "tier");
		 _log.info("tier=" + tier );

		 String ten10Id = getValue(request, "ten10Id");
		 _log.info("ten10Id=" + ten10Id );
		 VcgAn ten = null;
		try {
			ten = VcgAnLocalServiceUtil.getVcgAn( Long.valueOf(ten10Id) );
		} catch (NumberFormatException e2) {
			ApplicationWorkFlowException.handleException(e2);
		} catch (PortalException e2) {
			ApplicationWorkFlowException.handleException(e2);
		} catch (SystemException e2) {
			ApplicationWorkFlowException.handleException(e2);
		}
		
		 String cgIdStr = getValue(request, "cgId");
		 _log.info("cgId=" + cgIdStr );
		 
		 String zip = ParamUtil.get(request, "zip", "");
		 _log.info("zip=" + zip );
		 
		 String startDate = getValue(request, "startDate");
		 _log.info("startDate=" + startDate );
		 
		 int hours = Integer.valueOf(tier);
		 
		 User user = null;
		try {
			user = UserLocalServiceUtil.getUser(Long.valueOf(cgIdStr));
		} catch (PortalException e1) {
			ApplicationWorkFlowException.handleException(e1);
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
		}
		 String fedTaxId = StringPool.BLANK;
		 if ( user != null ){
			 fedTaxId = CaretUtil.getExpandoValue( user.getExpandoBridge(), CaretStrPool.METADATA, false );
		 }
		 _log.info("fedTaxId=" + fedTaxId );
		 
		 
		 if ( fedTaxId!= null && !fedTaxId.isEmpty() && ! blsRate.isEmpty() && blsRate.length() > 4 ){
			String cbsaarea = blsRate.substring(0,5) + '%';
			try {
				Vendr vendor = null; // VendrLocalServiceUtil.findByFedTaxId(fedTaxId, -1, -1);
				if ( vendor == null ){
					vendor = new VendrImpl();
					vendor.setFirstName(user.getFirstName());
					vendor.setLastName(user.getLastName());
					vendor.setFedTaxId(fedTaxId);
					CaretUtil.setExpandoValue( vendor, CaretStrPool.METADATA, fedTaxId );
//					vendor.setVendorSsn(fedTaxId);
					vendor.setZip(zip);
					try {
						VendrLocalServiceUtil.addVendr(vendor);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
					VetVr vv = new VetVrImpl();
					vv.setCgId( user.getPrimaryKey() );
//					vv.setVeteranId( ten.getVeteranStatus() );
					vv.setVendrId( vendor.getVendrId() );
					try {
						VetVrLocalServiceUtil.addVetVr(vv);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
				
				_log.info("vendor********************** " + vendor.getVendrId() );
				
				List<Map<String, Object>> list = CaretLocalServiceUtil.getReport( "getBlsRate", (Object)cbsaarea );
				if ( !list.isEmpty() ){
					String blsRateId = list.get(0).get("ndx0").toString();
					_log.info("blsRateId is " + blsRateId );
					String rateStr = list.get(0).get("ndx1").toString();
					_log.info("rate is " + rateStr );
					String areaName= list.get(0).get("ndx2").toString();
					_log.info("areaName is " + areaName );
					
					double rate = Double.valueOf(rateStr);
					double payment = hours * rate;
					
					StiPt stipend = new StiPtImpl();
					try {
						Date stipendStartDate = new Date();
						try{
							stipendStartDate= Toolbox.parseDate(startDate);
						} catch (Exception e){
							_log.error("parseException" + startDate);
						}
						stipend.setStipendStartDate(stipendStartDate);
						stipend.setBlsRateHourly(rateStr);
						stipend.setVendrId(vendor.getVendrId());
						tier = String.valueOf((Integer.valueOf(hours))/25);
						stipend.setTier(tier);
						stipend.setTierHours( String.valueOf(hours) );
						stipend.setStipendStatus(CaretStrPool.PAYMENT_PENDING);
						
						StiPtLocalServiceUtil.addStiPt(stipend);
						
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
					NumberFormat nf = NumberFormat.getCurrencyInstance();
					
					JSONObject json = JSONFactoryUtil.createJSONObject();
					json.put("user", user.getFullName() );
					json.put("areaName", areaName);
					json.put("rate", nf.format(rate) );
					json.put("hours", hours );
					json.put("startDate", startDate );
					json.put("payment", nf.format(payment) );
					
					writeJson ( response, json );
					_log.info( "payment is ... " + payment );
				}
//				try {
//					VcgDemo vcg = VcgDemoLocalServiceUtil.fetchVcgDemo( ten.getVcgId() );
//					_log.info("vcg.getVcgDemoId= " + vcg.getVcgDemoId() );
//					vcg.setStatus("PAYMENT CREATED");
//					VcgDemoLocalServiceUtil.updateVcgDemo(vcg);
					
//				} catch (SystemException e) {
//					ApplicationWorkFlowException.handleException(e);
//				}
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		 return StringPool.BLANK;
	}
	
	public void validateCachedAddress ( ResourceRequest request, ResourceResponse response ){
	    super.validateUSPSAddress(request, response,true);
	}
	
	public void validateUSPSAddress ( ResourceRequest request, ResourceResponse response ){
	    super.validateUSPSAddress(request, response);
	}
	
	//@ProcessAction (name="calculateStipend")
	public String calculateStipend ( ResourceRequest request, ResourceResponse response  ){
		String zip = ParamUtil.getString(request, "zip", StringPool.BLANK);
		Long tierhours = ParamUtil.getLong(request, "tier");
		List<BlsRe> blsRates;
		JSONObject stipends, json = JSONFactoryUtil.createJSONObject();
		try {
			blsRates = BlsReLocalServiceUtil.findBlsByZip(zip);
			if(blsRates.isEmpty()) {
				json.put("error", "Zipcode not found please notify Supervisor");
			} else {
				BlsRe blsRe = blsRates.get(0);
				BlsAe blsAe = BlsAeLocalServiceUtil.fetchBlsAe(blsRe.getBlsAeId());
				Double rate = blsRe.getH75();
				//stipends = JSONFactoryUtil.createJSONObject();
				//stipends.put("stipend", rate*tierhours);
				double times4 = tierhours*4.35;
				double stipend = rate*times4;
				json.put("hours", tierhours);
				json.put("times4",  Math.floor(times4 * 100) / 100);
				json.put("wage", rate);
				json.put("stipend", Math.floor(stipend * 100) / 100);
				if (blsAe != null) {
					json.put("areaname", blsAe.getAreaName());
				} else {
					json.put("areaname", "");
					
				}
				json.put("county", blsRe.getCounty());
				json.put("location", blsRe.getCity()+ ", " +blsRe.getState());
				json.put("zipcode", blsRe.getZip());
			}
			return writeJson ( response, json );
			//request.setAttribute("stipend", rate);
		} catch (ApplicationWorkFlowException e) {
			
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			
			ApplicationWorkFlowException.handleException(e);
		}
		return StringPool.BLANK;
		
	}
	
	public void saveAssessment ( ResourceRequest request, ResourceResponse response ) {
		_log.info("saveAssessment");
		
		long vcgId = ParamUtil.getLong(request, "vcgId", 0);
		long groupId = ParamUtil.getLong(request, "groupId", 0);
		String type = ParamUtil.getString(request, "type", "");
		long assessmentId = ParamUtil.getLong(request, "assessmentId");
		Date completionDate= ParamUtil.getDate(request, "completionDate", new SimpleDateFormat("MM/dd/yyyy"));
		String comment= ParamUtil.getString(request, "comment", "");
		long caregiverId = ParamUtil.getLong(request, "caregiverId");
		String mode= ParamUtil.getString(request, "assmtMode", "");
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		JSONObject json = JSONFactoryUtil.createJSONObject();		
		
		try {
			if(assessmentId > 0)
			{
				Assmt assessment = AssmtLocalServiceUtil.getAssmt(assessmentId);
	
				if(type.equals(CaretStrPool.QUARTER1) || type.equals(CaretStrPool.QUARTER2) || type.equals(CaretStrPool.QUARTER3) || type.equals(CaretStrPool.ANNUAL))
				{	
					String tempDate = ParamUtil.getString(request, "completionDate", "");
					Date periodicCompletionDate;
					if(tempDate.equals("")){
						periodicCompletionDate = null;
					}else{
						periodicCompletionDate = ParamUtil.getDate(request, "completionDate", null);
					}

					if(!((Toolbox.formatDateCprs(assessment.getCompletionDate())).equals(Toolbox.formatDateCprs(periodicCompletionDate)))
							|| !(assessment.getComment().equals(comment))
							|| !(assessment.getMode().equals(mode)))
					{
						assessment.setCompletionDate(periodicCompletionDate);	
						assessment.setComment(comment);
						assessment.setMode(mode);
						CaretLocalServiceUtil.save(assessment);
						
						List<Assmt> assmtList = AssmtLocalServiceUtil.findByYear(vcgId, type, assessment.getYear()+1);
						if(assmtList.isEmpty())
						{							
							Assmt tempAssmt = new AssmtImpl();
							tempAssmt.setVcgId(vcgId);
							tempAssmt.setType(type);
							tempAssmt.setActive(true);
							tempAssmt.setCaregiverId(caregiverId);
							tempAssmt.setUserId(sc.getUserId());
							tempAssmt.setYear(assessment.getYear()+1);
														
							Date scheduleDateTemp = new Date();
							Calendar c = Calendar.getInstance(); 
							c.setTime(assessment.getScheduleDate());
							c.add(Calendar.DATE, 360);
							scheduleDateTemp = c.getTime();		
							
							tempAssmt.setScheduleDate(scheduleDateTemp);
							
							CaretLocalServiceUtil.save(tempAssmt);						
							json.put("assessmentStatus", "created");	

						}else{
							//System.out.println("assessment already exists");
							json.put("assessmentStatus", "exists");	
						}
						
					}				
				}else if(!((Toolbox.formatDateCprs(assessment.getCompletionDate())).equals(Toolbox.formatDateCprs(completionDate)))
					|| !(assessment.getComment().equals(comment)))
				{
					assessment.setCompletionDate(completionDate);	
					assessment.setComment(comment);
					CaretLocalServiceUtil.save(assessment);
				}
				
				// If Primary training date was modified - update the due date of the in home visit work item if one exist
				if(type.equals(CaretStrPool.PRIMARY_TRAINING)){
					WorIm workItem = WorImLocalServiceUtil.findByVcgId(vcgId, caregiverId, CaretStrPool.NEW, CaretStrPool.HOME_VISIT);
					 
					if(null!=workItem){
						workItem.setDueDate(WorkType.HOME_VISIT.getBusinessDueDate(completionDate));
						CaretLocalServiceUtil.save(workItem);
					}
				}
			}else{
				Assmt assessment = new AssmtImpl();
				
				assessment.setVcgId(vcgId);
				assessment.setCompletionDate(completionDate);
				assessment.setType(type);
				assessment.setComment(comment);
				assessment.setActive(true);
				assessment.setCaregiverId(caregiverId);
				assessment.setUserId(sc.getUserId());
	
				CaretLocalServiceUtil.save(assessment);
				assessmentId = assessment.getAssmtId();
					
				//if assessment type is training assessment - check if in home assessment has been completed or not - if not completed - create work item due after 10 days of training assessment completion date
				if(type.equals(CaretStrPool.PRIMARY_TRAINING)){
					boolean homeVisitCompleted = false;					
					List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

					for(Assmt oneAssmt:completedAssessmentList)
					{
						if(oneAssmt.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && oneAssmt.getCaregiverId()==caregiverId && oneAssmt.isActive()){
							homeVisitCompleted = true;
						}
					}

					if(! homeVisitCompleted ){
						long veteranId = ParamUtil.getLong(request, "veteranId");
						//CaretLocalServiceUtil.save( Toolbox.createHomeVisitWorkItem(sc, 0, assessment, WorkType.HOME_VISIT, veteranId, caregiverId, vcgId, completionDate ));					
						CaretLocalServiceUtil.save( CaretUtil.createHomeVisitWorkItem(sc, groupId, assessment, WorkType.HOME_VISIT, veteranId, caregiverId, vcgId, completionDate ));
					}
				}
	
				//if type of assessment is in-home visit - check if there is a open work item for that vcg and caregiver - if yes, update status of work item to complete
				if(type.equals(CaretStrPool.PRIMARY_IN_HOME)){
					WorIm workItem = WorImLocalServiceUtil.findByVcgId(vcgId, caregiverId, CaretStrPool.NEW, CaretStrPool.HOME_VISIT);	
					if(null!=workItem){
						workItem.setStatus(CaretStrPool.COMPLETE);
						workItem.setCompletionBy( sc.getUserId() );
						workItem.setCompletionDate( sc.getCreateDate() );
						
						CaretLocalServiceUtil.save(workItem);
					}
				}											
			}
				
		}catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		json.put("assessmentId", assessmentId);	
		writeJson ( response, json);
	}

	@ProcessAction (name="updateMessageStatus")
	public void updateMessageStatus( ResourceRequest request, ResourceResponse response ) {
		String messageId = ParamUtil.get(request, "messageId", StringPool.BLANK);
		Long userId = PortalUtil.getUserId(request);
		PMPortlet.updateMessageStatus(messageId, userId);
	}
	
	private static Log _log = LogFactoryUtil.getLog( CaretResourceCommand.class );

	@Override
	public String getJspDir() {
		return CaretBaseViewController.INTERNAL_VIEW;
	}
	
}
