package gov.va.caret.portlet.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ProcessAction;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.NoSuchClassNameException;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.bean.AssmtBean;
import gov.va.caret.bean.AttachmentBean;
import gov.va.caret.bean.CespBean;
import gov.va.caret.bean.SocBean;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.controller.dashboard.config.CslDashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfigFactory;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.letters.CscLetterType;
import gov.va.caret.letters.PopulateLettersImpl;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.CalEt;
import gov.va.caret.model.Call;
import gov.va.caret.model.Cesp;
import gov.va.caret.model.ClSoc;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Waivr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.AssmtImpl;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.CalEtImpl;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.impl.WaivrImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.BoxedGroupAssociation;
import gov.va.caret.model.support.General;
import gov.va.caret.model.support.NoteSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkStatus;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pdf.FileType;
import gov.va.caret.pm.portlet.PMPortlet;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CallLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.CespLocalServiceUtil;
import gov.va.caret.service.ClSocLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.WaivrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.ctssh.ServiceFacade;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;
import java.util.Scanner;

public class CaretActionCommand extends ActionCommand implements Serializable {
	
private static final long serialVersionUID = 2251500780038409153L;
	

@ProcessAction (name="loadVcgManagement")
public void loadVcgManagement( ActionRequest request, ActionResponse response ) {
	long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
	long vcgId = ParamUtil.getLong( request, CaretStrPool.VCGID );
	if ( vcgId == 0 ){
		vcgId = (Long) request.getAttribute(CaretStrPool.VCGID);
	}
	
	Map<String, Object> form = ResultMap.getForm(request);
	form.put(CaretStrPool.WORK_ID, worImId);
	try {
		VcgSupport vcg = null;
		VcgAn app = null;
		if ( vcgId != 0 ){
			long associate = ParamUtil.getLong(request, "associate");
			if ( associate > 0 ) {
				associateWorkItem ( associate, vcgId, request );
			}
			vcg = VcgSupport.getVcgSupport(vcgId);
			app =  VcgAnLocalServiceUtil.getRecent(vcgId);
			if ( app == null ){
				app = new VcgAnImpl();
			}
			List<Docum> supportDocs = new ArrayList<Docum>();
			List<WorIm> workItems = WorImLocalServiceUtil.findByVcgId(vcgId);
			List<WorIm> openReferrals = new ArrayList<WorIm>();
			List<WorIm> closedReferrals = new ArrayList<WorIm>();
			List<WorIm> openWork = new ArrayList<WorIm>();
			List<WorIm> closedWork = new ArrayList<WorIm>();
			for ( WorIm workItem: workItems ){
				WorkType type = WorkType.valueOf( workItem.getType() );
				switch ( type ){
				case REFERRAL:
				case CALL_REFERRAL:
				case CSL_REFERRAL:
				case HEC_REFERRAL:
				case HRC_REFERRAL:
					if ( CaretStrPool.COMPLETE.equals( workItem.getStatus() ) ){
						closedReferrals.add(new WorkItemSupport(workItem));
					} else {
						openReferrals.add(new WorkItemSupport(workItem));
					}
					break;
				default:
					if ( workItem.getCompletionDate() != null ){
						closedWork.add(new WorkItemSupport(workItem));
					} else {
						openWork.add(new WorkItemSupport(workItem));
					}
				}
			}
			
			ResultMap.getResultTotalMap( request ).put( "vcgClosedRefs", closedReferrals.size() );
			ResultMap.getResultTotalMap( request ).put( "vcgOpenRefs", openReferrals.size() );
			ResultMap.getResultTotalMap( request ).put( "vcgClosedWork", closedWork.size() );
			ResultMap.getResultTotalMap( request ).put( "vcgOpenWork", openWork.size() );
			
			ResultMap.getResultListMap( request ).put("vcgClosedWork", closedWork);
			ResultMap.getResultListMap( request ).put("vcgOpenWork", openWork);
			ResultMap.getResultListMap( request ).put("vcgClosedRefs", closedReferrals);
			ResultMap.getResultListMap( request ).put("vcgOpenRefs", openReferrals);
			
			form.put("supportDocs", supportDocs );
			//_log.info("number of supporting docs is : "+supportDocs.size());
			
		}
		
		form.put(CaretStrPool.VCGAN, app);
		form.put("vcg", vcg);
		
						
		
		//***Start of Supporting Doc Code ****		
		VcgSupport vcgSupport = new VcgSupport(vcg);
		vcgSupport.getSupportingDocData();
				
		form.put("vcgDocsCurrent", vcgSupport.getVcgDocsCurrent());
		form.put("vcgDocsCurrentSize", vcgSupport.getVcgDocsCurrent().size());

		
		// Periodic Assessments code 
		String section = ParamUtil.getString(request, "section", "");
		form.put("section", section);
		
		form.put("EaE", CaretUtil.isMviEnabled());
		
		//***Start of Assessments Code***		
		form.put(CaretStrPool.VETERAN_ID, app.getVeteranId() );
		if ( vcgId > 0 ){
			//get all applications for the vcg record (vcgid) - then check for IN_PROCESS apps
			List<VcgAn> vcgAnList= VcgAnLocalServiceUtil.getByVcg(vcgId);				
			
			for(VcgAn vcgAn:vcgAnList)
			{
				String dateStr = Toolbox.formatDateCprs(vcgAn.getReceivedDate());
				if(vcg.getPrimaryVcgAnId()==vcgAn.getVcgAnId()){
					form.put("primaryValidAppDate", dateStr);
				}
				if(vcg.getSecondaryVcgAnId()==vcgAn.getVcgAnId()){
					form.put("secondaryValidAppDate", dateStr);
				}				 
				if(vcg.getSecondaryTwoVcgAnId()==vcgAn.getVcgAnId()){
					form.put("secondaryTwoValidAppDate", dateStr);
				}
			}
			
			//for periodic assessments
			if(vcg.getPrimaryDispReason()!=null && (vcg.isApproved(vcg.getPrimaryDispReason())||(vcg.isReinstated(vcg.getPrimaryDispReason())))){
				String dateStr = Toolbox.formatDateCprs(vcg.getPrimaryDispositionDate());
				form.put("primaryApprovalDate", dateStr);				
			}
		
			loadAssessments(request, form, vcg);
			
			String showSection = ParamUtil.getString(request, CaretStrPool.SHOW_SECTION, "");
			request.setAttribute("showSection", showSection);
			if(showSection!=null && !showSection.equals("")){
				request.setAttribute("showAssessments", true);			 
			}
		}
		//***End of Assessments Code***
		
		ResultMap.getCaretMap(request).put("noteContext", "vcg");
		
	} catch (IllegalArgumentException e) {
		ApplicationWorkFlowException.handleException(e);
	} catch (PortalException e) {
		ApplicationWorkFlowException.handleException(e);
	}
	
}


	@ProcessAction (name="loadProcessApplication")
	public void loadProcessApplication ( ActionRequest request, ActionResponse response ) {
		Map<String, Object> form = ResultMap.getForm(request);
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		form.put(CaretStrPool.WORK_ID, worImId);
		try {
			if ( worImId > 0 ){
				
				long vcgAnId = ParamUtil.getLong(request, CaretStrPool.PRIMARY_KEY);
				_log.info("primary key is : "+vcgAnId);
				VcgAn app = VcgAnLocalServiceUtil.getVcgAn( vcgAnId );
				Veteran veteran = new Veteran( PersnLocalServiceUtil.getPersn( app.getVeteranId() ) );
				
				form.put( CaretStrPool.VETERAN_PERSN, veteran );
				Boolean verifiedVeteranOnly = true; // || StringPool.TRUE.equals( PortletProps.get("process-app-veteran.registered") );
				form.put( CaretStrPool.REGISTERED_ONLY, verifiedVeteranOnly );
				
				if ( app.getPrimaryId() > 0 ){
					form.put(CaretStrPool.PRIMARY_PERSN, new Primary (PersnLocalServiceUtil.getPersn( app.getPrimaryId() ) ) );
				}
				if ( app.getSecondaryId() > 0 ){
					form.put(CaretStrPool.SECONDARY_PERSN, new Secondary (PersnLocalServiceUtil.getPersn( app.getSecondaryId() ) ) );
				}
				if ( app.getSecondaryTwoId() > 0 ){
					form.put(CaretStrPool.SECONDARY_TWO_PERSN, new SecondaryTwo (PersnLocalServiceUtil.getPersn( app.getSecondaryTwoId() ) ) );
				}
				String actives = Arrays.deepToString( veteran.getVcgActives() );
				form.put(CaretStrPool.ACTIVE_VCG, actives.substring(1,actives.length()-2) );
				form.put("workType", WorImLocalServiceUtil.getWorIm(worImId).getType() );
				form.put(CaretStrPool.VCGAN, app);
				
				List<Docum> supportDocs = DocumLocalServiceUtil.getByPrimaryKey( vcgAnId );
				form.put("supportDocs", supportDocs );
				_log.info("number of supporting docs is : "+supportDocs.size());
				form.put("veteranId", app.getVeteranId() );
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_DISPOSITION_PAGE);
			}
		} catch (IllegalArgumentException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}
	
	
	public void loadAssessments( ActionRequest request, Map<String,Object> form, Vcg vcg) 
	{
		try 
		{			
			AssmtBean primaryClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_CLINICAL); 				
			AssmtBean primaryAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_ASSESSMENT); 			
			AssmtBean primaryTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_TRAINING); 				
			AssmtBean primaryInHome = new AssmtBean(new AssmtImpl(), CaretStrPool.PRIMARY_IN_HOME); 				
			AssmtBean secondaryClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_CLINICAL); 
			AssmtBean secondaryAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_ASSESSMENT); 
			AssmtBean secondaryTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TRAINING); 
			AssmtBean secondaryTwoClinical = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_CLINICAL); 
			AssmtBean secondaryTwoAssessment = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_ASSESSMENT); 
			AssmtBean secondaryTwoTraining = new AssmtBean(new AssmtImpl(), CaretStrPool.SECONDARY_TWO_TRAINING); 
			
			List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcg.getVcgId());
			
			long year=0;
			for(Assmt assessment:completedAssessmentList)
			{
				//get active assessments for the caregiver
				if(assessment.isActive())
				{
					String dateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());				
					if(assessment.getType().equals(CaretStrPool.PRIMARY_CLINICAL) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryClinical.setAssessment(assessment);
						primaryClinical.setFormattedcompletionDate(dateStr);					
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_ASSESSMENT) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryAssessment.setAssessment(assessment);
						primaryAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_TRAINING) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryTraining.setAssessment(assessment);
						primaryTraining.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && assessment.getCaregiverId()==vcg.getPrimaryId()){
						primaryInHome.setAssessment(assessment);
						primaryInHome.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_CLINICAL) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryClinical.setAssessment(assessment);
						secondaryClinical.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_ASSESSMENT) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryAssessment.setAssessment(assessment);
						secondaryAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TRAINING) && assessment.getCaregiverId()==vcg.getSecondaryId()){
						secondaryTraining.setAssessment(assessment);
						secondaryTraining.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_CLINICAL) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoClinical.setAssessment(assessment);
						secondaryTwoClinical.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_ASSESSMENT) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoAssessment.setAssessment(assessment);
						secondaryTwoAssessment.setFormattedcompletionDate(dateStr);
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_TRAINING) && assessment.getCaregiverId()==vcg.getSecondaryTwoId()){
						secondaryTwoTraining.setAssessment(assessment);
						secondaryTwoTraining.setFormattedcompletionDate(dateStr);
					}
					
					if(assessment.getYear()>year){
						year = assessment.getYear();
					}
				}
			}
					
			
			List<AssmtBean> primaryAssessmentList = new ArrayList<AssmtBean>();
			primaryAssessmentList.add(primaryClinical);
			primaryAssessmentList.add(primaryAssessment);
			primaryAssessmentList.add(primaryTraining);
			primaryAssessmentList.add(primaryInHome);
			
			List<AssmtBean> secondaryAssessmentList = new ArrayList<AssmtBean>();
			secondaryAssessmentList.add(secondaryClinical);
			secondaryAssessmentList.add(secondaryAssessment);
			secondaryAssessmentList.add(secondaryTraining);

			List<AssmtBean> secondaryTwoAssessmentList = new ArrayList<AssmtBean>();
			secondaryTwoAssessmentList.add(secondaryTwoClinical);
			secondaryTwoAssessmentList.add(secondaryTwoAssessment);
			secondaryTwoAssessmentList.add(secondaryTwoTraining);

			form.put("primaryAssessmentList", primaryAssessmentList);
			form.put("secondaryAssessmentList", secondaryAssessmentList);
			form.put("secondaryTwoAssessmentList", secondaryTwoAssessmentList);				
			
			
			//****Start for Periodic Assessments*****
			
			//get current set of periodic assessments
			List<AssmtBean> periodicAssessmentList = new ArrayList<AssmtBean>();
			for(Assmt assessment:completedAssessmentList)
			{
				AssmtBean assmtBean = new AssmtBean(new AssmtImpl(), "");
				//String completionDateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());
				String completionDateStr = "";
				if(assessment.isActive() && assessment.getYear()>0 && (year==assessment.getYear() || (year-1)==assessment.getYear()))
				{
					String scheduleDateStr = Toolbox.formatDateCprs(assessment.getScheduleDate());
					if(assessment.getMode().equals(CaretStrPool.NOT_COMPLETED) && assessment.getCompletionDate()==null){
						completionDateStr = "";
					}else{
						completionDateStr = Toolbox.formatDateCprs(assessment.getCompletionDate());
					}
										
					assmtBean.setAssessment(assessment);
					assmtBean.setFormattedScheduleDate(scheduleDateStr);					
					assmtBean.setFormattedcompletionDate(completionDateStr);					
					periodicAssessmentList.add(assmtBean);
				}
				//_log.info("assessment id is : "+assessment.getAssmtId());
			}	
			
			//_log.info("periodic assmt number is : "+periodicAssessmentList.size());

			form.put("periodicAssessmentList", periodicAssessmentList);
			form.put("periodicAssessmentSize", periodicAssessmentList.size());
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	
	
	@ProcessAction (name="workClose")
	public void workClose ( ActionRequest request, ActionResponse response ) {
		_log.info("workClose");
		
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorkItemSupport workItem = new WorkItemSupport(WorImLocalServiceUtil.getWorIm(worImId) );
			switch ( WorkType.valueOf( workItem.getType() ) ){
			case CALL_REFERRAL:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
				
				workItem.setStatus( WorkStatus.COMPLETE.name() );
				workItem.setCompletionBy( sc.getUserId() );
				workItem.setCompletionDate( sc.getCreateDate() );
				
				CaretLocalServiceUtil.save(workItem);
				_log.info("adding note " + LanguageUtil.get( Locale.getDefault(), ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK) ) );
				CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(),
						worImId,
						workItem.getGroupId(),
						sc.getUserId(),
						ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK)));
				break;
			case FAILED_TIU_NOTE:
				if ( worImId > 0 && CAction.canDoCaret(request, CAction.CaretCan.APPROVE_TIU_REWRITE ) ){
					if ( workItem.getCompletionDate() == null ){
						VcgSupport vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( workItem.getVcgId() ) );
						WorkItemSupport cscWork = new WorkItemSupport( 
								CaretUtil.createWorkItem( sc, vcg.getGroupId(), vcg, WorkType.TIU_NOTE_REWRITE, vcg.getVeteranId(), workItem.getCaregiverId() ) );
						cscWork.setVcgId( workItem.getVcgId() );
						String note = ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK);
						if ( !Toolbox.isEmpty(note) ){
							Note noteObj = CaretUtil.createNote(sc.getCreateDate(), worImId, workItem.getGroupId(), sc.getUserId(), note);
							CaretLocalServiceUtil.addNote(noteObj);
							CaretLocalServiceUtil.save( cscWork );
							cscWork.useNote("tiuRewriteNote", noteObj);
							workItem.useNote("tiuRewriteNote", noteObj);
						}
						CaretLocalServiceUtil.save( cscWork );
						workItem.setCompletionBy( sc.getUserId() );
						workItem.setStatus( WorkStatus.COMPLETE.name() );
						workItem.setCompletionDate( sc.getCreateDate() );
						CaretLocalServiceUtil.save( workItem );
					}
				}
			default:
				break;
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	@ProcessAction (name="openReferral")
	public void openReferral ( ActionRequest request, ActionResponse response ) {
		
		try {
			WorkType type = WorkType.valueOf( ParamUtil.getString(request, "type", StringPool.BLANK) );  
			request.setAttribute(CaretStrPool.WORK_ID, ParamUtil.getLong(request, CaretStrPool.WORK_ID ) );
			switch ( type ){
			case CALL_REFERRAL:
				loadCall(request);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				break;
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
				loadReferral(request);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_REFERRAL_PAGE);
				break;
			default:
				break;
			}
			if ( "VCG_MANAGEMENT_PAGE".equals( ParamUtil.getString(request, "onPageComplete", StringPool.BLANK) ) ){
				ResultMap.getForm(request).put("onPageComplete", "VCG_MANAGEMENT_PAGE" );
//				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
			}
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IllegalArgumentException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
		
	}
	
//	
//	@SuppressWarnings("unchecked")
//	@ProcessAction (name="approvePaymentMonth")
//	public void approvePaymentMonth( ActionRequest actionRequest, ActionResponse actionResponse ) {
//		_log.info("approvePaymentMonth..." );
//		int m = ParamUtil.get(actionRequest, "month", 12);
//		int year = ParamUtil.get(actionRequest, "year", 0);
//		_log.info("month= " + m + ", year=" + year );
//		if ( m < 12 && year > 0 ){
//			Calendar calendar = Calendar.getInstance();
//			calendar.set(Calendar.MONTH, m);
//			calendar.set(Calendar.YEAR, year);
//			calendar.set(Calendar.DAY_OF_MONTH, 0);
//			calendar.set(Calendar.HOUR, 0);
//			Date date = calendar.getTime();
//			_log.info( "date=" + date );
//			
//			DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( StiPtImpl.class, PortalClassLoaderUtil.getClassLoader() )
//			.add ( PropertyFactoryUtil.forName ("StipendStartDate").gt( date ) );
//			calendar.roll(Calendar.MONTH, true);
//			Date date2 = calendar.getTime();
//			dynamicQuery.add ( PropertyFactoryUtil.forName ("StipendStartDate").lt( date2 ) )
//			.add ( PropertyFactoryUtil.forName ("StipendStatus").eq( "PENDING PAYMENT" ) );
//			List<StiPt> list = Collections.emptyList();
//			try {
//				list = StiPtLocalServiceUtil.dynamicQuery(dynamicQuery);
//				Date now = new Date();
//				for ( StiPt payment : list ){
//					PayLg payLog = new PayLgImpl();
//					Double paymentAmt = Double.valueOf( payment.getTierHours() ) * Double.valueOf( payment.getBlsRateHourly() );
//					payLog.setAmount( paymentAmt );
//					payLog.setPaymentDate( payment.getStipendStartDate() );
//					payLog.setStiPtId( payment.getPrimaryKey() );
//					PayLgLocalServiceUtil.addPayLg(payLog);
//					
//					payment.setStipendStatus("PAYMENT_FINANCED");
//					payment.setStipendApprovedDate(now);
//					payment.setMonthlyPayment( paymentAmt.toString() );
//					StiPtLocalServiceUtil.updateStiPt(payment);
//				}
//			} catch (SystemException e) {
//				ApplicationWorkFlowException.handleException(e);
//			}
//			actionRequest.setAttribute("monthYear", Months.values()[m] + ", " + year );
//		}
//	}
//	
	@ProcessAction (name="loadTen10App")
	public void loadVcgAnApp ( ActionRequest actionRequest, ActionResponse actionResponse ) {
		_log.info("loadTen10App..." );
		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/createTen10.jsp" );
		loadStatesAndFacilities( actionRequest );
	}
	
	public void loadStatesAndFacilities ( PortletRequest request ) {
		try {
			Map<String,Object> caret = ResultMap.getCaretMap(request);
			caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private void saveBoxGroups ( PortletRequest request, long primaryKey ){
		try {
			List<Long> fmChecks = CaretParam.loadSelectedBoxModel(request, CaretStrPool.BOX_GROUP);

			String[] radioNames = new String[]{
					"boxRadioGrp_heardFromUs", "boxRadioGrp_enrolledVaHealth", 
					"boxRadioGrp_dischargedAfter911", "boxRadioGrp_veteranScCondition",
					"boxRadioGrp_prescreenPcafc"
			};
			for ( String radio: radioNames ){
				Long radioId = ParamUtil.getLong(request, radio, 0);
				if ( radioId > 0 ){
					fmChecks.add(radioId);
				}
			}
			
			if ( primaryKey > 0 ){
				List<Long> updated = new ArrayList<Long>();
				List<BgAsn> bgAsnList = BoxGpLocalServiceUtil.getBoxGroupAssociations( primaryKey );
				for ( BgAsn bgAsn: bgAsnList ){
					if ( fmChecks.contains( bgAsn.getBoxGpId() ) ){
						if ( !bgAsn.isSelected() ){
							bgAsn.setSelected( true );
							CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
							updated.add( bgAsn.getBoxGpId() );
						}
						fmChecks.remove( bgAsn.getBoxGpId() );
					} else {
						if ( bgAsn.isSelected() ){
							bgAsn.setSelected( false );
							CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
						}
					}
				}
				for ( Long boxGpId: fmChecks){
					if ( ! updated.contains( boxGpId ) ){
						BgAsn bgAsn = new BgAsnImpl();
						bgAsn.setBoxGpId( boxGpId );
						bgAsn.setOwnerId( primaryKey );
						bgAsn.setSelected( true );
						CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
					}
				}
			} else {
				for ( Long boxGpId: fmChecks ){
					BgAsn bgAsn = new BgAsnImpl();
					bgAsn.setBoxGpId(boxGpId);
					bgAsn.setOwnerId( primaryKey );
					bgAsn.setSelected( true );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
				}
			}
			
			_log.info(fmChecks);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private void saveCall ( ActionRequest request ) throws ApplicationWorkFlowException{
		_log.info("saveCall..." );
		Call call = null;
		Person caller = null;
		Veteran veteran = null;
		
		getOutput(request);
		Long callId = ParamUtil.getLong(request, "call_primaryKey");
		Long veteranId = ParamUtil.getLong(request, "veteranPersn_primaryKey");
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		if ( callId > 0 ){
			try {
				call = CallLocalServiceUtil.getCall(callId);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		
		if ( call == null) {
			call = new CallImpl();
		}
			
		Long callerId = ParamUtil.getLong(request, "callerPersn_primaryKey");
		if ( callerId > 0 ){
			try {
				caller = new Person( PersnLocalServiceUtil.getPersn( callerId ) );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( caller == null ){
			caller = new Person ( new PersnImpl() );
		}
		//TODO: pass list of parameter names 
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");

		//TODO: pass list of parameter names 
		CaretParam.loadModel(request, caller, caller.getModelAttributes().keySet(), "callerPersn_");
		
		boolean unknown = ParamUtil.getBoolean(request,  "callerPersn_statusLabel");
		if ( unknown ){
			caller.setStatus(CaretStrPool.UNKNOWN_IDENTITY);
			caller.setFirstName(StringPool.BLANK);
			caller.setLastName(StringPool.BLANK);
		} else if ( !Toolbox.isEmpty( caller.getFirstName() ) ){
			caller.setStatus(StringPool.BLANK);
		} 
		
		if ( veteranId > 0 ){
			try {
				veteran = new Veteran ( PersnLocalServiceUtil.getPersn( veteranId ) );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		if ( veteran == null ){
			veteran = new Veteran ( new PersnImpl() );
		}
		//TODO: pass list of parameter names 
		
		CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(), "veteranPersn_");
		
		if ( veteran.isForeigner() ){
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.G_UNDERLINE );
		} else {
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.U_UNDERLINE );
		}
		
		if ( call.isSameAddress() ){
			caller.setAddress(veteran.getAddress());
			caller.setAddress2(veteran.getAddress2());
			caller.setZip(veteran.getZip());
			caller.setState(veteran.getState());
			caller.setCity(veteran.getCity());
			caller.setValidAddress(veteran.getValidAddress());
		} else {
			if ( caller.isForeigner() ){
				CaretParam.loadModel( request, caller, Toolbox.getAddressCollection(), CaretStrPool.CALLER_PERSN + CaretStrPool.G_UNDERLINE );
			} else {
				CaretParam.loadModel( request, caller, Toolbox.getAddressCollection(), CaretStrPool.CALLER_PERSN + CaretStrPool.U_UNDERLINE );
			}
		}
		CaretLocalServiceUtil.save( caller );
		CaretLocalServiceUtil.save( veteran );
		_log.info("veteran is " + veteran);
		
		long roleId = (Long)sc.getAttribute( CaretStrPool.ROLE_ID );
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );

		String message = null;
		if ( call.getPrimaryKey() == 0 ){
			call.setCreateGroupId( roleId );
			call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
			try {
				message = PortalUtil.getUser(request).getFullName() + " created " +
							LanguageUtil.get(themeDisplay.getLocale(), call.getCallType()) + " as " +
							LanguageUtil.get(themeDisplay.getLocale(), call.getCallState() ) ; 
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		call.setVeteranPersnId( veteran.getPersnId() );
		call.setCallerPersnId( caller.getPersnId() );
		if ( call.getCallId() > 0 ){
			call.setModificationDate( sc.getCreateDate() );
		}
		if ( call.getCallState() != null &&
				call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE)
				&& call.getCompletionDate() == null ){
			call.setCompletionDate(sc.getCreateDate());
		}
		call = (Call)CaretLocalServiceUtil.save( call );
		if ( CaretStrPool.CALL_STATE_REFERRAL.equals( call.getCallState() ) ){
			WorIm workItem = null;
			
			if ( veteran.getGroupId() > 0  ){//type, persnId
				if ( call.getWorkPrimaryKey() > 0 ){
					try {
						workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
						if ( workItem != null ){
							workItem.setGroupId( veteran.getGroupId() );
							CaretLocalServiceUtil.save( workItem );
						}
					} catch (PortalException e) {
						ApplicationWorkFlowException.handleException(e);
					} catch (SystemException e) {
						ApplicationWorkFlowException.handleException(e);
					}
				}
				if ( workItem == null ){
					workItem = CaretUtil.createWorkItem(sc, veteran.getGroupId(), call, WorkType.CALL_REFERRAL, veteran.getPersnId(), caller.getPersnId()  );
//					workItem.setQueId(CaretStrPool.REFERRAL_QUE);
					CaretLocalServiceUtil.save( workItem );
					call.setWorkPrimaryKey(workItem.getPrimaryKey());
					CaretLocalServiceUtil.save( call );
				}
			} else {
				throw new ApplicationWorkFlowException( "NEED GROUP ID" );
			}
			
		} else if ( !CaretStrPool.CALL_STATE_COMPLETE.equals(  call.getCallState() ) ){
			CalEt callEvent = new CalEtImpl();
			callEvent.setCallId(call.getCallId());
			StringBuilder sb = new StringBuilder( call.getCallType() );
			sb.append(CaretStrPool.COLON_SPACE);
			if ( call.isHangUp() ){
				sb.append("Hang-up, ");
			}
			if ( call.isWithoutContact() ){
				sb.append("Without-contact, ");
			}
			if ( call.isWrongNumber() ){
				sb.append("Wrong-number, ");
			}
			callEvent.setComment( sb.substring(0,sb.length()-1) );
			callEvent.setEvent( call.getCallState() );
			callEvent.setCreationDate( sc.getCreateDate() );
			CaretLocalServiceUtil.save(callEvent);
		}
		
		
		saveBoxGroups(request, call.getPrimaryKey());
		_log.info("adding note " + LanguageUtil.get( Locale.getDefault(), message	 ) );
		CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), call.getCallId(), roleId, sc.getUserId(), message) );
		_log.info("call is " + call);
	}
		
	public void saveSoc ( ActionRequest request ){
		_log.info("saveSoc..." );

		try {			
			getOutput(request);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			String thresholdMet = ParamUtil.get(request, "soc_tresholdMet", StringPool.BLANK);						

			long socId = CounterLocalServiceUtil.increment( ClSoc.class.getName() );
			ClSoc soc = ClSocLocalServiceUtil.createClSoc(socId);
			CaretParam.loadModel(request, soc,	soc.getModelAttributes().keySet(), "soc_");
			
			soc.setClSocId(socId);
			soc.setCreationDate(new Date());

			if(thresholdMet.equals("No")){
				String followupCall = ParamUtil.get(request, "soc_followupCall_q14", StringPool.BLANK);
				String followupCallTime = ParamUtil.get(request, "soc_followupCallTime_q14", StringPool.BLANK);
				soc.setFollowupCall(followupCall);
				soc.setFollowupCallTime(followupCallTime);
			}

			ClSocLocalServiceUtil.addClSoc(soc);
			
			//NOTE: TODO use save() to save soc
			//CaretLocalServiceUtil.save( soc );
			
			//create work item for follow up call			
			if(soc.getFollowupCall() != null && soc.getFollowupCall().equals("Yes")){
				Call call = CallLocalServiceUtil.getCall( Long.parseLong(ParamUtil.get(request, "soc_callId", StringPool.BLANK)) );
				long veteranId = call.getVeteranPersnId();
				Person veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				CaretLocalServiceUtil.save( CaretUtil.createWorkItem( sc, veteran.getGroupId(), soc, WorkType.SOC_FOLLOWUP, veteranId, call.getCallerPersnId() ));
			}
			
			CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), soc.getCallId(), (Long)sc.getAttribute( CaretStrPool.ROLE_ID ), sc.getUserId(), "Completed SOC Call Attempt - "+soc.getAttemptNum()) );			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	

	public void saveCesp ( ActionRequest request ){
		_log.info("saveCesp..." );

		try {
			getOutput(request);
			
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			int numOfCesp = ParamUtil.getInteger(request, "cesp_numOfCesp");
			String cespClosed = ParamUtil.get(request, "cesp_cespClosed", StringPool.BLANK);

			long cespId = CounterLocalServiceUtil.increment( Cesp.class.getName() );
			Cesp cesp = CespLocalServiceUtil.createCesp(cespId);
			CaretParam.loadModel(request, cesp, cesp.getModelAttributes().keySet(), "cesp_");
			
			cesp.setCespId(cespId);
			cesp.setCreationDate(new Date());

			String notification = "";
			if(numOfCesp == 0){
				cesp.setStatus(CaretStrPool.CESP_STATUS_INITIAL);//initial	
				notification = "CESP - Initial - Completed";
			}else if(cespClosed.equals("No")){
				cesp.setStatus(CaretStrPool.CESP_STATUS_COMPLETE);//complete - in step 2								
				notification = "CESP - Completed";
			}else if(cespClosed.equals("Yes")){
				cesp.setStatus(CaretStrPool.CESP_STATUS_CLOSED);//complete - cesp closed										
				notification = "CESP - Closed";
			}

			CespLocalServiceUtil.addCesp(cesp);
			//NOTE: TODO use save() to save cesp
			//CaretLocalServiceUtil.save( cesp );

			
			//create work item for CSC			
			if(null!=cesp.getCespClosedReason() 
				&& (cesp.getCespClosedReason().equals("Goals Reached") || cesp.getCespClosedReason().equals("Participation Discontinued - refer to CSC"))){
				Call call = CallLocalServiceUtil.getCall( Long.parseLong(ParamUtil.get(request, "cesp_callId", StringPool.BLANK)) );
				long veteranId = call.getVeteranPersnId();
				Person veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				CaretLocalServiceUtil.save( CaretUtil.createWorkItem( sc, veteran.getGroupId(), cesp, WorkType.CESP_CSC, veteranId, call.getCallerPersnId() ));
			}

			CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), cesp.getCallId(), (Long)sc.getAttribute( CaretStrPool.ROLE_ID ), sc.getUserId(), notification) );			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	private void saveReferral ( ActionRequest request ) throws ApplicationWorkFlowException{
		Call call = null;
		Person caller = null;
		WorIm workItem = null;

		getOutput(request);
		Long callId = ParamUtil.getLong(request, "call_primaryKey");

		Person veteran = null;
		Long veteranId = ParamUtil.getLong(request, "veteranPersn_primaryKey");
		if ( veteranId > 0 ){
			try {
				veteran = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( veteran == null ){
			veteran = new Person ( new PersnImpl() );
		}
		
		CaretParam.setCaretServiceContext(request);
		boolean createWorkItem = false;
		if ( callId > 0 ){
			try {
				call = CallLocalServiceUtil.getCall(callId);
				if ( call.getWorkPrimaryKey() > 0 ){
					workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
				} else {
					createWorkItem = true;
					workItem = new WorImImpl();
				}
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
			if ( workItem.getStatus().equals( StringPool.BLANK ) ){
				workItem.setStatus( WorkStatus.NEW.name() );
			}
			
			if ( !workItem.getStatus().equals( WorkStatus.NEW.name() ) ){
				throw new ApplicationWorkFlowException( "WORK ITEM ALREADY STARTED" );
			}
		}
		
		
			
		Long callerId = ParamUtil.getLong(request, "callerPersn_primaryKey");
		if ( callerId > 0 ){
			try {
				caller = new Person ( PersnLocalServiceUtil.getPersn( callerId ) );
			} catch (Exception e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		if ( caller == null ){
			caller = new Person ( new PersnImpl() );
		}
		
		//TODO: pass list of parameter names
		CaretParam.loadModel(request, caller, caller.getModelAttributes().keySet(), "callerPersn_");
		
		boolean unknown = ParamUtil.getBoolean(request,  "callerPersn_statusLabel");
		if ( unknown ){
			caller.setStatus(CaretStrPool.UNKNOWN_IDENTITY);
			caller.setFirstName(StringPool.BLANK);
			caller.setLastName(StringPool.BLANK);
		} else if ( !Toolbox.isEmpty( caller.getFirstName() ) ){
			caller.setStatus(StringPool.BLANK);
		}
		CaretLocalServiceUtil.save( caller );
		_log.info("caller is " + caller);
		

		//TODO: pass list of parameter names 
		CaretParam.loadModel(request, veteran, veteran.getModelAttributes().keySet(), "veteranPersn_");
		_log.info("veteran is " + veteran);
		if ( veteran.isForeigner() ){
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.G_UNDERLINE );
		} else {
			CaretParam.loadModel( request, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSN + CaretStrPool.U_UNDERLINE );
		}
		
		if ( call == null) {
			call = new CallImpl();
		}
		CaretParam.loadModel( request, call, call.getModelAttributes().keySet(), "call_");

		if ( call.isSameAddress() ){
			caller.setAddress( veteran.getAddress() );
			caller.setAddress2( veteran.getAddress2() );
			caller.setZip( veteran.getZip() );
			caller.setState( veteran.getState() );
			caller.setCity( veteran.getCity() );
			caller.setValidAddress( veteran.getValidAddress() );
		}
		CaretLocalServiceUtil.save( veteran );
		
		if ( ! CaretViewController.getViewController().validateRequired(CaretStrPool.CALL, request) ){
			throw new ApplicationWorkFlowException( "VALIDATION" );
		}
		

		ServiceContext sc = CaretParam.setCaretServiceContext( request );
		
		call.setVeteranPersnId( veteran.getPersnId() );
		call.setCallerPersnId( caller.getPersnId() );

		if ( call.getCallId() == 0 || createWorkItem ){
			call.setCallState(CaretStrPool.CALL_STATE_COMPLETE);
			DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
			call.setCreateGroupId( dashConfig.getRoleId() );
			call.setUserId( (Long) sc.getAttribute( CaretStrPool.USER_ID ) );
			CaretLocalServiceUtil.save( call );
			
			WorkType workType;
			if ( dashConfig instanceof CslDashboardConfig ){
				workType = WorkType.CSL_REFERRAL;
			} else {
				try{
					workType = WorkType.valueOf( dashConfig.getRole() + "_REFERRAL");
				} catch(Exception e){
					workType = WorkType.REFERRAL;
				}
			}
			
			workItem = CaretUtil.createWorkItem(sc, veteran.getGroupId(), call, workType, veteran.getPersnId(), call.getCallerPersnId() );
		} else {
			workItem.setGroupId( veteran.getGroupId() );
		}
		CaretLocalServiceUtil.save( workItem );
		call.setWorkPrimaryKey( workItem.getPrimaryKey() );
		if ( call.getCallState() != null &&
				call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE)
				&& call.getCompletionDate() == null ){
			call.setCompletionDate(sc.getCreateDate());
		}
		call = (Call)CaretLocalServiceUtil.save( call );
		_log.info("call is " + call);
		
		saveReferralQuestionaire ( call.getCallId(), request );
			
		
		//Supporting Docs attachment code
		try {		
			if ( request.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
				for ( Docum document : DocumLocalServiceUtil.getByPrimaryKey( call.getCallId() ) ){
					DocumLocalServiceUtil.deleteDocument( document );
				}
				String path = (String) request.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
				String name = (String) request.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassId(PortalUtil.getClassNameId(Call.class));
				attachment.setClassPk(call.getCallId());
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.REFERRAL_1010.name());
				handleApplicationDocument( request, attachment);
				request.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
				request.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			}
//			if ( request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
//				String path = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
//				String name = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
//				AttachmentBean attachment = new AttachmentBean();
//				attachment.setClassId(PortalUtil.getClassNameId(Call.class));
//				attachment.setClassPk(call.getCallId());
//				attachment.setPath(path);
//				attachment.setName(name);
//				attachment.setType(FileType.REFERRAL_POA.name());
//				handleApplicationDocument( request, attachment);
//				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
//				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
//			}
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
		_log.info("saveReferral..." );
	}
	
	private void saveReferralQuestionaire(long persnId, PortletRequest request) throws ApplicationWorkFlowException {
		
		List<Long> fmChecks = CaretParam.loadSelectedBoxModel(request, CaretStrPool.BOX_GROUP);

		String[] radioNames = new String[]{
				"boxRadioGrp_enrolledVaHealth", "boxRadioGrp_dischargedAfter911", 
				"boxRadioGrp_veteranScCondition", "boxRadioGrp_prescreenPcafc"
		};
		for ( String radio: radioNames ){
			Long radioId = ParamUtil.getLong(request, radio, 0);
			if ( radioId > 0 ){
				fmChecks.add(radioId);
			}
		}
		
		List<Long> updated = new ArrayList<Long>();

		Set<Long> privateSet = new HashSet<Long>();
		for ( BoxGp item: BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.REFERRAL_QUESTIONAIRE_YN) ){
			privateSet.add( item.getBoxGpId() );
		}
		boolean lodQa = CAction.canDoCaret(request, CaretCan.LOD_QA.name() );
		
		List<BgAsn> bgAsnList = BoxGpLocalServiceUtil.getBoxGroupAssociations( persnId );
		
		for ( BgAsn bgAsn: bgAsnList ){
			if ( !lodQa && privateSet.contains( bgAsn.getBoxGpId() ) ){
				fmChecks.remove( bgAsn.getBoxGpId() );
				continue;
			}
			if ( fmChecks.contains( bgAsn.getBoxGpId() ) ){
				if ( !bgAsn.isSelected() ){
					bgAsn.setSelected( true );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
					updated.add( bgAsn.getBoxGpId() );
				}
				fmChecks.remove( bgAsn.getBoxGpId() );
			} else {
				if ( bgAsn.isSelected() ){
					bgAsn.setSelected( false );
					CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
				}
			}
		}
		for ( Long boxGpId: fmChecks){
			if ( ! updated.contains( boxGpId ) ){
				BgAsn bgAsn = new BgAsnImpl();
				bgAsn.setBoxGpId( boxGpId );
				bgAsn.setOwnerId( persnId );
				bgAsn.setSelected( true );
				CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
			}
		}
	}

	
	public void getOutput( PortletRequest request ){
		CaretViewController.getViewController().getOutput(request);
	}
	
	public void writeTiuNote ( ActionRequest request, String noteBody, String noteTitle, VcgSupport vcg, Person.Role caregiverRole ) throws ApplicationWorkFlowException{
		_log.info("write TIU Note..." );
		
		try{
			ServiceFacade.WriteTIUNote(PersnLocalServiceUtil.getPersn( CaretParam.getPersnId(request) ),
					noteTitle,
					noteBody,
					vcg.getVeteran().getIcn());
			
			boolean exception = false;
			exception = "true".equals( PortletProps.get("tiu.pending") );
			//TODO: comment out when ServiceFacade.WriteTIUNote() is complete
			if ( exception ){
				throw new Exception("WriteTIUNote service impl. PENDING");
			}
			
		} catch ( Exception e ){
			String msg = request.getParameter("msg");
			ApplicationWorkFlowException.handleException(e, msg);
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorkItemSupport work = new WorkItemSupport( CaretUtil.createWorkItem( sc, vcg.getGroupId(), vcg, WorkType.FAILED_TIU_NOTE, vcg.getVeteranId(), vcg.getPersonId(caregiverRole) ) );
			work.setStatus("research-required");
			work.setQueId( sc.getUserId() );
			work.setVcgId( vcg.getVcgId() );
			work.setLeaAttr("FAILURE_DESC", "ERR CODE: Exception, ERR DESC: " + e.getMessage() );
			CaretLocalServiceUtil.save( work );
		}
	}

	public void newWorkNote ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException {
		String note = request.getParameter(CaretStrPool.WORK_COMMENT);
		try{
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			
			ServiceContext sc = CaretParam.setCaretServiceContext(request);

			String applicationStatus = request.getParameter("applicationStatus");
			if ( !Toolbox.isEmpty( applicationStatus ) && ( CaretStrPool.IN_PROCESS.equals( work.getStatus() ) || CaretStrPool.NEW.equals( work.getStatus() ) ) ){
				VcgApplication vcgAn = new VcgApplication ( VcgAnLocalServiceUtil.getVcgAn( work.getClassPk() ) );
				if ( CaretStrPool.IN_PROCESS.equals( applicationStatus ) ){
					applicationStatus = LanguageUtil.get( Locale.getDefault(), "awaiting-va-healthcare-enrollment");
					work.setNote("newWorkNote", applicationStatus + ":" + note, sc.getUserId(), sc.getCreateDate() );
					vcgAn.setStatus( ApplicationStatus.IN_REVIEW.name() );
				} else if ( CAction.canDoCaret( request, CAction.CaretCan.DISPOSITION_VCG.name() ) ) {
					VcgSupport vcgSupport = ( work.getVcgId() == 0? VcgSupport.getVeteranVcg( work.getPersnId() ) : new VcgSupport( VcgLocalServiceUtil.getVcg( work.getVcgId() ) ) );
					if ( CaretStrPool.DUPLICATE.equals(applicationStatus) ){
						vcgAn.setStatus( CaretStrPool.DUPLICATE );
						vcgAn.setStatus( ApplicationStatus.DECISION_MADE.name() );
						if ( vcgSupport.getVcgId() > 0 ){
							vcgSupport.setDuplicateApplication(vcgAn.getVcgAnId(), request.getParameter(CaretStrPool.DISPOSITION_NOTE) );
							CaretLocalServiceUtil.save(vcgSupport);
						}
					} else if ( CaretStrPool.INVALID.equals(applicationStatus) ){
						vcgAn.setStatus( CaretStrPool.INVALID );
						vcgAn.setStatus( ApplicationStatus.DECISION_MADE.name() );
						if ( vcgSupport.getVcgId() > 0 ){
							vcgSupport.setInvalidApplication( work.getClassPk(), note);
							CaretLocalServiceUtil.save(vcgSupport);
						}
					}
					work.setStatus(CaretStrPool.COMPLETE);
					work.setCompletionDate( sc.getCreateDate() );
					work.setCompletionBy( sc.getUserId() );
					work.setNote("newWorkNote", applicationStatus + ":" + note, sc.getUserId(), sc.getCreateDate() );
					if ( ApplicationStatus.DECISION_MADE.name().equals(vcgAn.getStatus() ) && WorkType.ONLINE_APP.equals( work.getType() ) ) {
						Set<Long> userSet = new HashSet<Long>();
						userSet.add( CaretStrPool.ALL_POS );
						setOnlineNotes(userSet, vcgAn, vcgSupport.getVeteran(), sc);
					}
				}
				CaretLocalServiceUtil.save(vcgAn);
			} else if ( !Toolbox.isEmpty(note) ){
				work.setNote("newWorkNote", note, sc.getUserId(), sc.getCreateDate() );
			}
			
			CaretLocalServiceUtil.save(work);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	
	public void submitTiuNote ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException {
		
		if ( CAction.canDoCaret(request, CAction.CaretCan.PERFORM_TIU_REWRITE) ) try {
			
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			VcgSupport vcg = new VcgSupport( VcgLocalServiceUtil.getVcg( work.getVcgId() ) );
			Person person = vcg.getPersonRole( work.getCaregiverId() );
			String dispositionChoice = vcg.caregiverDispReason( person.getRole() );
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			
			writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc),
					getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole());
			work.setStatus(WorkStatus.COMPLETE.name());
			work.setCompletionDate( sc.getCreateDate() );
			CaretLocalServiceUtil.save(work);
/*
			String body = request.getParameter(CaretStrPool.WORK_COMMENT);
			String header = request.getParameter("tiu_header");
			
			ServiceFacade.WriteTIUNote(PersnLocalServiceUtil.getPersn( CaretParam.getPersnId(request) ),
					getNoteTitle(vcg, dispositionChoice, person.getRole()),
					getNoteBody(vcg, dispositionChoice, person.getRole(), sc),
					vcg.getVeteran().getIcn());
			
			boolean exception = false;
			exception = "true".equals( PortletProps.get("tiu.pending") );
			//TODO: comment out when ServiceFacade.WriteTIUNote() is completed
			if ( exception ){
				ApplicationWorkFlowException.handleException("Could not not save TIU Note");
				if ( ! Toolbox.isEmpty(header) ){
					work.setNote("errorTiuRewrite", header, sc.getUserId(), sc.getCreateDate() );
				}
//				work.setNote("tiuWriteAttemptBody", body, sc.getUserId(), sc.getCreateDate() );
				CaretLocalServiceUtil.save( work );
			} else {
				work.setStatus(WorkStatus.COMPLETE.name());
				work.setCompletionDate( sc.getCreateDate() );
				CaretLocalServiceUtil.save(work);
			}
		*/	
			
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
	}
	
	public void saveVcgTier ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException{
		// see saveVcgEntry
		_log.info("saveVcgTier");
	}
	
	public void createVcg( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException {
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( request, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
		if (CAction.canDoCaret(request, CAction.CaretCan.DISPOSITION_VCG.name())) {
			_log.info("createVcg... ");
			getOutput(request);
			long veteranId = ParamUtil.getLong(request, "vcg_veteranId", 0);
			long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID);
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);

			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			String applicationStatus = request.getParameter("applicationStatus");

			VcgApplication vcgAn = null;
			WorIm worIm = null;
			VcgSupport vcgSupport = null;
			Veteran vcgVeteran = null;
			try {
				worIm = WorImLocalServiceUtil.getWorIm(worImId);
				vcgAn = new VcgApplication(VcgAnLocalServiceUtil.getVcgAn(vcgAnId));
				vcgAn.setStatus(applicationStatus);

				if (CaretStrPool.INVALID.equals(applicationStatus)) {
					String comment = "";
					if (veteranId > 0) {
						vcgVeteran = new Veteran(PersnLocalServiceUtil.getPersn(veteranId));
						vcgVeteran.setStatus(CaretStrPool.ACTIVE_VCG);
						
						vcgSupport = VcgSupport.getVeteranVcg(veteranId);
						vcgSupport.setGroupId(vcgVeteran.getGroupId());
						String noteStr = request.getParameter(CaretStrPool.DISPOSITION_NOTE);
						vcgSupport.setInvalidApplication(vcgAnId, noteStr);

						CaretLocalServiceUtil.save(vcgVeteran);
						Note note = CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgSupport.getVcgId(),
								0l, sc.getUserId(), noteStr));
						vcgSupport.useNote("Invalid", note);
						CaretLocalServiceUtil.save(vcgSupport);
						vcgAn.setVcgId(vcgSupport.getVcgId());
						
						worIm.setVcgId(vcgSupport.getVcgId());
					}
					vcgAn.setInvalidPerson(1, request.getParameter(CaretStrPool.DISPOSITION_NOTE) );
					vcgAn.setStatus(applicationStatus);
					CaretLocalServiceUtil.save(vcgAn);

					worIm.setStatus(WorkStatus.COMPLETE.name());
					worIm.setCompletionDate( sc.getCreateDate() );
					worIm.setCompletionBy( sc.getUserId() );
					CaretLocalServiceUtil.save(worIm);
					
					//Note for Online users
//					_log.info("adding note " + LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE) );
					if ( worIm.getType().equals( WorkType.ONLINE_APP.name() ) ){
						CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgAn.getVcgAnId(),
							0, vcgAn.getVeteranId(), LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE) ) );
					}
					return;
				} else if (veteranId == 0) {
					ApplicationWorkFlowException.handleException("VCG requires VeteranId");
					return;
				} 

				vcgVeteran = new Veteran(PersnLocalServiceUtil.getPersn(veteranId));
				vcgVeteran.setStatus(CaretStrPool.ACTIVE_VCG);
				vcgSupport = VcgSupport.getVeteranVcg(veteranId);
				boolean isNewVcg = vcgSupport.getVcgId() > 0;
				// groupId defect...
//				_log.info( "************************************");
//				_log.info( "************************************");
				_log.info( "VCG=Veteran=Application... groupId=" + vcgAn.getGroupId() );
//				_log.info( "************************************");
//				_log.info( "************************************");
				vcgSupport.setGroupId(vcgAn.getGroupId());
				vcgVeteran.setGroupId(vcgAn.getGroupId());

//				String comment = StringPool.BLANK;

				Map<Person,boolean[]> changeMap = new HashMap<Person,boolean[]>();
				List<String> errors = new ArrayList<String>();
				
				int invalids = 0;
				int caregivers = 0;
				int count = 0;
				Set<Long> userSet = new HashSet<Long>();
				
				if (CaretStrPool.DUPLICATE.equals(applicationStatus)) {
					worIm.setStatus( WorkStatus.COMPLETE.name() );
					worIm.setCompletionDate( sc.getCreateDate() );
					worIm.setCompletionBy( sc.getUserId() );
					vcgAn.setStatus( CaretStrPool.DUPLICATE );
					vcgSupport.setDuplicateApplication(vcgAn.getVcgAnId(), request.getParameter(CaretStrPool.DISPOSITION_NOTE) );
					
					userSet.add(CaretStrPool.ALL_POS);
				} else {
					worIm.setStatus(WorkStatus.IN_PROCESS.name());

					long primaryId = ParamUtil.getLong(request, "vcg_primaryId", 0);
					long secondaryId = ParamUtil.getLong(request, "vcg_secondaryId", 0);
					long secondaryTwoId = ParamUtil.getLong(request, "vcg_secondaryTwoId", 0);

					Person vcgPrimary = null, vcgSecondary = null, vcgSecondaryTwo = null;

					if (vcgAn.getVeteranId() != veteranId) {
						boolean[] changes = new boolean[Person.Changes.values().length];
						Persn merged = PersnLocalServiceUtil.getPersn(vcgAn.getVeteranId());
						errors.addAll( CaretViewController.getViewController().setVcgPerson(request,
								new Veteran(merged), vcgVeteran, changes) );
						if ( errors.isEmpty() ){
							merged.setStatus(CaretStrPool.REVISION_MERGED);
							CaretLocalServiceUtil.save(merged);
						}
						if ( vcgSupport != null && ( vcgSupport.isPrimaryApproved() || vcgSupport.isSecondaryApproved() || vcgSupport.isSecondaryTwoApproved() ) ){
							changeMap.put(vcgVeteran, changes);
						}
					}
					vcgAn.setVeteranId( veteranId );
					//init VCG 
					CaretLocalServiceUtil.save(vcgSupport);
					
					if (vcgAn.getPrimaryId() > 0) {
						Primary appPrimary = new Primary(PersnLocalServiceUtil.getPersn(vcgAn.getPrimaryId()));
						String primaryStatus = ParamUtil.get(request, "primaryStatus", StringPool.BLANK);
						caregivers++;
						if (CaretStrPool.INVALID.equals(primaryStatus)) { //Decision Made
							vcgAn.setInvalidPerson(vcgAn.getPrimaryId(), ParamUtil.get(request, "primaryNote", "Missing INVALID-App reason"));
							
							invalids++;
							userSet.add( appPrimary.getRootUserId() ); //Decision Made
						} else if (primaryId > 0) {
							vcgPrimary = new Primary(PersnLocalServiceUtil.getPersn(primaryId));
							if (CaretStrPool.IN_PROCESS.equals(primaryStatus)) {
								if ( vcgSupport.getPrimaryDispReason() != null && VcgSupport.isActive( vcgSupport.getPrimaryDispReason() ) ) {
									throw new ApplicationWorkFlowException("VCG - Primary Slot already reserved!");
								} else if (vcgAn.getPrimaryId() != primaryId) {
									boolean[] changes = new boolean[Person.Changes.values().length];
									CaretViewController.getViewController().setVcgPerson(request, appPrimary, vcgPrimary, changes);
									
									if ( vcgSupport != null && vcgSupport.isPrimaryApproved() ){
										changeMap.put(vcgPrimary, changes);
									}
									
								}
								vcgPrimary.setStatus(CaretStrPool.ACTIVE_VCG);
								vcgSupport.setNewPrimary( primaryId, vcgAn.getPrimaryRelationship(), vcgAnId );
								count++;
							}
						}
					}
					if (vcgAn.getSecondaryId() > 0) {
						Secondary appSecondary = new Secondary(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryId()));
						String secondaryStatus = ParamUtil.get(request, "secondaryStatus", StringPool.BLANK);
						caregivers++;
						if (CaretStrPool.INVALID.equals(secondaryStatus)) {
							vcgAn.setInvalidPerson(vcgAn.getSecondaryId(),
									ParamUtil.get(request, "secondaryNote", "Missing INVALID-App reason"));
							invalids++;
							userSet.add( appSecondary.getRootUserId() );
						} else if (secondaryId > 0) {
							vcgSecondary = new Secondary(PersnLocalServiceUtil.getPersn(secondaryId));
							if (CaretStrPool.IN_PROCESS.equals(secondaryStatus)) {
								if ( vcgSupport.getSecondaryDispReason() != null && VcgSupport.isActive( vcgSupport.getSecondaryDispReason() ) ) {
									throw new ApplicationWorkFlowException("VCG - Secondary Slot already reserved!");
								} else if (vcgAn.getSecondaryId() != secondaryId) {
									boolean[] changes = new boolean[Person.Changes.values().length];
									CaretViewController.getViewController().setVcgPerson(request, appSecondary,
											vcgSecondary, changes);
									if ( vcgSupport != null && vcgSupport.isSecondaryApproved() ){
										changeMap.put(vcgSecondary, changes);
									}
								}
								vcgSecondary.setStatus(CaretStrPool.ACTIVE_VCG);
								vcgSupport.setNewSecondary( secondaryId, vcgAn.getSecondaryRelationship(), vcgAnId );
								count++;
							}
						}
					}
					if (vcgAn.getSecondaryTwoId() > 0) {
						SecondaryTwo appSecondaryTwo = new SecondaryTwo(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryTwoId()));
						String secondaryTwoStatus = ParamUtil.get(request, "secondaryTwoStatus", StringPool.BLANK);
						caregivers++;
						
						if (CaretStrPool.INVALID.equals(secondaryTwoStatus)) {
							vcgAn.setInvalidPerson(vcgAn.getSecondaryTwoId(),
									ParamUtil.get(request, "secondaryTwoNote", "Missing INVALID-App reason"));
							invalids++;
							userSet.add( appSecondaryTwo.getRootUserId() );
						} else if (secondaryTwoId > 0) {
							vcgSecondaryTwo = new SecondaryTwo(PersnLocalServiceUtil.getPersn(secondaryTwoId));
							if (CaretStrPool.IN_PROCESS.equals(secondaryTwoStatus)) {
								if ( vcgSupport.getSecondaryTwoDispReason() != null && VcgSupport.isActive( vcgSupport.getSecondaryTwoDispReason() ) ) {
									throw new ApplicationWorkFlowException("VCG - Secondary II Slot already reserved!");
								} else if (vcgAn.getSecondaryTwoId() != secondaryTwoId) {
									boolean[] changes = new boolean[Person.Changes.values().length];
									CaretViewController.getViewController().setVcgPerson(request, appSecondaryTwo,
											vcgSecondaryTwo, changes);
									if ( vcgSupport != null && vcgSupport.isSecondaryTwoApproved() ){
										changeMap.put(vcgSecondaryTwo, changes);
									}
								}
								vcgSecondaryTwo.setStatus(CaretStrPool.ACTIVE_VCG);
								vcgSupport.setNewSecondaryTwo( secondaryTwoId, vcgAn.getSecondaryTwoRelationship(), vcgAnId );
								count++;
							}
						}
					}
				}
				setOnlineNotes(userSet, vcgAn, vcgVeteran, sc);
				
				CaretLocalServiceUtil.save(vcgSupport);
				CaretLocalServiceUtil.save(vcgVeteran);
				
				if ( invalids == caregivers || count == 0 ){
					worIm.setStatus(WorkStatus.COMPLETE.name());
					vcgAn.setStatus( ApplicationStatus.DECISION_MADE.name() );
				} else {
					vcgAn.setStatus( ApplicationStatus.IN_REVIEW.name() );
				}
				vcgAn.setVcgId( vcgSupport.getVcgId() );
				CaretLocalServiceUtil.save(vcgAn);

				worIm.setVcgId( vcgSupport.getVcgId() );
				CaretLocalServiceUtil.save(worIm);
				
				String comment = isNewVcg?
						"Updated VCG record with " + count + " new Caregiver selection(s)"
						: "Created new VCG record with " + count + " Caregiver selection(s)";
				CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgSupport.getVcgId(),
						NoteSupport.NoteGroup.CREATE_VCG.groupId(), sc.getUserId(), comment));
				
				for ( Person person: changeMap.keySet() ){
					CaretViewController.getViewController().applyWorkItem( request, changeMap.get(person), person, vcgSupport, person.getRole() );
					CaretLocalServiceUtil.save(person);
				}
				
				if ( CAction.canDoCaret(request, CAction.CaretCan.MANAGE_VCG.name()) ) {
					request.setAttribute( CaretStrPool.VCGID, vcgSupport.getVcgId() );
					loadVcgManagement(request, response);
					response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
				}
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}

	private void setOnlineNotes( Set<Long> userSet, VcgApplication vcgAn, Veteran vcgVeteran, ServiceContext sc ) throws ApplicationWorkFlowException, PortalException, SystemException {
		if ( userSet.contains( CaretStrPool.ALL_POS ) ){
			userSet.remove( CaretStrPool.ALL_POS );
			if ( vcgAn.getPrimaryId() > 0 ){
				userSet.add(new Primary(PersnLocalServiceUtil.getPersn(vcgAn.getPrimaryId())).getRootUserId());
			}
			if ( vcgAn.getSecondaryId() > 0 ){
				userSet.add(new Secondary(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryId())).getRootUserId());
			}
			if ( vcgAn.getSecondaryTwoId() > 0 ){
				userSet.add(new SecondaryTwo(PersnLocalServiceUtil.getPersn(vcgAn.getSecondaryTwoId())).getRootUserId());
			}
		}
		String onlineMessage = LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE) ;
		if ( !userSet.isEmpty() ){
			userSet.add(vcgVeteran.getRootUserId());
		}
		for ( Long id : userSet ){
			CaretLocalServiceUtil.addNote(CaretUtil.createNote(sc.getCreateDate(), vcgAn.getVcgAnId(), 0, id, onlineMessage ) );
		}
	}


	public void saveVcgDisposition ( ActionRequest request, VcgSupport vcg, Person person ) throws ApplicationWorkFlowException{
			String ndx = request.getParameter("vcg_ndx") + StringPool.UNDERLINE;
			Date dispositionDate = Toolbox.parseDate(request.getParameter(ndx + "dispositionDate"));
			String dispositionChoice = request.getParameter(ndx + "dispositionChoice");
			String dispositionReason = Toolbox.nullSafe( request.getParameter(ndx + "dispositionReason") );
			String oldDispositionState = null;
			long vcgAnId = 0;
			int[] extensionDays = new int[1];
			ServiceContext sc = CaretParam.setCaretServiceContext( request );
			boolean generalUpdate = false;
			Set<Long> userIds = new HashSet<Long>();
			
			if ( person.getRole() == Person.Role.PRIMARY && !vcg.getPrimaryDispReason().equals( dispositionChoice )){
				oldDispositionState = vcg.getPrimaryDispReason();
				vcg.setPrimaryDispReason( extDays(dispositionChoice, extensionDays) + dispositionReason  );
				userIds.add( vcg.getPrimary().getRootUserId() );
				vcgAnId = vcg.getPrimaryVcgAnId();
				if ( vcg.isRevoked( vcg.getPrimaryDispReason() ) ){
					vcg.setPrimaryRevocationDate(dispositionDate);
				} else {
					if ( vcg.isApproved(dispositionChoice) || vcg.isReinstated(dispositionChoice) ){
						Date tierEffectiveDate = Toolbox.parseDate(request.getParameter(ndx + "tierEffectiveDate"));
						vcg.setTierEffectiveDate(tierEffectiveDate );
						vcg.setTierLevel( ParamUtil.getInteger(request, ndx + "tier") );

						if ( vcg.getPrimaryInitDispDate() == null ){
							if ( vcg.isVacoWaiverPrimary() ){
								closeDelayWork ( request, person, sc, vcg );
							} else if ( vcg.isWaiverPrimary() ) {
								saveCscWaiver( request, person, sc, ndx, vcg, CaretStrPool.ACCEPTED );
							} 
						}
						
					}
					vcg.setPrimaryDispositionDate(dispositionDate);
				}
				
				if ( vcg.isRevoked( dispositionChoice ) || vcg.isApproved(dispositionChoice) || vcg.isReinstated(dispositionChoice) || vcg.isAppealed(dispositionChoice) ){
					writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc), getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole());
				}
				
				//**** Periodic Assessments
				//if disp == approved -> create 4 periodic assessments scheduled 90 days apart
				if(vcg.isApproved(dispositionChoice)){
					saveFirstPeriodicAssessments(request, vcg, person, dispositionDate);				
				}
				//if primary was revoked; inactivate all periodic assessments
				if(vcg.isRevoked(dispositionChoice)){
					_log.info("primary status changed from approved...inactivating periodic assmts...");
					inactivateAssessments(vcg.getVcgId(), vcg.getPrimaryId(), CaretStrPool.ASSMT_PERIODIC);
				}
				
				//if primary was reinstated; activate all periodic assessments
				if(vcg.isReinstated(dispositionChoice)){
					_log.info("primary status changed to reinstated...activating periodic assmts...");
					activateAssessments(vcg.getVcgId(), vcg.getPrimaryId(), CaretStrPool.ASSMT_PERIODIC);
				}
				
			} else if ( person.getRole() == Person.Role.SECONDARY && !vcg.getSecondaryDispReason().equals( dispositionChoice ) ){
				oldDispositionState = vcg.getSecondaryDispReason();
				vcg.setSecondaryDispReason( extDays(dispositionChoice, extensionDays) + dispositionReason  );
				vcgAnId = vcg.getSecondaryVcgAnId();
				userIds.add( vcg.getSecondary().getRootUserId() );
				if ( vcg.isRevoked( vcg.getSecondaryDispReason() ) ){
					vcg.setSecondaryRevocationDate(dispositionDate);
				} else {
					if ( vcg.isApproved(dispositionChoice) && vcg.getSecondaryInitDispDate()== null ){
						if ( vcg.isVacoWaiverSecondary() ){
							closeDelayWork ( request, person, sc, vcg );
						} else if ( vcg.isWaiverSecondary() ) {
							saveCscWaiver( request, person, sc, ndx, vcg, CaretStrPool.ACCEPTED);
						}
					}
					vcg.setSecondaryDispositionDate(dispositionDate);
				}
				if ( vcg.isRevoked( dispositionChoice ) || vcg.isApproved(dispositionChoice) || vcg.isReinstated(dispositionChoice) || vcg.isAppealed(dispositionChoice) ){
					writeTiuNote(request, getNoteBody(vcg, dispositionChoice, person.getRole(), sc), getNoteTitle(vcg, dispositionChoice, person.getRole()), vcg, person.getRole());
				}
			} else if ( person.getRole() == Person.Role.SECONDARYTWO && !vcg.getSecondaryTwoDispReason().equals( dispositionChoice )  ){
				oldDispositionState = vcg.getSecondaryTwoDispReason();
				vcg.setSecondaryTwoDispReason( extDays(dispositionChoice, extensionDays)  + dispositionReason );
				vcgAnId = vcg.getSecondaryTwoVcgAnId();
				userIds.add( vcg.getSecondaryTwo().getRootUserId() );
				if ( vcg.isRevoked( vcg.getSecondaryTwoDispReason() ) ){
					vcg.setSecondaryTwoRevocationDate(dispositionDate);
				} else {
					if ( vcg.isApproved(dispositionChoice) && vcg.getSecondaryInitDispDate() == null ){
						if ( vcg.isVacoWaiverSecondaryTwo() ){
							closeDelayWork ( request, person, sc, vcg );
						} else if ( vcg.isWaiverSecondaryTwo() ){
							saveCscWaiver( request, person, sc, ndx, vcg, CaretStrPool.ACCEPTED);
						}
					}
					vcg.setSecondaryTwoDispositionDate(dispositionDate);
				}
				if ( extensionDays[0] > 0 ){
					_log.info("Benefits extended " + extensionDays[0] + " days from revocation date");
				}
			} else if ( person.getRole() == Person.Role.GENERAL && !vcg.getGeneralDispReason().equals( dispositionChoice )  ){ // General Caregiver
				_log.info( "General Caregiver... update profile..." );
				generalUpdate = true;
 
				vcg.setGeneralDispReason( extDays(dispositionChoice, extensionDays)  + dispositionReason  );
				oldDispositionState = vcg.getGeneralDispReason();
				if ( vcg.isRevoked( vcg.getGeneralDispReason() ) ){
					vcg.setGeneralRevocationDate(dispositionDate);
				} else {
					vcg.setGeneralDispositionDate(dispositionDate);
				}
			}
			
			String note = request.getParameter(ndx + "note");
			if ( !CaretStrPool.IN_PROCESS.equals( dispositionChoice )){
				vcg.setNote("dispositionNote", note, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.DISPOSITION.groupId() );
			}
			
			
//			WorkType getDispositionWork()
			
			WorkType cbopcWork = vcg.getDispositionWork(dispositionChoice);
			if ( cbopcWork  != null ){
				//CBOPC Work Item
				Map<WorkType,WorIm> workItemMap = (Map)request.getAttribute("workItemMap");
				if ( workItemMap == null ){
					workItemMap = new HashMap<WorkType,WorIm>();
					request.setAttribute("workItemMap", workItemMap);
				}
				if ( !workItemMap.containsKey( cbopcWork ) ){
					WorIm workItem = CaretUtil.createWorkItem(sc, 0, vcg, cbopcWork, vcg.getVeteranId(), person.getPersnId() );
					workItem.setVcgId( vcg.getVcgId() );
					workItem.setQueId( sc.getUserId() );
					CaretLocalServiceUtil.save(workItem);
					workItemMap.put(cbopcWork, workItem);
				}
			}
	
			VcgApplication vcgApp = null;
			if ( !generalUpdate ){
				//Update active Work Item
				try {
					vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( vcgAnId ) );
					if ( vcgApp != null ){
						ApplicationStatus appStatus = null;
						List<WorIm> works = WorImLocalServiceUtil.findByClassId(vcg.getVcgId(), vcgAnId);
						if ( !works.isEmpty() ){
							WorkItemSupport vcgAppWork = new WorkItemSupport( works.get(0) );
							if ( vcgAppWork.isCompletable( vcg ) ){
								if ( !WorkStatus.COMPLETE.name().equals( vcgAppWork.getStatus() ) ){
									vcgAppWork.setStatus( CaretStrPool.COMPLETE );
									vcgAppWork.setCompletionBy(sc.getUserId());
									vcgAppWork.setCompletionDate(sc.getCreateDate());
									CaretLocalServiceUtil.save(vcgAppWork);
									appStatus = ApplicationStatus.DECISION_MADE;
								} else if ( !ApplicationStatus.DECISION_MADE.name().equals( vcgApp.getStatus() ) ){
									appStatus = ApplicationStatus.IN_REVIEW;
								}
							} else if ( !ApplicationStatus.DECISION_MADE.name().equals( vcgApp.getStatus() ) ){
								appStatus = ApplicationStatus.IN_REVIEW;
							}
						}
						if ( appStatus != null ){
							vcgApp.setStatus( appStatus.name() );
							CaretLocalServiceUtil.save( vcgApp );
						}
					}
				} catch (NoSuchClassNameException e) {
					throw new ApplicationWorkFlowException(e);
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException(e);
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException(e);
				}
			}
			
			if ( ! userIds.isEmpty() && vcgApp != null ) {
				String message = LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE);
				userIds.add( vcg.getVeteran().getRootUserId() );
				for ( long userId : userIds ){
					if ( userId > 0 ){
						CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgApp.getVcgAnId(), 0, userId, message ) );
					}
				}
			}
			CaretLocalServiceUtil.save(vcg);
		}
	
	
	private String getNoteBody(VcgSupport vcg, String dispositionChoice, Person.Role role, ServiceContext sc ) {
		StringBuilder sb = new StringBuilder();
		sb.append("Veteran’s Name - ").append(vcg.getVeteranName()).append("\n");
		sb.append("Veteran’s SSN - ").append(vcg.getVeteran().getSsn()).append("\n");
		
		VcgAn app = vcg.getPersonVcgAn(role);
		sb.append("Form 10-10CG Valid Date - ").append( Toolbox.formatDateCprs(app.getReceivedDate() ) ).append("\n");
		
		try {
			sb.append("Veteran Assessment Completed - ").append( Toolbox.formatDateCprs(vcg.geVeteranAssessmentCompletionDate() ) ).append("\n");
			sb.append("Caregiver Assessment Completed - ").append( Toolbox.formatDateCprs(vcg.getCaregiverAssessmentCompletionDate(role) ) ).append("\n");
			sb.append("Caregiver Training Verified - ").append( Toolbox.formatDateCprs(vcg.getCaregiverTrainingCompletionDate(role) ) ).append("\n");
			sb.append("In-Home Visit Completed - ").append( Toolbox.formatDateCprs(vcg.getInHomeCompletionDate(role) ) ).append("\n");
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		
		sb.append("Approval Date - ").append( Toolbox.formatDateCprs(sc.getCreateDate()) ).append("\n");
		sb.append("Approved Primary Family Caregiver Name - ").append(vcg.getPrimaryName()).append("\n");
//		(If there is a Secondary)
		if ( vcg.isSecondaryApproved() ){
			sb.append("Approved Secondary Family Caregiver Name - ").append(vcg.getSecondaryName()). append("\n");
		}
		
		
		return sb.toString();
	}


	private String getNoteTitle(VcgSupport vcg, String dispositionChoice, Person.Role role ) {
		
		String title = MessageFormat.format( LanguageUtil.get( Locale.getDefault(), "national-note-title-" + dispositionChoice ), role.name() );
		
		return title;
	}


	private void closeDelayWork(ActionRequest request, Person person, ServiceContext sc, VcgSupport vcg) throws ApplicationWorkFlowException {
		
		WorIm workItem = WorImLocalServiceUtil.findByCgWorkLast( vcg.getVcgId(), person.getPersnId(), WorkType.APP_DELAY.name() );
		
		if ( Toolbox.isEmpty( workItem.getStatus() ) || CaretStrPool.IN_PROCESS.equals( workItem.getStatus() ) ){
			throw new ApplicationWorkFlowException( "INVALID WORK ITEM STATUS" );
		} else {
			workItem = WorImLocalServiceUtil.findByCgWorkLast( vcg.getVcgId(), person.getPersnId(), WorkType.DELAY_REVIEWED.name() );
			workItem.setCompletionBy(PortalUtil.getUserId(request) );
			workItem.setCompletionDate( sc.getCreateDate() );
			workItem.setStatus( WorkStatus.COMPLETE.name() );
			
//			workItem.useNote(noteAtt, vcg.getNote(noteAtt));
			CaretLocalServiceUtil.save(workItem);
		}
		
	}


	private Waivr saveCscWaiver(ActionRequest request, Person person, ServiceContext sc, String ndx, Vcg vcg, String adjudication) throws ApplicationWorkFlowException {
		Waivr waiver = new WaivrImpl();
		waiver.setReason( request.getParameter(ndx + "waiverReason") );
		waiver.setNote( request.getParameter(ndx + "waiverNote") );
		waiver.setUserId( sc.getUserId() );
		waiver.setCreationDate( sc.getCreateDate() );
		waiver.setClassPk( vcg.getVcgId() );
		waiver.setAdjudication( adjudication );
		CaretLocalServiceUtil.save(waiver);
		return waiver;
	}


	private void saveFirstPeriodicAssessments(ActionRequest request, VcgSupport vcgSupport, Person person, Date dispositionDate){
		
		Map<String, Object> form = ResultMap.getForm(request);
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		
		//AssmtBean periodicAssmtOne = new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER1); 				
		//AssmtBean periodicAssmtTwo = new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER2);  			
		//AssmtBean periodicAssmtThree = new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER3); 				
		//AssmtBean periodicAssmtAnnual = new AssmtBean(new AssmtImpl(), CaretStrPool.ANNUAL); 

		List<AssmtBean> periodicAssessmentList = new ArrayList<AssmtBean>();
		//periodicAssessmentList.add(periodicAssmtOne);
		//periodicAssessmentList.add(periodicAssmtTwo);
		//periodicAssessmentList.add(periodicAssmtThree);
		//periodicAssessmentList.add(periodicAssmtAnnual);
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER1));
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER2));
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.QUARTER3));
		periodicAssessmentList.add(new AssmtBean(new AssmtImpl(), CaretStrPool.ANNUAL));

		try {
			Calendar c = Calendar.getInstance(); 
			c.setTime(dispositionDate);
			for(AssmtBean oneAssmt:periodicAssessmentList){
				oneAssmt.getAssessment().setYear(1);
				oneAssmt.getAssessment().setVcgId(vcgSupport.getVcgId());
				oneAssmt.getAssessment().setActive(true);
				oneAssmt.getAssessment().setCaregiverId(person.getPersnId());
				oneAssmt.getAssessment().setUserId(sc.getUserId());
				
				c.add(Calendar.DATE, 90);
				oneAssmt.getAssessment().setScheduleDate(c.getTime());	
				
				CaretLocalServiceUtil.save(oneAssmt.getAssessment());
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		form.put("periodicAssessmentList", periodicAssessmentList);
	}

	
	public void inactivateAssessments( long vcgId, long caregiverId, String category) 
	{
		String[] periodicTypes = {CaretStrPool.QUARTER1, CaretStrPool.QUARTER2, CaretStrPool.QUARTER3, CaretStrPool.ANNUAL};
		String[] initialTypes = {CaretStrPool.PRIMARY_ASSESSMENT, CaretStrPool.PRIMARY_CLINICAL, CaretStrPool.PRIMARY_TRAINING, CaretStrPool.PRIMARY_IN_HOME, CaretStrPool.SECONDARY_ASSESSMENT, CaretStrPool.SECONDARY_CLINICAL, CaretStrPool.SECONDARY_TRAINING, CaretStrPool.SECONDARY_TWO_ASSESSMENT, CaretStrPool.SECONDARY_TWO_CLINICAL, CaretStrPool.SECONDARY_TWO_TRAINING};

		try 
		{						
			List<Assmt> assessmentList;
			if(category.equals(CaretStrPool.ASSMT_PERIODIC)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, periodicTypes);
			}else if(category.equals(CaretStrPool.ASSMT_INITIAL)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, initialTypes);
			}else{
				assessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);
			}
			
			for(Assmt assessment:assessmentList)
			{
				if(assessment.isActive() && assessment.getCaregiverId()==caregiverId)
				{
					assessment.setActive(false);
					CaretLocalServiceUtil.save(assessment);
				}
			}			
		} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
		}
	}

	
	public void activateAssessments( long vcgId, long caregiverId, String category) 
	{
		String[] periodicTypes = {CaretStrPool.QUARTER1, CaretStrPool.QUARTER2, CaretStrPool.QUARTER3, CaretStrPool.ANNUAL};
		String[] initialTypes = {CaretStrPool.PRIMARY_ASSESSMENT, CaretStrPool.PRIMARY_CLINICAL, CaretStrPool.PRIMARY_TRAINING, CaretStrPool.PRIMARY_IN_HOME, CaretStrPool.SECONDARY_ASSESSMENT, CaretStrPool.SECONDARY_CLINICAL, CaretStrPool.SECONDARY_TRAINING, CaretStrPool.SECONDARY_TWO_ASSESSMENT, CaretStrPool.SECONDARY_TWO_CLINICAL, CaretStrPool.SECONDARY_TWO_TRAINING};

		try 
		{						
			List<Assmt> assessmentList;
			if(category.equals(CaretStrPool.ASSMT_PERIODIC)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, periodicTypes);
			}else if(category.equals(CaretStrPool.ASSMT_INITIAL)){
				assessmentList = AssmtLocalServiceUtil.findByAssmtTypes(vcgId, initialTypes);
			}else{
				assessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);
			}
			
			for(Assmt assessment:assessmentList)
			{
				if(!assessment.isActive() && assessment.getCaregiverId()==caregiverId)
				{
					assessment.setActive(true);
					CaretLocalServiceUtil.save(assessment);
				}
			}			
		} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
		}
	}



	private String extDays(String dispositionReason, int[] extensionDays) {
		int ndx = dispositionReason.indexOf("[");
		String temp = dispositionReason;
		if ( ndx > 0 ){
			temp = dispositionReason.substring(0,ndx);
			extensionDays[0] = Integer.valueOf( dispositionReason.substring(ndx+1, dispositionReason.indexOf("]")) );
		}
		return temp;
	}

	
	public void saveVcgEntry ( ActionRequest request, ActionResponse response ) throws ApplicationWorkFlowException{
		getOutput(request);
		String ndx = Toolbox.nullSafe(request.getParameter("ndx")) + StringPool.UNDERLINE;
		long persnId = ParamUtil.getLong(request, request.getParameter("vcg_ndx") + "_primaryKey", ParamUtil.getLong(request, "_primaryKey", ParamUtil.getLong(request, ndx + "primaryKey") ) );
		long vcgId = ParamUtil.getLong(request, request.getParameter("ndx") + "vcgId", ParamUtil.getLong(request, "vcgId") );
		String icn = request.getParameter(ndx + "iCN");
		
		ServiceContext sc = CaretParam.setCaretServiceContext( request );
		VcgSupport vcg = null;
		if ( vcgId > 0 ){
			vcg = VcgSupport.getVcgSupport( vcgId );
			
			if ( CAction.canDoCaret( request, CAction.CaretCan.MANAGE_VCG.name() ) ){
				int mode = ParamUtil.getInteger(request, "MODE", 0);
				
				try {
					
					Person person = null;
					Person formPerson = null;
					boolean isApproved = false;
//					boolean relationshipEmpty = mode == 1 || Toolbox.isEmpty( request.getParameter( ndx + "relationship" ) );
					if ( persnId > 0 ){
						if ( persnId == vcg.getVeteranId() ){
							if ( mode == 0 ){
								formPerson = (Veteran) CaretParam.loadModel( request, new Veteran( new PersnImpl() ), 
									Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "phone", "phone2", "ssn", "country", "validAddress",  "externalId", "vaHealthEnrolled", "groupId" ),
									ndx ); //TODO: create transfer work-item if facility is changed
							}
							person = new Veteran( PersnLocalServiceUtil.getPersn(persnId) );
							isApproved = vcg.isPrimaryApproved() || vcg.isSecondaryApproved() || vcg.isSecondaryTwoApproved();
						} else if ( persnId == vcg.getPrimaryId() ){
							person = new Primary( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0 ) {
								formPerson = (Primary) CaretParam.loadModel( request, new Primary( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "phone", "phone2", "ssn", "country", "validAddress",  "externalId", "otherInsChecked", "otherHealthInsurance", "mediEnrolled"),
										ndx );
								vcg.setPrimaryType( request.getParameter( ndx + "relationship" ) );
							}
							isApproved = vcg.isPrimaryApproved();
						} else if ( persnId == vcg.getSecondaryId() ){
							person = new Secondary( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0 ) {
								formPerson = (Secondary) CaretParam.loadModel( request, new Secondary( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
										ndx );
								vcg.setSecondaryType( request.getParameter( ndx + "relationship" ) );
							}
							isApproved = vcg.isSecondaryApproved();
						} else if ( persnId == vcg.getSecondaryTwoId() ){
							person = new SecondaryTwo( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0 ) {
								formPerson = (SecondaryTwo) CaretParam.loadModel( request, new SecondaryTwo( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
										ndx );
								vcg.setSecondaryTwoType( request.getParameter( ndx + "relationship" ) );
							}
							isApproved = vcg.isSecondaryTwoApproved();
						} else {
							person = new General( PersnLocalServiceUtil.getPersn(persnId) );
							if ( mode == 0  || mode == 3 ) {
								formPerson = (General) CaretParam.loadModel( request, new General( new PersnImpl() ), 
										Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
										ndx );
								vcg.setGeneralType( request.getParameter( ndx + "relationship" ) );
							}
						}
					} else if ( mode == 3 ) {
						person = new General( new PersnImpl() );
						if ( mode == 0  || mode == 3 ) {
							formPerson = (General) CaretParam.loadModel( request, new General( new PersnImpl() ), 
									Toolbox.getCollection("firstName","lastName","middleName", "birthDate", "gender", "email", "address", "phone", "phone2", "ssn", "country", "validAddress",  "externalId" ),
									ndx );
						}
					}
					
					
					if ( mode == 0 || mode == 3 ){
						if ( formPerson.isForeigner() ){
							CaretParam.loadModel( request, formPerson, Toolbox.getAddressCollection(), Toolbox.nullSafe(request.getParameter("ndx")) + CaretStrPool.G_UNDERLINE );
						} else {
							CaretParam.loadModel( request, formPerson, Toolbox.getAddressCollection(), Toolbox.nullSafe(request.getParameter("ndx")) + CaretStrPool.U_UNDERLINE );
						}
					}
					
					switch ( mode ){
						case 1:
							if ( CAction.canDoCaret( request, CAction.CaretCan.DISPOSITION_VCG.name() ) ){
								saveVcgDisposition ( request, vcg, person );
							}
							break;
						case 2:
							
							if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_TIER_LEVEL.name() ) ){
								String tierEffectiveDate = request.getParameter(ndx + "tierEffectiveDate");
								String tierLevelStr = request.getParameter(ndx + "tier");
								String dispositionDate = request.getParameter(ndx + "dispositionDate");
								String caretNote = request.getParameter("caret_note");
								int tierLevel = Integer.valueOf(String.valueOf(tierLevelStr.charAt(4)));
								int oldTier = vcg.getTierLevel();
//								VcgSupport vcgSupport = new VcgSupport(vcg);
								if ( tierEffectiveDate != null && !vcg.getTierEffectiveDateStr().equals( tierEffectiveDate ) ||
										vcg.getTierLevel() != tierLevel ){
									vcg.setTierEffectiveDateStr( tierEffectiveDate );
									if ( dispositionDate!= null && !StringPool.BLANK.equals( dispositionDate ) ){
										vcg.setPrimaryDispositionDate( Toolbox.parseDate(dispositionDate) );
									}
									vcg.setTierLevel( tierLevel  );
					
									vcg.setNote("tierUpdateNote", caretNote, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.TIER_UPDATE.groupId() );
									CaretLocalServiceUtil.save(vcg);
									
									if ( tierLevel != oldTier ){
										String message = LanguageUtil.get( Locale.getDefault(), CaretStrPool.DISPOSITIONED_ONLINE_MESSAGE);
										CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), vcg.getPrimaryVcgAnId(), 0, person.getRootUserId(), message ) );
										CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), vcg.getPrimaryVcgAnId(), 0, vcg.getVeteran().getRootUserId(), message ) );
									}
									
									WorIm workItem = CaretUtil.createWorkItem(sc, 0, vcg, WorkType.TIER_UPDATE, 
											vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() );
									workItem.setQueId( sc.getUserId() );
									workItem.setVcgId(vcgId);
									CaretLocalServiceUtil.save( workItem );
									
								} 
							}
							break;
						case 3: //assigning General CG
							
							if ( vcg.getGeneralId() > 0 && ( vcg.isApproved( vcg.getGeneralDispReason() ) || vcg.isReinstated( vcg.getGeneralDispReason() ) ) ){
								throw new ApplicationWorkFlowException ( "Cannot over-write an approved General Caregiver for a new General Caregiver ");
							}
							
							if ( CaretViewController.getViewController().setVcgPerson( request, formPerson, person, new boolean[5]).isEmpty() ){
								CaretLocalServiceUtil.save(person);
								vcg.setNote("generalAssignmentNote", ParamUtil.get(request, CaretStrPool.WORK_COMMENT, CaretStrPool.ASSIGNED_GENERAL_CG_MESSAGE ),
										sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.ASSIGN_GENERAL.groupId() );
								
								vcg.setNewGeneral(person.getPersnId(), request.getParameter( ndx + "relationship" ) );
								CaretLocalServiceUtil.save(vcg);
							}
							
							break;
						case 4:
//							String vcgNdx = request.getParameter("vcg_ndx") + StringPool.UNDERLINE;
							Waivr waiver = saveCscWaiver( request, person, sc, ndx, vcg, null );
							VcgAn vcgAn = vcg.getPersonVcgAn( persnId );
							WorkItemSupport workAppDelay =  new WorkItemSupport(CaretUtil.createWorkItem(sc, vcg.getGroupId(), vcgAn, WorkType.APP_DELAY, vcg.getVeteranId(), persnId));
							workAppDelay.setVcgId( vcg.getVcgId() );
							workAppDelay.setQueId( waiver.getWaivrId() );
							CaretLocalServiceUtil.save(workAppDelay);
							
							vcg.setNote("appDelayNote",  request.getParameter(ndx + "waiverNote"),
									sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.APP_DELAY.groupId() );
							CaretLocalServiceUtil.save(vcg);

							workAppDelay.useNote("appDelayNote", vcg.getNote("appDelayNote"));
							CaretLocalServiceUtil.save(workAppDelay);
							break;
						default:
					
							
						
						boolean[] change = new boolean[5];
						
						List<String> errors = CaretViewController.getViewController().setVcgPerson( request, formPerson, person, change);
						
						if ( ! errors.isEmpty() ){
							request.setAttribute("SAVE_FAILED", errors.get(0) );
							return;
						}
						
						if ( change[Person.Changes.INSURANCE_CHANGE.ordinal()] || 
								change[Person.Changes.ADDRESS_CHANGE.ordinal()] || 
								change[Person.Changes.PII_CHANGE.ordinal()] || 
								change[Person.Changes.FACILITY_CHANGE.ordinal()] || 
								change[Person.Changes.NAME_CHANGE.ordinal()] ){
							if ( isApproved ){
								List <WorIm> workItems =  CaretUtil.createWorkItems(request, 0, person, change, 
										vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() ) ;
								
								for ( WorIm workItem : workItems ){
									workItem.setQueId( sc.getUserId() );
									workItem.setVcgId(vcgId);
									CaretLocalServiceUtil.save(workItem);
									_log.info("adding note " + ParamUtil.get(request,CaretStrPool.WORK_COMMENT, StringPool.BLANK ) );
								}
//								CaretLocalServiceUtil.addNote( Toolbox.createNote( 
//										sc.getCreateDate(),
//										person.getPersnId(),
//										vcg.getVcgId(),
//										sc.getUserId(),
//										ParamUtil.get(request, CaretStrPool.WORK_COMMENT, CaretStrPool.SYSTEM_GENERATED_WORK ) ) );
							}
							String comment = request.getParameter(CaretStrPool.WORK_COMMENT);
							if ( !Toolbox.isEmpty(comment) ){
								vcg.setNote(person.getRole().getLabel()+"Note", request.getParameter(CaretStrPool.WORK_COMMENT), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.PROFILE_UPDATE.groupId() );
								CaretLocalServiceUtil.save(vcg);
							}
//							if ( change[Person.Changes.ADDRESS_CHANGE.ordinal()] ){
//								StringBuilder sb = new StringBuilder().append(person.getAddress())
//										.append( person.getCity() ).append( person.getState()).append( person.getZip());
//								boolean valid = isValid(request, person.getAddress(), person.getCity(), person.getState(), person.getZip() );
//								person.setValidAddress( valid );
//							}
							CaretLocalServiceUtil.save(person);
						} else {
							String comment = request.getParameter(CaretStrPool.WORK_COMMENT);
							if ( !Toolbox.isEmpty(comment) ){
								vcg.setNote(person.getRole().getLabel()+"Note", request.getParameter(CaretStrPool.WORK_COMMENT), sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CAREGIVER_INFO.groupId() );
								CaretLocalServiceUtil.save(vcg);
							}
						}
					}

				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
				
				loadVcgManagement (request, response);
				response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
			}
		} else {
			_log.info("vcgId == 0");
			Veteran vcgVeteran;
			try {
				if ( persnId > 0 ){
					vcgVeteran = new Veteran(PersnLocalServiceUtil.getPersn(persnId));
				} else if ( !Toolbox.isEmpty(icn) ){
					vcgVeteran = new Veteran(new PersnImpl());
					vcgVeteran.setICN(icn);
					vcgVeteran.setLastName(request.getParameter("veteranPersonu_lastName"));
				} else {
					throw new ApplicationWorkFlowException ( "NEED VERIFIED ID FOR VCG CREATION" );
				}
				CaretParam.loadModel(request, vcgVeteran, vcgVeteran.getModelAttributes().keySet(), ndx);
				if ( vcgVeteran.isForeigner() ){
					CaretParam.loadModel( request, vcgVeteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + CaretStrPool.G_UNDERLINE );
				} else {
					CaretParam.loadModel( request, vcgVeteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + CaretStrPool.U_UNDERLINE );
				}
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
			vcgVeteran.setStatus(CaretStrPool.ACTIVE_VCG);
			vcgVeteran.setVaHealthEnrolled(ParamUtil.get(request, ndx + "_vaHealthEnrolled", false));
			CaretLocalServiceUtil.save(vcgVeteran);
			VcgSupport vcgSupport = VcgSupport.getVeteranVcg( vcgVeteran.getPersnId() );
			vcgSupport.setGroupId(vcgVeteran.getGroupId());

			CaretLocalServiceUtil.save(vcgSupport);
			vcgSupport.setNote("vcgCreateNote", ParamUtil.get(request, "veteranPerson_comments", "Created a VCG Record"),
					sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.CREATE_VCG.groupId());
			CaretLocalServiceUtil.save(vcgSupport);

			Note note = vcgSupport.getNote("vcgCreateNote");
			long worImId = ParamUtil.getLong(request, "worImId");
			if ( worImId > 0 ){
				try {
					WorkItemSupport workItem = new WorkItemSupport ( WorImLocalServiceUtil.getWorIm(worImId) );
					workItem.useNote("vcgCreateNote", note);
					workItem.setVcgId( vcgSupport.getVcgId() );
					CaretLocalServiceUtil.save(workItem);
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException();
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException();
				}
			}
			vcg = vcgSupport;
		}
		
		if ( vcg != null ){
			request.setAttribute(CaretStrPool.VCGID, vcg.getVcgId() );
		}
		loadVcgManagement (request, response);
		request.setAttribute( CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE );
	}
	
	private boolean isValid( PortletRequest request, String address, String city, String state, String zip ) {
		PortletSession session = request.getPortletSession();
		StringBuilder sb = new StringBuilder().append(address).append( city ).append( state ).append( zip );
		Boolean valid = (Boolean)session.getAttribute( sb.toString() );
		if ( valid == null ){
			valid = CaretUtil.isValidateUspsAddress(address, city, state, zip );
			session.setAttribute( sb.toString() , valid );
		}
		return valid;
	}


	public void associateWorkItem ( long associateId, long vcgId, PortletRequest request ) throws ApplicationWorkFlowException{
		if ( associateId > 0 ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				WorkItemSupport associateWorIm = new WorkItemSupport ( WorImLocalServiceUtil.getWorIm(associateId) );
				String summary = null;
				if ( WorkType.CALL_REFERRAL.equals( associateWorIm.getWorkType() ) ) {
					summary = CallLocalServiceUtil.getCall( associateWorIm.getClassPk() ).getSummary();
				}
				associateWorIm.setVcgId(vcgId); 
				String comment = "Associated " + associateWorIm.getType() + " to VCG. ";
				if ( !Toolbox.isEmpty(summary) ){
					associateWorIm.setNote("callSummary", summary, sc.getUserId(), sc.getCreateDate() );
					associateWorIm.setNote("associatedNote", comment, sc.getUserId(), sc.getCreateDate() );
				} else {
					associateWorIm.setNote("associatedNote", comment, sc.getUserId(), sc.getCreateDate() );
				}
				if ( CaretStrPool.NEW.equals( associateWorIm.getStatus() ) ){
					associateWorIm.setStatus( CaretStrPool.IN_PROCESS );
				}
				CaretLocalServiceUtil.save(associateWorIm);
				Note note = associateWorIm.getNote( "associatedNote" );
				
				VcgSupport vcgSupport = VcgSupport.getVcgSupport(vcgId);
				vcgSupport.useNote("workItemAssociate", note );
				CaretLocalServiceUtil.save( vcgSupport );
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException();
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException();
			}
		}
	}
	
	public void saveVcgAn ( ActionRequest actionRequest ){
		_log.info("saveVcgAn..." );
		getOutput(actionRequest);
		
		try {
			
			VcgApplication vcgApplication = new VcgApplication( new VcgAnImpl() );
			CaretParam.loadModel(actionRequest, vcgApplication, vcgApplication.getModelAttributes().keySet(), CaretStrPool.VCGAN_UNDERLINE);
						
			//create new person records in db for veteran and caregivers
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			vcgApplication.setCreationDate(sc.getCreateDate());
			
			long caregiverId = 0;
			
			String veteranFirstName = ParamUtil.get(actionRequest, "veteranPerson_firstName", "");
			if(!veteranFirstName.equals("")){			
				Veteran veteran = new Veteran( new PersnImpl() );
				CaretParam.loadModel(actionRequest, veteran, veteran.getModelAttributes().keySet(), CaretStrPool.VETERAN_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(veteran.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + "u_" );
				}else if(!"false".equals(veteran.getCountry())){//foreign address
					CaretParam.loadModel(actionRequest, veteran, Toolbox.getAddressCollection(), CaretStrPool.VETERAN_PERSON + "g_" );										
				}	
				veteran.setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );
				CaretLocalServiceUtil.save( veteran );
				vcgApplication.setVeteranId(veteran.getPersnId());
			}

			String primaryFirstName = ParamUtil.get(actionRequest, "primaryPerson_firstName", "");
			if(!primaryFirstName.equals("")){			
				Primary primary = new Primary ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, primary, primary.getModelAttributes().keySet(), CaretStrPool.PRIMARY_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(primary.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, primary, Toolbox.getAddressCollection(), CaretStrPool.PRIMARY_PERSON + "u_" );
					if ( PortletProps.get("csc.required.primary.input").contains("uspsValidation") && primary.isCompleteDomesticAddress() && !primary.isForeigner() ){
						primary.setValidAddress(true);
					}
				} else if (!"false".equals(primary.getCountry())){
					CaretParam.loadModel(actionRequest, primary, Toolbox.getAddressCollection(), CaretStrPool.PRIMARY_PERSON + "g_" );					
				}
				primary.setOtherInsChecked(ParamUtil.getBoolean(actionRequest, "primaryPerson_otherHealthInsuranceYesNo"));
				primary.setMediEnrolled(vcgApplication.getMediEnrolled());
				CaretLocalServiceUtil.save( primary );
				vcgApplication.setPrimaryId(primary.getPersnId());
				caregiverId = primary.getPersnId();
			}

			String secondaryFirstName = ParamUtil.get(actionRequest, "secondaryPerson_firstName", "");
			if(!secondaryFirstName.equals("")){			
				Person secondary = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, secondary, secondary.getModelAttributes().keySet(), CaretStrPool.SECONDARY_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(secondary.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, secondary, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_PERSON + "u_" );
				}else if(!"false".equals(secondary.getCountry()) ){
					CaretParam.loadModel(actionRequest, secondary, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_PERSON + "g_" );					
				}
				CaretLocalServiceUtil.save( secondary );
				vcgApplication.setSecondaryId(secondary.getPersnId());
				if ( caregiverId == 0 ){
					caregiverId = secondary.getPersnId();
				}
			}

			String secondaryTwoFirstName = ParamUtil.get(actionRequest, "secondaryTwoPerson_firstName", "");
			if(!secondaryTwoFirstName.equals("")){			
				Person secondaryTwo = new Person ( new PersnImpl() );
				CaretParam.loadModel(actionRequest, secondaryTwo, secondaryTwo.getModelAttributes().keySet(), CaretStrPool.SECONDARY_TWO_PERSON  + StringPool.UNDERLINE);
				if( "false".equals(secondaryTwo.getCountry()) ){ //usa address
					CaretParam.loadModel(actionRequest, secondaryTwo, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_TWO_PERSON + "u_" );
				}else if(!"false".equals(secondaryTwo.getCountry()) ){
					CaretParam.loadModel(actionRequest, secondaryTwo, Toolbox.getAddressCollection(), CaretStrPool.SECONDARY_TWO_PERSON + "g_" );
				}
				CaretLocalServiceUtil.save( secondaryTwo );
				vcgApplication.setSecondaryTwoId(secondaryTwo.getPersnId());
				if ( caregiverId == 0 ){
					caregiverId = secondaryTwo.getPersnId();
				}
			}

			boolean foreignCountry = ParamUtil.getBoolean(actionRequest, "veteranPerson_country");
			String groupId = "";
			if(foreignCountry){
				groupId = ParamUtil.get(actionRequest, "veteranPersong_groupId", "");
			}else{
				groupId = ParamUtil.get(actionRequest, "veteranPerson_groupId", "");
			}
			if(!groupId.equals("")){vcgApplication.setGroupId(Long.parseLong(groupId));}

			CaretLocalServiceUtil.save( vcgApplication );
			
			/*
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
				String type = FileType.CSC_1010.name();
				handleApplicationDocument( actionRequest, vcgApplication, path, name, type );				
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			}
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
				String type = FileType.CSC_POA.name();
				handleApplicationDocument( actionRequest, vcgApplication, path, name, type );				
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
			}
			*/
			
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.FILE_NAME);
				//String type = FileType.CSC_1010.name();
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassPk(vcgApplication.getVcgAnId());
				attachment.setClassId(PortalUtil.getClassNameId(VcgAn.class));
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.CSC_1010.name());
				//handleApplicationDocument( actionRequest, vcgApplication, path, name, type );
				handleApplicationDocument( actionRequest, attachment);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			}
			if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
				String path = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
				String name = (String) actionRequest.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
				//String type = FileType.CSC_POA.name();
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassPk(vcgApplication.getVcgAnId());
				attachment.setClassId(PortalUtil.getClassNameId(VcgAn.class));
				attachment.setPath(path);
				attachment.setName(name);
				attachment.setType(FileType.CSC_POA.name());
				//handleApplicationDocument( actionRequest, vcgApplication, path, name, type );
				handleApplicationDocument( actionRequest, attachment);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_PATH);
				actionRequest.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
			}
			WorkItemSupport work = new WorkItemSupport( CaretUtil.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.CSC_APP, vcgApplication.getVeteranId(), caregiverId ) );
			CaretLocalServiceUtil.save( work );
			work.setNote("cscNewApp", actionRequest.getParameter("vcgAn_comments"), sc.getUserId(), sc.getCreateDate() );
			CaretLocalServiceUtil.save( work );
			
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
//	public void handleApplicationDocument ( PortletRequest request, VcgAn vcgApplication, String path, String name, String type) throws FileNotFoundException, SystemException {
	public void handleApplicationDocument ( PortletRequest request, AttachmentBean attachment) throws FileNotFoundException, SystemException {
		
		//File uploadFile = new File(path);
		File uploadFile = new File(attachment.getPath());
		InputStream inputStream = new FileInputStream( uploadFile );
		OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
		
		long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
		Docum document = DocumLocalServiceUtil.createDocum(documId);
		document.setDocument(outputBlob);
		document.setDeleted(false);
		//document.setClassPk( vcgApplication.getVcgAnId() );
		//document.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
		document.setClassPk( attachment.getClassPk() );
		document.setClassId( attachment.getClassId() );
		document.setType(attachment.getType());
		document.setName(attachment.getName());
		try {
			DocumLocalServiceUtil.addDocum( document );
			request.getPortletSession().removeAttribute(CaretStrPool.FILE_NAME);
			FileUtil.delete(uploadFile);
		}
		catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	@ProcessAction (name="searchEntry")
	public void searchEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		searchEntry(actionRequest);
	}

	public void loadCallType(PortletRequest request) throws ApplicationWorkFlowException {
		
		Map<String,Object> form = ResultMap.getForm (request);
		
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			String[] array = (callType + StringPool.COMMA + "soc-call").split(StringPool.COMMA) ;
			List<String> c = ListUtil.fromArray(array);
			Collections.sort(c);
			form.put( "standard-call-types", c );
		}
		form.put( CaretStrPool.CUSTOM_CALL_TYPES, BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES) );
		DashboardConfigFactory.loadInstance( request, null );
	}
	
	public void loadCall(PortletRequest request) throws ApplicationWorkFlowException {
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
		
		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute("serviceStatus", serviceStatus.split(StringPool.COMMA) );
		}

		Map<String,Object> form = ResultMap.getForm (request);
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		boolean newInstance = CaretStrPool.NEW.equals( request.getParameter(CaretStrPool.STATUS) ) ;
		
		long veteranId = 0;
		
		try {
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			CaretViewController controller = CaretViewController.getViewController();
			if ( callId > 0 ){
				Call call = CallLocalServiceUtil.getCall( callId );
				if ( newInstance ) {
					call.setCallId(0);
					call.setWorkPrimaryKey(0);
				}
				form.put( "call", call );
				
				Person caller = new Person(PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ));
				form.put(CaretStrPool.CALLER_PERSN, caller );
				controller.loadAddress( caret, caller, CaretStrPool.CALLER_PERSN );
				
				if ( !newInstance ){
					//Start SOC
					String callerName = caller.getFirstName() +" "+caller.getLastName();
					form.put("callerName", callerName);
	
					loadSocAspects(request, form, call, callId);
					//End SOC
					
					//Start CESP
					loadCespAspects(request, form, call, callId);
					//End CESP
				}
				
				veteranId = call.getVeteranPersnId();
				Person person = new Person( PersnLocalServiceUtil.getPersn( veteranId ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );
			
				boolean enableSoc = !newInstance && call.getCreationDate().before( CaretParam.getSocDueDate() );
				request.setAttribute("enableSoc", enableSoc );
				//request.setAttribute("expanded", enableSoc? "collapsed": "expanded" );
				request.setAttribute("expanded", "expanded");

				List<?> l = CaretLocalServiceUtil.getCallEvents( callId );
				results.put("callEvents", l);
				total.put("callEvents", l.size());

				request.setAttribute("isDisabled", call.getCallState() != null && call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE) );
//				request.setAttribute("isDisabled", call.getCallId() > 0);
				
				if ( call.getWorkPrimaryKey() > 0 ){
					WorIm workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
					form.put("workItem", workItem );
					if ( workItem != null && ( workItem.getUserId() > 0 || workItem.getCompletionBy() > 0 ) ){
						request.setAttribute("isDisabled", true);
						if ( workItem.getStatus() != null ){
							if ( ! workItem.getStatus().toLowerCase().contains("completed") ){
								request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
							}
						} else {
							request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
						}
					}
				}
				
				if ( StringPool.TRUE.equals( PortletProps.get("csl-lead-on-open")) && CAction.canDoCaret(request, CaretCan.CSL_FUNCTION) ){
					call.setUserId( CaretParam.setCaretServiceContext(request).getUserId() );
					CaretLocalServiceUtil.save(call);
				}
			} else {
				request.setAttribute("expanded", "expanded");
			}
			
			ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			loadCallSelects( request );
			loadMoreCallInfo ( request );
//			loadMoreReferralInfo ( request, veteranId );
			loadStatesAndFacilities( request );
			controller.loadRequiredInputs( CaretStrPool.CALL, form );
			
			request.setAttribute(CaretStrPool.ROLE, ((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getRole() );
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}
	
	public String initiateLetter(ActionRequest request, ActionResponse response) {
		//File file = null;
		StringWriter writer = new StringWriter();
		//String letterName = request.getParameter(CaretStrPool.LETTER_NAME);
		try {
			response.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.LOAD_LETTER_PAGE);
			InputStream stream = getClass().getClassLoader().getResourceAsStream("test.xml"); //new URL( uri.toString() ).openStream();
			  
			String inputStreamString = new Scanner(stream,"UTF-8").useDelimiter("\\A").next();
			request.setAttribute( "letterContent",inputStreamString);
			  
			long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
			long vcgId = ParamUtil.getLong( request, CaretStrPool.VCGID );
			if ( vcgId == 0 ) {
				vcgId = (Long) request.getAttribute(CaretStrPool.VCGID);
			}
			VcgAn vcgAn =  VcgAnLocalServiceUtil.getRecent(vcgId);
			Long vcgAnId = vcgAn.getVcgAnId();
			
			request.setAttribute(CaretStrPool.WORK_ID, worImId);
			request.setAttribute(CaretStrPool.VCGID, vcgId);
			List<Docum> allLetters = new ArrayList<Docum>();
			allLetters.addAll(DocumLocalServiceUtil.getByClass(vcgAnId, PortalUtil.getClassNameId(VcgAn.class), FileType.CSC_Letter.name()));
			request.setAttribute("allLetters", allLetters);
			request.setAttribute(CaretStrPool.CSC_LETTER_NAMES, Arrays.asList(CscLetterType.values()));
			_log.info("Number of letters docs is : "+allLetters.size());
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			} 
			
			return StringPool.BLANK;
	}
	
	@ProcessAction (name="sendLetter")
	public void sendLetter( ActionRequest actionRequest, ActionResponse actionResponse ) throws IOException {
	    String letterName = actionRequest.getParameter(CaretStrPool.SEND_LETTER_NAME);
		new PopulateLettersImpl().generateAndPopulatePDFWithEditedContent(actionRequest, letterName);
		//update if existing pdf or save if new pdf
		if ( letterName != null && !letterName.isEmpty() ) {
			try {
				String type = FileType.CSC_Letter.name();
				long vcgId = ParamUtil.getLong( actionRequest, CaretStrPool.VCGID );
				VcgAn vcgAn;
				vcgAn = VcgAnLocalServiceUtil.getRecent(vcgId);
				Long vcgAnId = vcgAn.getVcgAnId();
				AttachmentBean attachment = new AttachmentBean();
				attachment.setClassPk(vcgAnId);
				attachment.setClassId(PortalUtil.getClassNameId(VcgAn.class));
				attachment.setType(type);
				attachment.setName(letterName);
				handleLettersDocument( actionRequest, attachment);
			} catch (ApplicationWorkFlowException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		initiateLetter(actionRequest, actionResponse);
	}
	
	//Saves letter document to DB
	public void handleLettersDocument( ActionRequest actionRequest, AttachmentBean attachment) {
		
		try {
			String name = (String) actionRequest.getAttribute(CaretStrPool.LETTER_FILE);
			File uploadFile = new File( PortletProps.get(CaretStrPool.FILE_TEMP_STORE) + name );
			InputStream inputStream = new FileInputStream( uploadFile );
			OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
			
			long userId = PortalUtil.getUserId(actionRequest);
			User user = UserLocalServiceUtil.getUserById(userId);
			long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
			Docum document = DocumLocalServiceUtil.createDocum(documId);
			document.setDocument(outputBlob);
			document.setDeleted(false);
			document.setClassPk( attachment.getClassPk() );
			document.setClassId( attachment.getClassId() );
			document.setType(attachment.getType());
			document.setName(name);
			document.setNote(new Date().toString() + "," + user.getFullName());
			DocumLocalServiceUtil.addDocum( document );
			actionRequest.getPortletSession().removeAttribute(CaretStrPool.LETTER_FILE);
			FileUtil.delete(uploadFile);
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	private void loadSocAspects(PortletRequest request, Map<String,Object> form, Call call, long callId) throws PortalException, SystemException {
		
		form.put("callDate", Toolbox.formatDateCprs( call.getCreationDate() ) );
		long loggedPersnId = CaretParam.getPersnId(request);
		Person loggedUser = new Person ( PersnLocalServiceUtil.getPersn( loggedPersnId ) );
		form.put("loggedPersnId", loggedPersnId );
		form.put("loggedUserName", loggedUser.getFirstName() +" "+ loggedUser.getLastName() );
				
		List<ClSoc> socList = ClSocLocalServiceUtil.findByCallId(callId);

		int attemptNum = socList.size()+1;
		form.put("attemptNum", attemptNum);
		
		int numOfSoc = socList.size();
		form.put("numOfSoc", numOfSoc);
		
		
		if(numOfSoc > 0){	 
			List<SocBean> socHistory = new ArrayList<SocBean>();
			for(ClSoc oneSoc : socList){
				Person createdByPersn = new Person ( PersnLocalServiceUtil.getPersn( oneSoc.getPersnId() ) );
				String name = createdByPersn.getFirstName()+" "+createdByPersn.getLastName();

				SocBean oneBean = new SocBean();
				oneBean.setSoc(oneSoc);
				oneBean.setFormattedCreatedDate(Toolbox.formatDateTimeMetadata(oneSoc.getCreationDate()));
				oneBean.setCreatedByName(name);
				socHistory.add(oneBean);	
			}
			form.put("soc-history", socHistory);
		}

	}
	
	private void loadCespAspects(PortletRequest request, Map<String,Object> form, Call call, long callId) throws PortalException, SystemException {
		
		long loggedPersnId = CaretParam.getPersnId(request);
		form.put("loggedPersnId", loggedPersnId );

		//check if there are any cesp for the call
		List<Cesp> cespList = CespLocalServiceUtil.findByCallId(callId);	
		int numOfCesp = cespList.size();
		form.put("numOfCesp", numOfCesp);
		
		String cespStatus = StringPool.BLANK;

		if(numOfCesp > 0){
			form.put("step", CaretStrPool.CESP_STEP2);
				 
			List<CespBean> cespHistory = new ArrayList<CespBean>();
			for(Cesp oneCesp : cespList){
				Person createdByPersn = new Person ( PersnLocalServiceUtil.getPersn( oneCesp.getCreatedByPersnId() ) );
				String name = createdByPersn.getFirstName()+" "+createdByPersn.getLastName();

				CespBean oneBean = new CespBean();
				oneBean.setCesp(oneCesp);
				oneBean.setFormattedCreatedDate(Toolbox.formatDateTimeMetadata(oneCesp.getCreationDate()));
				oneBean.setCespCreatedByName(name);
				cespHistory.add(oneBean);	
				
				if(oneCesp.getStatus().equals(CaretStrPool.CESP_STATUS_CLOSED)){
					cespStatus = "closed";
				}
			}
			form.put("cesp-history", cespHistory);
		}else{
			form.put("step", CaretStrPool.CESP_STEP1);
		}

		form.put("cespStatus", cespStatus);
	}
	
	
	@ProcessAction (name="loadEntry")
	public void loadEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		_log.info("loadEntry..." +  entry );
//		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, "/jsp/internal/"+ action + ".jsp" );
//		_log.info("action..." +  entry );
		try{
			if ( CaretStrPool.CREATE_REFERRAL.equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_REFERRAL.name() ) ){
					boolean isCallReferral = loadReferral(actionRequest);
					if ( isCallReferral ){
						actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					} else {
						actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_REFERRAL_PAGE);
					}
				}
			} else if ( "MANAGE_VCG".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					loadVcgManagement (actionRequest, actionResponse);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
				}
			} else if ( CaretStrPool.CREATE_CALLS.equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					loadCall (actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
				}
			} else if ( "CREATE_CALL_TYPE".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALL_TYPE.name() ) ){
					loadCallType (actionRequest);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.ADD_CALLTYPE_PAGE);
				}
			} else if ( "soc".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_SOC.name() ) ){
					loadCall (actionRequest);
					actionRequest.setAttribute("enableSoc", true);
					actionRequest.setAttribute("isDisabled", true);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					//			loadLetter(actionRequest);
				}
			} else if ( "cesp".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CESP.name() ) ){
					loadCall (actionRequest);
					actionRequest.setAttribute("enableCesp", true);
					actionRequest.setAttribute("isDisabled", true);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.EDIT_CALL_PAGE);
					//			loadLetter(actionRequest);
				}
			} else if ( "cbopcWork".equals(entry) ){
				
			} else if ( "CREATE_VCG".equals(entry) || "SET_GENERAL_CG".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_VCG.name() ) ){
					ResultMap.getForm(actionRequest).put("veteranRequired", Collections.singletonMap("lastTreatmentPlace", "hidden-element"));
					long veteranId = ParamUtil.getLong(actionRequest, CaretStrPool.VETERAN_ID );
					if ( veteranId > 0 ){
						Persn person;
						try {
							person = PersnLocalServiceUtil.getPersn(veteranId);
							ResultMap.getForm(actionRequest).put(CaretStrPool.LASTNAME, new Person(person));
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
					ResultMap.getForm(actionRequest).put("associate", ParamUtil.getBoolean(actionRequest, "associate"));
					if ( ParamUtil.getLong(actionRequest, "worImId") > 0 ){
						try {
							ResultMap.getForm(actionRequest).put("workItem", 
									new WorkItemSupport ( WorImLocalServiceUtil.getWorIm( ParamUtil.getLong(actionRequest, "worImId") ) ) ); 
						} catch (PortalException e1) {
							ApplicationWorkFlowException.handleException(e1);
						} catch (SystemException e1) {
							ApplicationWorkFlowException.handleException(e1);
						}
					}
					actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ) );

					Map caret = ResultMap.getCaretMap(actionRequest);
					if ( actionRequest.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) instanceof FacilityDashboardConfig ) {
						caret.put( CaretStrPool.VHA_MEMBER, CaretUtil.getVhaOrgList( actionRequest ) );
						try {
							caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
						caret.put( CaretStrPool.VHA_ORGTREE, false );
					} else {
						loadStatesAndFacilities( actionRequest );
						caret.put( CaretStrPool.VHA_ORGTREE , true );
					}
					//TODO: required attributes...
					
					CaretViewController.getViewController().loadRequiredInputs( CaretStrPool.NEW_VCG_VETERAN_FORM, ResultMap.getForm(actionRequest) ) ;
					
					caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_VCG_PAGE );
					//			loadLetter(actionRequest);
				}
	//			loadCbopcWork(actionRequest);
			} else if ( "CREATE_APPLICATIONS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_APPLICATIONS.name() ) ){
		//			loadStatesAndFacilities( actionRequest );
					createEntry(actionRequest, actionResponse);
					long veteranId = ParamUtil.getLong(actionRequest, CaretStrPool.VETERAN_ID );
					if ( veteranId > 0 ){
						Persn person;
						try {
							person = PersnLocalServiceUtil.getPersn(veteranId);
							actionRequest.setAttribute("defaultUser", new Person(person));
						} catch (PortalException e) {
							ApplicationWorkFlowException.handleException(e);
						} catch (SystemException e) {
							ApplicationWorkFlowException.handleException(e);
						}
					}
				}
			} else if ( "PROCESS_APPLICATIONS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					loadProcessApplication(actionRequest, actionResponse);
					
				}
			} else if ( "INTERNAL_MESSAGE".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.INTERNAL_MESSAGE.name() ) ){
					PMPortlet.render(actionRequest, actionResponse);
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.INTERNAL_MESSAGES_PAGE+actionRequest.getAttribute("targetPath"));
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException ( e );
		}
	}
	


	private void searchEntry( PortletRequest request ) {
//		Map<String, Integer> total = ResultMap.getResultTotalMap( request );
//		Map<String, List<?>> results = ResultMap.getResultListMap(request);
		_log.info("searchEntry");
	}
	
	@ProcessAction (name="saveEntry")
	public void saveEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);

		_log.info("save entry..." +  entry );
		
///*		
		String tracker = ParamUtil.getString(actionRequest, CaretStrPool.TRACKER, StringPool.BLANK );
		if ( ! CaretParam.isTracked( actionRequest, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			actionRequest.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
//*/
		try {
			if ( "vcg".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.MANAGE_VCG.name() ) ){
					saveVcgEntry(actionRequest, actionResponse);
				}
			} else if ( "CREATE_REFERRAL".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_REFERRAL.name() ) ){
					saveReferral(actionRequest);
				} else if ( CAction.canDoCaret(actionRequest, CaretCan.DISPOSITION_CALLS.name() ) ){
					saveCallDisposition( actionRequest, actionResponse );
				}
			} else if ( "CREATE_CALLS".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CALLS.name() ) ){
					saveCall(actionRequest);
				}
				if ( CAction.canDoCaret(actionRequest, CaretCan.DISPOSITION_CALLS.name() ) ){
					saveCallDisposition( actionRequest, actionResponse );
				}
			} else if ( "soc".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_SOC.name() ) ){
					saveSoc(actionRequest);
				}
			}else if("cesp".equals(entry)){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_CESP.name() ) ){
					saveCesp(actionRequest);
				}
			}else if ( "vcgAn".equals(entry) ){
				if ( CAction.canDoCaret(actionRequest, CaretCan.CREATE_APPLICATIONS.name() ) ){
					saveVcgAn(actionRequest);
				}
			}else if ( "cscWaiver".equals(entry) ){				
				saveCSCWaiver(actionRequest);
			}
									
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException ( e );
		}
	}
	
	


	private void saveCallDisposition(ActionRequest actionRequest, ActionResponse actionResponse) {
		_log.info("saveCallDisposition..."  );
		long callId = ParamUtil.getLong(actionRequest, "call_primaryKey");
		if ( callId > 0 ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
				Call call = CallLocalServiceUtil.getCall(callId);
//				call.setSummary(actionRequest.getParameter(CaretStrPool.WORK_COMMENT));
				call.setModificationDate( sc.getCreateDate() );
				String callState = actionRequest.getParameter("call_callState");
				call.setCallState( callState );
				
				WorkItemSupport work = new WorkItemSupport( WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() ) );
				if ( work.getVcgId() > 0 ){
					VcgSupport vcgSupport = VcgSupport.getVcgSupport( work.getVcgId() );
					vcgSupport.setNote("callDispComment", actionRequest.getParameter(CaretStrPool.WORK_COMMENT),
							sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.REFERRAL.groupId());
					vcgSupport.setNote("callDisposition", callState, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.REFERRAL.groupId());
					CaretLocalServiceUtil.save(vcgSupport);
					work.useNote("callDispComment", vcgSupport.getNote("callDispComment") );
					work.useNote("callDisposition", vcgSupport.getNote("callDisposition") );
					actionRequest.setAttribute( CaretStrPool.VCGID, vcgSupport.getVcgId() );
				} else {
					work.setNote("callDispComment", actionRequest.getParameter(CaretStrPool.WORK_COMMENT), sc.getUserId(), sc.getCreateDate() );
					work.setNote("callDisposition", callState, sc.getUserId(), sc.getCreateDate() );
				}
				
				if ( callState.contains("completed") ){
					work.setStatus(WorkStatus.COMPLETE.name());
					work.setCompletionBy( sc.getUserId() );
					work.setCompletionDate( sc.getCreateDate() );
				}
				CaretLocalServiceUtil.save(work);
				CaretLocalServiceUtil.save(call);
				
				if ( "VCG_MANAGEMENT_PAGE".equals( ParamUtil.getString( actionRequest, "onPageComplete", StringPool.BLANK) ) ){
					actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.VCG_MANAGEMENT_PAGE);
					loadVcgManagement(actionRequest, actionResponse);
				}
				
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		
	}


	private void loadCallSelects(PortletRequest request ) throws ApplicationWorkFlowException{
		Map<String,Object> form = ResultMap.getForm (request);
		
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			form.put( "standard-call-types", callType.split(StringPool.COMMA) );
		}
		form.put( "custom-call-types", BoxGpLocalServiceUtil.getBoxGroups("custom-call-types") );
		
		
		String callerLearnAbout = PortletProps.get("call.callerLearnAbout");
		if ( !callerLearnAbout.isEmpty() ){
			request.setAttribute("callerLearnAbout", callerLearnAbout.split(StringPool.COMMA) );
		}
		String callerCaregiverType = PortletProps.get("call.callerCaregiverType");
		if ( !callerCaregiverType.isEmpty() ){
			request.setAttribute("callerCaregiverType", callerCaregiverType.split(StringPool.COMMA) );
		}
		
		loadRelationshipLists(request);
	}
	
	private void loadMoreReferralInfo ( PortletRequest request, long veteranId ) throws ApplicationWorkFlowException{
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.REFERRAL_QUESTIONAIRE_YN);
		Map<String,List<BoxGp>> boxGpMap = new HashMap<String,List<BoxGp>>();
		int i = 0;
		List<BoxGp> boxGpList = new ArrayList<BoxGp>(5);
		for ( BoxGp boxGp: groups ){
			boxGpList.add( boxGp );
			if ( i % 2 == 1 ){
				boxGpMap.put( boxGp.getBoxSubGroup(), boxGpList );
				boxGpList = new ArrayList<BoxGp>(5);
			}
			i++;
		}
		
		Map<String, Object> form = ResultMap.getForm(request);
		form.put( "ref-prescreen-meets-pcafc", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-prescreen-meets-pcafc" ) );
		form.put( "ref-enrolled-in-va-health", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-enrolled-in-va-health" ) );
		form.put( "ref-discharged-after-911", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-discharged-after-911" ) );
		form.put( "ref-veteran-has-sc-condition", CaretUtil.loadBoxGroup ( "referral-questionaire-radio", "ref-veteran-has-sc-condition" ) );
		
		Map<Long,Boolean> enabledBxGps =  new CaretMap<Long,Boolean>( false );
		form.put(CaretStrPool.BOX_GROUP, enabledBxGps);
		
		if ( veteranId > 0 ){
			for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( veteranId, true ) ) {
				enabledBxGps.put( bgAsn0.getBoxGpId(), true );
			}
		}		
		
		if ( CAction.canDoCaret(request, CaretCan.LOD_QA.name() ) ){
			form.put( CaretStrPool.HEC_QUESTIONAIRE, CaretUtil.loadBoxGroup ( CaretStrPool.HEC_QUESTIONAIRE, CaretStrPool.HEC_QUESTIONAIRE ) );
		}
	}
	
	private void loadMoreCallInfo ( PortletRequest request ) throws ApplicationWorkFlowException{
		
		String serviceBranches = PortletProps.get("call.serviceBranches");
		if ( !serviceBranches.isEmpty() ){
			request.setAttribute("serviceBranches", serviceBranches.split(StringPool.COMMA) );
		}
		
		String eraServiceTypes = PortletProps.get("call.eraServiceTypes");
		if ( !eraServiceTypes.isEmpty() ){
			request.setAttribute("eraServiceTypes", eraServiceTypes.split(StringPool.COMMA) );
		}
		
		long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
//		Set<Long> bgAsnSet = new HashSet<Long>();
		
		Map<Long,Boolean> boxGrp =  new CaretMap<Long,Boolean>( false );
		
		Map<String, Object> form = ResultMap.getForm(request);
		form.put(CaretStrPool.BOX_GROUP, boxGrp);
		
		if ( callId > 0 ){
			for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( callId, true ) ) {
				boxGrp.put( bgAsn0.getBoxGpId(), true );
			}
		}
		ResultMap.getForm(request);
//		form.put( subName, groups );
		form.put( "veteran-primary-diagnosis", CaretUtil.loadBoxGroup ( "veteran-primary-diagnosis", "veteran-primary-diagnosis" ) );
		form.put( "other-primary-diagnosis", CaretUtil.loadBoxGroup ( "other-primary-diagnosis", "other-primary-diagnosis" ) );
		form.put( "public-law-111-163-reasons", CaretUtil.loadBoxGroup ( "public-law-111-163-reasons", "public-law-111-163-reasons") );
		form.put( "heard-from-us", CaretUtil.loadBoxGroup ( "heard-from-us", "heard-from-us" ) );

		form.put( "prescreen-meets-pcafc", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "prescreen-meets-pcafc" ) );
		form.put( "enrolled-in-va-health", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "enrolled-in-va-health" ) );
		form.put( "discharged-after-911", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "discharged-after-911" ) );
		form.put( "veteran-has-sc-condition", CaretUtil.loadBoxGroup ( "referral-questionaire-yn", "veteran-has-sc-condition" ) );
		
		form.put( "support-lines-transfer", CaretUtil.loadBoxGroup ( "support-lines", "support-lines-transfer") );
		form.put( "support-lines-number-provided", CaretUtil.loadBoxGroup ( "support-lines", "support-lines-number-provided") );
		form.put( "interventions-applied-family", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-family") );
		form.put( "interventions-applied-care", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-care") );
		form.put( "interventions-applied-respite", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-respite") );
		form.put( "interventions-applied-counseling", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-counseling") );
		form.put( "interventions-applied-directives", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-directives") );
		form.put( "interventions-applied-other", CaretUtil.loadBoxGroup ( "interventions-applied", "interventions-applied-other") );
		
		if ( CAction.canDoCaret(request, CaretCan.LOD_QA.name() ) ){
			form.put( CaretStrPool.HEC_QUESTIONAIRE, CaretUtil.loadBoxGroup ( CaretStrPool.HEC_QUESTIONAIRE, CaretStrPool.HEC_QUESTIONAIRE ) );
		}
	}
	
	
	
	public boolean loadReferral(PortletRequest request) throws ApplicationWorkFlowException {
		request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );

		String serviceStatus = PortletProps.get("veteran.supplemental.serviceStatuses");
		if ( !serviceStatus.isEmpty() ){
			request.setAttribute(CaretStrPool.SERVICE_STATUS, serviceStatus.split(StringPool.COMMA) );
		}
		Map<String,Object> form = ResultMap.getForm( request );
		boolean newInstance = CaretStrPool.NEW.equals( request.getParameter(CaretStrPool.STATUS) ) ;
		try {
			CaretViewController controller = CaretViewController.getViewController();
			long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID, 0 );
			long veteranId = 0;
			if ( callId > 0 ){
				Map<String,Object> caret = ResultMap.getCaretMap(request);
				
				Call call = CallLocalServiceUtil.getCall( callId );
				if ( newInstance ) {
					call.setCallId(0);
					call.setWorkPrimaryKey(0);
				} else if ( "send-referral".equals( call.getCallState() ) ) {
					loadCall ( request );
					return true;
				}
				form.put( CaretStrPool.CALL, call );
				
				if ( call.getWorkPrimaryKey() > 0 ){
					WorIm workItem = WorImLocalServiceUtil.getWorIm( call.getWorkPrimaryKey() );
					form.put("workItem", workItem );
					if ( workItem != null && ( workItem.getUserId() > 0 || workItem.getCompletionBy() > 0 )  ){
						request.setAttribute("isDisabled", true);
						if ( workItem.getStatus() != null ){
							if ( ! workItem.getStatus().toLowerCase().contains("completed") ){
								request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
							}
						} else {
							request.setAttribute("dispositionCall", CAction.canDoCaret(request, CaretCan.DISPOSITION_CALLS.name() ) );
						}
					}
				}
				
				Person person = new Person( PersnLocalServiceUtil.getPersn( call.getCallerPersnId() ) );
				form.put(CaretStrPool.CALLER_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.CALLER_PERSN );
				veteranId = call.getVeteranPersnId();
				person = new Person ( PersnLocalServiceUtil.getPersn( veteranId ) );
				form.put(CaretStrPool.VETERAN_PERSN, person );
				controller.loadAddress( caret, person, CaretStrPool.VETERAN_PERSN );

//				if ( ( call.getCallState() != null &&
//						call.getCallState().toLowerCase().contains(CaretStrPool.CALL_STATE_COMPLETE) ) ||					
//						! CAction.canDoCaret(request, CAction.CaretCan.CREATE_REFERRAL.name() ) ){
//					request.setAttribute("isDisabled", true);
//				}
				request.setAttribute("isDisabled", !newInstance && call.getCallId() > 0);
				
			}
			
			loadCallSelects( request );
			loadMoreReferralInfo(request, callId );
			
			ResultMap.getCaretMap(request).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			
			loadStatesAndFacilities( request );

			DashboardConfig config = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
			if ( config != null ){
				request.setAttribute(CaretStrPool.ROLE, config.getRole() );
			}
			controller.loadRequiredInputs( CaretStrPool.REFFERAL, form );
			
			if ( CAction.canDoCaret(request, CAction.CaretCan.REFERRAL_ATTACHMENT.name() ) || CAction.canDoCaret(request, CAction.CaretCan.MANAGE_VCG.name() ) ){
				if ( !newInstance ) {
					List<Docum> supportDocs = DocumLocalServiceUtil.getByPrimaryKey( callId );
					form.put("supportDocs", supportDocs );
				}
				form.put("hasDocumentAcess", true);
			} else {
				form.put("hasDocumentAcess", false);
			}
			
//			form.put("noteContext", CaretStrPool.CALL );
			ResultMap.getCaretMap(request).put("noteContext", CaretStrPool.CALL);
			
		} catch (Exception e) {
			throw new ApplicationWorkFlowException(e);
		}
		return false;
	}
	
	
	public void takeOwnershipCall ( ActionRequest request, ActionResponse actionResponse ){
		_log.info("takeOwnershipCall");
		
		long callId = ParamUtil.getLong(request, CaretStrPool.CALL_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			Call workItem = CallLocalServiceUtil.getCall(callId);
			workItem.setUserId( sc.getUserId() );
//			workItem.setStatus(WorkStatus.IN_PROCESS.name());
			CaretLocalServiceUtil.save(workItem);
			
//			updateVcgAnStatus(workItem);
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}
	
	public void takeOwnership ( ActionRequest request, ActionResponse actionResponse ){
		_log.info("takeOwnership");
		
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			WorIm workItem = WorImLocalServiceUtil.getWorIm(worImId);
			workItem.setUserId( sc.getUserId() );
//			workItem.setStatus(WorkStatus.IN_PROCESS.name());
			CaretLocalServiceUtil.save(workItem);
			
//			updateVcgAnStatus(workItem);
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
	}

	public void assignTo ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long userId = ParamUtil.getLong(request, "form_userName");
		if ( primKey > 0 && userId > 0 ){
			try {
				WorIm workItem = WorImLocalServiceUtil.getWorIm(primKey);
				workItem.setUserId(userId);
//				workItem.setStatus(WorkStatus.IN_PROCESS.name());
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				CaretLocalServiceUtil.save( workItem );
				CaretLocalServiceUtil.addNote( 
						CaretUtil.createNote( 
								sc.getCreateDate(),
								workItem.getWorImId(),
								workItem.getGroupId(),
								sc.getUserId(),
								ParamUtil.get(request,
										CaretStrPool.WORK_COMMENT, StringPool.BLANK ) ) );

//				updateVcgAnStatus(workItem);
				
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}		
	}
	
	public void reviewAppDelay ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		String workImStatus = ParamUtil.get(request, "worIm_status", StringPool.BLANK);
		if ( primKey > 0 && ! Toolbox.isEmpty(workImStatus) && CAction.canDoCaret(request, CAction.CaretCan.CREATE_VACO_WAIVER) ){
			try {
				ServiceContext sc = CaretParam.setCaretServiceContext(request);

				WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(primKey) );
				workItem.setStatus( workImStatus );

				String noteAtt = "ReviewNote";
				VcgSupport vcg = VcgSupport.getVcgSupport( workItem.getVcgId() );
				String comment = ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK );
				vcg.setNote(noteAtt, comment, sc.getUserId(), sc.getCreateDate(), NoteSupport.NoteGroup.APP_DELAY.groupId());
				CaretLocalServiceUtil.save( vcg );
				
				if ( !workImStatus.equals( CaretStrPool.IN_PROCESS ) ){
					workItem.setCompletionBy(PortalUtil.getUserId(request) );
					workItem.setCompletionDate( sc.getCreateDate() );
					Waivr waiver = WaivrLocalServiceUtil.getWaivr( workItem.getQueId() );
					waiver.setCompletionDate( sc.getCreateDate() );
					waiver.setAdjudication( workImStatus );
					CaretLocalServiceUtil.save( waiver );
					
					VcgAn vcgAn = vcg.getPersonVcgAn( workItem.getCaregiverId() );
					WorkItemSupport workAppDelay =  new WorkItemSupport(CaretUtil.createWorkItem(sc, workItem.getGroupId(), vcgAn, WorkType.DELAY_REVIEWED, workItem.getPersnId(), workItem.getCaregiverId()));
					workAppDelay.setVcgId( vcg.getVcgId() );
					workAppDelay.setQueId( waiver.getUserId() );
//					CaretLocalServiceUtil.save(workAppDelay);
					
					workAppDelay.useNote(noteAtt, vcg.getNote(noteAtt));
					CaretLocalServiceUtil.save(workAppDelay);
				}
				workItem.useNote(noteAtt, vcg.getNote(noteAtt) );
				CaretLocalServiceUtil.save( workItem );

			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}		
	}
	
	
	
	public void updateVcgAnStatus ( WorIm workItem ){
		
		try{
			String[] types = PortletProps.get(CaretStrPool.APP_TYPES).split(StringPool.COMMA);
			
			boolean updateStatus = false;
			for (String appType: types) { 
				if(workItem.getType().equals(appType))
				{
			         updateStatus = true;
			    }
			}
			
			if(updateStatus)
			{	
				long vcgAnId = workItem.getClassPk();
				VcgAn vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				vcgAn.setStatus(ApplicationStatus.IN_REVIEW.name());
				VcgAnLocalServiceUtil.updateVcgAn(vcgAn);
			}
			
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}		
	}

	
	public void facilTransfer ( ActionRequest request, ActionResponse actionResponse ){
		
		long primKey = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		long groupId = ParamUtil.getLong(request, "transfer_groupId");
		if ( primKey > 0 && groupId > 0 ){
			try {
				WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(primKey) );
				workItem.setQueId(groupId);
				workItem.setStatus(WorkStatus.TRANSFER_REQUESTED.name());
				ServiceContext sc = CaretParam.setCaretServiceContext(request);
				workItem.setNote("transferReason", ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK ),
												sc.getUserId(), sc.getCreateDate() );
				CaretLocalServiceUtil.save( workItem );
				
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} 
		}//audit log to contain
		//reason for transfer and date transfer accepted
	}
	
	public void acceptTransfer ( ActionRequest request, ActionResponse actionResponse ) throws PortalException, SystemException{
		boolean accept = ParamUtil.getBoolean(request, "transfer");
		long worImId = ParamUtil.getLong(request, CaretStrPool.WORK_ID);
		if ( worImId > 0 ){
			ServiceContext sc = CaretParam.setCaretServiceContext(request);
			DashboardConfig config = (DashboardConfig) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG);
			WorkItemSupport workItem = new WorkItemSupport( WorImLocalServiceUtil.getWorIm(worImId) );
			if ( accept ){
				workItem.setGroupId( workItem.getQueId() );
			}
			if ( WorkType.VCG_TRANSFER.name().equals( workItem.getType() ) ){
				transferVcgWorkItems( workItem, accept, config.workItemTypes() );
				workItem.setStatus( WorkStatus.COMPLETE.name() );
			} else {
				if ( workItem.getVcgId() > 0 ){
					transferVcgWorkItems( workItem, accept, config.workItemTypes() );
				}
				workItem.setStatus( WorkStatus.IN_PROCESS.name() );
			}
			Persn veteran = PersnLocalServiceUtil.getPersn( workItem.getPersnId() );
			if ( workItem.getQueId() != veteran.getGroupId() ){
				veteran.setGroupId( workItem.getQueId() );
				CaretLocalServiceUtil.save( veteran );
			}
			workItem.setQueId(0);
			workItem.setUserId(0);
			workItem.setNote("transferResponse", ParamUtil.get(request, CaretStrPool.WORK_COMMENT, StringPool.BLANK ),
					sc.getUserId(), sc.getCreateDate() );
			CaretLocalServiceUtil.save( workItem );
		}
	}

	
	private void transferVcgWorkItems(WorIm workItem, boolean accept, Collection<String> workTypes ) throws ApplicationWorkFlowException {
		for ( WorIm worIm : WorImLocalServiceUtil.findByVcgId( workItem.getVcgId() ) ){
			if ( worIm.getWorImId() == workItem.getWorImId() ) continue;
			if ( workTypes.contains(worIm.getType()) && ( worIm.getQueId() > 0 || (accept && worIm.getGroupId() != workItem.getGroupId() ) ) ){
				if ( accept ){
					worIm.setGroupId( workItem.getGroupId() );
					worIm.setUserId(0);
				}
				worIm.setQueId( 0 );
				CaretLocalServiceUtil.save( worIm );
			}
		}
		if ( accept && workItem.getVcgId() > 0 ){
			try {
				Vcg vcg = VcgLocalServiceUtil.getVcg( workItem.getVcgId() );
				vcg.setGroupId( workItem.getGroupId() );
				CaretLocalServiceUtil.save(vcg);
			} catch (PortalException | SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		}
		
	}
	
	

	@ProcessAction (name="createEntry")
	public void createEntry( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String entry = ParamUtil.get(actionRequest, "entry", StringPool.BLANK);
		_log.info("createEntry..." +  entry );
		
		actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ) );
		ResultMap.getCaretMap(actionRequest).put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
		loadStatesAndFacilities( actionRequest );
		loadRelationshipLists( actionRequest );
		
		actionRequest.setAttribute("isDisabled", true);
		
		Map<String,Object> form = ResultMap.getForm (actionRequest);
		CaretViewController controller = CaretViewController.getViewController();
		controller.loadRequiredInputs( CaretStrPool.VETERAN_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.PRIMARY_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.SECONDARY_PERSN, form );
		controller.loadRequiredInputs( CaretStrPool.SECONDARY_TWO_PERSN, form );

		try {
			String  extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
			long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
			//_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
			form.put("extensions",  extensions );
			form.put("maxSize",  maxSize );
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CREATE_APPLICATION_PAGE);
	}
	
	
	public void loadRelationshipLists ( PortletRequest request ) {
		CaretViewController.getViewController().loadRelationshipLists(request);
	}
	
	@ProcessAction (name="uploadFile")
	public void uploadFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		
		String type = ParamUtil.get(request, "type", StringPool.BLANK);
		//_log.info("file type is : "+type);

		
		long size = uploadRequest.getSize("file");
		//_log.info("size=" + size );
		if ( size == 0 ){
			_log.info("returning since size is 0...");
			return;
		}

		File uploadFile = uploadRequest.getFile("file");
		String tempLocation = PropsUtil.get(CaretStrPool.FILE_TEMP_STORE);
		String name = uploadRequest.getFileName("file");
		
		File file = new File(tempLocation + name);
		try {
			FileUtil.copyFile( uploadFile, file );
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		//_log.info("path is ... " + uploadFile.getPath() + ", name=" + name );
		//String filePath = "";
		//String fileName = "";
		if(CaretStrPool.TEN_TEN_CG.equals(type) ){
			//filePath = CaretStrPool.FILE_PATH;
			//fileName = CaretStrPool.FILE_NAME;
			request.getPortletSession().setAttribute(CaretStrPool.FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.FILE_NAME, name);
		} else if( CaretStrPool.POA.equals(type) ){
			//filePath = CaretStrPool.POA_FILE_PATH;
			//fileName = CaretStrPool.POA_FILE_NAME;			
			request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_NAME, name);
		} else {
			request.getPortletSession().setAttribute(CaretStrPool.FILE_PATH, file.getPath() );
			request.getPortletSession().setAttribute(CaretStrPool.FILE_NAME, name);
		}
		_log.info("path is ... " + file.getPath() + ", name=" + name );
	}


	
	@ProcessAction (name="cscWaiver")
	public void cscWaiver( ActionRequest actionRequest, ActionResponse actionResponse ) {
		_log.info("cscWaiver....");
		actionRequest.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( actionRequest ));
		
		String workItemId = ParamUtil.get(actionRequest, "workItemId", StringPool.BLANK);
		String vcgAnId = ParamUtil.get(actionRequest, "vcgAnId", StringPool.BLANK);
		String receivedDate = ParamUtil.get(actionRequest, "receivedDate", StringPool.BLANK);
		String daysPassed = ParamUtil.get(actionRequest, "daysPassed", StringPool.BLANK);
				
		Map<String,Object> form = ResultMap.getForm (actionRequest);
		form.put("workItemId", workItemId);
		form.put("vcgAnId", vcgAnId);
		form.put("receivedDate", receivedDate);
		form.put("daysPassed", daysPassed);
		
		try {
			long loggedPersnId = CaretParam.getPersnId(actionRequest);
			form.put("loggedPersnId", loggedPersnId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.CSC_WAIVER_PAGE);
	}

	
	public void saveCSCWaiver( ActionRequest actionRequest) throws ApplicationWorkFlowException {
		getOutput(actionRequest);
		
		try {
			ServiceContext sc = CaretParam.setCaretServiceContext(actionRequest);
			Waivr w = new WaivrImpl();
			Waivr waiver = (Waivr) CaretParam.loadModel(actionRequest, new WaivrImpl(), w.getModelAttributes().keySet(), CaretStrPool.WAIVER_UNDERLINE);
			waiver.setCreationDate(new Date());
			
			CaretLocalServiceUtil.save( waiver );
									
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}

	@ProcessAction (name="messageActions")
	public void messageActions( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String messageAction = ParamUtil.get(actionRequest, "messageAction", StringPool.BLANK);
		_log.info("messageActions..." +  messageAction );
				PMPortlet.render(actionRequest, actionResponse);
				actionResponse.setRenderParameter(CaretStrPool.MVC_PATH, CaretStrPool.INTERNAL_MESSAGES_PAGE+actionRequest.getAttribute("targetPath"));
	}
	
	@ProcessAction (name="selectRole")
	public void selectRole( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		if ( StringPool.TRUE.equals( PortletProps.get(CaretStrPool.ROLES_SELECTION_ENABLED ) ) ) {
			String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
	
			if ( ! CaretParam.isTracked( request, tracker, true ) ){
				_log.warn("TRACKER BLOCKING action... ");
				request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
				return;
			}
			long roleId = ParamUtil.getLong(request,  "role" );
			_log.info("reached save selected Role..... " + roleId);
			if ( roleId > 0 ){
				Role role = RoleLocalServiceUtil.getRole(roleId);
				long orgId = 0;
				boolean validates = true;
				if ( role.getName().toLowerCase().startsWith("csc") ){
					validates = (orgId = ParamUtil.getLong(request,  "facility" )) > 0;
				} else if ( role.getName().toLowerCase().startsWith("visn") ){
					validates = (orgId = ParamUtil.getLong(request,  "visn" )) > 0;
				}
				if ( validates ){
					CodifiedRole.updateClinicRole( PortalUtil.getUserId(request), new long[]{ role.getRoleId() }, orgId );
				}
			}
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog( CaretActionCommand.class );
}
