
package gov.va.caret.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.portlet.action.OnlineActionCommand;
import gov.va.caret.portlet.resource.OnlineResourceCommand;
import gov.va.caret.security.CAction;
import gov.va.caret.util.CaretUtil;

import java.io.IOException;

import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * Portlet implementation class OnlinePortlet
 */
public class OnlinePortlet extends CaretBasePortlet {

	public static final String PLID = "caret_online_WAR_caretportlet";
	
	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {
		if ( CAction.canDoOnline ( renderRequest, CAction.VIEW ) ){
			super.include(path,renderRequest, renderResponse);
		}else {
			_log.info("VIEW needed");
			super.include(CaretBaseViewController.INVALID_ACCESS_VIEW, renderRequest, renderResponse);
		}
	}
	
	public void init(){
		try {
			super.init();
			long siteId = GroupLocalServiceUtil.getGroup( PortalUtil.getDefaultCompanyId(), CaretUtil.getOnlineSite() ).getGroupId();
			PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup(LayoutLocalServiceUtil.getLayouts(siteId, true).get(0), PLID);
			portletSetup.setValue("portletSetupShowBorders", String.valueOf(Boolean.FALSE));
			portletSetup.store();
		} catch (PortletException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		this.actionCommand = new OnlineActionCommand();
		this.resourceCommand = new OnlineResourceCommand();
		this.viewController = OnlineViewController.get();
	}


	private static Log _log = LogFactoryUtil.getLog(OnlinePortlet.class);
}
