package gov.va.caret.model.support;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.OrganizationLocalServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.WorImWrapper;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class WorkItemSupport extends WorImWrapper {

	private static Log _log = LogFactoryUtil.getLog( WorkItemSupport.class );
	String personName = null;
	String caregiverName = null;
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	private Boolean docLoaded = null;
	private WorkType workType = null;
	private Map<String,Note> notes = new HashMap<String,Note>();
	
	private static final long serialVersionUID = 1L;
	private static final int NOTE_FIELD_LENGTH = 75;
	private static final int BG_LEA_FIELD_LENGTH = 75;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public WorkItemSupport(gov.va.caret.model.WorIm WorIm) {
		super(WorIm);
	}

	public String getPersonName() {
		if ( personName == null ){
			this.personName = getFullName( getPersnId() );
		}
		return personName;
	}

	public String getCaregiverName() {
		if ( caregiverName == null ){
			this.caregiverName = getFullName( getCaregiverId() );
		}
		return caregiverName;
	}
	
	public List<Docum> getDocuments(){
		try{
			if ( isDocType() ){
				return DocumLocalServiceUtil.getByPrimaryKey( getClassPk() );
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public WorkType getWorkType(){
		if ( workType == null ){
			workType = WorkType.valueOf( getType() ); 
		}
		return workType;
	}
	
	public boolean isDocType(){
		return getWorkType().isDocType;
	}
	
	public boolean isDocLoaded(){
		if ( docLoaded == null ){
			try {
				docLoaded = isDocType() && DocumLocalServiceUtil.getByPrimaryKeyCount( getClassPk() ) > 0;
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return docLoaded;
	}
	
	public boolean isTransferable(){
		switch (getWorkType()){
			case ONLINE_APP:
			case CSC_APP:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public boolean isAssignable(){
		switch (getWorkType()){
			case ONLINE_APP:
			case CSC_APP:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public String getDueDateStr ( ){
		if ( getDueDate() != null ){
			return Toolbox.formatDateCprs( getDueDate() );
		}
		return StringPool.BLANK;
	}
	
	public String getCreateDateStr ( ){
		if ( getCreationDate() != null ){
			return Toolbox.formatDateCprs( getCreationDate() );
		}
		return StringPool.BLANK;
	}

	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			return CaretUtil.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	public String getFacilityName (){
		if ( getGroupId() == 0 ){
			return StringPool.BLANK;
		} else {
			try {
				return OrganizationLocalServiceUtil.getOrganization( getGroupId() ).getName();
			} catch (PortalException e) {
			} catch (SystemException e) {
			}
		}
		return StringPool.BLANK;
	}
	
	public String getUserQueue(){
		if ( getUserId() > 0 ){
			return CaretUtil.getUserFullName ( getUserId() );
		}
		return StringPool.BLANK;
	}
	

	public boolean isCompletable ( VcgSupport vcgSupport ) throws SystemException, PortalException {
		if ( WorkType.CSC_APP.name().equals( getType() ) || WorkType.ONLINE_APP.name().equals( getType() ) ){
			
			_log.debug("WorkStatus : (" + getClassPk() + ") " + getStatus()  );
			if ( getVcgId() == 0 || WorkStatus.COMPLETE.name().equals( getStatus() ) ){
				return false;
			}
			VcgApplication vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( getClassPk() ) );
			int i = 0;
			_log.debug("------------------------AppStatus--" + vcgApp.getStatus() + "-----------------------------------" );
			_log.debug( "vcgApplication - Primary - vcg-closed:" + vcgSupport.getPrimaryDispReason()  );
			_log.debug("vcgApplication - Primary - invalid:" + vcgApp.isInvalidPrimary() );
			_log.debug("vcgApplication - Primary - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getPrimaryDispReason() ) );
			if ( vcgApp.getPrimaryId() == 0 || vcgApp.isInvalidPrimary() || 
					( vcgSupport.getPrimaryDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getPrimaryVcgAnId() ) ||
					vcgSupport.getPrimaryVcgAnId() != getClassPk() ){
				i ++;
			}
			_log.debug("vcgApplication - Secondary - vcg-closed:" + vcgSupport.getSecondaryDispReason()  );
			_log.debug("vcgApplication - Secondary - invalid:" + vcgApp.isInvalidSecondary() );
			_log.debug("vcgApplication - Secondary - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getSecondaryDispReason() ) );
			if ( vcgApp.getSecondaryId() == 0 || vcgApp.isInvalidSecondary() || 
					( vcgSupport.getSecondaryDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getSecondaryVcgAnId() )  ||
					vcgSupport.getSecondaryVcgAnId() != getClassPk() ){
				i ++;
			}
			_log.debug("vcgApplication - Secondary2 - vcg-closed:" + vcgSupport.getSecondaryTwoDispReason()  );
			_log.debug("vcgApplication - Secondary2 - invalid:" + vcgApp.isInvalidSecondaryTwo() );
			_log.debug("vcgApplication - Secondary2 - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getSecondaryTwoDispReason() ) );
			if ( vcgApp.getSecondaryTwoId() == 0 || vcgApp.isInvalidSecondaryTwo() || 
					( vcgSupport.getSecondaryTwoDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getSecondaryTwoVcgAnId() )  ||
					vcgSupport.getSecondaryTwoVcgAnId() != getClassPk() ){
				i ++;
			}
			return i == 3;
		}
		return false;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getPersnId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Person ID cannot be 0");
		}
		super.persist();
		saveCustomAttributes();
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( !customAttributes.isEmpty() ) {
			for ( String key : customAttributes.keySet() ){
				String text = customAttributes.get(key).getLargeText();
				modelAttributes.put(key, text.substring(0, Math.min(text.length(), BG_LEA_FIELD_LENGTH )) );
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), NOTE_FIELD_LENGTH )) );
		}
		if ( getCompletionDate() != null ) {
			modelAttributes.put( "completionDate", Toolbox.getDateFormatCprs().format( getCompletionDate() ) );
		}
		return modelAttributes;
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( WorkItemSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getWorImId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp getCustomAttribute ( String attribute  ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( WorkItemSupport.class.getName(), String.valueOf( getWorImId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	
	private void saveCustomAttributes() {
		if ( !customAttributes.isEmpty() ){
			for ( BgLae value : customAttributes.values() ){
				try {
					value.setOwnerId(getWorImId());
					CaretLocalServiceUtil.save(value);
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note.getNoteId() == 0 ) try {
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public void setNote ( String attribute, String comment, long userId, Date createDate ){
		 notes.put( attribute, CaretUtil.createNote( createDate, getWorImId(), getGroupId(), userId, comment ) );
	}
	
	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	
//	public void setTransferComment ( String comment, long userId, Date createDate ){
//		this.note = Toolbox.createNote( createDate, getWorImId(), getGroupId(), userId, comment );
//	}

	private BgLae getLeaAttr ( String attribute  ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getWorImId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}
	
	public void setLeaAttr ( String attribute, String value ) throws ApplicationWorkFlowException{
		BgLae bgLea = getLeaAttr(attribute);
		bgLea.setLargeText(  value.substring(0, Math.min( value.length(), BG_LEA_FIELD_LENGTH ))  );
		customAttributes.put(attribute, bgLea);
	}
	
}
