package gov.va.caret.model.support;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.VcgAnWrapper;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;

public class VcgApplication extends VcgAnWrapper {

	private static final long serialVersionUID = 1L;
	private static Log _log = LogFactoryUtil.getLog( VcgApplication.class );
	private static final Collection<String> modelAttKeys = new VcgAnImpl().getModelAttributes().keySet();
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	
	int REUSE_COMMENT = 0;
	
	public String getComments() {
		_log.warn("need to use floating Note for this... ");
		return "TODO//";
	}
	
	public void setComments(String comments) {
		try {
			BgLae commentAttr = null;
			String attr = "comments";
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					commentAttr = customAttributes.get(key);
				}
			}
			if ( commentAttr == null ){
				commentAttr = getLeaAttr ( attr, REUSE_COMMENT );
				customAttributes.put( attr, commentAttr );
			}
			commentAttr.setLargeText(comments);
			commentAttr.setOwnerId( getVcgAnId() );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	public VcgApplication(VcgAn vcgAn) {
		super(vcgAn);
	}

	public static Collection<String> getModelAttKeys() {
		return modelAttKeys;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getVeteranId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Veteran ID cannot be 0");
		}
		if ( getPrimaryId() == 0 && getSecondaryId() == 0 && getSecondaryTwoId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("All Caregiver IDs cannot be 0");
		}
		super.persist();
		saveCustomAttributes();
	}
	
	private static BoxGp initCustomAttribute( String attribute, int sequence, String appId ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( VcgApplication.class.getName() );
		custom.setBoxSubGroup( appId );
		custom.setLabel( attribute );  //attribute
		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	
	private static BoxGp getCustomAttribute ( String attribute, int sequence, String appId, boolean init ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( VcgApplication.class.getName(), appId );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			if ( init ){
				custom = initCustomAttribute ( attribute, sequence, appId );
			}
			return custom;
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null && init ){
			custom = initCustomAttribute ( attribute, sequence, appId );
		}
		return custom;
	}
	
	private void saveCustomAttributes() {
		if ( !customAttributes.isEmpty() ){
			for ( BgLae value : customAttributes.values() ){
				try {
					CaretLocalServiceUtil.save(value);
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
	}
	
	private BgLae getLeaAttr ( String attribute, int sequence) throws ApplicationWorkFlowException {
		return getLeaAttr ( attribute, sequence, getVcgAnId(), true );
	}
	
	public boolean isInvalidPrimary() throws ApplicationWorkFlowException{
		if ( getPrimaryId() > 0 ){
			List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( VcgApplication.class.getName(), String.valueOf( getVcgAnId() ) );
			if ( attributes.isEmpty() ){
				return false;
			}
			String attribute = CaretStrPool.INVALID_APP_PERSON + getPrimaryId();
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					return true;
				}
			}
		}
		return false;
	}
	
	public boolean isInvalidSecondary() throws ApplicationWorkFlowException{
		if ( getSecondaryId() > 0 ){
			List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( VcgApplication.class.getName(), String.valueOf( getVcgAnId() ) );
			if ( attributes.isEmpty() ){
				return false;
			}
			String attribute = CaretStrPool.INVALID_APP_PERSON + getSecondaryId();
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					return true;
				}
			}
		}
		return false;
	}
	
	public boolean isInvalidSecondaryTwo() throws ApplicationWorkFlowException{
		if ( getSecondaryTwoId() > 0 ){
			List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( VcgApplication.class.getName(), String.valueOf( getVcgAnId() ) );
			if ( attributes.isEmpty() ){
				return false;
			}
			String attribute = CaretStrPool.INVALID_APP_PERSON + getSecondaryTwoId();
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					return true;
				}
			}
		}
		return false;
	}
	public static BgLae getLeaAttr ( String attribute, int sequence, long vcgAnId, boolean init ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute, sequence, String.valueOf( vcgAnId ), init );
		BgLae value = null;
		if ( custom == null && !init ){
			return null;
		} else {
			//example to bypass "No xxx exists with the key"
			if ( BgLaeLocalServiceUtil.countByBgCharInst( vcgAnId, custom.getBoxGpId() ) == 0 ){
				if ( init ){
					value = new BgLaeImpl();
					value.setBoxGpId( custom.getBoxGpId() );
				}
			} else {
				value = BgLaeLocalServiceUtil.getBgLaeAssociation( vcgAnId, custom.getBoxGpId() );
			}
		}
		return value;
	}
	
	public void setInvalidPerson ( long personId, String largeText ) {
		int sequence = 0;
		if ( personId == getVeteranId() ){
			sequence = Person.Role.VETERAN.getId();
		} else if ( personId == getPrimaryId() ){
			sequence = Person.Role.PRIMARY.getId();
		} else if ( personId == getSecondaryId() ){
			sequence = Person.Role.SECONDARY.getId();
		} else if ( personId == getSecondaryTwoId() ){
			sequence = Person.Role.SECONDARYTWO.getId();
		}
		try {
			BgLae invalid = null;
			String attr = CaretStrPool.INVALID_APP_PERSON + personId;
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					invalid = customAttributes.get(key);
				}
			}
			if ( invalid == null ){
				invalid = getLeaAttr ( attr, sequence );
				customAttributes.put( attr, invalid );
			}
			invalid.setLargeText(largeText);
			invalid.setOwnerId(personId);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( !customAttributes.isEmpty() ) {
			for ( String key : customAttributes.keySet() ){
				String text = customAttributes.get(key).getLargeText();
				text = text.substring(0, Math.min(text.length(), 75));
				if ( customAttributes.get(key).getBgLaeId() == 0 ){
					_log.info(key + " attribute, new instance =" + text);
				}
				modelAttributes.put(key, text );
			}
		}
		return modelAttributes;
	}
	
	public Date getApplicationDate(){
		Date receivedDate = super.getReceivedDate();
		if (receivedDate == null){
			return getSubmitDate();
		}
		return receivedDate;
	}
	
}
