package gov.va.caret.model.support;

import java.math.BigDecimal;

import gov.va.caret.model.NoteWrapper;

public class NoteSupport extends NoteWrapper  {

	private static final long serialVersionUID = 1L;
	
	public static int CALL = 1;
	public static int WORK = 2;
	public static int VCG = 3;
	
	
	public enum NoteGroup {
		APP_DELAY ( 5l ),
		ASSIGN_GENERAL ( 10l ),
		CAREGIVER_INFO(20l),
		CREATE_VCG ( 30l ),
		CUSTOM_NOTE ( 40l ),
		DISPOSITION ( 50l ),
		PROFILE_UPDATE ( 60l ),
		REFERRAL ( 70l ),
		TIER_UPDATE ( 80l ),
		TRANSFER ( 90l );
		
		long groupId;
		NoteGroup ( long id ){
			this.groupId = id;
		}
		public long groupId(){
			return groupId;
		}
		public static NoteGroup getNoteGroup( Object o ){
			if ( o instanceof BigDecimal ){
				BigDecimal l = (BigDecimal)o;
				for ( NoteGroup next : NoteGroup.values() ){
					if ( l.longValue() == next.groupId ){
						return next;
					}
				}
			}
			return null;
		}
	}
	
	public NoteSupport( gov.va.caret.model.Note noteImpl ) {
		super(noteImpl);
	}

	public void setValue( String value ){ 
		super.setValue( value.substring( 0, Math.min( 400, value.length() ) ) );
	}
	
}
