package gov.va.caret.model.support;



public enum DispositionType {
	
	DISAPPROVE(0),
	APPROVE(0),
	REVOKE(1),
	APPEAL(2),
	REINSTATE(3);

	int flow;
	DispositionType(int flow){
		this.flow = flow;
	}
	
	public int getFlow(){
		return flow;
	}
	
	public DispositionType next(){
		if ( ordinal() > 0 ){
			for ( DispositionType next : DispositionType.values() ){
				if ( next.ordinal() > ordinal() ){
					return next;
				}
			}
		}
		return this;
	}
}
