package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.PMReadMessage;
import gov.va.caret.model.PMReadMessageModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the PMReadMessage service. Represents a row in the &quot;read_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.PMReadMessageModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PMReadMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMReadMessageImpl
 * @see gov.va.caret.model.PMReadMessage
 * @see gov.va.caret.model.PMReadMessageModel
 * @generated
 */
public class PMReadMessageModelImpl extends BaseModelImpl<PMReadMessage>
    implements PMReadMessageModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a p m read message model instance should use the {@link gov.va.caret.model.PMReadMessage} interface instead.
     */
    public static final String TABLE_NAME = "read_message";
    public static final Object[][] TABLE_COLUMNS = {
            { "readMessageId", Types.BIGINT },
            { "messageId", Types.BIGINT },
            { "readDate", Types.TIMESTAMP }
        };
    public static final String TABLE_SQL_CREATE = "create table read_message (readMessageId LONG not null primary key,messageId LONG,readDate DATE null)";
    public static final String TABLE_SQL_DROP = "drop table read_message";
    public static final String ORDER_BY_JPQL = " ORDER BY pmReadMessage.readDate DESC";
    public static final String ORDER_BY_SQL = " ORDER BY read_message.readDate DESC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.PMReadMessage"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.PMReadMessage"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.PMReadMessage"),
            true);
    public static long MESSAGEID_COLUMN_BITMASK = 1L;
    public static long READDATE_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.PMReadMessage"));
    private static ClassLoader _classLoader = PMReadMessage.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] {
            PMReadMessage.class
        };
    private long _readMessageId;
    private long _messageId;
    private long _originalMessageId;
    private boolean _setOriginalMessageId;
    private Date _readDate;
    private long _columnBitmask;
    private PMReadMessage _escapedModel;

    public PMReadMessageModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _readMessageId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setReadMessageId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _readMessageId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return PMReadMessage.class;
    }

    @Override
    public String getModelClassName() {
        return PMReadMessage.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("readMessageId", getReadMessageId());
        attributes.put("messageId", getMessageId());
        attributes.put("readDate", getReadDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long readMessageId = (Long) attributes.get("readMessageId");

        if (readMessageId != null) {
            setReadMessageId(readMessageId);
        }

        Long messageId = (Long) attributes.get("messageId");

        if (messageId != null) {
            setMessageId(messageId);
        }

        Date readDate = (Date) attributes.get("readDate");

        if (readDate != null) {
            setReadDate(readDate);
        }
    }

    @Override
    public long getReadMessageId() {
        return _readMessageId;
    }

    @Override
    public void setReadMessageId(long readMessageId) {
        _readMessageId = readMessageId;
    }

    @Override
    public long getMessageId() {
        return _messageId;
    }

    @Override
    public void setMessageId(long messageId) {
        _columnBitmask |= MESSAGEID_COLUMN_BITMASK;

        if (!_setOriginalMessageId) {
            _setOriginalMessageId = true;

            _originalMessageId = _messageId;
        }

        _messageId = messageId;
    }

    public long getOriginalMessageId() {
        return _originalMessageId;
    }

    @Override
    public Date getReadDate() {
        return _readDate;
    }

    @Override
    public void setReadDate(Date readDate) {
        _columnBitmask = -1L;

        _readDate = readDate;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            PMReadMessage.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public PMReadMessage toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (PMReadMessage) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        PMReadMessageImpl pmReadMessageImpl = new PMReadMessageImpl();

        pmReadMessageImpl.setReadMessageId(getReadMessageId());
        pmReadMessageImpl.setMessageId(getMessageId());
        pmReadMessageImpl.setReadDate(getReadDate());

        pmReadMessageImpl.resetOriginalValues();

        return pmReadMessageImpl;
    }

    @Override
    public int compareTo(PMReadMessage pmReadMessage) {
        int value = 0;

        value = DateUtil.compareTo(getReadDate(), pmReadMessage.getReadDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PMReadMessage)) {
            return false;
        }

        PMReadMessage pmReadMessage = (PMReadMessage) obj;

        long primaryKey = pmReadMessage.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        PMReadMessageModelImpl pmReadMessageModelImpl = this;

        pmReadMessageModelImpl._originalMessageId = pmReadMessageModelImpl._messageId;

        pmReadMessageModelImpl._setOriginalMessageId = false;

        pmReadMessageModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<PMReadMessage> toCacheModel() {
        PMReadMessageCacheModel pmReadMessageCacheModel = new PMReadMessageCacheModel();

        pmReadMessageCacheModel.readMessageId = getReadMessageId();

        pmReadMessageCacheModel.messageId = getMessageId();

        Date readDate = getReadDate();

        if (readDate != null) {
            pmReadMessageCacheModel.readDate = readDate.getTime();
        } else {
            pmReadMessageCacheModel.readDate = Long.MIN_VALUE;
        }

        return pmReadMessageCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(7);

        sb.append("{readMessageId=");
        sb.append(getReadMessageId());
        sb.append(", messageId=");
        sb.append(getMessageId());
        sb.append(", readDate=");
        sb.append(getReadDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(13);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.PMReadMessage");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>readMessageId</column-name><column-value><![CDATA[");
        sb.append(getReadMessageId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>messageId</column-name><column-value><![CDATA[");
        sb.append(getMessageId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>readDate</column-name><column-value><![CDATA[");
        sb.append(getReadDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
