package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Crypto;
import gov.va.caret.model.CryptoModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Crypto service. Represents a row in the &quot;CARET_CRYPTO_VALUES&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.CryptoModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CryptoImpl}.
 * </p>
 *
 * @author caret
 * @see CryptoImpl
 * @see gov.va.caret.model.Crypto
 * @see gov.va.caret.model.CryptoModel
 * @generated
 */
public class CryptoModelImpl extends BaseModelImpl<Crypto>
    implements CryptoModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a crypto model instance should use the {@link gov.va.caret.model.Crypto} interface instead.
     */
    public static final String TABLE_NAME = "CARET_CRYPTO_VALUES";
    public static final Object[][] TABLE_COLUMNS = {
            { "cryptoId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "type_", Types.VARCHAR },
            { "value", Types.VARCHAR },
            { "hcode", Types.INTEGER }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_CRYPTO_VALUES (cryptoId LONG not null primary key,ownerId LONG,type_ VARCHAR(75) null,value VARCHAR(75) null,hcode INTEGER)";
    public static final String TABLE_SQL_DROP = "drop table CARET_CRYPTO_VALUES";
    public static final String ORDER_BY_JPQL = " ORDER BY crypto.cryptoId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_CRYPTO_VALUES.cryptoId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Crypto"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Crypto"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Crypto"),
            true);
    public static long OWNERID_COLUMN_BITMASK = 1L;
    public static long TYPE_COLUMN_BITMASK = 2L;
    public static long CRYPTOID_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Crypto"));
    private static ClassLoader _classLoader = Crypto.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Crypto.class };
    private long _cryptoId;
    private long _ownerId;
    private long _originalOwnerId;
    private boolean _setOriginalOwnerId;
    private String _type;
    private String _originalType;
    private String _value;
    private int _hcode;
    private long _columnBitmask;
    private Crypto _escapedModel;

    public CryptoModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _cryptoId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCryptoId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _cryptoId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Crypto.class;
    }

    @Override
    public String getModelClassName() {
        return Crypto.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("cryptoId", getCryptoId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("type", getType());
        attributes.put("value", getValue());
        attributes.put("hcode", getHcode());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long cryptoId = (Long) attributes.get("cryptoId");

        if (cryptoId != null) {
            setCryptoId(cryptoId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        String value = (String) attributes.get("value");

        if (value != null) {
            setValue(value);
        }

        Integer hcode = (Integer) attributes.get("hcode");

        if (hcode != null) {
            setHcode(hcode);
        }
    }

    @Override
    public long getCryptoId() {
        return _cryptoId;
    }

    @Override
    public void setCryptoId(long cryptoId) {
        _cryptoId = cryptoId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _columnBitmask |= OWNERID_COLUMN_BITMASK;

        if (!_setOriginalOwnerId) {
            _setOriginalOwnerId = true;

            _originalOwnerId = _ownerId;
        }

        _ownerId = ownerId;
    }

    public long getOriginalOwnerId() {
        return _originalOwnerId;
    }

    @Override
    public String getType() {
        if (_type == null) {
            return StringPool.BLANK;
        } else {
            return _type;
        }
    }

    @Override
    public void setType(String type) {
        _columnBitmask |= TYPE_COLUMN_BITMASK;

        if (_originalType == null) {
            _originalType = _type;
        }

        _type = type;
    }

    public String getOriginalType() {
        return GetterUtil.getString(_originalType);
    }

    @Override
    public String getValue() {
        if (_value == null) {
            return StringPool.BLANK;
        } else {
            return _value;
        }
    }

    @Override
    public void setValue(String value) {
        _value = value;
    }

    @Override
    public int getHcode() {
        return _hcode;
    }

    @Override
    public void setHcode(int hcode) {
        _hcode = hcode;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Crypto.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Crypto toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Crypto) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        CryptoImpl cryptoImpl = new CryptoImpl();

        cryptoImpl.setCryptoId(getCryptoId());
        cryptoImpl.setOwnerId(getOwnerId());
        cryptoImpl.setType(getType());
        cryptoImpl.setValue(getValue());
        cryptoImpl.setHcode(getHcode());

        cryptoImpl.resetOriginalValues();

        return cryptoImpl;
    }

    @Override
    public int compareTo(Crypto crypto) {
        long primaryKey = crypto.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Crypto)) {
            return false;
        }

        Crypto crypto = (Crypto) obj;

        long primaryKey = crypto.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        CryptoModelImpl cryptoModelImpl = this;

        cryptoModelImpl._originalOwnerId = cryptoModelImpl._ownerId;

        cryptoModelImpl._setOriginalOwnerId = false;

        cryptoModelImpl._originalType = cryptoModelImpl._type;

        cryptoModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Crypto> toCacheModel() {
        CryptoCacheModel cryptoCacheModel = new CryptoCacheModel();

        cryptoCacheModel.cryptoId = getCryptoId();

        cryptoCacheModel.ownerId = getOwnerId();

        cryptoCacheModel.type = getType();

        String type = cryptoCacheModel.type;

        if ((type != null) && (type.length() == 0)) {
            cryptoCacheModel.type = null;
        }

        cryptoCacheModel.value = getValue();

        String value = cryptoCacheModel.value;

        if ((value != null) && (value.length() == 0)) {
            cryptoCacheModel.value = null;
        }

        cryptoCacheModel.hcode = getHcode();

        return cryptoCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{cryptoId=");
        sb.append(getCryptoId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", value=");
        sb.append(getValue());
        sb.append(", hcode=");
        sb.append(getHcode());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Crypto");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>cryptoId</column-name><column-value><![CDATA[");
        sb.append(getCryptoId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>value</column-name><column-value><![CDATA[");
        sb.append(getValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>hcode</column-name><column-value><![CDATA[");
        sb.append(getHcode());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
