package gov.va.caret.letters;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.support.DocumentSupport;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.pdf.FileType;
import gov.va.caret.security.CAction;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document.OutputSettings;
import org.jsoup.safety.Whitelist;
import org.w3c.dom.Document;
//import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xml.sax.InputSource;

public class PopulateLettersImpl implements PopulateLetters{
	
	public static final String FORM = "/letters/VeteranRevocation.pdf";
	private static Log _log = LogFactoryUtil.getLog(PopulateLettersImpl.class);
	
	public void generateAndPopulatePDF(PortletRequest request, String letterName) {
		//LetterFields letterFields = populateLetterFields (request, letterName);
		//PDDocument pdfDoc = letterFields.getPdfDoc();
        //PDDocumentCatalog docCatalog = pdfDoc.getDocumentCatalog();
        //PDAcroForm acroForm = docCatalog.getAcroForm(); 
        //acroForm.setXFA(null);	     	        
        //printFields(pdfDoc, letterFields); 
        String tempLocation = PortletProps.get(CaretStrPool.FILE_TEMP_STORE);
        String name = letterName+ "_" + DateUtil.newTime() + ".pdf";
       
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
         String documentPath = "/letters/";
    	try {
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

            factory.setNamespaceAware(false);
           factory.setValidating(false);
           factory.setFeature("http://xml.org/sax/features/namespaces", false);
           factory.setFeature("http://xml.org/sax/features/validation", false);
           factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
           factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);            

            DocumentBuilder builder = factory.newDocumentBuilder();
            
    		// builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			/*URI uri = new URI( request.getScheme(),
								null,
								request.getServerName(),
								request.getServerPort(),
								request.getContextPath() + documentPath + "test.xml",
								null, null);*/
			InputStream stream = getClass().getClassLoader().getResourceAsStream("test.xml"); //new URL( uri.toString() ).openStream();
			ITextRenderer renderer = new ITextRenderer();
			
			// Create instance
//			final Tidy tidy = new Tidy();
//			tidy.setMakeClean( true );
//			tidy.setXHTML( true );
//			tidy.setSmartIndent( true );
			final ByteArrayOutputStream outStr2 = new ByteArrayOutputStream();
//			final Document document = tidy.parseDOM( stream , null );
//			tidy.pprint( document , outStr2 );
			final StringBuilder stringBuilder = new StringBuilder();
			stringBuilder.append( new String( outStr2.toByteArray() , "UTF-8" ) );
			final String validXHTML = stringBuilder.toString();
						
			InputSource inputSource = new InputSource(new StringReader(validXHTML));
			final Document doc = builder.parse(inputSource);
			renderer.setDocument(doc, tempLocation);
			renderer.layout();
			String fileNameWithPath = tempLocation + name;
			FileOutputStream fos = new FileOutputStream( fileNameWithPath );
			renderer.createPDF(fos, true);
			//pdfDoc.save(tempLocation + name);
		} catch (IOException e2) {
			e2.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		request.setAttribute(CaretStrPool.LETTER_FILE, name );
  }
	
	public void generateAndPopulatePDFWithEditedContent(PortletRequest request, String letterName) {
		
		String tempLocation = PortletProps.get(CaretStrPool.FILE_TEMP_STORE);
        String name = letterName+ "_" + DateUtil.newTime() + ".pdf";

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String documentPath = "/letters/";
    	try {
    		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

            factory.setNamespaceAware(false);
           factory.setValidating(false);
           factory.setFeature("http://xml.org/sax/features/namespaces", false);
           factory.setFeature("http://xml.org/sax/features/validation", false);
           factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
           factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);            

            DocumentBuilder builder = factory.newDocumentBuilder();
           
			String letterContent = "<?xml version='1.0' encoding='UTF-8'?> "
					+ "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">   <wrapper>" + 
									"<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">"+
									"<head>"+
									"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></meta>"+
									"</head>"+
									"<body>";
			letterContent += request.getParameter(CaretStrPool.EDITED_LETTER_CONTENT);
			letterContent += "</body>"+
								"</html></wrapper>";
			ITextRenderer renderer = new ITextRenderer();
			
			// Create instance
//			final Tidy tidy = new Tidy();
//			tidy.setMakeClean( true );
//			tidy.setXHTML( true );
//			tidy.setSmartIndent( true );
			final ByteArrayOutputStream outStr2 = new ByteArrayOutputStream();
//			final Document document = tidy.parseDOM( new ByteArrayInputStream( letterContent.getBytes() ) , null );
//			tidy.pprint( document , outStr2 );
			final StringBuilder stringBuilder = new StringBuilder();
			stringBuilder.append( new String( outStr2.toByteArray() , "UTF-8" ) );
			final String validXHTML = stringBuilder.toString();
			
			InputSource inputSource = new InputSource(new StringReader(validXHTML));
			final Document doc = builder.parse(inputSource);

			//// if you have html source in hand, use it to generate document object
			renderer.setDocument(doc, tempLocation);
			renderer.layout();
			
			String fileNameWithPath = tempLocation + name;
			FileOutputStream fos = new FileOutputStream( fileNameWithPath );
			renderer.createPDF(fos, true);
		}
    	
        catch (IOException e2) {
			e2.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		request.setAttribute(CaretStrPool.LETTER_FILE, name ); // tempLocation + name);
		
  }
	
	String cleanXmlAndRemoveUnwantedTags(String textToEscape) {
	    Whitelist whitelist = Whitelist.none();
	    whitelist.addTags(new String[] { "b", "br", "font" });

	    OutputSettings outputSettings = new OutputSettings()
	                    .syntax(OutputSettings.Syntax.xml)
	                    .charset(StandardCharsets.UTF_8)
	                    .prettyPrint(false);

	    String safe = Jsoup.clean(textToEscape, "", whitelist, outputSettings);
	    return safe;
	}

	public void generatePDF(PortletRequest request, 
		ByteArrayOutputStream output, String letterName) throws COSVisitorException, IOException  {
		//String documentName = "Veteran Requests CG Revocation_fields.pdf";
		LetterFields letterFields = populateLetterFields (request, letterName);
		printFields( letterFields.getPdfDoc(), letterFields );
		letterFields.getPdfDoc().save( output );
	}
	
	public static void generateVeteranCGPDF(PortletRequest request)  {
		
		List<Long> persnRevisionIds = new ArrayList<Long>();
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( request );
		Map<String, Object> form = ResultMap.getForm(request);
		try {
			long persnId = CaretParam.getPersnId(request);
			long userId = PortalUtil.getUserId( request );
			persnRevisionIds.add( persnId );//TODO:...
			for ( Persn persn: PersnLocalServiceUtil.getByOwner( userId ) ){ //userId, the user who created this Persn record, revisions create new Persn records
				persnRevisionIds.add( persn.getPersnId() );
			}
			
			Map persnIdMap = Collections.singletonMap(CaretStrPool.PERSN_ID, persnRevisionIds );
			List<Map<String, Object>> myApplications = new ArrayList<Map<String, Object>> ();
			myApplications = (List<Map<String, Object>>) CaretLocalServiceUtil.getReport( dashboard.getDashboardReport(), persnIdMap );
			List<Docum> allLetters = new ArrayList<Docum>();
			List<DocumentSupport> allSupportLetters = new ArrayList<DocumentSupport>();
			for ( Map<String, Object> appFields : myApplications ){
				BigDecimal vcgAnId = (BigDecimal) appFields.get( CaretStrPool.NDX0 );
				VcgAn vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId.longValue());
				VcgSupport vcgSupport = VcgSupport.getVcgSupport(vcgAn.getVcgId());
				allLetters.addAll( DocumLocalServiceUtil.getByClass(vcgAnId.longValue(), PortalUtil.getClassNameId(VcgAn.class), FileType.CSC_Letter.name()));
				//vcgSupport.getSupportingDocData();
				//allSupportLetters.addAll(vcgSupport.getVcgDocsAll());
			}
			form.put("allLetters", allLetters);
			form.put("allSuportLetters", allSupportLetters);
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (PortalException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		
		
		/*	LetterFields letterFields = populateLetterFields (request, letterName);
			printFields( letterFields.getPdfDoc(), letterFields );
			letterFields.getPdfDoc().save( output );*/
			
}
	
	private PDDocument initLetterDocument( PortletRequest request, String form ) throws URISyntaxException, MalformedURLException, IOException {
		//pass a blank pdf
		String documentPath = "/letters/";
    	URI uri = new URI( request.getScheme(),
	    					null,
	    					request.getServerName(),
	    					request.getServerPort(),
	    					request.getContextPath() + documentPath + form,
	    					null, null);
		 
		return PDDocument.load( new URL( uri.toString() ) );
	}

	

	public LetterFields populateLetterFields (PortletRequest request, String letterName ) {
		LetterFields letterFields = null;
		long vcgId = ParamUtil.getLong(request, "vcgId", 0);
		try {
			PDDocument pdfDoc = initLetterDocument(request, letterName+".pdf");
			VcgAn vcgAn =  VcgAnLocalServiceUtil.getRecent(vcgId);
			Long vcgAnId = vcgAn.getVcgAnId();
			VcgApplication vcgApplication;
			Person veteran = null;
			Person primary = null;
			Person secondary = null;
			Person currentUser = null;
			if ( vcgAnId > 0 ) {  
				try {
					currentUser = new Person( PersnLocalServiceUtil.getByUser(PortalUtil.getUserId( request )) );
					vcgApplication = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) ); 
					veteran = new Veteran ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
					if ( vcgApplication.getPrimaryId() > 0 ){
							
						primary = new Primary ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
						
						Primary formPrim = (Primary) CaretParam.loadModel(request, new Primary( new PersnImpl() ),
								Toolbox.getCollection("lastName","firstName","middleName",
														"birthDate","gender","ssn","phone","phone2","email" ), 
														CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
						//loadAddress( request, formPrim, CaretStrPool.PRIMARY_PERSN );
					}
					if ( vcgApplication.getSecondaryId() > 0 ){
						secondary = new Secondary ( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
						
						Secondary formSec = (Secondary) CaretParam.loadModel(request, new Secondary( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email"), CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
						//loadAddress( request, formSec, CaretStrPool.SECONDARY_PERSN );
					}
					/*if ( vcgApplication.getSecondaryTwoId() > 0 ){
						secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
						
						SecondaryTwo formSec2 = (SecondaryTwo) CaretParam.loadModel(request, new SecondaryTwo( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email"), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
						//loadAddress( request, formSec2, CaretStrPool.SECONDARY_TWO_PERSN );
						
					}*/
					
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException(e);
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException(e);
				}
			}
			
			letterFields = new LetterFields(currentUser, veteran, primary, secondary, pdfDoc);
			
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (PortalException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return letterFields;
	}
	
  
  public void printFields( PDDocument pdfDocument, LetterFields letterFields)
  {
  	PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
      PDAcroForm acroForm = docCatalog.getAcroForm();
      List fields;
      try {
    	  fields = acroForm.getFields();
    	  Iterator fieldsIter = fields.iterator();
 
    	  _log.info(new Integer(fields.size()).toString() + " top-level fields were found on the form");
 
	      while( fieldsIter.hasNext())
	      {
	          PDField field = (PDField)fieldsIter.next();
	          processField(field, "|--", field.getPartialName(), letterFields);
	      }
	  	} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
  }
  
  private void processField(PDField field, String sLevel, String sParent, LetterFields letterFields)
  {
  	List kids;
	try {
		 kids = field.getKids();
	     if(kids != null)
	     {
	      	Iterator kidsIter = kids.iterator();
	          if(!sParent.equals(field.getPartialName()))
	          {
	              sParent = sParent + "." + field.getPartialName();
	          }
	          //System.out.println(sLevel + sParent);
	          while(kidsIter.hasNext())
	          {
	               Object pdfObj = kidsIter.next();
	               if(pdfObj instanceof PDField)
	               {
	                    PDField kid = (PDField)pdfObj;
	                    processField(kid, "|  " + sLevel, sParent, letterFields);
	                }
	           }
	       }
	       else
	       {
	      	  //String outputString = sLevel + sParent + "." + field.getPartialName() + " = " + field.getValue() + ", (" + field.getAlternateFieldName() + ") ,  type=" + field.getClass().getName();
	      	  //System.out.println(outputString);
	    	   
	    	  //field.setReadonly(true);
	                    	 	      	 
	      	  Person  veteran = letterFields.getVeteran();
	      	  Person primary = letterFields.getPrimary();
	      	  Person secondary = letterFields.getSecondary();
	      	  Person currentUser = letterFields.getCurrentUser();
	      	  //all fields
	      	  // ==> Veteran Info ==
		      if(veteran!=null) {
		    	 if (field.getPartialName() != null ) {
		    		 if(field.getPartialName().equals("date")) {
				         	field.setValue(new Date().toString());
				     } else if(field.getPartialName().equals("veteranName")) {        		
			      		 field.setValue(veteran.getFullName());
			        }  else if(field.getPartialName().equals("primaryCaregiverName")) {        		
			      		 field.setValue(primary.getFullName());
			        }  else if(field.getPartialName().equals("primaryCaregiverName1")) {        		
			      		 field.setValue(primary.getFullName());
			        }  else if(field.getPartialName().equals("cscPhoneAdress")) {        		
			      		 field.setValue(currentUser.getPhone());
			        }  else if(field.getPartialName().equals("cscPhoneNumber")) {        		
			      		 field.setValue(currentUser.getPhone());
			        }  else if(field.getPartialName().equals("cscName") && isNotEmpty(veteran.getFullName())) {        		
			      		 field.setValue(currentUser.getFullName());
			        }  else if(field.getPartialName().equals("conversationDate")) {        		
			      		 field.setValue(new Date().toString());
			        }   else if(field.getPartialName().equals("additionalComments")) {        		
			      		 field.setValue("");
			        }  
		    	 }
		      	
		      }
	       }
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
  }
  
  private boolean isNotEmpty(String str){
  	if(str != null && !str.trim().isEmpty()){
  		return true;
  	}else{
  		return false;
  	}  	
  }
  
}
