package gov.va.caret.letters;

import gov.va.caret.model.support.Person;

import org.apache.pdfbox.pdmodel.PDDocument;

public class LetterFields {

	private Person currentUser;
	private Person veteran;
	private Person primary;
	private Person secondary;
	private PDDocument pdfDoc = null;

	
	final static Person nullPerson = Person.DEFAULT_PERSON;

	public boolean isPrimaryPreview() {
		return false;
	}
	
	public boolean isSecondaryPreview() {
		return false;
	}
	
	private Person nullSafe ( Person persn ){
		return persn == null? nullPerson : persn;
	}

	public LetterFields(Person currentUser, Person veteran, Person primary, Person secondary,
				PDDocument pdfDoc) {

		super();
		this.currentUser = currentUser;
		this.veteran = veteran;
		this.primary = primary;
		this.secondary = secondary;
		this.pdfDoc = pdfDoc;
	}

	public Person getCurrentUser() {
		return currentUser;
	}

	public void setCurrentUser(Person currentUser) {
		this.currentUser = currentUser;
	}
	
	public Person getVeteran() {
		return nullSafe(veteran);
	}

	public Person getPrimary() {
		return nullSafe(primary);
	}

	public Person getSecondary() {
		return nullSafe(secondary);
	}

	public PDDocument getPdfDoc() {
		return pdfDoc;
	}
}
