package gov.va.caret.hook.events;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutConstants;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.portlet.OnlinePortlet;
import gov.va.caret.security.CAction;
import gov.va.caret.util.CaretUtil;



public class StartupAction extends SimpleAction {
	
	
	@Override
	public void run(String[] ids) throws ActionException {
		try {
			ServiceContext sc = new ServiceContext();
			sc.setUserId( UserLocalServiceUtil.getDefaultUserId( GetterUtil.getLong(ids[0]) ) );
			sc.setCompanyId( GetterUtil.getLong(ids[0]) );
			sc.setAddGuestPermissions(false);
			
			if ( OrganizationLocalServiceUtil.getOrganizationsCount() > 20 ){
				setup(sc);
				addUsers ( sc );
			}
		}
		catch (Exception e) {
			throw new ActionException(e);
		}
	}

	private void setup ( ServiceContext serviceContext) throws PortalException, SystemException {
		
		String clinicalSite = CaretUtil.getClinicSite();
		Group group;
		try{
			group = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), clinicalSite );
		} catch ( com.liferay.portal.NoSuchGroupException e ){ 
			group = null;
		}
		
		if ( group == null ){
			group = addSite(clinicalSite, "Autogenerated CareT Clinical Site for workflow", serviceContext);
			addPortlet( serviceContext, group.getGroupId(), CAction.CARET_PORTLET );
		}
		
		String onlineSite = CaretUtil.getOnlineSite();
		try{
			group = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), onlineSite );
		} catch ( com.liferay.portal.NoSuchGroupException e ){ 
			group = null;
		}
		if ( group == null ){
			group = addSite(onlineSite, "Autogenerated CareT Online Site for workflow", serviceContext);
			addPortlet( serviceContext, group.getGroupId(), OnlinePortlet.PLID );
		}
	}
	
	private Group addSite(String name, String description, ServiceContext serviceContext) {
		int type = GroupConstants.TYPE_SITE_PRIVATE;
		Group group = null;
		try {
			String friendlyUrl = "/" + name.toLowerCase().replace(' ', '-');
			
			serviceContext.setAddGroupPermissions(true);
			long classPK = CounterLocalServiceUtil.increment( Group.class.getName() );
			group = GroupLocalServiceUtil.addGroup(serviceContext.getUserId(), 0, Group.class.getName(), classPK,
					0, name, description, type, false, 0,
					friendlyUrl, true, true, serviceContext);
			
		} catch (DuplicateGroupException e) {
			e.printStackTrace();
		} catch (PortalException e1) {
			e1.printStackTrace();
		} catch (com.liferay.portal.kernel.exception.SystemException e1) {
			e1.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return group;
	}

	private void addPortlet( ServiceContext serviceContext, long groupId, String plid ) throws PortalException, SystemException {
		
		LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet( groupId, true );
		if ( layoutSet != null ){
			int count = layoutSet.getPageCount();
			if ( count == 0 ){
				String name = PropsUtil.get( "layout.page.name" );
				Layout layout = LayoutLocalServiceUtil.addLayout(serviceContext.getUserId(), groupId, true, 
		                0, name, name, "CareT Landing Page",
		                LayoutConstants.TYPE_PORTLET, true, "/"+name.toLowerCase().replace(' ', '_'), serviceContext);
				
				LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();

				layoutTypePortlet.addPortletId(serviceContext.getUserId(), plid, "column-1", -1, false);
				
				PermissionChecker permissionChecker;
				try {
					permissionChecker = PermissionCheckerFactoryUtil.create( UserLocalServiceUtil.getDefaultUser(serviceContext.getCompanyId()) );
					PermissionThreadLocal.setPermissionChecker( permissionChecker );
				} catch (Exception e) {
					e.printStackTrace();
				}
				
				UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
				typeSettingsProperties.setProperty("layout-template-id", "1_column");
				
				layout.setTypeSettingsProperties(typeSettingsProperties);
				layout = LayoutLocalServiceUtil.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
				
				layoutSet = LayoutSetLocalServiceUtil.updateLogo( groupId, true, true, getClass().getClassLoader().getResourceAsStream("caretLogo.png") );

			}
		}
	}


	class UserImport {
		public UserImport(long roleId, long orgId, String emailAddress, String screenName, String first,
				String last, String password, boolean isOnline) {
			super();
			this.roleId = roleId;
			this.emailAddress = emailAddress;
			this.screenName = screenName;
			if ( orgId > 0 ){
				this.orgId = new long[]{orgId};
			}
			this.password = password;
			this.first = first;
			this.last = last;
			this.isOnline = isOnline;
		}
	
		public String emailAddress, screenName, password, first, last;
		public long roleId;
		public long[] orgId = null;
		boolean isOnline = false;
	}

	private void addUsers( ServiceContext serviceContext ) throws ApplicationWorkFlowException, SystemException   {
		
		File csvFile = new File ( PropsUtil.get("spreadsheet.location") + "/users.csv" );
		boolean exists = FileUtil.exists(csvFile);
		if ( !exists ){
			return;
		}
		
		long caretId = 0;
		String clinicSite = CaretUtil.getClinicSite( );
		String onlineSite = CaretUtil.getOnlineSite( );
		
		try {
			caretId = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), clinicSite ).getGroupId();
		} catch (PortalException e1) {
			e1.printStackTrace();
			return;
		}
		BufferedReader br = null;
		String line = "";
		List<UserImport> users = new ArrayList<UserImport>();
	
		try {
			br = new BufferedReader(new FileReader(csvFile));
			while ((line = br.readLine()) != null) { //parse and validate...
				String[] userRow = line.split(",");
				String roleName = userRow[0];
				if ( "ROLE".equals(roleName) ) {
					continue;
				}
				long orgId = 0;
				Role role = RoleLocalServiceUtil.fetchRole( serviceContext.getCompanyId(), roleName );
				if ( role == null ) {
					continue;
				}
				boolean isOnline = role.getSubtype().isEmpty();
				long roleId = role.getRoleId();
				User user = null;
				try {// validation...
					if ( userRow.length > 5 ){
						orgId = OrganizationLocalServiceUtil.getOrganization( serviceContext.getCompanyId(), userRow[5] ).getOrganizationId();
					}
					user = UserLocalServiceUtil.getUserByScreenName( serviceContext.getCompanyId(), userRow[1] );
					if ( user == null ){
						user = UserLocalServiceUtil.getUserByEmailAddress( serviceContext.getCompanyId(), userRow[1]+"@caret.gov" );
					}
				} catch (PortalException e) { //ignoring exception thrown when the user does not exist... 
				}
				
				if ( user == null ){
					users.add( new UserImport(roleId, orgId, userRow[1]+"@caret.gov", userRow[1], 
												userRow[2], userRow[3], userRow[4], isOnline) );
				}
			}
			
			for ( UserImport userImport: users ){
				long[] roleId = userImport.isOnline? new long[]{} : new long[]{userImport.roleId};
				long[] groupId = userImport.isOnline? new long[]{} : new long[]{caretId};
				boolean autoPassword = true;
				boolean isMale = true;
				int bdayMonth = 10;
				int bdayDay = 15;
				int bdayYear = 1980;
				
				
				User user = UserLocalServiceUtil.addUser(serviceContext.getUserId(), serviceContext.getCompanyId(), autoPassword, userImport.password,
					userImport.password, false, userImport.screenName, userImport.emailAddress, 
					0, StringPool.BLANK, LocaleUtil.getDefault(), userImport.first, "Middle", userImport.last, 0, 0, isMale, bdayMonth, bdayDay, bdayYear, "CareT User", 
					groupId, userImport.orgId, roleId, new long[]{}, false, serviceContext);
				if ( userImport.isOnline ){
					Group online = GroupLocalServiceUtil.getGroup( serviceContext.getCompanyId(), onlineSite );
					// UserGroupRoleLocalServiceUtil.deleteUserGroupRoles( user.getUserId(), new long[]{online.getGroupId()} );
					UserGroupRoleLocalServiceUtil.addUserGroupRoles( new long[]{user.getUserId()}, online.getGroupId(),
							userImport.roleId);
				}
			}
			
		} catch (FileNotFoundException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			e.printStackTrace();
		} finally {
			if (br != null) {
				try {
					br.close();
				} catch (IOException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
	}
	
}
