package gov.va.caret.hook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.util.PortalUtil;


public class LandingPage extends Action {

	private static final Log _log = LogFactoryUtil.getLog( LandingPage.class );

	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		Group userSite = (Group) request.getAttribute("groupSite");
		if ( userSite == null ){
			try {
				userSite = LandingGroupSequence.getUserSite( PortalUtil.getUser(request) );
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
			if ( userSite == null ) {
				_log.info("landing page user site is null..." );
				return;
			}
		}
		String siteLanding = PortalUtil.getPortalProperties().get( PropsKeys.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING ) + userSite.getFriendlyURL();
		LastPath lastPath = new LastPath(StringPool.BLANK, siteLanding);
		if ( _log.isInfoEnabled() ){
			_log.info("landing page..." + lastPath );
		}
		request.getSession().setAttribute(WebKeys.LAST_PATH, lastPath);
	}
}
