/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

/**
 * @author PShabaneh
 */
public class ApplicationWorkFlowException extends PortalException {

	private static final long serialVersionUID = 1L;
	
	//TODO: allow configuration of this property
	static boolean showStackTrace = true;
	
	public ApplicationWorkFlowException() {
		super();
	}

	public ApplicationWorkFlowException(String msg) {
		super(msg);
		handleException(msg);
	}

	public ApplicationWorkFlowException(String msg, Throwable cause) {
		super(msg, cause);
		handleException(cause, msg);
	}

	public ApplicationWorkFlowException(Throwable cause) {
		super(cause);
		handleException(cause);
	}

	
// TODO: manage error further...
	public static void handleException(Throwable e) {
		_log.error( e.getLocalizedMessage() );
		if ( showStackTrace || _log.isInfoEnabled() ){
			e.printStackTrace();
		}
	}

	public static void handleException(String msg) {
		_log.error(msg);
	}
	
	public static void handleException(Throwable e, String msg) {
		_log.error( e.getLocalizedMessage() );
		if ( showStackTrace || _log.isInfoEnabled() ){
			e.printStackTrace();
		}
	}

	private static Log _log = LogFactoryUtil.getLog( ApplicationWorkFlowException.class );
	
}