unit fDupPro;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ORCtrls, ExtCtrls, OrFn, OrNet, fBase508Form,
  VA508AccessibilityManager, Vcl.ComCtrls;

type
  TfrmDupPro = class(TfrmBase508Form)
    pnlSelDupPro: TPanel;
    pnlBottom: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    lboSelPro: TCaptionListView;
    stxtName: TVA508StaticText;
    procedure btnOKClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure lboSelProDblClick(Sender: TObject);
    procedure lboSelProChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
  private
    { Private declarations }
    fItemName: String;
  public
    constructor CreateByStrings(aList:TStrings;anItemName:String);
  end;


function getSingleProviderorCosignerDFN(const DUZ: Int64; CSPKey:String; CSPDate:Double; TITLEIEN: Integer; IEN:Integer; CSPFlag:Boolean): Int64;

implementation

{$R *.dfm}

uses rCore, uCore;

////////////////////////////////////////////////////////////////////////////////

function getListItemID(aDUZ: Int64;aList:TStrings;aName:String): Int64;
var
  frmProDupSel: TfrmDupPro;

begin
  Result := -1;
  if assigned(aList) then
    case aList.Count of
      0: ShowMessage('The name selected is not a CPRS user name allowable for entry in this field. Please select another name.');
      1: if ((aList.Count = 1) and (StrToInt64(Piece(aList[0], U, 1)) = aDUZ)) then
          Result := aDUZ;
    else
      begin
        frmProDupSel := TfrmDupPro.CreateByStrings(aList,aName);
        with frmProDupSel do
          try
            if ShowModal = mrOK then
              Result := lboSelPro.ItemID;
          finally
            Release;
          end;
      end
    end;
end;

function getSingleProviderorCosignerDFN(const DUZ: Int64; CSPKey:String; CSPDate:Double; TITLEIEN: Integer; IEN:Integer; CSPFlag:Boolean): Int64;
var
  i: Integer;
  SL: TStringList;

begin
  Result := -1;
  if DUZ = 0 then
    if Length(CSPKey) > 0 then
      ShowMessage('No Provider Selected!')
    else
      ShowMessage('No Cosigner Selected!')
  else if User.DUZ = DUZ then
    Result := DUZ
  else
    begin
      CallV('ORWU2 COSIGNER',[DUZ,1,CSPDate,IEN,TITLEIEN,CSPFlag]);
      SL := TStringList.Create;
      for i := 0 to RPCBrokerV.Results.Count - 1 do
        SL.Add(Piece(RPCBrokerV.Results[i], U, 1) + U + Piece(RPCBrokerV.Results[i], U, 2) + Piece(RPCBrokerV.Results[i], U, 3));
      try
        if Length(CSPKey) > 0 then
          Result := getListItemID(DUZ,SL,'Provider')
        else
          Result := getListItemID(DUZ,SL,'Cosigner');
      finally
        SL.Free;
      end;
    end;
end;

////////////////////////////////////////////////////////////////////////////////

constructor TfrmDupPro.CreateByStrings(aList: TStrings;anItemName:String);
begin
  inherited Create(nil);
  if assigned(aList) then
    FastAssign(aList,lboSelPro.ItemsStrings);

  Caption := anItemName + 's';
  stxtName.Caption := 'Please select the correct '+anItemName;
  fItemName := anItemName;
  ResizeAnchoredFormToFont(self);
end;

procedure TfrmDupPro.btnOKClick(Sender: TObject);
begin
  if not (Length(lboSelPro.ItemID) > 0) then  //*DFN*
    infoBox('A ' + fItemName + ' has not been selected.', 'No '+ fItemName + ' Selected', MB_OK)
  else
    ModalResult := mrOK;
end;

procedure TfrmDupPro.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if (key = VK_ESCAPE) then
    ModalResult := mrCancel
end;

procedure TfrmDupPro.lboSelProChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  inherited;
  // uncomment the next line if want to enable/disable the OK button
  //  btnOK.Enabled := lboSelPro.ItemIndex >= 0;
end;

procedure TfrmDupPro.lboSelProDblClick(Sender: TObject);
begin
  btnOKClick(btnOK);
end;

end.
