unit fTemplateDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ORCtrls, ORFn, AppEvnts, uTemplates, fBase508Form, uConst,
  VA508AccessibilityManager
  , mRequiredFieldsNavigator, Vcl.ComCtrls,
  Vcl.Menus, uRequiredFieldsHighlighter, U_CPTEditMonitor, U_CPTPasteDetails;

type
  TfrmTemplateDialog = class(TfrmBase508Form)
    sbMain: TScrollBox;
    splFields: TSplitter;
    grdpnlBottom: TGridPanel;
    btnAllGrid: TButton;
    btnNoneGrid: TButton;
    btnPreviewGrid: TButton;
    btnOKGrid: TButton;
    btnCancelGrid: TButton;
    StaticText1: TStaticText;
    pnlDebug: TPanel;
    reText: TRichEdit;
    PopupMenu1: TPopupMenu;
    S1: TMenuItem;
    T1: TMenuItem;
    N1: TMenuItem;
    S4: TMenuItem;
    pnlBottomGrid: TPanel;
    pnlBottomLeft: TPanel;
    pnlBottomRight: TPanel;
    pnlBtnTop: TPanel;
    pnlBtnBottom: TPanel;
    CPTemp: TCopyEditMonitor;
    procedure btnAllClick(Sender: TObject);
    procedure btnNoneClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnOKClick(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure S1Click(Sender: TObject);
    procedure T1Click(Sender: TObject);
    procedure S4Click(Sender: TObject);
  private
    RFH: TRequiredFieldsHighlighter;        // NSR20100706 AA 2015/09/29
    frRequiredFields: TRequiredFieldsFrame; // NSR20100706 AA 2015/09/29
    FFirstBuild: boolean;
    SL: TStrings;
    BuildIdx: TStringList;
    Entries: TStringList;
    NoTextID: TStringList;
    Index: string;
    OneOnly: boolean;
    Count: integer;
    RepaintBuild: boolean;
    FirstIndent: integer;
    FBuilding: boolean;
    FOldHintEvent: TShowHintEvent;
    FMaxPnlWidth: integer;
    FTabPos: integer;
    FCheck4Required: boolean;
    FSilent: boolean;
    procedure ChkAll(Chk: boolean);
    procedure BuildCB(CBidx: integer; var Y: integer; FirstTime: boolean);
    procedure ItemChecked(Sender: TObject);
    procedure BuildAllControls;
    procedure AppShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: Controls.THintInfo);
    procedure FieldChanged(Sender: TObject);
    procedure EntryDestroyed(Sender: TObject);
    function GetObjectID( Control: TControl): string;
    function GetParentID( Control: TControl): string;
    function FindObjectByID( id: string): TControl;
    function IsAncestor( OldID: string; NewID: string): boolean;
    procedure ParentCBEnter(Sender: TObject);
    procedure ParentCBExit(Sender: TObject);
    procedure UMScreenReaderInit(var Message: TMessage); message UM_MISC;
    procedure InitScreenReaderSetup;

    procedure FieldValueChanged(Sender: TObject);  // NSR20100706 AA 2015/09/29
    procedure CMFocusChanged(var Message: TCMFocusChanged); Message CM_FocusChanged; // NSR20100706 AA 2015/09/29
    procedure UpdateControlHighlighting(ctrl:TWinControl); //NSR20100706 AA 2015/09/29
    procedure setOKStatus; // NSR20100706 AA 2015/09/29
{$IFDEF DEBUG}
    procedure SetControlDebugInfo(aControl:TWinControl); //NSR20100706 AA 2015/09/29 - debug
    procedure SetDebugInfo; //NSR20100706 AA 2015/09/29
{$ENDIF}
  public
    property Silent: boolean read FSilent write FSilent ;

    procedure setReqHighlightAlign(aPos:Integer); // NSR20100706 AA 2015/09/29
    procedure setReqHighlightColor; // NSR20100706 AA 2015/09/29
    procedure AdjustFormToFontSize(aSize:Integer); // NSR20100706 AA 2015/09/29

  published
  end;

// Returns True if Cancel button is pressed
function DoTemplateDialog(SL: TStrings; const CaptionText: string; PreviewMode: boolean = FALSE; ExtCPMon: TCopyPasteDetails = nil): boolean;
procedure CheckBoilerplate4Fields(SL: TStrings; const CaptionText: string = ''; PreviewMode: boolean = FALSE; ExtCPMon: TCopyPasteDetails = nil); overload;
procedure CheckBoilerplate4Fields(var AText: string; const CaptionText: string = ''; PreviewMode: boolean = FALSE; ExtCPMon: TCopyPasteDetails = nil); overload;
procedure ShutdownTemplateDialog;

var
  frmTemplateDialog: TfrmTemplateDialog;

implementation

uses dShared, uTemplateFields, fRptBox, uInit, rMisc, uDlgComponents,
  VA508AccessibilityRouter, VAUtils, fFrame
  , ORNet
  , fOptionsTIUTemplates
  ;

{$R *.DFM}

var
  uTemplateDialogRunning: boolean = false;

const
  Gap = 4;
  IndentGap = 18;


procedure GetText(SL: TStrings; IncludeEmbeddedFields: Boolean);
var
  i, p1, p2: integer;
  Txt, tmp: string;
  Save, Hidden: boolean;
  TmpCtrl: TStringList;

begin
  Txt := SL.Text;
  SL.Clear;
  TmpCtrl := TStringList.Create;
  try
    for i := 0 to frmTemplateDialog.sbMain.ControlCount-1 do
      with frmTemplateDialog.sbMain do
      begin
        tmp := IntToStr(Controls[i].Tag);
        tmp := StringOfChar('0', 7-length(tmp)) + tmp;
        TmpCtrl.AddObject(tmp, Controls[i]);
      end;
    TmpCtrl.Sort;
    for i := 0 to TmpCtrl.Count-1 do
    begin
      Save := FALSE;
      if(TmpCtrl.Objects[i] is TORCheckBox) and (TORCheckBox(TmpCtrl.Objects[i]).Checked) then
        Save := TRUE
      else
      if(frmTemplateDialog.OneOnly and (TmpCtrl.Objects[i] is TPanel)) then
        Save := TRUE;
      if(Save) then
      begin
        tmp := Piece(frmTemplateDialog.Index,U,TControl(TmpCtrl.Objects[i]).Tag);
        p1 := StrToInt(Piece(tmp,'~',1));
        p2 := StrToInt(Piece(tmp,'~',2));
        Hidden := (copy(Piece(tmp,'~',3),2,1)=BOOLCHAR[TRUE]);
        SL.Text := SL.Text + ResolveTemplateFields(Copy(Txt,p1,p2), FALSE, Hidden, IncludeEmbeddedFields);
      end;
    end;
  finally
    TmpCtrl.Free;
  end;
end;

// Returns True if Cancel button is pressed
function DoTemplateDialog(SL: TStrings; const CaptionText: string; PreviewMode: boolean = FALSE; ExtCPMon: TCopyPasteDetails = nil): boolean;
var
  i, j, idx, Indent: integer;
  DlgProps, Txt: string;
  DlgIDCounts: TStringList;
  DlgInt: TIntStruc;
  CancelDlg: Boolean;
  CancelMsg: String;


  procedure IncDlgID(var id: string); //Appends an item count in the form of id.0, id.1, id.2, etc
  var                                 //based on what is in the StringList for id.
    k: integer;

  begin
    k := DlgIDCounts.IndexOf(id);

    if (k >= 0) then
      begin
      DlgInt := TIntStruc(DlgIDCounts.Objects[k]);
      DlgInt.x := DlgInt.x + 1;
      id := id + '.' + InttoStr(DlgInt.x);
      end
    else
      begin
      DlgInt := TIntStruc.Create;
      DlgInt.x := 0;
      DlgIDCounts.AddObject(id, DlgInt);
      id := id + '.0';
      end;

  end;

  procedure CountDlgProps(var DlgID: string);  //Updates the item and parent item id's with the count
  var                                          // value id.0, id.1, id.2, id.3, etc.  The input dialog
    x: integer;                                // id is in the form 'a;b;c;d', where c is the item id
    id, pid: string;                           // and d is the parent item id

  begin
    id  := piece(DlgID,';',3);
    pid := piece(DlgID,';',4);

    if length(pid) > 0 then
      x := DlgIDCounts.IndexOf(pid)
    else
      x := -1;

    if (x >= 0) then
      begin
      DlgInt := TIntStruc(DlgIDCounts.Objects[x]);
      pid := pid + '.' + InttoStr(DlgInt.x);
      end;

    if length(id) > 0 then
      IncDlgID(id);

    SetPiece(DlgID,';',3,id);
    SetPiece(DlgID,';',4,pid);
  end;

begin
  Result := FALSE;
  CancelDlg := FALSE;
  SetTemplateDialogCanceled(FALSE);
  frmTemplateDialog := TfrmTemplateDialog.Create(Application);
  clearRequiredControls;// NSR20100706 AA 2015/09/29
  try
    DlgIDCounts := TStringList.Create;
    DlgIDCounts.Sorted := TRUE;
    DlgIDCounts.Duplicates := dupError;
    frmTemplateDialog.Caption := CaptionText;
    AssignFieldIDs(SL);         // assigning IDs for every template field
    frmTemplateDialog.SL := SL;
    frmTemplateDialog.Index := '';
    Txt := SL.Text;
    frmTemplateDialog.OneOnly := (DelimCount(Txt, ObjMarker) = 1);
    frmTemplateDialog.Count := 0;
    idx := 1;
    frmTemplateDialog.FirstIndent := 99999;
    repeat
      i := pos(ObjMarker, Txt); // processing  ^@@^ items
      if(i > 1) then
      begin
        j := pos(DlgPropMarker, Txt);
        if(j > 0) then
          begin
          DlgProps := copy(Txt, j + DlgPropMarkerLen, (i - j - DlgPropMarkerLen));
          CountDlgProps(DlgProps);
          end
        else
          begin
          DlgProps := '';
          j := i;
          end;
        inc(frmTemplateDialog.Count);
        frmTemplateDialog.Index := frmTemplateDialog.Index +
                                   IntToStr(idx)+'~'+IntToStr(j-1)+'~'+DlgProps+U;
        inc(idx,i+ObjMarkerLen-1);
        Indent := StrToIntDef(Piece(DlgProps, ';', 5),0);
        if(frmTemplateDialog.FirstIndent > Indent) then
          frmTemplateDialog.FirstIndent := Indent;
      end;
      if(i > 0) then
        delete(txt, 1, i + ObjMarkerLen - 1);
    until (i = 0);

    if(frmTemplateDialog.Count > 0) then
    begin
      // NSR20100706 AA 2015/09/29
      { hiding frRequiredFields might be confusing as some of the fields could be disabled at opening of the dialog
      frmTemplateDialog.frRequiredFields.Visible :=
        getNumberOfMissingFields(frmTemplateDialog.sbMain)>0; left 'as is' to keep the current appearance}
      frmTemplateDialog.btnNoneGrid.Visible := not frmTemplateDialog.OneOnly;
      frmTemplateDialog.btnAllGrid.Visible := not frmTemplateDialog.OneOnly;
      frmTemplateDialog.BuildAllControls;  // build dialog controls
      frmTemplateDialog.setOKStatus;

      frmTemplateDialog.CPTemp.RelatedPackage := 'Template: ' + CaptionText;
      repeat
         frmTemplateDialog.ShowModal;
         if(frmTemplateDialog.ModalResult = mrOK) then
           GetText(SL, TRUE)     {TRUE = Include embedded fields}
         else
          if (not PreviewMode) and (not frmTemplateDialog.Silent) and (not uInit.TimedOut) then
            begin
              CancelMsg := 'If you cancel, your changes will not be saved.  Are you sure you want to cancel?';
              if (InfoBox(CancelMsg, 'Cancel Dialog Processing', MB_YESNO or MB_DEFBUTTON2 or MB_ICONQUESTION) = ID_YES) then
                begin
                  SL.Clear;
                  Result := TRUE;
                  CancelDlg := TRUE;
                end
              else
                CancelDlg := FALSE;
            end
          else
            begin
              SL.Clear;
              Result := TRUE;
              CancelDlg := TRUE;
            end;
      until CancelDlg or (frmTemplateDialog.ModalResult = mrOK)
    end
    else
      SL.Clear;
  finally
    //frmTemplateDialog.Free;    v22.11e RV
    if (Sl.Count > 0) and Assigned(ExtCPMon) then
      frmTemplateDialog.CPTemp.TransferData(ExtCPMon.EditMonitor);
    frmTemplateDialog.Release;
    frmTemplateDialog := nil;  // cleaning pointer after Release
    for i := 0 to DlgIDCounts.Count-1 do begin
      DlgIDCounts.Objects[i].Free;
    end;
    DlgIDCounts.Free;
  end;

  if Result then
    SetTemplateDialogCanceled(TRUE)
  else
  begin
    SetTemplateDialogCanceled(FALSE);
    CheckBoilerplate4Fields(SL, CaptionText, PreviewMode, ExtCPMon);
  end;
end;

procedure ShutdownTemplateDialog;
begin
  if uTemplateDialogRunning and assigned(frmTemplateDialog) then
  begin
    frmTemplateDialog.Silent := True;
    frmTemplateDialog.ModalResult := mrCancel;
  end;
end;

procedure CheckBoilerplate4Fields(SL: TStrings; const CaptionText: string = ''; PreviewMode: boolean = FALSE; ExtCPMon: TCopyPasteDetails = nil);
begin
  while(HasTemplateField(SL.Text)) do
  begin
    if (BoilerplateTemplateFieldsOK(SL.Text)) then
    begin
      SL[SL.Count-1] := SL[SL.Count-1] + DlgPropMarker + '00100;0;-1;;0' + ObjMarker;
      DoTemplateDialog(SL, CaptionText, PreviewMode, ExtCPMon);
    end
    else
      SL.Clear;
  end;
  StripScreenReaderCodes(SL);
end;

procedure CheckBoilerplate4Fields(var AText: string; const CaptionText: string = ''; PreviewMode: boolean = FALSE; ExtCPMon: TCopyPasteDetails = nil);
var
  tmp: TStringList;

begin
  tmp := TStringList.Create;
  try
    tmp.text := AText;
    CheckBoilerplate4Fields(tmp, CaptionText, PreviewMode, ExtCPMon);
    AText := tmp.text;
  finally
    tmp.free;
  end;
end;

procedure TfrmTemplateDialog.ChkAll(Chk: boolean);
var
  i: integer;

begin
  for i := 0 to sbMain.ControlCount-1 do
  begin
    if(sbMain.Controls[i] is TORCheckBox) then
      TORCheckBox(sbMain.Controls[i]).Checked := Chk;

  end;
  if assigned(frRequiredFields) then
    begin
      if assigned(frRequiredFields.FocusedControl) then
        frRequiredFields.FocusedControl.SetFocus;
    end;
end;

procedure TfrmTemplateDialog.btnAllClick(Sender: TObject);
begin
  ChkAll(TRUE);
end;

procedure TfrmTemplateDialog.btnNoneClick(Sender: TObject);
begin
  ChkAll(FALSE);
end;

function TfrmTemplateDialog.GetObjectID( Control: TControl): string;
var
  idx, idx2: integer;
begin
  result := '';
  if Assigned(Control) then
  begin
    idx := Control.Tag;
    if(idx > 0) then
    begin
      idx2 := BuildIdx.IndexOfObject(TObject(idx));
      if idx2 >= 0 then
        result := BuildIdx[idx2]
      else
        result := Piece(Piece(Piece(Index, U, idx),'~',3), ';', 3);
    end;
  end;
end;

function TfrmTemplateDialog.GetParentID( Control: TControl): string;
var
  idx: integer;
begin
  result := '';
  if Assigned(Control) then
  begin
    idx := Control.Tag;
    if(idx > 0) then
      result := Piece(Piece(Piece(Index, U, idx),'~',3), ';', 4);
  end;
end;

function TfrmTemplateDialog.FindObjectByID( id: string): TControl;
var
  i: integer;
  ObjID: string;
begin
  result := nil;
  if ID <> '' then
  begin
    for i := 0 to sbMain.ControlCount-1 do
    begin
      ObjID := GetObjectID(sbMain.Controls[i]);
      if(ObjID = ID) then
      begin
        result := sbMain.Controls[i];
        break;
      end;
    end;
  end;
end;

procedure TfrmTemplateDialog.InitScreenReaderSetup;
var
  ctrl: TWinControl;
  list: TList;
begin
  if ScreenReaderSystemActive then
  begin
    list := TList.Create;
    try
      sbMain.GetTabOrderList(list);
      if list.Count > 0 then
      begin
        ctrl := TWinControl(list[0]);
        PostMessage(Handle, UM_MISC, WParam(ctrl), 0);
      end;
    finally
      list.free;
    end;
  end;
end;

function TfrmTemplateDialog.IsAncestor( OldID: string; NewID: string): boolean;
begin
  if (OldID = '') or (NewID = '') then
    result := False
  else if OldID = NewID then
    result := True
  else
    result := IsAncestor(OldID, GetParentID(FindObjectByID(NewID)));
end;

procedure TfrmTemplateDialog.BuildCB(CBidx: integer; var Y: integer; FirstTime: boolean);
var
  bGap, Indent, i, idx, p1, p2: integer;
  EID, ID, PID, DlgProps, tmp, txt, tmpID: string;
  pctrl, ctrl: TControl;
  pnl: TPanel;
  KillCtrl, doHint, dsp, noTextParent: boolean;
  Entry: TTemplateDialogEntry;
//  StringIn, StringOut: string;
  cb: TCPRSDialogParentCheckBox;

  procedure NextTabCtrl(ACtrl: TControl);
  begin
    if(ACtrl is TWinControl) then
    begin
      inc(FTabPos);
      TWinControl(ACtrl).TabOrder := FTabPos;
    end;
  end;

begin
  tmp := Piece(Index, U, CBidx);      // Index:     tmp^tmp^tmp
                                      // tmp:       p1~p2~DlgProps
  p1 := StrToInt(Piece(tmp,'~',1));   //            p1 - position
  p2 := StrToInt(Piece(tmp,'~',2));   //            p2 - length
  DlgProps := Piece(tmp,'~',3);       // set of flags
                                      //            1 - visibility
                                      //            2 - Group Index (radio button?)
                                      //            3 - ?
                                      //            4 - ?
                                      //            5 - gap in CRLFs
  ID := Piece(DlgProps, ';', 3);      // DlgProps:  ...;...;ID;PID
                                      // ID links that CB with one of the sbMain Controls
  PID := Piece(DlgProps, ';', 4);

  ctrl := nil;
  pctrl := nil;
  if(PID <> '') then             // NoTextID - list of items without checkboxed parents ?
    noTextParent := (NoTextID.IndexOf(PID) < 0)
  else
    noTextParent := TRUE;        // noTextParent - no Text Parent
  if not FirstTime then          // FirstTime there are no controls - ctrl is nil
    ctrl := FindObjectByID(ID);  // find Control on sbMain by ID
                                 //  - for every control on sbMain with (tag<>0)
                                 //    get the control ID from BuildIdx or from Index
                                 //  - if ID is found then compare it with the original one

  if noTextParent and (PID <> '') then
    pctrl := FindObjectByID(PID);// find parent control by ID

  if(PID = '') then
    KillCtrl := FALSE            // Don't kill if no parent
  else
  begin
    if(assigned(pctrl)) then
    begin
      if(not (pctrl is TORCheckBox)) or
        (copy(DlgProps,3,1) = BOOLCHAR[TRUE]) then // show if parent is unchecked
        KillCtrl := FALSE
      else
        KillCtrl := (not TORCheckBox(pctrl).Checked); // Kill only if unchecked if parent is Checkbox
    end
    else
      KillCtrl := noTextParent; // if no pctrl defined or no pctrl found in NoTextID list
                                //    use noTextParent flag
  end;

  if KillCtrl then              // Kill the ctrl with no TextParent (exclude from BuildIdx, free if exists)
  begin
    if(assigned(ctrl)) then     // Hide Associate (the control linked to TORCheckBox)
    begin
      if(ctrl is TORCheckBox) and (assigned(TORCheckBox(ctrl).Associate)) then
        TORCheckBox(ctrl).Associate.Hide;
      idx := BuildIdx.IndexOfObject(TObject(ctrl.Tag)); // remove ctrl from BuildIdx
      if idx >= 0 then
        BuildIdx.delete(idx);
      ctrl.Free;                                        // free ctrl
    end;
    exit;                       // EXIT if ctrl is killed
  end;

  tmp := copy(SL.Text, p1, p2);
  if(copy(tmp, length(tmp)-1, 2) = CRLF) then   // remove trailing CRLFs
    delete(tmp, length(tmp)-1, 2);

  bGap := StrToIntDef(copy(DlgProps,5,1),0);    // remove header CRLFs
  while bGap > 0 do
  begin
    if(copy(tmp, 1, 2) = CRLF) then
    begin
      delete(tmp, 1, 2);
      dec(bGap);
    end
    else
      bGap := 0;
  end;

  if(tmp = NoTextMarker) then  // '<@>'
  begin
    if(NoTextID.IndexOf(ID) < 0) then
      NoTextID.Add(ID);        // add CB (dialog?)  ID to NoTextID list
    exit;                      // EXIT if the template is NoText
  end;

  if(not assigned(ctrl)) then
  begin
    dsp := (copy(DlgProps,1,1)=BOOLCHAR[TRUE]); // template visibility
    EID := 'DLG' + IntToStr(CBIdx);
    idx := Entries.IndexOf(EID); // Entries - List of TTemplateDialogEntries - visible DLGnnn
    doHint := FALSE;
    txt := tmp;                 // tmp holds template text without Index
    if(idx < 0) then            // DLG is not found in Entries list
    begin
      if(copy(DlgProps,2,1)=BOOLCHAR[TRUE]) then // GroupIndex (chop first 70 chars only?)
      begin
        i := pos(CRLF, tmp);
        if(i > 0) then
        begin
          dec(i);
          if i > 70 then
          begin
            i := 71;
            while (i > 0) and (tmp[i] <> ' ') do dec(i);
            if i = 0 then
              i := 70
            else
              dec(i);
          end;
          doHint := TRUE;
          tmp := copy(tmp, 1, i) + ' ...';
        end;
      end;
      Entry := GetDialogEntry(sbMain, EID, tmp); // Created TTemplateDialogEntry
      Entry.AutoDestroyOnPanelFree := TRUE;
      Entry.OnDestroy := EntryDestroyed;
      Entries.AddObject(EID, Entry);

      //Populate the Copy/Paste control
    end
    else
      Entry := TTemplateDialogEntry(Entries.Objects[idx]);

    if(dsp or OneOnly) then // if VISIBLE or only 1 ObjMarket found in Template
      cb := nil             // then no need in TCheckBox
    else
      cb := TCPRSDialogParentCheckBox.Create(Self);  // else create Parent check box

    pnl := Entry.GetPanel(FMaxPnlWidth, sbMain, cb);  // TDlgFieldPanel               !!!!
    pnl.Show;
    if(doHint and (not pnl.ShowHint)) then
    begin
      pnl.ShowHint := TRUE;
      Entry.Obj := pnl;
      Entry.Text := txt;
      pnl.hint := Entry.GetText;
      Entry.OnChange := FieldChanged; // tracking control changes for NSR20100706
    end  // NSR20100706 AA 2015/09/29 -------------------------------------------------- begin
    else // notification on changes to the Field
      Entry.OnChange := FieldValueChanged; // NSR20100706 AA 2015/09/29 ------------------ end

    if not assigned(cb) then
      ctrl := pnl
    else
    begin
      AddParentCheckbox(Entry,cb); // NSA20100706 AA 2015/09/29

      ctrl := cb;
      ctrl.Parent := sbMain;

      TORCheckbox(ctrl).OnEnter := frmTemplateDialog.ParentCBEnter;
      TORCheckbox(ctrl).OnExit := frmTemplateDialog.ParentCBExit;

      TORCheckBox(ctrl).Height := TORCheckBox(ctrl).Height + 5;
      TORCheckBox(ctrl).Width := 17;

    {Insert next line when focus fixed}
    //  ctrl.Width := IndentGap;
    {Remove next line when focus fixed}
      TORCheckBox(ctrl).AutoSize := false;
      TORCheckBox(ctrl).Associate := pnl;
      pnl.Tag := Integer(ctrl);           // panel Tag assigned to the ctlr (pointer)
      tmpID := copy(ID, 1, (pos('.', ID) - 1)); {copy the ID without the decimal place}
//      if Templates.IndexOf(tmpID) > -1 then
//        StringIn := 'Sub-Template: ' + TTemplate(Templates.Objects[Templates.IndexOf(tmpID)]).PrintName
//      else
//        StringIn := 'Sub-Template:';
//      StringOut := StringReplace(StringIn, '&', '&&', [rfReplaceAll]);
//      TORCheckBox(ctrl).Caption := StringOut;
      UpdateColorsFor508Compliance(ctrl);

    end;
    ctrl.Tag := CBIdx;  // ctrl is TDlgFieldPanel
                        // or
                        // Template Entry parent TORCheckBox

    // adjust position for visible control
    Indent := StrToIntDef(Piece(DlgProps, ';', 5),0) - FirstIndent;
    if dsp then inc(Indent);
    ctrl.Left := Gap + (Indent * IndentGap);
    //ctrl.Width := sbMain.ClientWidth - Gap - ctrl.Left - ScrollBarWidth;
    if(ctrl is TORCheckBox) then
      pnl.Left := ctrl.Left + IndentGap;

    if(ctrl is TORCheckBox) then with TORCheckBox(ctrl) do
    begin
      GroupIndex := StrToIntDef(Piece(DlgProps, ';', 2),0);
      if(GroupIndex <> 0) then
        RadioStyle := TRUE;   // RadioStyle for "groupped" ctrl
      OnClick := ItemChecked;
      StringData := DlgProps;
    end;

    // registration in BuildIdx list - all CBs are included
    if BuildIdx.IndexOfObject(TObject(CBIdx)) < 0 then
      BuildIdx.AddObject(Piece(Piece(Piece(Index, U, CBIdx),'~',3), ';', 3), TObject(CBIdx));
  end;

  // adjustnment of the ctrl Y position
  ctrl.Top := Y;
  // adjustmnt of the available Y position
  NextTabCtrl(ctrl);
  if(ctrl is TORCheckBox) then
  begin
    TORCheckBox(ctrl).Associate.Top := Y;
    NextTabCtrl(TORCheckBox(ctrl).Associate);
    inc(Y, TORCheckBox(ctrl).Associate.Height+1);
  end
  else
    inc(Y, ctrl.Height+1);
end;

procedure TfrmTemplateDialog.ParentCBEnter(Sender: TObject);
begin
  (Sender as TORCheckbox).FocusOnBox := true;
end;

procedure TfrmTemplateDialog.ParentCBExit(Sender: TObject);
begin
  (Sender as TORCheckbox).FocusOnBox := false;
end;

procedure TfrmTemplateDialog.ItemChecked(Sender: TObject);
begin
  if(copy(TORCheckBox(Sender).StringData,4,1) = '1') then
  begin
    RepaintBuild := TRUE;
    Invalidate;
  end;
  UpdateControlHighlighting(TCheckBox(Sender)); // NSR20100706
end;

procedure TfrmTemplateDialog.BuildAllControls;
var
  i, Y: integer;
  FirstTime: boolean;

begin
  if FBuilding then exit;
  FBuilding := TRUE;
  try
    FTabPos := 0;
    FirstTime := (sbMain.ControlCount = 0);
    NoTextID.Clear;
    Y := Gap - sbMain.VertScrollBar.Position;
    for i := 1 to Count do // all @@
      BuildCB(i, Y, FirstTime); // BUild CB
    if ScreenReaderSystemActive then
    begin
      amgrMain.RefreshComponents;
      Application.ProcessMessages;
    end;
    CPTemp.MonitorAllAvailable;
  finally
    FBuilding := FALSE;
  end;
end;

procedure TfrmTemplateDialog.FormPaint(Sender: TObject);
begin
  if RepaintBuild then
  begin
    RepaintBuild := FALSE;
    BuildAllControls;
    InitScreenReaderSetup;
  end;
end;

procedure TfrmTemplateDialog.FormShow(Sender: TObject);
begin
  inherited;
  if FFirstBuild then
  begin
    FFirstBuild := FALSE;
    InitScreenReaderSetup;
  end;
  frRequiredFields.setAlign(ReqHighlightAlign);  // NSR20100706 AA 2015/09/29
  RFH.HighlightControls(ReqHighlight);           // NSR20100706 AA 2015/09/29
end;

procedure TfrmTemplateDialog.FormCreate(Sender: TObject);

  procedure setupRequiredFields; // NSR20100706 AA 2015/09/29
  begin
    RFH := TRequiredFieldsHighlighter.Create; // NSR20100706 AA 2015/10/07

    restoreHighlightOptions;

    frRequiredFields := TRequiredFieldsFrame.Create(Self);
    frRequiredFields.Parent := Self;
    frRequiredFields.RFH := RFH;
    frRequiredFields.adjustButtonSize(Application.MainForm.Font.Size);
    AdjustFormToFontSize(Application.MainForm.Font.Size);
    S1.Checked := ReqHighlight;
{$IFDEF DEBUG}
    N1.Visible := True;
    T1.Visible := True;
{$ENDIF}
    frRequiredFields.SetButtonStatus;
  end;
  
var
 DteStr: String;
begin
  uTemplateDialogRunning := True;
  FFirstBuild := TRUE;
  BuildIdx := TStringList.Create;
  Entries := TStringList.Create;
  NoTextID := TStringList.Create;
  FOldHintEvent := Application.OnShowHint;
  Application.OnShowHint := AppShowHint;
  FMaxPnlWidth := FontWidthPixel(sbMain.Font.Handle) * MAX_ENTRY_WIDTH; //AGP change Template Dialog to wrap at 80 instead of 74
  SetFormPosition(Self);
  ResizeAnchoredFormToFont(Self);
  setUpRequiredFields; // NSR20100706 AA 2015/09/29
  DteStr := FormatDateTime('mmddyyhhmmss', Now);
  CPTemp.ItemIEN := StrToInt64Def(DteStr, 3) * -1;
end;

procedure TfrmTemplateDialog.AppShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: Controls.THintInfo);
const
  HistHintDelay = 1200000; // 20 minutes

begin
//  if(HintInfo.HintControl.Parent = sbMain) then
    HintInfo.HideTimeout := HistHintDelay;
  if(assigned(FOldHintEvent)) then
    FOldHintEvent(HintStr, CanShow, HintInfo);
end;

procedure TfrmTemplateDialog.FormDestroy(Sender: TObject);
begin
  //Application.OnShowHint := FOldHintEvent;   v22.11f - RV - moved to OnClose
  NoTextID.Free;
  FreeEntries(Entries);
  Entries.Free;
  BuildIdx.Free;
  uTemplateDialogRunning := False;

  RFH.Free;  // NSR20100706 AA 2015/10/07
end;

procedure TfrmTemplateDialog.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
  If RectContains(sbMain.BoundsRect, SbMain.ScreenToClient(MousePos)) then
  begin
    ScrollControl(sbMain, (WheelDelta > 0));
    Handled := True;
  end;
end;

procedure TfrmTemplateDialog.FieldChanged(Sender: TObject);
begin
  with TTemplateDialogEntry(Sender) do
      TPanel(Obj).hint := GetText;
  fieldValueChanged(Sender); // notifying dialog the value have changed NSR20100706 AA 2015/09/29
end;

procedure TfrmTemplateDialog.FormCloseQuery(Sender: TObject;  var CanClose: Boolean);
var
  Txt, tmp: string;
  i, p1, p2: Integer;
  Save: Boolean;

begin
  CanClose := TRUE;
  if FCheck4Required then
  begin
// NSR2010706 enables OK button only if all the required fields are populated.
// Since FCheck4Required is set TRUE by OK button this code won't be called.
// Leaving "as is" in case it is needed for reminder dialogs processing

    FCheck4Required := FALSE;
    Txt := SL.Text;
    for i := 0 to sbMain.ControlCount - 1 do
    begin
      Save := FALSE;
      if (sbMain.Controls[i] is TORCheckBox) and
        (TORCheckBox(sbMain.Controls[i]).Checked) then
        Save := TRUE
      else
      if (OneOnly and (sbMain.Controls[i] is TPanel)) then
        Save := TRUE;
      if (Save) then
      begin
        tmp := Piece(Index,U,sbMain.Controls[i].Tag);
        p1 := StrToInt(Piece(tmp, '~', 1));
        p2 := StrToInt(Piece(tmp, '~', 2));
        if AreTemplateFieldsRequired(copy(Txt, p1, p2)) then
          CanClose := FALSE;
      end;
    end;
    if not CanClose then
      begin // NSR20100706 AA -------------------------------------------- begin
        ReqHighlight := True;
        frRequiredFields.Visible := True;
        RFH.HighlightControls(ReqHighlight);
{$IFDEF DEBUG}
        setDebugInfo;
{$ENDIF}
        txt := RFH.getRequiredFieldNames(sbMain,char(VK_TAB));
        i := pos(CRLF,txt);
        if i < (Length(txt)-Length(CRLF)+1) then
          txt := 'The following Required fields are not populated:'+ CRLF+CRLF +txt
        else
          txt := 'The following Required field is not populated:'+ CRLF+CRLF +txt;

        frRequiredFields.FocusControl; // scroll to the first unpopulated field
        ShowMsg(txt);
      end;  // NSR20100706 AA ---------------------------------------------- end
  end;
end;

procedure TfrmTemplateDialog.btnOKClick(Sender: TObject);
begin
  FCheck4Required := TRUE;
end;

procedure TfrmTemplateDialog.btnPreviewClick(Sender: TObject);
var
  TmpSL: TStringList;

begin
  TmpSL := TStringList.Create;
  try
    FastAssign(SL, TmpSL);
    GetText(TmpSL, FALSE);  {FALSE = Do not include embedded fields}
    StripScreenReaderCodes(TmpSL);
    ReportBox(TmpSL, 'Dialog Preview', FALSE);
  finally
    TmpSL.Free;
  end;
end;

procedure TfrmTemplateDialog.EntryDestroyed(Sender: TObject);
var
  idx: integer;

begin
  idx := Entries.IndexOf(TTemplateDialogEntry(Sender).ID);
  if idx >= 0 then
    Entries.delete(idx);
end;

procedure TfrmTemplateDialog.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Application.OnShowHint := FOldHintEvent;
  SaveUserBounds(Self);
  saveHighlightOptions; // NSR20100706 AA 2015/09/29
end;

procedure TfrmTemplateDialog.UMScreenReaderInit(var Message: TMessage);
var
  ctrl: TWinControl;
  item: TVA508AccessibilityItem;
begin
  ctrl := TWinControl(Message.WParam);
  // Refresh the accessibility manager entry -
  // fixes bug where first focusable check boxes weren't working correctly
  if ctrl is TCPRSDialogParentCheckBox then
  begin
    item := amgrMain.AccessData.FindItem(ctrl, FALSE);
    if assigned(item) then
      item.free;
    amgrMain.AccessData.EnsureItemExists(ctrl);
  end;
end;

// NSR20100706 AA 2015/09/29 --------------------------------------------- begin
procedure TfrmTemplateDialog.FieldValueChanged(Sender: TObject);
begin
  UpdateControlHighlighting(ActiveControl);
end;

procedure TfrmTemplateDialog.S1Click(Sender: TObject);
begin
  inherited;
  S1.Checked := not S1.Checked;
  ReqHighlight := S1.Checked;
  SaveHighlightOptions;  // AA fix. Correlation between session and server
  RFH.HighlightControls(ReqHighlight);
end;

procedure TfrmTemplateDialog.S4Click(Sender: TObject);
begin
  inherited;
  UpdateRequiredFieldsPreferences(false); // don't reload values from server
  frRequiredFields.setAlign(ReqHighlightAlign);
  setReqHighlightColor;
  S1.Checked := ReqHighlight;  // AA fix. Correlation between session and server
end;

const
  ss = ' -----------------------------------------------------------------------';

procedure TfrmTemplateDialog.CMFocusChanged(var Message: TCMFocusChanged);
begin
{$IFDEF DEBUG}
  Caption :=
    TWinControl(Message.Sender).Name + ' ' +
    TWinControl(Message.Sender).ClassName;

{$ENDIF}
  UpdateControlHighlighting(TWinControl(Message.Sender));
  if ActiveControl is TORComboEdit then
    frRequiredFields.FocusedControl := ActiveControl.Parent // to address TORComboEdit
  else
    frRequiredFields.FocusedControl := ActiveControl // to address TORComboEdit
end;

procedure TfrmTemplateDialog.UpdateControlHighlighting(ctrl:TWinControl);
begin

  if not RFH.IsTemplateControl(ctrl,sbMain) then
    Exit;

//  HighlightControlInstance(ctrl,ReqHighlight); // it doesn't update an empty TORComboEdit  :(

  frRequiredFields.CurrentControl := ctrl;
  frRequiredFields.RequiredTotal := RFH.getNumberOfMissingFields(sbMain);

  RFH.HighlightControls(ReqHighlight);

  setOKStatus;

{$IFDEF DEBUG}
  setControlDebugInfo(ctrl);
{$ENDIF}
end;

procedure addSL(aTitle:String;aSL,aTarget:TStrings);
begin
  if not Assigned(aTarget) then
    exit;
  if not Assigned(aSL) then
    begin
      aTarget.Add(aTitle+ ': NOT ASSIGNED ');
      aTarget.Add('');
    end
  else
    begin
      aTarget.Add(copy(aTitle+ ' ' + ss,1,74)+ ' begin');
      if aSL.Text <> '' then
        begin
          aTarget.Text := aTarget.Text +aSL.Text;
          if trim(aTarget[aTarget.Count-1])='' then
            aTarget.Delete(aTarget.Count-1);
        end;
      aTarget.Add(copy(aTitle+ ' ' + ss,1,76)+ ' end');
      aTarget.Add('');
    end;
end;

procedure TfrmTemplateDialog.setReqHighlightColor;
begin
  try
    RFH.HighlightControls(ReqHighlight);
  except
    on E: Exception do
      ShowMessage(E.Message);
  end;
end;

procedure TfrmTemplateDialog.setOKStatus;
begin
  btnOKGrid.Enabled :=
    RFH.getNumberOfMissingFields(sbMain)<1;
end;

procedure TfrmTemplateDialog.setReqHighlightAlign(aPos:Integer);
begin
  try
    frRequiredFields.setAlign(aPos);
  except
    on E: Exception do
      ShowMessage(E.Message);
  end;
end;

procedure TfrmTemplateDialog.AdjustFormToFontSize(aSize:Integer);
var
  W: Integer;

  procedure adjustWidthToFont(aSize:Integer; var X:Integer);
  begin
    case aSize of
    8,9:
        X := 800;
    10,11:
        X := 800;
    12,13:
        X := 840;
    14,15,16,17:
        X := 1020;
    18:
        X := 1200;
    else
        X := 1280;
    end;
  end;

begin
  adjustWidthToFont(aSize,w);
  Width := w;
  Constraints.MinWidth := w;

  pnlBottomGrid.Height := frRequiredFields.szButtonY +
    pnlBtnTop.Height + pnlBtnBottom.Height;

  grdpnlBottom.ColumnCollection[0].Value := frRequiredFields.szButtonX;
  grdpnlBottom.ColumnCollection[1].Value := frRequiredFields.szButtonX;
  grdpnlBottom.ColumnCollection[3].Value := frRequiredFields.szButtonX;
  grdpnlBottom.ColumnCollection[5].Value := frRequiredFields.szButtonX;
  grdpnlBottom.ColumnCollection[6].Value := frRequiredFields.szButtonX;

  pnlBottomRight.Width := frRequiredFields.pnlRMargin.Width;
  pnlBottomLeft.Width := frRequiredFields.pnlLMargin.Width;

end;

procedure TfrmTemplateDialog.T1Click(Sender: TObject);
begin
  inherited;
  T1.Checked := not T1.Checked;
{$IFDEF DEBUG}
  SetDebugInfo;
{$ENDIF}
end;

{$IFDEF DEBUG}
procedure TfrmTemplateDialog.SetControlDebugInfo(aControl:TWinControl); //NSR20100706 AA 2015/09/29
var
  sValue: String;
  fld: TTemplateField;
begin
  fld := RFH.getTemplateFieldByControl(aControl);
  reText.Clear;
  reText.Lines.Add(Format('Field: %d',[Integer(fld)]));
  if assigned(fld) then
    begin
      reText.Lines.Add('   ID:    '+fld.ID);
      reText.Lines.Add('   Name:  '+fld.FldName);
      reText.Lines.Add('   Value: '+sValue);
      if Fld.Required then
        reText.Lines.Add('   Required Field')
      else
        reText.Lines.Add('   Optional Field');
    end
  else
    reText.Lines.Add('   NO DATA ASSIGNED');

  reText.Lines.Add(Format('Control: %d',[Integer(aControl)]));
  reText.Lines.Add('   Class:  '+aControl.ClassName);
  reText.Lines.Add('   Tag:    '+IntToStr(aControl.Tag));
  reText.Lines.Add('   Info:   '+RFH.getControlInfo(aControl));
end;

procedure TfrmTemplateDialog.setDebugInfo;
var
  SL: TStringList;
  lst:TList;
  i: Integer;

  procedure setDebugLayout;
  var
    fDebug: Boolean;
  begin
    fDebug := T1.Checked;
    pnlDebug.Visible := fDebug;
    if not fDebug then
      begin
        splFields.Align := alTop;
        splFields.Visible := False;
      end
    else
      begin
        splFields.Visible := True;
        splFields.Align := alBottom;
      end;
  end;

  procedure AddControlsInfo(aSL: TStringList;aCtrl: TWinControl;anOffset:String ='  ');
  var
    i: integer;
  begin
    if not assigned(aCtrl) then
      exit;
    SL.Add(anOffset+ Format('%10.10d %10.10d %20.20s %s',[Integer(aCtrl),aCtrl.Tag,aCtrl.Name,aCtrl.ClassName]));

    for I := 0 to aCtrl.ControlCount -1 do
      if aCtrl.Controls[i] is TWinControl then
        AddControlsInfo(aSL,TWinControl(aCtrl.Controls[i]),anOffset);
  end;

  function toSL:TSTringList;
  begin
    Result := TStringList.Create;
    Result.Add(Format('Class: %s Item: %d',[ClassName,Integer(self)]));
    Result.Add('Name: '+Name);
    Result.Add('Index: '+Index);
    Result.Add('Count: '+IntToStr(Count));
    Result.Add('Font Size: '+IntToStr(Font.Size));
    if fFirstBuild then
      Result.Add('FirstBuild: '+'True')
    else
      Result.Add('FirstBuild: '+'False');

    AddSL('BuildIdx:',BuildIdx,Result);
    AddSL('NoTextID:',NoTextID,Result);
    AddSL('Entries:',Entries,Result);
  end;

begin
  reText.Clear;
  SL := toSL;
  reText.Text := SL.Text;

  reText.Text := reText.Text + CRLF +
    'Required Fields Navigation:'+ CRLF+
      frRequiredFields.toStr + CRLF;

  AddSL('ControlList:',RFH.getRequiredControls,reText.Lines);

  SL.Clear;
  AddControlsInfo(SL,sbMain);
  AddSL('sbMain.Controls:',SL,reText.Lines);

  SL.Clear;
  lst := getuTmplFlds;
  for i := 0 to lst.Count -1 do
    SL.Add(Format('%d %20.20s',[i,TTemplateField(lst[i]).ID]));
  AddSL('uTmplFlds:',SL,reText.Lines);

  SL.Free;

  SetDebugLayout;
end;
{$ENDIF}
// NSR20100706 AA 2015/09/29 ----------------------------------------------- end

end.
