unit fRptBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORFn, ComCtrls, ExtCtrls, fBase508Form,
  VA508AccessibilityManager, uReports, Vcl.Menus, U_CPTEditMonitor,
  fBase508Dialog;

type
  TfrmReportBox = class(TfrmBase508Dialog)
    lblFontTest: TLabel;
    memReport: TRichEdit;
    dlgPrintReport: TPrintDialog;
    pmnu: TPopupMenu;
    mnuCopy: TMenuItem;
    CPRptBox: TCopyEditMonitor;
    cmdPrint: TButton;
    procedure cmdPrintClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure mnuCopyClick(Sender: TObject);
    procedure CPRptBoxCopyToMonitor(Sender: TObject; var AllowMonitor: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    fPrintHeader: Boolean;
    property PrintHeader: Boolean read fPrintHeader write fPrintHeader;
  end;

procedure ReportBox(ReportText: TStrings; ReportTitle: string;
  AllowPrint: Boolean; includeHeader: Boolean = true);

implementation

uses
  uCore, rCore, uGN_Utils, Printers, rMisc;

{$R *.DFM}

const
  TX_ERR_CAP = 'Print Error';
  TX_FONT_SIZE = 10;
  TX_FONT_NAME = 'Courier New';
  TX_FONT_COLOR = clBlack;

procedure PrintWindowsReport(ARichEdit: TRichEdit; APageBreak, Atitle: string;
  var ErrMsg: string; includeHeader: Boolean = false);
var
  i, j, x, y, LineHeight: integer;
  aGoHead: string;
  aHeader: TStringList;

begin
  aHeader := TStringList.Create;
  aGoHead := '';
  if piece(Atitle, ';', 2) = '1' then
  begin
    Atitle := piece(Atitle, ';', 1);
    aGoHead := '1';
  end;
  // CreatePatientHeader(aHeader, Atitle);
  with ARichEdit do
  begin
    { v20.4 - SFC-0602-62899 - RV }
    while (Lines.Count > 0) and ((Lines[Lines.Count - 1] = '') or
      (Lines[Lines.Count - 1] = APageBreak)) do
      Lines.Delete(Lines.Count - 1);
    // remove trailing blank lines and form feeds
    while (Lines.Count > 0) and ((Lines[0] = '') or (Lines[0] = APageBreak)) do
      Lines.Delete(0); // remove leading blank lines and form feeds

    if Lines.Count > 1 then
    begin
      Printer.Canvas.Font.Size := TX_FONT_SIZE;
      Printer.Canvas.Font.Name := TX_FONT_NAME;
      Printer.Canvas.Font.Color := TX_FONT_COLOR;
      Printer.Title := Atitle;
      x := Trunc(Printer.Canvas.TextWidth(StringOfChar('=',
        TX_FONT_SIZE)) * 0.75);
      LineHeight := Printer.Canvas.TextHeight(TX_FONT_NAME);
      y := LineHeight * 5; // 5 lines = .83" top margin   v15.9 (RV)
      Printer.BeginDoc;

      // Do we need to add the header?
      IF includeHeader then
      begin
        for j := 0 to aHeader.Count - 1 do
        begin
          Printer.Canvas.TextOut(x, y, aHeader[j]);
          y := y + LineHeight;
        end;
      end;

      for i := 0 to Lines.Count - 1 do
      begin
        if Lines[i] = APageBreak then
        begin
          Printer.NewPage;
          y := LineHeight * 5; // 5 lines = .83" top margin    v15.9 (RV)
          if (includeHeader) then
          begin
            for j := 0 to aHeader.Count - 1 do
            begin
              Printer.Canvas.TextOut(x, y, aHeader[j]);
              y := y + LineHeight;
            end;
          end;
        end
        else
        begin
          Printer.Canvas.TextOut(x, y, Lines[i]);
          y := y + LineHeight;
        end;
      end;

      Printer.EndDoc;
    end
    else if ARichEdit.Lines.Count = 1 then
      if piece(ARichEdit.Lines[0], U, 1) <> '0' then
        ErrMsg := piece(ARichEdit.Lines[0], U, 2);
  end;
  aHeader.Free;
end;

function CreateReportBox(ReportText: TStrings; ReportTitle: string;
  AllowPrint: Boolean; includeHeader: Boolean = true): TfrmReportBox;
var
  i, AWidth, MinWidth, MaxWidth, AHeight: integer;
  Rect: TRect;

begin
  Result := TfrmReportBox.Create(Application);
  try
    with Result do
    begin
      MinWidth := 0;
      MaxWidth := 350;
      for i := 0 to ReportText.Count - 1 do
      begin
        AWidth := lblFontTest.Canvas.TextWidth(ReportText[i]);
        if AWidth > MaxWidth then
          MaxWidth := AWidth;
      end;
      cmdPrint.Visible := AllowPrint;

      PrintHeader := includeHeader;
      MaxWidth := MaxWidth + GetSystemMetrics(SM_CXVSCROLL);

      AHeight := (ReportText.Count * (lblFontTest.Height + 2)) +
        pnlBaseButtons.Height; // pnlbutton.Height;
      AHeight := HigherOf(AHeight, 250);
      if AHeight > (Screen.Height - 80) then
        AHeight := Screen.Height - 80;
      if MaxWidth > Screen.Width then
        MaxWidth := Screen.Width;
      ClientWidth := MaxWidth;
      ClientHeight := AHeight;
      ResizeAnchoredFormToFont(Result);
      Width := Width + (GetSystemMetrics(SM_CXVSCROLL) * 2);
      Constraints.MinWidth := MinWidth + (MinWidth div 2) +
        (GetSystemMetrics(SM_CXVSCROLL) * 2);

      case mainFontSize of
        8:
          Constraints.MinHeight := 285;
        10:
          Constraints.MinHeight := 325;
        12:
          Constraints.MinHeight := 390;
        14:
          Constraints.MinHeight := 460;
      else
        Constraints.MinHeight := 575;
      end;

      QuickCopy(ReportText, memReport);
      for i := 1 to Length(ReportTitle) do
        if ReportTitle[i] = #9 then
          ReportTitle[i] := ' ';
      Caption := ReportTitle;
      memReport.SelStart := 0;
      Rect := BoundsRect;
      ForceInsideWorkArea(Rect);
      BoundsRect := Rect;
    end;
  except
    KillObj(@Result);
    raise;
  end;
end;

procedure ReportBox(ReportText: TStrings; ReportTitle: string;
  AllowPrint: Boolean; includeHeader: Boolean = true);
var
  frmReportBox: TfrmReportBox;

begin
  Screen.Cursor := crHourglass;
  // wat cq 18425 added hourglass and disabled mnuFileOpen
  frmReportBox := CreateReportBox(ReportText, ReportTitle, AllowPrint,
    includeHeader);
  try
    frmReportBox.ShowModal;
  finally
    frmReportBox.Release;
    Screen.Cursor := crDefault;
  end;
end;

/// /////////////////////////////////////////////////////////////////////////////

procedure TfrmReportBox.mnuCopyClick(Sender: TObject);
begin
  inherited;
  memReport.CopyToClipboard;
end;

procedure TfrmReportBox.cmdPrintClick(Sender: TObject);
var
  ErrMsg: string;
const
  PAGE_BREAK = '**PAGE BREAK**';
begin
  if dlgPrintReport.Execute then
  begin
    memReport.Lines.Add('End of report');
    PrintWindowsReport(memReport, PAGE_BREAK, Self.Caption, ErrMsg, true);
    memReport.Lines.Delete(memReport.Lines.Count - 1);
  end;
  memReport.Invalidate;
end;

procedure TfrmReportBox.CPRptBoxCopyToMonitor(Sender: TObject;
  var AllowMonitor: Boolean);
begin
  inherited;
  CPRptBox.RelatedPackage := Self.Caption + ';' + Patient.Name;
  CPRptBox.ItemIEN := -1;
  AllowMonitor := true;
end;

procedure TfrmReportBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if (not(fsModal in FormState)) then
    Action := caFree;
end;

procedure TfrmReportBox.FormCreate(Sender: TObject);
begin
  inherited;
  cmdOK.Caption := '&Close';
  cmdCancel.Visible := false;
end;

procedure TfrmReportBox.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_ESCAPE then
    ModalResult := mrCancel;
end;

procedure TfrmReportBox.FormResize(Sender: TObject);
begin
  inherited;
  Self.memReport.Refresh;
end;

end.
