unit fDupPts;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ORCtrls, ExtCtrls, OrFn, fBase508Form,
  VA508AccessibilityManager, Vcl.ComCtrls;

type
  TfrmDupPts = class(TfrmBase508Form)
    pnlDupPts: TPanel;
    lblSelDupPts: TLabel;
    Panel1: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    lboSelPt: TCaptionListView;
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lboSelPtDblClick(Sender: TObject);
  private
    FDFN:    string;
    FOKPressed: boolean;
  public
    { Public declarations }
  end;

function SelectDupPt(var DFN: string; PtList: TStringList): Boolean;

implementation

{$R *.dfm}

uses rCore, uCore;

function SelectDupPt(var DFN: string; PtList: TStringList): Boolean;

var
  frmDupPts: TfrmDupPts;
begin
  frmDupPts := TfrmDupPts.Create(Application);
  try
    FastAssign(PtList, frmDupPts.lboSelPt.ItemsStrings);
    frmDupPts.ShowModal;
    Result := frmDupPts.FOKPressed;
    if frmDupPts.FOKPressed then
      DFN := frmDupPts.FDFN
    else
      DFN := '';
  finally
    frmDupPts.Release;
  end;
end;

procedure TfrmDupPts.FormCreate(Sender: TObject);
begin
  FDFN := '';
  FOKPressed := False;
end;

procedure TfrmDupPts.btnOKClick(Sender: TObject);
begin
  if not(Length(lboSelPt.ItemID) > 0) then
  begin
    infoBox('A patient has not been selected.', 'No Patient Selected', MB_OK);
    exit;
  end;
  FOKPressed := True;
  FDFN := lboSelPt.ItemID;
  close;
end;

procedure TfrmDupPts.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = VK_ESCAPE) then
    btnCancelClick(Self);
end;

procedure TfrmDupPts.lboSelPtDblClick(Sender: TObject);
begin
  btnOKClick(Self);
end;

procedure TfrmDupPts.btnCancelClick(Sender: TObject);
begin
  Close;
end;

end.
