unit uLog;

interface

procedure LogLine(aLine: String);
procedure LogEnterExit(aName: String; anExit: Boolean = FALSE);

implementation

uses
  WinApi.PSApi, WinApi.Windows, System.SysUtils, Forms, Classes;

const
  SpellLogMarginDelta = '  ';
  fmtLog = '%s';
var
  SpellLogMargin: String;
  SpellLogLine: String;
  SpellLogIgnore: Boolean = FALSE;
  SpellList: TStringList;

procedure SpellLogMarginUp;
begin
  SpellLogMargin := SpellLogMargin + SpellLogMarginDelta;
end;

procedure SpellLogMarginDown;
begin
  SpellLogMargin := copy(SpellLogMargin, 1, Length(SpellLogMargin) -
    Length(SpellLogMarginDelta));
end;

function CurrentProcessMemory: Cardinal;
var
  MemCounters: TProcessMemoryCounters;
begin
  Result := 0;
  MemCounters.cb := SizeOf(MemCounters);
  if GetProcessMemoryInfo(GetCurrentProcess, @MemCounters, SizeOf(MemCounters))
  then
    Result := MemCounters.WorkingSetSize
  else
    RaiseLastOSError;
end;
(*
  function zzMemoryAllocated:Cardinal;
  var
  st:TMemoryManagerState;
  sb:TSmallBlockTypeState;
  begin
  GetMemoryManagerState(st);
  result:=st.TotalAllocatedMediumBlockSize+st.TotalAllocatedLargeBlockSize;
  for sb in st.SmallBlockTypeStates do begin
  result:=result + sb.UseableBlockSize*sb.AllocatedBlockCount;
  end;
  end;

  procedure LogLine(aLine:String);
  begin
  if SpellLogIgnore  then
  exit;

  SpellLogLine := FormatDateTime('hh:mm:ss.zzz  ',Now) +
  //   Format(' %12.12d ',[CurrentProcessMemory]) +
  //   Format(' %12.12d ',[zzMemoryAllocated]) +
  SpellLogMargin +
  Format(fmtLog,[aLine]) + #13#10 + SpellLogLine;
  end;
*)


procedure LogLine(aLine: String);
var
  s: String;
begin
  if SpellLogIgnore then
    exit;
  if assigned(SpellList) then
  begin
    SpellList.Text := aLine;
    for s in SpellList do
      SpellLogLine := FormatDateTime('hh:mm:ss.zzz  ', Now) +
        Format(fmtLog, [SpellLogMargin + s]) + #13#10 + SpellLogLine;
  end
  else
    SpellLogLine := FormatDateTime('hh:mm:ss.zzz  ', Now) +
      Format(fmtLog, [SpellLogMargin + aLine]) + #13#10 + SpellLogLine;
end;

procedure LogLinePlus(aLine: String; anExit: Boolean);
begin
  if SpellLogIgnore then
    exit;

  if anExit then
    SpellLogLine := FormatDateTime('hh:mm:ss.zzz  ', Now) +
      Format(fmtLog, [SpellLogMargin + aLine]) + #13#10 + SpellLogLine
  else
    SpellLogLine := FormatDateTime('hh:mm:ss.zzz  ', Now) +
      Format(fmtLog, [SpellLogMargin + aLine]) + #13#10 + SpellLogLine;
end;

procedure LogEnterExit(aName: String; anExit: Boolean = FALSE);
begin
  if anExit then
  begin
    SpellLogMarginDown;
    LogLinePlus(aName, anExit);
  end
  else
  begin
    LogLinePlus(aName, anExit);
    SpellLogMarginUp;
  end;
  Application.ProcessMessages;
end;

initialization

SpellLogIgnore := True; // disabling log by default
SpellList := TStringList.Create;

finalization

SpellList.Free;

end.
