unit uGN_Utils;

interface

uses
  ORFn, rGN_Core, Windows, Controls, ExtCtrls, Buttons, ComCtrls, uCore, uTIU,
  Forms, Classes, System.SysUtils;

type
  TViewMode = (vmParentedForm, vmDialog, vmConfirmationDlg);

procedure MenuItemMoveRight(aMenu: hMenu; aCommand: Cardinal);

procedure setFormParented(aForm: TForm; aParent: TWinControl;
  anAlign: TAlign = alClient);

function HintString(aHint: String; aLimit: Integer = 80): String;
function LongDescriptionByCode(aCode, aDefault: String; aDate: TFMDateTime;
  AI10Active: Boolean): String;
function RemoveDuplicate(aTarget, aDelimeter: String): String;
function IsCorrectVersion(bDebug: Boolean): Boolean;
function getLongDescriptionByCode(aCode, aDefault: String): String;

function getMainFormTextHeight: Integer;
function getMainFormTextWidth(aText: String): Integer;
procedure adjustBitBtn(aBB: TBitBtn; ImageWidth: Integer = 16);

function EncounterToStr(anEncounter: TEncounter): String;
function EditNoteRecToStr(aRecord: TEditNoteRec): String;

procedure CleanPtList(aList: TList);

procedure adjustFormSize(aForm: TForm; X, Y: Integer);
procedure adjustFormPosition(aForm: TForm);

function LockForUpdate(CtrlToLock: TWinControl): Integer;
procedure UnlockForUpdate(Var ReSetVar: Integer; CtrlToLock: TWinControl);

function getTitleHeight(aForm: TForm): Integer;

procedure reHighlight(aRE: TRichEdit; StartChar, EndChar: Integer;
  HighLightColor: Integer);
procedure reHighlightDrop(aRE: TRichEdit);

procedure FocusWinControl(aControl:TWinControl);
procedure setLogFontSize(aSize:Integer);

var
  _marginW: Integer;
  _marginH: Integer;

implementation

uses
  ORNet, rPCE, rMisc, VAUtils, ORSystem, Dialogs,
  fGN_RPCLog, uGN_RPCLog, uGN_Const,
  Math, WinApi.RichEdit, WinApi.Messages;

function LockForUpdate(CtrlToLock: TWinControl): Integer;
begin
  Result := CtrlToLock.Perform(EM_GETEVENTMASK, 0, 0);
  CtrlToLock.Perform(EM_SETEVENTMASK, 0, 0);
  CtrlToLock.Perform(WM_SETREDRAW, Ord(false), 0);
end;

procedure UnlockForUpdate(Var ReSetVar: Integer; CtrlToLock: TWinControl);
begin
  CtrlToLock.Perform(WM_SETREDRAW, Ord(true), 0);
  InvalidateRect(CtrlToLock.Handle, NIL, true);
  CtrlToLock.Perform(EM_SETEVENTMASK, 0, ReSetVar);
end;

procedure MenuItemMoveRight(aMenu: hMenu; aCommand: Cardinal);
var
  mii: TMenuItemInfo;
  Buffer: array [0 .. 79] of Char;

begin
  // GET Help Menu Item Info
  mii.cbSize := SizeOf(mii);
  mii.fMask := MIIM_TYPE;
  mii.dwTypeData := Buffer;
  mii.cch := SizeOf(Buffer);
  GetMenuItemInfo(aMenu, aCommand, false, mii);
  // SET Help Menu Item Info
  mii.fType := mii.fType or MFT_RIGHTJUSTIFY;
  if SetMenuItemInfo(aMenu, aCommand, false, mii) then
    if Assigned(Application.MainForm) then
    begin
      Application.MainForm.Width := Application.MainForm.Width + 1;
      Application.ProcessMessages;
      Application.MainForm.Width := Application.MainForm.Width - 1;
      Application.ProcessMessages;
    end;
end;

function HintString(aHint: String; aLimit: Integer = 80): String;
var
  i: Integer;
  s, sHint: String;
  sl: TStringList;
begin
  // ICD-10. Removing duplicate data from Hint text
  if pos(' - ', aHint) > 0 then
    sHint := copy(aHint, pos(' - ', aHint) + 3, Length(aHint))
  else
    sHint := aHint;

  sHint := StringReplace(sHint, #9, ' ', [rfReplaceAll]);

  sl := TStringList.Create;
  sl.Delimiter := ' ';
  sl.DelimitedText := sHint;
  s := '';
  for i := 0 to sl.Count - 1 do
  begin
    if Length(s + sl[i]) > aLimit then
    begin
      Result := Result + s + #13#10;
      s := sl[i] + ' ';
    end
    else
      s := s + sl[i] + ' ';
  end;
  Result := Result + s;
end;

function FMDateToWindowsDate(aDate: String): TFMDateTime;
var
  year, month, day: Word;
begin
  year := StrToIntDef(copy(aDate, 1, 3), 0) + 1700;
  month := StrToIntDef(copy(aDate, 4, 2), 0);
  day := StrToIntDef(copy(aDate, 6, 2), 0);
  Result := EncodeDate(year, month, day);
end;

// ICD-10 Remediation. CodeCR:184
function getLongDescriptionByCode(aCode, aDefault: String): String;
var
  sl: TStringList;
  s: String;
begin
  Result := aDefault;
  sl := TStringList.Create;
  tCallV(sl, 'ORWPCE GET DX TEXT', ['', aCode]);
  if sl.Count > 0 then
  begin
    s := sl[0];
    FreeAndNil(sl);
    if (pos('-', s) = 1) or (trim(s) = '') then
      Result := aDefault
    else
      Result := copy(s, 4, Length(s));
  end
  else
    Result := aDefault;
end;

function LongDescriptionByCode(aCode, aDefault: String; aDate: TFMDateTime;
  AI10Active: Boolean): String;
var
  s: String;
  bExtend, bActive: Boolean;
  dDate: TFMDateTime;
  LexResults: TStringList;
begin
  if trim(aCode) = '' then
  begin
    Result := aDefault;
    Exit;
  end;

  LexResults := TStringList.Create;

  if pos('ICD-10', aDefault) > 0 then
  begin
    dDate := StrToFloat(GImplementationDate);
    bExtend := true;
    bActive := true;
  end
  else
  begin
    dDate := FMDateToWindowsDate(GImplementationDate) - 1;
    dDate := DateTimeToFMDateTime(dDate);
    bExtend := true;
    bActive := false;
  end;

  ListLexicon(LexResults, aCode, LX_ICD, dDate, bExtend, bActive);
  s := LexResults.Text;
  if (pos('-', s) = 1) or (trim(s) = '') then
    Result := aDefault
  else
    Result := Piece(s, U, 2) + ' (' + Piece(s, U, 3) + ' ' +
      Piece(s, U, 4) + ')';

  FreeAndNil(LexResults);
end;

function RemoveDuplicate(aTarget, aDelimeter: String): String;
begin
  if pos(aDelimeter, aTarget) > 0 then
    Result := copy(aTarget, pos(aDelimeter, aTarget) + Length(aDelimeter),
      Length(aTarget))
  else
    Result := aTarget;
end;

function IsCorrectVersion(bDebug: Boolean): Boolean;
var
  sApplication,
  sMessage, ClientVer, ServerVer, ServerReq: string;

  procedure LogInfoBox(aText, aCaption: String; aBtn: Integer);
  begin
    AddLogLine(aText, aCaption);
    InfoBox(aText, aCaption, aBtn);
  end;

begin
  Result := bDebug;
{$IFDEF DEBUG}
  InfoBox('This DEBUG build ignores version validation.' + CRLF + CRLF +
    ' DO NOT USE IT IN PRODUCTION ACCOUNTS!', 'DEBUG INFO', MB_OK);
{$ENDIF}
  if not IsAuthUser then
    InfoBox('You are not authorized to use Group Notes.', 'Group Notes', MB_OK)
{$IFDEF DEBUG}
      ;
{$ELSE}
  else
{$ENDIF}
  begin
    sApplication := FileVersionValue(Application.ExeName,
      FILE_VER_FILEDESCRIPTION) + '  ( ' +
      FileVersionValue(Application.ExeName, FILE_VER_COMMENTS) +
      ', CRC: ' + IntToHex(CRCForFile(Application.ExeName), 8) +
      ' )';
    ClientVer := ClientVersion(Application.ExeName);
    ServerReq := Piece(FileVersionValue(Application.ExeName,
      FILE_VER_INTERNALNAME), ' ', 1);
    ServerVer := ServerVersion('OR GN SET LOCATIONS', ClientVer);
    sMessage := 'Client:          ' + ClientVer + CRLF + 'Server:          ' +
      ServerVer + CRLF + 'Required Server: ' + ServerReq;
    AddLogLine(sMessage, 'Version Info');

    if (ServerVer = '0.0.0.0') then
      LogInfoBox
        ('Unable to determine current version of server, please make sure you installed latest patch OR*3*222.',
        'Group Notes', MB_OK)
    else
    begin
      ClientVer := ClientVersion(Application.ExeName);
      ServerReq := Piece(FileVersionValue(Application.ExeName,
        FILE_VER_INTERNALNAME), ' ', 1);

      sMessage := 'Client:          ' + ClientVer + CRLF + CRLF + 'Server: ' +
        Char(VK_Tab) + ServerVer + CRLF + 'Required: ' + Char(VK_Tab) +
        ServerReq;

      if (CompareVersion(ServerVer, ClientVer) > 0) then
      // Server newer than Client
        LogInfoBox(TX_CLIENT_MISMATCH
{$IFDEF DEBUG}
          + CRLF + CRLF + sMessage
{$ENDIF}
          , TC_CLIERR, MB_OK)

      else
      begin
        if (CompareVersion(ServerVer, ServerReq) <> 0) then
        begin
          {
            if (CompareVersion(ServerVer, ServerReq) > 0) then // Server newer than Required
            begin
            if (CompareVersion(ServerVer, ClientVer) > 0) then  //  Server newer than Client
            begin
            sMessage :=TX_VER1 + ClientVer + TX_VER2 + CRLF + ServerReq + TX_VER_REQ + TX_VER3 + ServerVer + '.' + TX_VER_OLD2;
            LogInfoBox(sMessage, TC_VER, MB_OK);
            end;
            end
            else // if (CompareVersion(ServerVer, ServerReq) < 0) then // Server older then Required

            begin
            sMessage := TX_VER1 + ClientVer + TX_VER2 + CRLF + ServerReq + TX_VER_REQ + TX_VER3 + ServerVer + '.' + TX_VER_NEW;
            LogInfoBox(sMessage, TC_VER, MB_OK);
            end;
          }
          sMessage := // TX_VER1 + ClientVer + TX_VER2 + CRLF + CRLF + Char(VK_Tab)
            'This is ' +  char(VK_TAB) + sApplication + CRLF + CRLF + char(VK_TAB) +
            ServerReq + Char(VK_Tab) + TX_VER_REQ + CRLF + Char(VK_Tab) +

            ServerVer + Char(VK_Tab) + TX_VER3 + CRLF + TX_VER_NEW;
          LogInfoBox(sMessage, TC_VER, MB_OK);
        end
        else
          Result := true;
      end;
    end;
  end;
end;

procedure setFormParented(aForm: TForm; aParent: TWinControl;
  anAlign: TAlign = alClient);
begin
  if aForm.Parent <> aParent then
  begin
    aForm.BorderStyle := bsNone;
    aForm.Parent := aParent;
    aForm.Align := anAlign;
    // aForm.Menu := nil;
    if not aForm.Visible then
      aForm.Show;
  end;
end;

function getMainFormTextHeight: Integer;
begin
  Result := 12;
  if Assigned(Application.MainForm) then
    Result := Application.MainForm.Canvas.TextHeight('qwerty1234567890');
end;

function getMainFormTextWidth(aText: String): Integer;
begin
  Result := 0;
  if Assigned(Application.MainForm) then
    Result := Application.MainForm.Canvas.TextWidth(aText);
end;

procedure adjustBitBtn(aBB: TBitBtn; ImageWidth: Integer = 16);
var
  i: Integer;
begin
  if not Assigned(Application.MainForm) then
    Exit;
  aBB.Font.Size := Application.MainForm.Font.Size;
  i := getMainFormTextWidth(aBB.Caption + 'W') + 2 * _marginW + ImageWidth;
  aBB.Width := i;
end;

const
  fmtName = '%-22.22s';
  fmtNameValue = '%-22.22s: %s';
  fmtNameValueD = '%-22.22s: %d';
  fmtNameValueCode = '%-22.22s: %s (%d)';

function NamedBool(aName: String; aValue: Boolean): String;
begin
  if aValue then
    Result := format(fmtNameValue, [aName, 'TRUE'])
  else
    Result := format(fmtNameValue, [aName, 'False']);
  Result := Result + CRLF;
end;

function EncounterToStr(anEncounter: TEncounter): String;
begin
  Result := 'Encounter: Not assigned';
  if not Assigned(anEncounter) then
    Exit;
  with anEncounter do
  begin
    Result := '';
    Result := Result + NamedBool('Need Visit', NeedVisit);
    Result := Result + format(fmtNameValue,
      ['Date/Time: ', DateTimeToStr(DateTime)]) + CRLF;
    Result := Result + NamedBool('Inpatient', Inpatient);
    Result := Result + format(fmtNameValueCode, ['Location (ID)', LocationName,
      Location]) + CRLF;
    Result := Result + format(fmtNameValue,
      ['Location Text', LocationText]) + CRLF;
    Result := Result + format(fmtNameValueCode, ['Provider (ID)', ProviderName,
      Provider]) + CRLF;
    Result := Result + NamedBool('Standalone', Standalone);
    Result := Result + format(fmtNameValue, ['Visit Category: ', '']) +
      VisitCategory + CRLF;
    Result := Result + format(fmtNameValue,
      ['Visit String: ', VisitStr]) + CRLF;
  end;
end;

function EditNoteRecToStr(aRecord: TEditNoteRec): String;

  function ListToString(aTitle: String; aList: TStrings): String;
  var
    s: String;
  begin
    if not Assigned(aList) then
    begin
      Result := format(fmtNameValue, [aTitle, 'not assigned']) + CRLF;
    end
    else
    begin
      Result := '';
      if aList.Count < 1 then
        Result := format(fmtNameValue, [aTitle, '']) + CRLF
      else
        for s in aList do
        begin
          if Result = '' then
            Result := format(fmtNameValue, [aTitle, s]) + CRLF
          else
            Result := Result + format(fmtNameValue, ['', s]) + CRLF;
        end;
    end;
  end;

begin
  with aRecord do
  begin
    // Result := 'Note Record-------------------------------------------begin' + CRLF;
    Result := '';
    Result := Result + format(fmtNameValueD, ['NoteIEN', NoteIEN]) + CRLF;
    Result := Result + format(fmtNameValueD, ['DocType', DocType]) + CRLF;
    Result := Result + format(fmtNameValueCode, ['Title (IEN)', TitleName,
      Title]) + CRLF;
    // 'DateTime: ' + TFMDateTime;
    Result := Result + format(fmtNameValueCode, ['Author  (IEN)', AuthorName,
      Author]) + CRLF;
    Result := Result + format(fmtNameValueCode, ['Cosigner (IEN)', CosignerName,
      Cosigner]) + CRLF;
    Result := Result + format(fmtNameValue, ['Subject', Subject]) + CRLF;
    Result := Result + format(fmtNameValueCode, ['Location (IEN)', LocationName,
      Location]) + CRLF;
    // VisitDate: TFMDateTime;
    Result := Result + format(fmtNameValueCode, ['Package Ptr/Ref (IEN)',
      PkgPtr + '/' + PkgRef, PkgIEN]) + CRLF;
    Result := Result + format(fmtNameValueCode,
      ['LastCosigner (IEN)', LastCosignerName, LastCosigner]) + CRLF;

    Result := Result + NamedBool('Need CPT', NeedCPT) + CRLF;
    {
      Addend: Integer;
      IDParent: integer;
      ClinProcSummCode: integer;
      ClinProcDateTime: TFMDateTime;
    }
    Result := Result + ListToString('Lines', Lines);
    Result := Result + ListToString('Common Lines', GenLines);
    Result := Result + ListToString('Pt. Lines', PtLines);

    if ErrTxt <> '' then
      Result := Result + 'Error text:' + ErrTxt + CRLF;

    Result := Result + CRLF;
    // Result := Result + 'Note Record---------------------------------------------end' + CRLF;
      {
      PRF_IEN: integer;
      ActionIEN: string;
    }
  end;
end;

procedure CleanPtList(aList: TList);
begin
  if not Assigned(aList) then
    Exit;

  while aList.Count > 0 do
  begin
    if aList.Items[0] <> nil then
      try
        TPatient(aList.Items[0]).Free;
        aList.Delete(0);
      except
        raise;
      end;
  end;
end;

procedure adjustFormSize(aForm: TForm; X, Y: Integer);
var
  R: TRect;
begin
  R := Screen.WorkAreaRect;
  if X > (R.Right - R.Left) then
    X := (R.Right - R.Left);

  if Y > (R.Bottom - R.Top) then
    Y := (R.Bottom - R.Top);

  aForm.Width := round(X);
  aForm.height := round(Y);
end;

procedure adjustFormPosition(aForm: TForm);
var
  R: TRect;
begin
  R := Screen.WorkAreaRect;
  if aForm.Left + aForm.Width > R.Right then
    aForm.Left := max(R.Left, (R.Right - aForm.Width));

  if aForm.Top + aForm.height > R.Bottom then
    aForm.Top := max(R.Top, R.Bottom - aForm.height);
end;

function getTitleHeight(aForm: TForm): Integer;
var
  P: TPoint;
  R: TRect;
begin
  P.X := 0;
  P.Y := 0;
  P := aForm.ClientToScreen(P);
  getWindowRect(aForm.Handle, R);
  Result := P.Y - R.Location.Y;
end;

procedure reHighlight(aRE: TRichEdit; StartChar, EndChar: Integer;
  HighLightColor: Integer);
var
  format: CHARFORMAT2;
begin
  aRE.SelStart := StartChar;
  aRE.SelLength := EndChar;
  // Set the background color
  FillChar(format, SizeOf(format), 0);
  format.cbSize := SizeOf(format);
  format.dwMask := CFM_BACKCOLOR;
  format.crBackColor := HighLightColor;
  aRE.Perform(EM_SETCHARFORMAT, SCF_SELECTION, Longint(@format));
end;

procedure reHighlightDrop(aRE: TRichEdit);
var
  format: CHARFORMAT2;
begin
  // Set the background color
  FillChar(format, SizeOf(format), 0);
  format.cbSize := SizeOf(format);
  format.dwMask := CFM_BACKCOLOR;
  format.dwEffects := CFE_AUTOBACKCOLOR;
  aRE.Perform(EM_SETCHARFORMAT, SCF_SELECTION, Longint(@format));
end;

procedure FocusWinControl(aControl:TWinControl);
begin
  if Assigned(aControl) and aControl.CanFocus then
    try
      aControl.SetFocus;
    except
      on E: Exception do
        ShowMessage('DEBUG: '+aControl.Name+CRLF+E.Message);
    end;
end;

procedure setLogFontSize(aSize:Integer);
begin
  if assigned(frmRPCLog) then
    frmRPCLog.setFontSize(aSize);
end;

initialization

_marginW := 6;
_marginH := 3;

end.

