unit uGN_RPCLog;

interface
uses
  fGN_RPCLog, Dialogs,
  Forms, Classes, System.SysUtils;

procedure AddLogLine(aLine, aTitle: string; bLoud: Boolean = true);
procedure AddFlag(aTitle: string);
procedure ShowBroker;
procedure RPCLogNext;
procedure RPCLogPrev;
procedure RPCLogSaveAll;

implementation

procedure AddLogLine(aLine, aTitle: string; bLoud: Boolean = true);
var
  sl: TStringList;
begin
  if not bLoud then
    Exit;
  sl := TStringList.Create;
  sl.Text := aLine;

  if not Assigned(frmRPCLog) then
    frmRPCLog := TfrmRPCLog.Create(Application);

  frmRPCLog.addLogItem(aTitle, aTitle, sl);
end;

procedure AddFlag(aTitle: string);
var
  s: String;
begin
  s := RPCLogFlag + ' ' + aTitle;
  AddLogLine(aTitle, s);
end;

procedure ShowBroker;
begin
  if not Assigned(frmRPCLog) then
  begin
    try
      frmRPCLog := TfrmRPCLog.Create(Application);
    except
      on E: Exception do
      begin
        ShowMessage('RPC Log: ' + #10#13#10#13 + E.Message);
        if Assigned(frmRPCLog) then
          frmRPCLog.Free;
        frmRPCLog := nil;
      end;
    end;
  end;
  if Assigned(frmRPCLog) then
  begin
//    ResizeAnchoredFormToFont(frmRPCLog);
    frmRPCLog.Show;
    frmRPCLog.BringToFront;
  end;
end;

procedure RPCLogNext;
begin
  if Assigned(frmRPCLog) then
    frmRPCLog.doNext;
end;

procedure RPCLogPrev;
begin
  if Assigned(frmRPCLog) then
    frmRPCLog.doPrev;
end;

procedure RPCLogSaveAll;
begin
  if assigned(frmRPCLog) then
  if frmRPCLog.acSaveOnExit.Checked then
    frmRPCLog.SaveAll;
end;

end.
