/// /////////////////////////////////////////////////////////////////////////////
//
// Tracking changes to the code. Exclude this unit from the "Release" build
//
/// /////////////////////////////////////////////////////////////////////////////

unit uGN_ChangeLog;

interface

uses
  Classes;

var
  ChangeLog: TStringList;

implementation

procedure AppLogAdd(aLine: String; aTop: Boolean = false);
begin
  if aTop then
    ChangeLog.Text := aLine + ChangeLog.Text
  else
    ChangeLog.Text := ChangeLog.Text + aLine;
end;

initialization
ChangeLog := TStringList.Create;
with ChangeLog do
begin
  Add('OR 3.0*455 Build 5');
  Add('  Build 5 was updated to fix "Can''t focus..." error occurs after closing "New Encounter" dialog');
  Add('  SpellChecking funtionality restored (missing in Build 4)');
  Add('  Project file updated to address I16875276FY18 -- Application abnormally ends with External Exception C0000006.');
  Add('  RPCLog window was modified:');
  Add('    - RPCLog K/B shortcuts change: ');
  Add('      Crtl+F1 - opens main application window');
  Add('      Crtl+F3 - adds flag to the log');
  Add('  Main window shortcut changed:');
  Add('    -  Crtl+F2 - opens RPC Log window');
  Add('    -  Crtl+F4 - selects next record in the RPC Log');
  Add('    -  Crtl+F5 - selects prev record of the RPC Log');
  Add('  Minor changes made to "Debug" window');
  Add('  The next files were modified');
  Add('    GroupNotes.proj - version changed to build 5');
  Add('    GroupNotes.dpr - unit uGN_RPCLog added to the project');
  Add('    fAddlSigners.pas - comments removed');
  Add('    fBase508Form.pas - processing of the shortcuts modified');
  Add('    fDupPts.pas, *.dfm - form layout updated');
  Add('    fNoteProps.pas - code formatted, coments removed');
  Add('    fRptBox.dfm - form layout adjusted');
  Add('    fTimeout.pas, *.dfm - form layout adjusted');
  Add('    fSignItem.pas, *.dfm - condition added to SetFocus call');
  Add('    mTreeGrid.pas, *.dfm - condition added to SetFocus calld');
  Add('    rCore.pas - changes from CPRS v31.244 added');
  Add('    uConst.pas - changes from CPRS v31.244 added');
  Add('    uCore.pas - changes from CPRS v31.244 added');
  Add('    Encounter\fEncounterFrame.pas, *.dfm - condition added to SetFocus call');
  Add('    Encounter\fPCEBase.pas, *.dfm - condition added to SetFocus call');
  Add('    Encounter\fPCEBaseMain.pas, *.dfm - code re-formatted');
  Add('    Encounter\fPCEBase.pas, *.dfm - condition added to SetFocus call');
  Add('    Encounter\fPCELex.pas, *.dfm - coments removed');
  Add('    Encounter\fVisitType.pas, *.dfm - condition added to SetFocus call');
  Add('    Encounter\uPCE.pas - code reformatted');
  Add('    GroupNotes\fGN_Debug.pas, *.dfm - minor layout changes');
  Add('    GroupNotes\fEcounter.pas, *.dfm - SpellChecking added to TMemo components');
  Add('    GroupNotes\fGN_MainFrame.pas, *.dfm - "Save On Exit" option added to Tools menu');
  Add('    GroupNotes\fGN_Page.pas, *.dfm - condition added to SetFocus call');
  Add('    GroupNotes\fGN_RPCLog.pas, *.dfm - shortcuts added, layout modified...');
  Add('    GroupNotes\uGN_RPCLog.pas, *.dfm - new unit. Functions/Procedures related to fGN_RPCLog');
  Add('    GroupNotes\fGN_ChnageLog.pas - updated with description of Build 5');
  Add('    GroupNotes\fGN_Utils.pas - procedure FocusWinControl added');
  Add('    GroupNotes\uGN_Const.pas - TX_IN_USE definition moved from fGN_MainFrame');
  Add('');
  Add('OR 3.0*455 Build 4');
  Add('  Build 4 was updated to address defect accessibilty guidelines issue 577688:');
  Add('      In OR*3.0*455 and predecessors, it is impossible to use the cursor keys in patient selection.');
  Add('      In 448 and earlier, viewing a patient with the cursor keys will automatically add him/her to ');
  Add('      the list, where it will be impossible to remove them using the keyboard only.');
  Add('      In 455, it is impossible to give focus to the patient selection list without using the mouse.');
  Add('');
  Add('    - OnClick event handler replaced with OnChange handler');
  Add('    - Menu item "Select Patient(s)" renamed to "Show Patient(s) Selector"');
  Add('    - Debug menu Item "One Click Selection" hidden');
  Add('    - Double click of the patient line adds the record to the selected list');
  Add('    - Action "Select" added to add patient to the selected list');
  Add('    - Button "Select" added (linked to "Select" action)');
  Add('    - Shortcut "Shift+Return" for patient list linked to "Select" action');
  Add('  The next files were modified');
  Add('    fPrSelOptns.dfm - Radio group item updated to change the shortcut to "P&roviders"');
  Add('    fRptBox.dfm, fRptBox.pas - updated to allow to close dialog by clicking ESC');
  Add('    dmGN_Common.dfm - Select action icon added');
  Add('    fGN_About.dfm - updated layout');
  Add('    fGN_MainFrame.dfm, fGN_MainFrame.pas - implementation of Select action added');
  Add('    fGN_Page.pas - comment removed');
  Add('    fGN_PtSel.dfm, fGN_PtSel.pas - updated with implementation of Select action');
  Add('    fGN_SelectedPatients.dfm - layout updated');
  Add('    uGN_ChamgeLog.dfm - updated with descriptions of changes');
  Add('');
  Add('OR 3.0*455 Build 3');
  Add('  Build 3 was updated to address SpellChecking issue (Word hanging on closing)');
  Add('    - uSpell.pas replaced with SpellCheck\uWord.Spell.pas');
  Add('    - fSpellNotify.* replaced with SpellCheck\fWordNotify.*');
  Add('    - Debug view updated to include tree view of the data associated with patients');
  Add('    - RPC Log caption fixed');
  Add('    - "GN GUI DEBUG" security key enables access to DEBUG menu');
  Add('    - PCE data is not saved - FIXED');
  Add(' The next files were modified or added');
  Add('  fAddSigners.* - procedures changed to function, minor layout changes');
  Add('  fBase508Form.* - shortcuts added to support RPC Log');
  Add('  fDupPts.* - added to project');
  Add('  uProbs.* - updated to support RTTI');
  Add('  uProbs.* - updated to support RTTI');
  Add('  uSurgery.* - updated to support RTTI');
  Add('  uTIU.pas');
  Add('    - updated to support RTTI');
  Add('    - procedure NoteRecordClear(aRec:TEditNoteRec); removed');
  Add('  GroupNotes.dpr - files uWordSpell, fWordNotify, uLog added to the project, uSpell, fSpellNotify - removed');
  Add('  GroupNotes.dproj - project version updated');
  Add('  Ecounter\fEncounter.* - comments removed, minor layout change, code formatted');
  Add('  Ecounter\fEncounterFrame.* - PCE data is not saved - fixed');
  Add('  Ecounter\fDiagnoses.* - code formatted');
  Add('  Ecounter\fImmunization.* - reference on form variable removed from the object code');
  Add('  Ecounter\fPCELex.* - code enhanced');
  Add('  Ecounter\uPCE.* - TPCEData.Save method updated - parameter added');
  Add('  GroupNotes\fGN_About.dfm - layout updated');
  Add('  GroupNotes\dmGN_Common.dfm - icons updated');
  Add('  GroupNotes\fGN_About.dfm - layout updated');
  Add('  GroupNotes\fGN_Encounter.* - layout updated with tree of patients to support enhanced debug mode');
  Add('  GroupNotes\fGN_GroupEncounter.* - function IsComplete added');
  Add('  GroupNotes\fGN_Debug.* - unit added to the project to replace debug panel');
  Add('  GroupNotes\fGN_MainFrame.* - info message added when encounter location is not defined (debug mode only)');
  Add('  GroupNotes\fGN_PtSel.* - function IsComplete added');
  Add('  GroupNotes\fGN_RPCLog.* - RPC Log window caption fixed, layout updated');
  Add('  GroupNotes\fGN_SelectedPatients.* - updated');
  Add('  GroupNotes\fGN_ChangeLog.pas - updated with the latest changes');
  Add('  GroupNotes\uGN_Const.pas - text message added');
  Add('  GroupNotes\uGN_Utils.pas - format of the debug output updated');
  Add('');

  Add('OR 3.0*455 Build 2');
  Add('  Build 2 was updated to address several issues found in Build 1 and clean up UI');
  Add('   Issues addressed: ');
  Add('   - Order of the selection of the components by tabbing on Immunization tab');
  Add('   - Saving of the note without signing results in rror message: "Empty note can not be signed"');
  Add('  GUI changes');
  Add('   - Debug menu options added (DEBUG build only)');
  Add('   - About box updated to be used in "Splash" mode');
  Add('   - RPC Log window updated.');
  Add('   - Toolbars added to be used if the "DEBUG" layout is selected (DEBUG build only)');
  Add('');
  Add(' The next is the list of the changed files');
  Add('  uGN_Utils.pas ');
  Add('    - procedure adjustBitBtn updated to considersize of the the icon');
  Add('    - procedure LeanPList added. Clears patient list passed as parameter');
  Add('    - procedure adjustFormSize added');
  Add('    - procedure adjustFormPosition added');
  Add('    - unt Math added to the uses clause');
  Add('    - function EditNoteResToStr updated.  internal functio ListToString added');
  Add('  uGN_Const.pas');
  Add('    - Constant LB_GNPTSEL removed');
  Add('    - constant GAP added');
  Add('  rGN_Core.pas ');
  Add('    - procedure CleanGNPtList removed.');
  Add('  fGN_SelectedPatients.pas');
  Add('    - unit updated to minimize use of the global list GNPtList.');
  Add('  fGN_SelectedPatients.dfm');
  Add('    - toolbar tbSelectedPatients added providing access to form actions');
  Add('  fGN_PtSel.dfm');
  Add('    - form updated with the toolbar');
  Add('  fGN_PtSel.pas');
  Add('    - implementation of toolbar added');
  Add('    - TPatientData object definition moved from the unit to the new unit oGN_PtData,pas');
  Add('  fGN_NoteDeleteReason.dfm');
  Add('    - form ayout updated');
  Add('  fGN_MainForm.dfm');
  Add('    - menu updated - menu items linked to the actions (font sizing)');
  Add('    - 2nd Inquiry button (under the patients list) removed');
  Add('  fGN_MainForm.pas');
  Add('    - updated to implement resizing control on change of the form font size');
  Add('  fGN_GroupEncounter,pas');
  Add('    - function getHeight added to control resizing of the form');
  Add('  fGN_GroupEncounter.dfm');
  Add('    - panel pnlEncounterGroupHeader removed');
  Add('  fGN_Encounter.pas');
  Add('    - procedure acSelectPatientsExecute(Sender: TObject); - added');
  Add('    - procedure ToolButton6Click(Sender: TObject);        - added');
  Add('    - procedure FormResize(Sender: TObject);              - added');
  Add('    - procedure populatePtList updated to accept name of the list as parameter');
  Add('    - procedure UpdateCommonNotes; - added');
  Add('    - procedure UpdateSingleNotes; - added');
  Add('    - several actions items were added to support new toolbars.');
  Add('    - unit modified to be used as a separate dialog. Changes were not finalized');
  Add('  fGN_Encounter.dfm');
  Add('    - form updated with the new toolbars providing access to the form actions');
  Add('  fGN_About.pas');
  Add('    - updated with support of "OK" button');
  Add('  fGN_About.dfm');
  Add('    - layout modified');
  Add('  dmGN_Common.dfm');
  Add('    - image list updated with the new images');
  Add('');
  Add('  uPCE.pas');
  Add('    - function PCEDataToString(aPCE: TPCEData):String;  added to the unit');
  Add('  fVisitType.pas');
  Add('    - procedure NotifyMasterForm; - added. Procedure sends message to the parent form to notify on the changes made');
  Add('    - procedure TfrmVisitType.lstVTypeSectionChange(Sender: TObject); - event handler added to use NotifyMaster');
  Add('    - procedure TfrmVisitType.lbProvidersChange(Sender: TObject);- event handler modified to use NotifyMaster');
  Add('  fVisitType.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fSkinTest.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fProcedure.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fProvider.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fPCELex.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fPCEBaseMain.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fPCEBaseGrid.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fPCEBaseGrid.pas');
  Add('    - source formatting changed');
  Add('  fPCEBase.pas');
  Add('    - component chkDebug removed. source updated');
  Add('  fPCEBase.dfm');
  Add('   - component chkDebug removed');
  Add('');
  Add('  fPatientEd.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fHealthFactor.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fGAF.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fEncVitals.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fEncounterFrame.pas');
  Add('    - component chkDebugInfo removed. source updated');
  Add('  fEncounterFrame.dfm');
  Add('    - layout updated with the use of components margins');
  Add('    - component chkDebugInfo removed');
  Add('  fEncnt.pas');
  Add('    - Splitter added to allow resize the selected patients list');
  Add('    - call of ResizeAnchoredFormToFont (UpdateEncounter function) commented out');
  Add('  fEncnt.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fDiagnoses.dfm');
  Add('    - layout updated with the use of components margins');
  Add('');
  Add('  uTIU.pas');
  Add('    - procedure NoteRecordClear(aRec:TEditNoteRec); added');
  Add('  uCore.pas');
  Add('    - constant definition LB_GNPTSEL removed');
  Add('  mTreeGrid.dfm');
  Add('    - main form font name set to "Tahoma" (default)');
  Add('  GroupNotes.dpr');
  Add('    - unit oGN_PtData.pas added - unit contains definition of the TPatientData class');
  Add('    - fxBroker unit moved to GroupNotes folder');
  Add('  fRptBox.pas');
  Add('    - button added to allow printing of the text.');
  Add('  fRptBox.dfm');
  Add('    - minor layout fixes - margins, buttons alignment.');
  Add('  fPtSelOptions.pas');
  Add('    -  procedure FormResize(Sender: TObject); evet handler removed');
  Add('  fPtSelOptions.dfm');
  Add('    - Group box component removed from orapnlMain (TORAutoPanel)');
  Add('      to avoid resizing of the group box when the parent panel is resized');
  Add('  fPtSelDemog.pas');
  Add('    - variable frmPtSelDemog removed');
  Add('    - source updated with comments');
  Add('  fPtSelDemog.dfm');
  Add('    - component positions adjusted');
  Add('  fNoteProps.pas');
  Add('    - use of TORAutoPanels minimized');
  Add('    - components of TOROffsetLabel type replaced with the TLabel components');
  Add('    - upused methods removed');
  Add('  fNoteProps.dfm');
  Add('    - component positions adjusted');
  Add('    - the form default font name set to "Tahoma"');
  Add('    - layout updated with the use of components margins');
  Add('  fBase508Form.dfm');
  Add('    - the form default font name set to "Tahoma"');
  Add('  fBase508Dialog.dfm');
  Add('    - layout updated with the use of components margins');
  Add('  fAddSigners.pas');
  Add('    - class parent changed from TfrmBase508Form to TfrmBase508Dialog');
  Add('    - components of TORAutoPanel removed');
  Add('  fAddSigners.dfm');
  Add('    - form updated to use TfrmBase508Dialog components');
  Add('');

  Add('OR 3.0*455 Build 1(4)');
  Add('  - function TfrmGNEncounter.NeedToSign updated to avoid A/V error');
  Add('    (case aPatientData.PtNote.Lines are not assigned)');
  Add('  - Font resizing added. ("Tools|Font" section supports font sizes 8,10,12,14,18)');
  Add('  - "Help" menu positioned on the left. (Use the"DEBUG|Help Menu on Right" to put it to the right)');
  Add('  - DEBUG menu added. The debug menu combines all "additions" to the original UI');
  Add('  - fPtSelDemog unit updated. The implementation of the window updated');
  Add('  - About box/Splash changed: frame added, cursor hidden, order of the text changed');
  Add('  - "You are not allowed to use Group Notes" ShowMessage replaced with InfoBox');
  Add('  - "Change Log" option added to the DEBUG menu"');
  Add('  - Main menu updated - options added to copy actions performed by main buttons');
  Add('    ("Select Patient(s)", "Create Group Note", "Start New Group Note")');
  Add('  - unit fPtDemo excluded from the project. The unit duplicated functionality of fRptBox unit');
  Add('  - unit fRptBox updated. Obsolite code removed');
  Add('  - The start status of the action "Identify Additional Signers" is set to "disabled"');
end;

finalization

ChangeLog.Free;

(*
GUI Developer random comments on Group Notes GUI application

Overview

The Group Notes GUI (GNG) provides a subset of the CPRS functionality -
creation of the Notes and Encounter descriptions.
It is trying to re-use the code of CPRS and thus inherits the dependencies of
the CPRS GUI units. Unfortunately this dependencies are not essential for GNG.

User interface of GNG is confusing. It mixes together traditional Form/Dialog style
with the "Browser" (all-in-one window) approach: while the selection of the patients
is done in the main application window the encounter data is collected in a separate dialog.
The benefits of such design are not obvious.
For the sake of consistency it would be better to select one style only.

The saving of the Encounter data and the notes follow the CPRS workflow which is
different from the one for GNG. As the result for GNG user there is no
clear indication when the savng is done, and it is difficult to implement the
saving confirmation step.
Error processing is also difficult to implement.

The application uses 'OR CPRS GUI CHART' application context.
The user of the GUI supposed to hold 'OR GN ACCESS' security key
The vesion of the server is kept in 'OR GN SET LOCATIONS' option.
Implementation of the GN specific RPC is done by the ORWGN routine.

Files

The files unique to the GNG are kept in GroupNotes folder
The rest of the files are following the CPRS (as of v31)

Modifications to the CPRS files

The files 'borrowed' from the CPRS were modified to exclude dependencies not vital for GNG.
The changes to the CPRS code introduced by GNG are provided with comment containing text like:
IFDEF GROUPNOTES

The next is the list of modified files

C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uCore.pas [5]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uCore.pas(406): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uCore.pas(1127): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uCore.pas(1304): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uCore.pas(1427): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uCore.pas(1518): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas [6]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas(7): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas(378): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas(485): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas(494): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas(954): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\uPCE.pas(3322): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas [7]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(12): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(238): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(297): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(507): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(518): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(606): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncounterFrame.pas(617): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fPCELex.pas [1]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fPCELex.pas(76): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\rPCE.pas [3]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\rPCE.pas(8): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\rPCE.pas(182): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\rPCE.pas(571): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fDiagnoses.pas [2]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fDiagnoses.pas(10): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fDiagnoses.pas(85): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fPCEBaseMain.pas [1]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fPCEBaseMain.pas(97): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uTIU.pas [2]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uTIU.pas(10): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uTIU.pas(39): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\rMisc.pas [5]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\rMisc.pas(77): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\rMisc.pas(94): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\rMisc.pas(101): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\rMisc.pas(403): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\rMisc.pas(535): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uGlobalVar.pas [2]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uGlobalVar.pas(9): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uGlobalVar.pas(25): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fAddlSigners.pas [4]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fAddlSigners.pas(7): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fAddlSigners.pas(79): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fAddlSigners.pas(95): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fAddlSigners.pas(396): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uSpell.pas [1]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uSpell.pas(22): { $ IFDEF GROUPNOTES}
  - file uSpell.pas was replaced with uWordSpell.pas in build 3
  - files uSpellNotify.* were replaced with fWordNotify.* in build 3

C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uSurgery.pas [2]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uSurgery.pas(18): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\uSurgery.pas(41): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fRptBox.pas [1]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fRptBox.pas(8):   { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncnt.pas [5]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncnt.pas(17): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncnt.pas(123): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncnt.pas(203): {$IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncnt.pas(242): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncnt.pas(544): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fPtSelOptns.pas [3]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fPtSelOptns.pas(45): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fPtSelOptns.pas(333): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\fPtSelOptns.pas(430): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncVitals.pas [2]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncVitals.pas(50): { $ IFDEF GROUPNOTES}
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\Encounter\fEncVitals.pas(166): { $ IFDEF GROUPNOTES}
C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\GroupNotes\fGN_GroupEncounter.pas [1]
  C:\dev\XE8_WorkBox\CPRS_v31_Development\OR_3_455\GroupNotes\fGN_GroupEncounter.pas(111): { $ IFDEF GROUPNOTES}

Sample of the code with comments:

In the next example the code between  { $ IFDEF GROUPNOTES}    { $ ENDIF} was added to the original CPRS code

    { $ IFDEF GROUPNOTES}
      if not assigned(Patient) then
        begin
          EncounterText.LocationName := '';
          EncounterText.LocationAbbr := '';
          EncounterText.RoomBed := '';
          EncounterText.ProviderName := '';
        end;
      if Patient = nil then
        exit;
    { $ ENDIF}

In the next example no code was added and the lines between  { $ ELSE}    { $ ENDIF} was commented out of
 the original CPRS code

    { $ IFDEF GROUPNOTES}
    { $ ELSE}
    ( *
          ConsultIEN := GetConsultIENforNote(DocIEN);
          if ConsultIEN > -1 then
            begin
              OrderID := GetConsultOrderIEN(ConsultIEN);
              UnlockOrderIfAble(OrderID);
            end;
          TChangeItem(Items[i]).Free;
    * )
    { $ ENDIF}

Files unique for GNG

Files were updated from the version OR*3.0*448 as following:
- renamed to use "GN prefix
- exclude use of TORAutoPanel objects
- Toolbars added to the windows
- "DEBUG" mode added to let user review key objects data

RPC Log

The RPC Log replaces "Last Broker Call" window (fxBroker unit).
The RPC Log keeps records in reverse chronological order with the most recent record on the top.
The log supports higlighting of the search target. To highlight a set of chars
enter them in the "Find" input field and press "Enter".
The details of the RPC call can be copied to the Clipboard (use menu buttons of menu options)

UI changes

The original UI was kept unchanged with the minor enhancements like use of component margins,
adjustment of the components and unification of the Encounter pages.
In attempt to move to the traditional window/dialog style several changes were made.
They are available if the user selects "Debug Layout" from the Debug section of the main menu.
The access to the Debug section is limited to the holders of the "GN GUI DEBUG" security key or
DEBUG build of the application.

*)

end.
