unit oGN_PtData;

interface
uses
  uTIU, uPCE, uCore;

type
  TPatientData = Class(TObject)
  private
    FOKForSign: Boolean;
    FPatient: TPatient;
    FAdditionalSigner: boolean;
  public
    PtNote: TEditNoteRec;
    PCEData: TPCEData;
    constructor Create;
    procedure Clear;
    property OKForSign: boolean read FOKForSign  write FOKForSign;
    property Patient: TPatient read FPatient write FPatient;
    property AdditionalSigner: boolean read FAdditionalSigner write FAdditionalSigner;
  end;

implementation
uses
  System.Classes;

{ TPatientData }
procedure TPatientData.Clear;
begin
  with PtNote do
  begin
    NoteIEN      := 0;
    DocType      := 0;
    Title        := 0;
    TitleName    := '';
    DateTime     := 0;
    Author       := 0;
    AuthorName   := '';
    Cosigner     := 0;
    CosignerName := '';
    Subject      := '';
    Location     := 0;
    LocationName := '';
    PkgIEN       := 0;
    PkgPtr       := '';
    PkgRef       := '';
    NeedCPT      := False;
    Addend       := 0;
    Lines.Clear;
    ErrTxt       := '';
  end;
  FPatient.Free;
  PCEData.Free;
  FAdditionalSigner := False;
end;

constructor TPatientData.Create;
begin
  FOKForSign := False;
  FPatient := TPatient.Create;
  PCEData := TPCEData.Create;
  AdditionalSigner := False;
  with PtNote do
  begin
    NoteIEN      := 0;
    DocType      := 0;
    Title        := 0;
    TitleName    := '';
    DateTime     := 0;
    Author       := 0;
    AuthorName   := '';
    Cosigner     := 0;
    CosignerName := '';
    Subject      := '';
    Location     := 0;
    LocationName := '';
    PkgIEN       := 0;
    PkgPtr       := '';
    PkgRef       := '';
    NeedCPT      := False;
    Addend       := 0;
    Lines        := TStringList.Create;
    GenLines     := TStringList.Create;
    PtLines      := TStringList.Create;
    ErrTxt       := '';
  end;
end;



end.
