unit fGN_SelectedPatients;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Buttons, Vcl.StdCtrls, Vcl.ComCtrls,
  Vcl.ExtCtrls, System.Actions, Vcl.ActnList
  , uPCE, WinAPI.CommCtrl
  , oGN_PtData, Vcl.ToolWin
  ;

type
  TfrmGN_SelectedPatients = class(TForm)
    lblInfo: TLabel;
    lvGnPtList: TListView;
    pnlTools: TPanel;
    alPatientList: TActionList;
    acRemove: TAction;
    acRemoveAll: TAction;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    tbSelectedPatients: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    procedure acRemoveExecute(Sender: TObject);
    procedure acRemoveAllExecute(Sender: TObject);
    procedure lvGnPtListCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure lvGnPtListColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvGnPtListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FsortCol: integer;
    FsortAscending: boolean;
  public
    { Public declarations }
    _PtList:TList;
    procedure setActionStatus;
    procedure addPatientData(aPtData:TPatientData;aLocation:String);
    procedure removePatientFromList(aPatient:Pointer);
    procedure loadFromList(aList:TList);
  end;

implementation

{$R *.dfm}
uses
  uCore
  , uGN_Const
  , ORFn
  , dmGN_Common, uGN_Utils;

procedure TfrmGN_SelectedPatients.setActionStatus;
begin
  acRemove.Enabled := (lvGnPtList.Items.Count > 0) and
    (lvGnPtList.ItemIndex >=0);
  acRemoveAll.Enabled := lvGnPtList.Items.Count > 0;
  sendMessage(Application.MainForm.Handle,UM_GNSELECT,0,0);
end;

procedure TfrmGN_SelectedPatients.removePatientFromList(aPatient: Pointer);
var
  i: Integer;
begin
  i := _PtList.IndexOf(aPatient);
  if i >= 0 then
  begin
    TPatient(_PtList.Items[i]).Free;
    _PtList.Delete(i);
  end;
end;

procedure TfrmGN_SelectedPatients.acRemoveAllExecute(Sender: TObject);
begin
  if (lvGnPtlist.Items.Count > 0) then
    begin
      lvGnPtList.Items.Clear;
      try
        CleanPtList(_PtList);
      except
        on E: Exception do
          ShowMessage(E.Message);
      end;
    end;
  setActionStatus;
end;

procedure TfrmGN_SelectedPatients.acRemoveExecute(Sender: TObject);
var
  i: integer;
begin
  if lvGNPtList.SelCount <= 0 then
    InfoBox('There is no selected patient', 'Warning', MB_OK or MB_ICONWARNING)
  else
    begin
      for i := 0 to lvGNPtList.Items.Count - 1 do
      begin
        if lvGNPtList.Items[i].Selected  then
          removePatientFromList(lvGNPtList.Items[i].Data);
      end;
      lvGnPtList.DeleteSelected;
      setActionStatus;
    end;
end;

procedure TfrmGN_SelectedPatients.addPatientData(aPtData:TPatientData;aLocation:String);
var
  i,ii: integer;

  AnItem: TListItem;
  PtAdmit: String;
  AdmitDT: TDateTime;
begin
  if not assigned(aPtData) then
    exit;

  PtAdmit := '';
  if (APtData.Patient.AdmitTime > 0) then
  begin
    AdmitDT := FMDateTimeToDateTime(APtData.Patient.AdmitTime);
    PtAdmit := DateToStr(AdmitDT);
  end;

  AnItem := lvGNPtList.Items.Add;
  AnItem.Data := APtData;
  AnItem.Caption := APtData.Patient.Name;
  AnItem.SubItems.Add(APtData.Patient.SSN);
  AnItem.SubItems.Add(IntToStr(APtData.Patient.Age));
  AnItem.SubItems.Add(APtData.Patient.Sex);
  AnItem.SubItems.Add(aLocation);
  AnItem.SubItems.Add(PtAdmit);
  AnItem.SubItems.Add(APtData.Patient.PrimaryTeam);
  AnItem.SubItems.Add(APtData.Patient.PrimaryProvider);

  i := 0;
  ii := lvGNPtList.Canvas.TextWidth(anItem.Caption) + GAP + GAP;
  if lvGNPtList.Columns[i].Width < ii then
    lvGNPtList.Columns[i].Width := ii;
  for i := 0 to anItem.SubItems.Count - 1 do
    begin
      ii := lvGNPtList.Canvas.TextWidth(anItem.SubItems[i]) + GAP + GAP;
      if lvGNPtList.Columns[i+1].Width < ii then
        lvGNPtList.Columns[i+1].Width := ii;
    end;
end;

procedure TfrmGN_SelectedPatients.FormCreate(Sender: TObject);
var
  i, ii: Integer;
begin
  inherited;
  Hide;
  FsortAscending := true;
  for i := 0 to lvGNPtList.Columns.Count - 1 do
    begin
      ii := lvGNPtList.Canvas.TextWidth(lvGNPtList.Columns[i].Caption) + gap;
      lvGNPtList.Columns[i].Width := ii;
    end;
end;

procedure TfrmGN_SelectedPatients.lvGnPtListChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
  SetActionStatus;
end;

procedure ListViewClearSortIndicator(aHandle:HWND; aColumn: Integer);
var
  Header: HWND;
  Item: THDItem;
begin
  Header := ListView_GetHeader(aHandle);
  ZeroMemory(@Item, SizeOf(Item));
  Item.Mask := HDI_FORMAT;

  // Clear the previous arrow
  Header_GetItem(Header, aColumn, Item);
  Item.fmt := Item.fmt and not (HDF_SORTUP or HDF_SORTDOWN);//remove both flags
  Header_SetItem(Header, aColumn, Item);
end;

procedure TfrmGN_SelectedPatients.lvGnPtListColumnClick(Sender: TObject;
  Column: TListColumn);

  procedure UpdateHeader(aHandle:HWND; aColumn: Integer);
  var
    Header: HWND;
    Item: THDItem;
  begin
    Header := ListView_GetHeader(aHandle);
    ZeroMemory(@Item, SizeOf(Item));
    Item.Mask := HDI_FORMAT;

    ListViewClearSortIndicator(aHandle,FsortCol);

    if Column.Index <> FsortCol then
      begin
        FsortAscending := False;
        FsortCol := Column.Index;
      end
    else
      FsortAscending := not FsortAscending;

    // Get the new column
    Header_GetItem(Header, FsortCol, Item);
    Item.fmt := Item.fmt and not (HDF_SORTUP or HDF_SORTDOWN);//remove both flags

    if FsortAscending then
      Item.fmt := Item.fmt or HDF_SORTDOWN//include the sort descending flag
    else
      Item.fmt := Item.fmt or HDF_SORTUP;//include the sort ascending flag

    Header_SetItem(Header, FsortCol, Item);

    with TListView(Sender) do
      begin
        SortType := stText;
        Items.BeginUpdate;
        AlphaSort;
        Items.EndUpdate;
      end;
  end;

begin
{
  if ((FsortCol = Column.Index))  then
        FsortAscending := not FsortAscending;
  FsortCol := Column.Index;
  lvGnPtList.AlphaSort;
}
  UpdateHeader(TListView(Sender).Handle,FsortCol);
end;

procedure TfrmGN_SelectedPatients.lvGnPtListCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
begin
  if not(Sender is TListView) then Exit;
  if not FsortAscending then
    begin
      if FsortCol = 0 then Compare := CompareStr(Item1.Caption, Item2.Caption)
      else Compare := CompareStr(Item1.SubItems[FsortCol - 1], Item2.SubItems[FsortCol - 1]);
    end
  else
    begin
      if FsortCol = 0 then Compare := CompareStr(Item2.Caption, Item1.Caption)
      else Compare := CompareStr(Item2.SubItems[FsortCol - 1], Item1.SubItems[FsortCol - 1]);
    end;
end;

procedure TfrmGN_SelectedPatients.loadFromList(aList:TList);
var
  p: Pointer;
  aPtData:TPatientData;
  sLocation:String;
begin
  for p in aList do
    if p <> nil then
      begin
        aPtData := TPatientData(p);
        sLocation := '???';
        addPatientData(aPtData,sLocation);
      end;
end;

end.
