unit fGN_PtSel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ORCtrls, ORDtTmRng, ExtCtrls, ComCtrls, Buttons, ORFn,
  rGN_Core, ORNet, ORDtTm
  , fGN_Page
  , fGN_MainFrame, uCore, uPCE
  , fPtSelDemog
  , uTIU, System.Actions, Vcl.ActnList
  , fGN_GroupEncounter  , fPtSelOptns, fGN_SelectedPatients
  , oGN_PtData, Vcl.ToolWin;


type
  TSetPtListTopProc = procedure(IEN: Int64) of object;

  TfrmGNPtSel = class(TfrmPage)
    pnlTop: TPanel;
    pnlOptions: TPanel;
    pnlRight: TPanel;
    Splitter1: TSplitter;
    pnlPtSel: TPanel;
    cboPatient: TORComboBox;
    pnlOptionsHeader: TPanel;
    lblOptions: TLabel;
    pnlPatientHeader: TPanel;
    calApptRng: TORDateRangeDlg;
    pnlSelectedPatients: TPanel;
    pnlDemographics: TPanel;
    pnlGroupEncounter: TPanel;
    bbInquiryDemographics: TBitBtn;
    alPatientSelector: TActionList;
    acInquiry: TAction;
    bvlTool: TBevel;
    pnlButtons: TPanel;
    cmdOK: TButton;
    cmdCancel: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    pnlPtListToolbar: TPanel;
    ToolBar2: TToolBar;
    ToolButton2: TToolButton;
    ToolBar3: TToolBar;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton1: TToolButton;
    ToolButton5: TToolButton;
    ToolButton7: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    acOneClickSelection: TAction;
    CheckBox1: TCheckBox;
    Panel2: TPanel;
    acSelect: TAction;
    BitBtn1: TBitBtn;
    lblPatient: TLabel;
   procedure cboPatientNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure cboPatientChange(Sender: TObject);
    procedure cboPatientClick(Sender: TObject);
    procedure cboPatientKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure cboPatientDblClick(Sender: TObject);
    procedure acInquiryExecute(Sender: TObject);
    procedure pnlTopResize(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure acOneClickSelectionExecute(Sender: TObject);
    procedure acSelectExecute(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
  private
    fOneClickSelection: boolean;
    FLastTopList: string;
    FSrcType: Integer;
    FSetPtListTop: TSetPtListTopProc;
    FDfltSrc: string;
    FDfltSrcType: string;
    FLastDFN: string;

    _Started:Boolean;
    _GroupEncounter: TfrmGN_GroupEncounter;
    _GroupDemographics: TfrmPtSelDemog;
    _GroupOptions: TfrmPtSelOptns;
    _SelectedPatients: TfrmGN_SelectedPatients;

    procedure ShowDemog(ItemID: string);
    procedure AddToGNPtList(APtData:TPatientData);
    procedure ClearIDInfo;

    function DupLastSSN(var DFN: string): TStringList;
    procedure DoInquiry;
    procedure DoAdd(anID:String);

    procedure InitView;
    function MoveOnAllowed(aStatus: Integer): boolean;
    function ContinueOnDeceased(aDfn: string): Boolean;

  public
    property OneCLick: Boolean read fOneClickSelection write fOneClickSelection;
    property LastTopList: string read FLastTopList write FLastTopList;
    property SrcType: Integer read FSrcType write FSrcType;
    property SetPtListTopProc: TSetPtListTopProc   read FSetPtListTop  write FSetPtListTop;
    procedure SetCaptionTop;
    procedure SetPtListTop(IEN: Int64);
    procedure setEncounter;

    procedure setLayout(aLayout:String);

    function isComplete:Boolean;

    procedure setActionStatus;
    function PatientsCount:Integer;
  end;

var
  frmGNPtSel: TfrmGNPtSel;
  IsRPL, RPLJob, DupDFN: string;
  RPLProblem: boolean;
  FDfltSrc, FDfltSrcType: string;

procedure SelectPatients(aLayout:String = '');

implementation
{$R *.dfm}

uses
  fGN_Encounter, uGN_Utils
  , rPCE
  , rCore
  , uConst
  , uGN_Const
  , fRptBox
  , dmGN_Common
, fDupPts;

var
  _frm: TfrmGNPtSel;

procedure SelectPatients(aLayout:String = '');
{ patient selection dialog }
begin
  if not assigned(_frm) then
    Application.CreateForm(TfrmGNPtSel,_frm);
  _frm.BorderStyle := bsSizeable;
  _frm.Position := poScreenCenter;
  _frm.pnlButtons.Visible := True;
  _frm._SelectedPatients.loadFromList(GNPtList);
  _frm.setLayout(aLayout);
  _frm.ShowModal;
//  _frm.Hide;
  FReeAndNil(_frm);
end;

////////////////////////////////////////////////////////////////////////////////

procedure TfrmGNPtSel.ClearIDInfo;
{clear demographic info}
begin
  FLastDFN := '';
  acInquiry.Enabled := false;
  if assigned(_GroupDemographics) then
    _GroupDemographics.ClearIDInfo;
end;

procedure TfrmGNPtSel.InitView;

  procedure SetupOptions;
  begin
    _GroupOptions := TfrmPtSelOptns.Create(self); // Was application - kcm
    setFormParented(_GroupOptions,pnlOptions);
    with _GroupOptions do
      begin
        SetCaptionTopProc := SetCaptionTop;
        SetPtListTopProc := SetPtListTop;
        TabOrder := 0; //cmdSaveList.TabOrder; // Put just before save default list button
        Show;
      end;
  end;

  procedure setupSelectedList;
  begin
    if not Assigned(GNPtList) then
      GNPtList := TList.Create;
    if not assigned(_SelectedPatients) then
      _SelectedPatients := TfrmGN_SelectedPatients.Create(self);
    _SelectedPatients._PtList := GNPtList;
    setFormParented(_SelectedPatients,pnlSelectedPatients);
  end;

  procedure setDemographics;
  begin
    if not assigned(_GroupDemographics) then
      _GroupDemographics := TfrmPtSelDemog.Create(self);
    setFormParented(_GroupDemographics,pnlDemographics);
  end;

  procedure setGroupEncounter;
  begin
    if not assigned(_GroupEncounter) then
      _GroupEncounter := TfrmGN_GroupEncounter.Create(self);
    setFormParented(_GroupEncounter,pnlGroupEncounter);
    pnlGroupEncounter.Height := _GroupEncounter.getHeight;
  end;

begin
  SetupOptions;
  setupSelectedList;
  setDemographics;
  setGroupencounter;

  RPLProblem := false;
  FDfltSrc := DfltPtList;
  FDfltSrcType := Piece(FDfltSrc, U, 2);
  FDfltSrc := Piece(FDfltSrc, U, 1);

  if (IsRPL = '1') then             // Deal with restricted patient list users.
    FDfltSrc := '';

  ClearIDInfo;

  if RPLProblem then exit;          // No code found that set RPLProblem to True

  if (IsRPL = '1') then             // Deals with restricted patient list users.
    pnlOptions.Visible := False;    // Removes unnecessary components from view.

  cboPatient.InitLongList('');

  if assigned(_GroupEncounter) then
    _GroupEncounter.Init;

  _GroupOptions.rgPtList.ItemIndex := 0;

  Constraints.MaxHeight := Screen.WorkAreaRect.Bottom - Screen.WorkAreaRect.Top;
  setActionStatus;

  OneClick := acOneClickSelection.Checked;

  _Started := True;
end;

procedure TfrmGNPtSel.FormCreate(Sender: TObject);
begin
  inherited;
  InitView;
end;

procedure TfrmGNPtSel.FormResize(Sender: TObject);
begin
  inherited;
  pnlPtListToolbar.Height := 28;

  if assigned(_GroupOptions) then
    pnlOptions.Width := _GroupOptions.orapnlMain.Width;

  if pnlTop.Height > Round( Height * 4 / 5) then
    pnlTop.Height := Round( Height * 4 / 5);
end;

procedure TfrmGNPtSel.cboPatientNeedData(Sender: TObject; const StartFrom: string;
  Direction, InsertAt: Integer);
{ process component request for data}
var
  i: Integer;
  NoAlias, ThePatient: String;
  PatientList: TStringList;

const
  ALIASSTRING = ' -- ALIAS';

begin
  NoAlias := StartFrom;
  with Sender as TORComboBox do
  begin
    if Items.Count > ShortCount then
      NoAlias := Piece(Items[Items.Count-1], U, 1) + U + NoAlias;
  end;
  if pos(AliasString, NoAlias)> 0 then
    NoAlias := Copy(NoAlias, 1, pos(AliasString, NoAlias)-1);
  PatientList := TStringList.Create;
  try
    begin
      if (IsRPL  = '1') then
        PatientList.Assign(ReadRPLPtList(RPLJob, NoAlias, Direction))
      else
      begin
        PatientList.Assign(SubSetOfPatients(NoAlias, Direction));
        for i := 0 to PatientList.Count-1 do
        begin
          ThePatient := PatientList[i];
          if (Uppercase(Piece(ThePatient, U, 2)) <> Uppercase(Piece(ThePatient, U, 6))) then
          begin
            SetPiece(ThePatient, U, 2, Piece(ThePatient, U, 2) + AliasString);
            PatientList[i] := ThePatient;
          end;
        end;
      end;
      cboPatient.ForDataUse(PatientList);
    end;
  finally
    PatientList.Free;
  end;
end;

procedure TfrmGNPtSel.ShowDemog(ItemID: string);
{ gets a record of patient indentifying information from the server and displays it }
begin
  if ItemID = FLastDFN then
    exit;
  if (StrToInt64Def(ItemID, 0) < 1) then
    exit;
  FLastDFN := ItemID;
  acInquiry.Enabled := True;
  if assigned(_GroupDemographics) then
    _GroupDemographics.ShowDemog(ItemID);
end;

procedure TfrmGNPtSel.ToolButton2Click(Sender: TObject);
begin
  inherited;
  if frmMainFrame.acDebugLayout.Checked then
    ModalResult := mrOK
  else
    frmMainFrame.acNewGroupNote.Execute;
end;

procedure TfrmGNPtSel.cboPatientChange(Sender: TObject);
{update patient info on changing the selection}
  procedure ShowMatchingPatients;
  begin
    with cboPatient do
    begin
      ClearIDInfo;
      if ShortCount > 0 then
      begin
        if ShortCount = 1 then
        begin
          ItemIndex := 0;
          ShowDemog(cboPatient.ItemID);
        end;
        Items.Add(LLS_LINE);
        Items.Add(LLS_SPACE);
      end;
      InitLongList('');
    end;
  end;

begin
//exit;
  acSelect.Enabled := cboPatient.ItemIndex >=0;
  if not acSelect.Enabled then
    exit;

  with cboPatient do
  begin
    if IsLast5(Text) then
    begin
      if (IsRPL = '1') then
        ListPtByRPLLast5(Items, Text)
      else
        ListPtByLast5(Items, Text);
      ShowMatchingPatients;
    end
    else if IsFullSSN(Text) then
    begin
      if (IsRPL = '1') then
        ListPtByRPLFullSSN(Items, Text)
      else
        ListPtByFullSSN(Items, Text);
      ShowMatchingPatients;
    end;
  end;
  ShowDemog(cboPatient.ItemID);

end;

function TfrmGNPtSel.DupLastSSN(var DFN: string): TStringList;//boolean;
{check for duplacate SSN}
var
  i: Integer;
  PtStrs: TStringList;
begin
  Result := nil;
  CallV('DG CHK BS5 XREF ARRAY', [DFN]);
  if (RPCBrokerV.Results[0] <> '1') then
    exit;
  PtStrs := TStringList.Create;
  with RPCBrokerV do
    if Results.Count > 0 then
    begin
      for i := 1 to Results.Count - 1 do
      begin
        if Piece(Results[i], U, 1) = '1' then
          PtStrs.Add(Piece(Results[i], U, 2) + U + Piece(Results[i], U, 3) + U +
            FormatFMDateTimeStr('mmm dd,yyyy', Piece(Results[i], U, 4)) + U +
            Piece(Results[i], U, 5));
      end;
    end;

  result := PtStrs;

//  SelectDupPt(DFN, PtStrs) <> mrOK;
end;

const
  TX_DGSR_ERR    = 'Unable to perform sensitive record checks';
  TC_DGSR_ERR    = 'Error';
  TC_DGSR_SHOW   = 'Restricted Record';
  TC_DGSR_DENY   = 'Access Denied';
  TX_DGSR_YESNO  = CRLF + 'Do you want to continue processing this patient record?';

function TfrmGNPtSel.MoveOnAllowed(aStatus: Integer): boolean;
var
  NewDFN, AMsg: string;
begin
  Result := false;
  case aStatus of
    DGSR_FAIL:
      InfoBox(TX_DGSR_ERR, TC_DGSR_ERR, MB_OK);

    DGSR_NONE: { Nothing - allow access to the patient. }
      Result := True;
    DGSR_SHOW:
      begin
        InfoBox(AMsg, TC_DGSR_SHOW, MB_OK);
        Result := True;
      end;
    DGSR_ASK:
      if InfoBox(AMsg + TX_DGSR_YESNO, TC_DGSR_SHOW,
        MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) = IDYES then
      begin
        LogSensitiveRecordAccess(NewDFN);
        acInquiry.Enabled := True;
        Result := True;
      end;
  else
    InfoBox(AMsg, TC_DGSR_DENY, MB_OK);
  end;
end;


function TfrmGNPtSel.ContinueOnDeceased(aDfn: string): Boolean;
var
  DateDied: TFMDateTime;
begin
  Result := True;
  DateDied := DateOfDeath(aDFN);
  if (DateDied > 0) and
    (InfoBox('This patient died ' + FormatFMDateTime('mmm dd,yyyy hh:nn',
    DateDied) + CRLF + 'Do you wish to continue?', 'Deceased Patient',
    MB_YESNO or MB_DEFBUTTON2) = ID_NO) then
    Result := false;

end;

procedure TfrmGNPtSel.cboPatientClick(Sender: TObject);
{ check access to selected patient, process selection if allowed }
(*
var
  NewDFN, AMsg: string;
  AccessStatus: Integer;

*)
begin
// OnClick replaced with OnChange
(*
  Enabled := false;
  Application.ProcessMessages;
  Enabled := True;

  NewDFN := cboPatient.ItemID;
  if StrToInt64Def(NewDFN, 0) >= 0 then
  begin

    Enabled := false;

    CheckSensitiveRecordAccess(NewDFN, AccessStatus, AMsg);
    if MoveOnAllowed(AccessStatus) then
      if OneCLick then
        DoAdd(NewDFN);

    Enabled := True;
  end;
*)
end;

procedure TfrmGNPtSel.cboPatientDblClick(Sender: TObject);
begin
  inherited;
  if OneClick then
    doAdd(IntToStr(cboPatient.ItemID))
  else
    doInquiry
end;

procedure TfrmGNPtSel.DoAdd(anID: string);
{add patient data to the list of selected patients}
{check for duplicates, notify the application main form on selection}
var
  aPtData: TPatientData;
  sl: TStringList;

  function DupPtInList(aList: TList;APtDFN: string): Boolean;
  var
    i: integer;
    APatient: TPatientData;
  begin
    Result := False;
    for i := 0 to (aList.Count - 1) do
    begin
      APatient := TPatientData(aList.Items[i]);
      if APatient.Patient.DFN = APtDFN then
      begin
        Result := True;
        Break;
      end;
    end;
  end;

begin

  if not DupPtInList(GNPtList, anID) then // check if the pt was selected before
  begin
    sl := DupLastSSN(anID); // get list of patients with 'duplicate SSN'

    if (sl = nil) or SelectDupPt(anID, sl) then // select one pt if needed
      if not DupPtInList(GNPtList, anID) then // have to check again
      begin
        APtData := TPatientData.Create;
        APtData.PCEData := TPCEData.Create;
        APtData.Patient.DFN := anID;
        AddToGNPtList(APtData);
        sendMessage(Application.MainForm.Handle, UM_GNSELECT, 0, 0);
      end;
    if assigned(sl) then
      sl.Free;
  end;
  setActionStatus;
end;

procedure TfrmGNPtSel.acInquiryExecute(Sender: TObject);
{invoke event processing routine}
begin
  inherited;
  doInquiry;
end;

procedure TfrmGNPtSel.acOneClickSelectionExecute(Sender: TObject);
begin
  inherited;
  acOneClickSelection.Checked := not acOneClickSelection.Checked;
  OneClick := acOneClickSelection.Checked;
end;

procedure TfrmGNPtSel.acSelectExecute(Sender: TObject);
var
  NewDFN, AMsg: string;
  AccessStatus: Integer;
begin
  inherited;
  NewDFN := cboPatient.ItemID;
  if StrToInt64Def(NewDFN, 0) < 1 then
    exit;
  CheckSensitiveRecordAccess(NewDFN, AccessStatus, AMsg);
  if MoveOnAllowed(AccessStatus)
    and ContinueOnDeceased(NewDFN) then
    doAdd(NewDFN);
end;

procedure TfrmGNPtSel.AddToGNPtList(APtData:TPatientData);
{add PtData to Selected patients list and register it in the global list}
begin
  if assigned(_SelectedPatients) and assigned(_GroupDemographics) then
    _SelectedPatients.addPatientData(APtData,_GroupDemographics.lblPtLocation.Caption);

  GNPtList.Add(APtData);
end;

procedure TfrmGNPtSel.DoInquiry;
{present Patient demographic info in report box}
var
  sl: TStringList;
begin
  if cboPatient.ItemID <> '' then
    begin
      sl := TSTringList.Create;
      LoadDemographics(sl,IntToStr(cboPatient.ItemID));
      ReportBox(sl, 'Patient Inquiry', True);
      sl.Free;
    end;
end;

procedure TfrmGNPtSel.cboPatientKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
{processing RETURN key press}
begin
  inherited;
  if Key = VK_RETURN then
    begin
      if ssShift in Shift then
        cboPatientDblClick(Sender);
      Key := 0;
    end;
end;

procedure TfrmGNPtSel.FormShow(Sender: TObject);
{reset patient list}
begin
  inherited;
  if StartOver and Assigned(_SelectedPatients) then
    _SelectedPatients.lvGnPtList.Items.Clear;

  pnltop.Height := pnlTop.Height + 1;
  Application.ProcessMessages;
  pnltop.Height := pnlTop.Height - 1;
end;

procedure TfrmGNPtSel.SetCaptionTop;
{ Show patient list name, set top list to 'Select ...' if appropriate. }
var
  X: string;
begin
  X := '';
  lblPatient.Caption := '&Patients';
  if (not User.IsReportsOnly) then
    begin
      case _GroupOptions.SrcType of
        TAG_SRC_DFLT:
          if fDfltSrc <> '' then
            lblPatient.Caption := '&Patients (' + FDfltSrc + ')'
          else
            lblPatient.Caption := '&Patients';
        TAG_SRC_PROV:
          X := 'Provider';
        TAG_SRC_TEAM:
          X := 'Team';
        TAG_SRC_SPEC:
          X := 'Specialty';
        TAG_SRC_CLIN:
          X := 'Clinic';
        TAG_SRC_WARD:
          X := 'Ward';
        TAG_SRC_PCMM:
          X := 'Pcmm Team'; // TDP - Added 5/27/2014 to handle PCMM team addition
//        TAG_SRC_ALL: { Nothing }
//          ;
      end; // case stmt
    end; // begin
  if Length(X) > 0 then
    with cboPatient do
      begin
        RedrawSuspend(Handle);
        ClearIDInfo;
        ClearTop;
        Text := '';
        Items.Add('^Select a ' + X + '...');
        Items.Add(LLS_LINE);
        Items.Add(LLS_SPACE);
        cboPatient.InitLongList('');
        RedrawActivate(cboPatient.Handle);
      end;
end;

{ List Source events: }

procedure TfrmGNPtSel.SetPtListTop(IEN: Int64);
{ Sets top items in patient list according to list source type and optional list source IEN. }
var
  NewTopList: string;
  FirstDate, LastDate: string;
begin
  // NOTE:  Some pieces in RPC returned arrays are rearranged by ListPtByDflt call in rCore!
  IsRPL := User.IsRPL;
  if (IsRPL = '') then // First piece in ^VA(200,.101) should always be set (to 1 or 0).
    begin
      InfoBox('Patient selection list flag not set.', 'Incomplete User Information', MB_OK);
      RPLProblem := True;
      Exit;
    end;
  // FirstDate := 0; LastDate := 0; // Not req'd, but eliminates hint.
  // Assign list box TabPosition, Pieces properties according to type of list to be displayed.
  // (Always use Piece "2" as the first in the list to assure display of patient's name.)
  cboPatient.pieces := '2,3'; // This line and next: defaults set - exceptions modifield next.
  cboPatient.tabPositions := '20,28';
  if ((_GroupOptions.SrcType = TAG_SRC_DFLT) and (FDfltSrc = 'Combination')) then
    begin
      cboPatient.pieces := '2,3,4,5,9';
      cboPatient.tabPositions := '20,28,35,45';
    end;
  if ((_GroupOptions.SrcType = TAG_SRC_DFLT) and
    (FDfltSrcType = 'Ward')) or (_GroupOptions.SrcType = TAG_SRC_WARD) then
    cboPatient.tabPositions := '35';
  if ((_GroupOptions.SrcType = TAG_SRC_DFLT) and
    (AnsiStrPos(pChar(FDfltSrcType), 'Clinic') <> nil)) or (_GroupOptions.SrcType = TAG_SRC_CLIN) then
    begin
      cboPatient.pieces := '2,3,9';
      cboPatient.tabPositions := '24,45';
    end;
  NewTopList := IntToStr(_GroupOptions.SrcType) + U + IntToStr(IEN); // Default setting.
  if (_GroupOptions.SrcType = TAG_SRC_CLIN) then
    with _GroupOptions.cboDateRange do
      begin
        if ItemID = '' then
          Exit; // Need both clinic & date range.
        FirstDate := Piece(ItemID, ';', 1);
        LastDate := Piece(ItemID, ';', 2);
        NewTopList := IntToStr(_GroupOptions.SrcType) + U + IntToStr(IEN) + U + ItemID; // Modified for clinics.
      end;
  if NewTopList = _GroupOptions.LastTopList then
    Exit; // Only continue if new top list.
  _GroupOptions.LastTopList := NewTopList;
  RedrawSuspend(cboPatient.Handle);
  ClearIDInfo;
  cboPatient.ClearTop;
  cboPatient.Text := '';
  if (IsRPL = '1') then // Deal with restricted patient list users.
    begin
      RPLJob := MakeRPLPtList(User.RPLList); // MakeRPLPtList is in rCore, writes global "B" x-ref list.
      if (RPLJob = '') then
        begin
          InfoBox('Assignment of valid OE/RR Team List Needed.', 'Unable to build Patient List', MB_OK);
          RPLProblem := True;
          Exit;
        end;
    end
  else
    begin
      case _GroupOptions.SrcType of
        TAG_SRC_DFLT:
          ListPtByDflt(cboPatient.Items);
        TAG_SRC_PROV:
          ListPtByProvider(cboPatient.Items, IEN);
        TAG_SRC_TEAM:
          ListPtByTeam(cboPatient.Items, IEN);
        TAG_SRC_SPEC:
          ListPtBySpecialty(cboPatient.Items, IEN);
        TAG_SRC_CLIN:
          ListPtByClinic(cboPatient.Items, _GroupOptions.cboList.ItemIEN, FirstDate, LastDate);
        TAG_SRC_WARD:
          ListPtByWard(cboPatient.Items, IEN);
        // TDP - Added 5/27/2014 to handle PCMM team addition
        TAG_SRC_PCMM:
          ListPtByPcmmTeam(cboPatient.Items, IEN);
        TAG_SRC_ALL:
          ListPtTop(cboPatient.Items);
      end;
    end;
  if _GroupOptions.cboList.Visible then
    lblPatient.Caption := '&Patients (' + _GroupOptions.cboList.Text + ')';
  if _GroupOptions.SrcType = TAG_SRC_ALL then
    lblPatient.Caption := '&Patients (All Patients)';
  with cboPatient do
    if ShortCount > 0 then
      begin
        Items.Add(LLS_LINE);
        Items.Add(LLS_SPACE);
      end;
  cboPatient.Caption := lblPatient.Caption;
  cboPatient.InitLongList('');
  RedrawActivate(cboPatient.Handle);
end;

procedure TfrmGNPtSel.pnlTopResize(Sender: TObject);
{adjust size of the Group encounter info area}
begin
  if assigned(_GroupEncounter) then
    pnlGroupEncounter.Height := _GroupEncounter.getHeight;
end;

procedure TfrmGNPtSel.setEncounter;
{update global uCore.Encounter properties based on the selected values}
begin
  if assigned(_GroupEncounter) then
    _GroupEncounter.setEncounter;
end;

procedure TfrmGNPtSel.setLayout(aLayout: string);
begin
  pnlPtListToolbar.Visible := aLayout = 'DEBUG';
  pnlPtListToolbar.Top := 0;
  pnlTop.Top := pnlPtListToolbar.Height;
  bvlTool.Visible  := not (aLayout = 'DEBUG');
//  bbInquiryDemographics.Visible  := not (aLayout = 'DEBUG');
  _SelectedPatients.tbSelectedPatients.Visible := aLayout = 'DEBUG';
  _SelectedPatients.BitBtn1.Visible := not (aLayout = 'DEBUG');
  _SelectedPatients.BitBtn2.Visible := not (aLayout = 'DEBUG');
end;

function TfrmGNPtSel.isComplete: Boolean;
begin
  Result := _GroupEncounter.isComplete;
end;

procedure TfrmGNPtSel.setActionStatus;
begin
  if assigned(_SelectedPatients) then
    cmdOK.Enabled := _SelectedPatients.lvGnPtList.Items.Count > 0;
end;

function TfrmGNPtSel.PatientsCount: Integer;
begin
  Result := 0;
  if assigned(_SelectedPatients) then
    Result := _SelectedPatients.lvGnPtList.Items.Count;
end;

end.
