unit fGN_NoteDeleteReason;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, VA508AccessibilityManager, fBase508Dialog, fBase508Form;

type
  TfrmNoteDelReason = class(TfrmBase508Dialog)
    lblInstruction: TStaticText;
    radPrivacy: TRadioButton;
    radAdmin: TRadioButton;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  end;

function SelectDeleteReason(ANote: Integer): string;

implementation

{$R *.DFM}

uses ORFn, rTIU, uConst;

const
  TX_REQRSN = 'A reason must be selected, otherwise press cancel.';
  TC_REQRSN = 'Reason Required';

function SelectDeleteReason(ANote: Integer): string;
var
  frmNoteDelReason: TfrmNoteDelReason;
begin
  Result := DR_NOTREQ;
  if JustifyDocumentDelete(ANote) then
  begin
    Result := DR_CANCEL;
    frmNoteDelReason := TfrmNoteDelReason.Create(Application);
    try
      ResizeFormToFont(TForm(frmNoteDelReason));
      if frmNoteDelReason.ShowModal = mrOK then
      with frmNoteDelReason do
      begin
        if radPrivacy.Checked then Result := DR_PRIVACY;
        if radAdmin.Checked then Result := DR_ADMIN;
      end;
    finally
      frmNoteDelReason.Release;
    end;
  end;
end;

procedure TfrmNoteDelReason.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  inherited;
  CanClose := (ModalResult = mrCancel)
    or (radPrivacy.Checked or radAdmin.Checked);
  if not CanClose then
    InfoBox(TX_REQRSN, TC_REQRSN, MB_OK);
end;

end.
