unit fGN_MainFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, ToolWin, StdCtrls, Menus,
  uCore, fGN_Page, uConst, fBase508Form, VA508AccessibilityManager,
  uPCE, ShellAPI, uInit, ORSystem, Vcl.Buttons, Vcl.ActnList,
  System.Actions, Vcl.StdActns, System.ImageList, Vcl.ImgList, System.UITypes,
  uGN_Const;

type
  TfrmMainFrame = class(TfrmBase508Form)
    pnlPage: TPanel;
    mnuGNMain: TMainMenu;
    Help1: TMenuItem;
    LastBroker1: TMenuItem;
    Font1: TMenuItem;
    Contents1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    File1: TMenuItem;
    Exit1: TMenuItem;
    pnlToolbar: TPanel;
    alMain: TActionList;
    acPtSelector: TAction;
    BitBtn1: TBitBtn;
    acNoteCreate: TAction;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    acNewGroupNote: TAction;
    BitBtn4: TBitBtn;
    acExitGN: TAction;
    acTopToolbar: TAction;
    ools1: TMenuItem;
    oolbaratthetop1: TMenuItem;
    pnlMain: TPanel;
    bvlTool: TBevel;
    acAbout: TAction;
    acLastRPC: TAction;
    acHelpContents: TAction;
    acHelpPosition: TAction;
    HelpMenuonRight1: TMenuItem;
    acShowDisabled: TAction;
    ShowDisabledButtons1: TMenuItem;
    Debug1: TMenuItem;
    acChangeLog: TAction;
    N2: TMenuItem;
    ChangeLog1: TMenuItem;
    N3: TMenuItem;
    SelectPatients1: TMenuItem;
    CreateGroupNote1: TMenuItem;
    StartNewGroupNote1: TMenuItem;
    acDebugLayout: TAction;
    DebugLayout1: TMenuItem;
    sbMain: TStatusBar;
    ac8: TAction;
    ac10: TAction;
    ac12: TAction;
    ac14: TAction;
    ac18: TAction;
    ppFontSize: TPopupMenu;
    N81: TMenuItem;
    N101: TMenuItem;
    N121: TMenuItem;
    N141: TMenuItem;
    N181: TMenuItem;
    acAppLog: TAction;
    N82: TMenuItem;
    N102: TMenuItem;
    N122: TMenuItem;
    N142: TMenuItem;
    N182: TMenuItem;
    Debug2: TMenuItem;
    SelectPatients2: TMenuItem;
    OneClickSelection1: TMenuItem;
    Select1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure LastBroker1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure UMShowPage(var Message: TMessage); message UM_SHOWPAGE;
    procedure WMSetFocus(var Message: TMessage); message WM_SETFOCUS;
    procedure FormDestroy(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure acPtSelectorExecute(Sender: TObject);
    procedure acNoteCreateExecute(Sender: TObject);
    procedure acNewGroupNoteExecute(Sender: TObject);
    procedure WindowClose1Execute(Sender: TObject);
    procedure acExitGNExecute(Sender: TObject);
    procedure acTopToolbarExecute(Sender: TObject);
    procedure acAboutExecute(Sender: TObject);
    procedure acLastRPCExecute(Sender: TObject);
    procedure acHelpPositionExecute(Sender: TObject);
    procedure acShowDisabledExecute(Sender: TObject);
    procedure acChangeLogExecute(Sender: TObject);
    procedure acDebugLayoutExecute(Sender: TObject);
    procedure ac8Execute(Sender: TObject);
    procedure ac10Execute(Sender: TObject);
    procedure ac12Execute(Sender: TObject);
    procedure ac18Execute(Sender: TObject);
    procedure ac14Execute(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FClosing: Boolean;
    FLastPage: TfrmPage;
    procedure ChangeFont(aNewFontSize: Integer);
    procedure timeOutAction;
    procedure setActionStatus;
  public
    property Closing: Boolean read FClosing;
    procedure SwitchTo(NewForm: TfrmPage);
    procedure _UM_GNSELECT(var Message: TMessage); message UM_GNSELECT;
    procedure _UM_GNDEBUG(var Message: TMessage); message UM_GNDEBUG;
    procedure _UM_GNSELECTPATIENT(var Message: TMessage); message UM_GNSELECTPATIENT;
  end;

var
  frmMainFrame: TfrmMainFrame;
  CloseFromMain: Boolean = False;
  DEAContext: Boolean = False;
  DelayReviewChanges: Boolean = False;

implementation

{$R *.dfm}

uses ORNet, ORFn,
  fGN_PtSel, fGN_Encounter,
  rMisc, rGN_Core, VAUtils, uGN_Utils,
  fGN_GroupEncounter, fGN_About, fEncounterFrame, uGN_ChangeLog, uGN_RPCLog,
  fRptBox, dmGN_Common, fGN_SelectedPatients, Math, TRPCB;

procedure TfrmMainFrame.FormCreate(Sender: TObject);
var
  b: Boolean;
begin
  b := False;
  try
    b := ConnectToServer('OR CPRS GUI CHART') and
{$IFDEF DEBUG}
      IsCorrectVersion(True);
{$ELSE}
      IsCorrectVersion(False);
{$ENDIF}
  except
    on E: EBrokerError do
      ShowMessage(E.Message);
  end;
  if not b then
    Application.Terminate
  else
  begin
    SizeHolder := TSizeHolder.Create; // 2FA - adding SizeHolder

    User := TUser.Create;
    Encounter := TEncounter.Create;

    Changes := TChanges.Create;
    if User.IsProvider then
      Encounter.Provider := User.DUZ;

    Caption := TX_IN_USE + MixedCase(User.Name) + '  (' +
      RPCBrokerV.Server + ')';

    sbMain.Panels[1].Text := MixedCase(User.Name);
    sbMain.Panels[2].Text := RPCBrokerV.Server + ':' +
      IntToStr(RPCBrokerV.ListenerPort);

    frmGNPtSel := TfrmGNPtSel.Create(self);
    setFormParented(frmGNPtSel, pnlPage);
    frmGNPtSel.OneClick := OneClickSelection1.Checked;

    frmGNEncounter := TfrmGNEncounter.Create(self);
    frmGNEncounter.Parent := pnlPage;
    frmGNEncounter.Align := alClient;
    frmGNEncounter.BorderStyle := bsNone;

    Application.ShowHint := True; // rpk 1/21/2012                        ICD-10

    ChangeFont(UserFontSize);
    SetUserBounds(TControl(frmMainFrame));

    if FindCmdLineSwitch('AAVIEW') then
      begin
        acDebugLayout.Checked := False;
        acDebugLayout.Execute;
        SwitchTo(frmGNEncounter);
        frmGNEncounter.lstPatients.Align := alClient;
        frmGNEncounter.lstPatients.Color := clCream;
        acNewGroupNote.Visible := False;
        acPtSelector.Visible := False;
        SelectPatients2.Visible := true;
        SelectPatients1.Visible := False;
        Select1.Visible := False;
      end
    else
      SwitchTo(frmGNPtSel);

    GImplementationDate := GetImplementationDate(); // rpk 2/14/2012      ICD-10

    InitTimeOut(nil, timeOutAction);
    UpdateTimeOutInterval(User.DTIME * 1000); // DTIME * 1000 mSec

    if acHelpPosition.Checked then
      MenuItemMoveRight(mnuGNMain.Handle, Help1.Command);

    Debug1.Visible := HasSecurityKey(GN_GUI_SECURITY_KEY)
{$IFDEF DEBUG}
      or True
{$ENDIF}
      ;
    SplashHide;
  end;
end;

procedure TfrmMainFrame.FormDestroy(Sender: TObject);
begin
  Encounter.Free;
  User.Free;
  SizeHolder.Free; // 2FA - added component
  inherited;
end;

procedure TfrmMainFrame.SwitchTo(NewForm: TfrmPage);
begin
  if FLastPage <> NewForm then
  begin
    if (FLastPage <> nil) then
    begin
      if assigned(FLastPage.Menu) then
        mnuGNMain.Unmerge(FLastPage.Menu);
      FLastPage.Hide;
    end;
    if assigned(NewForm) then
    begin
      if assigned(NewForm.Menu) then
        mnuGNMain.Merge(NewForm.Menu);
      NewForm.Show;
    end;
    FLastPage := NewForm;
    if NewForm <> nil then
    begin
      NewForm.BringToFront;
      NewForm.FocusFirstControl;
      Application.ProcessMessages;
    end;
  end;

  if acHelpPosition.Checked then
    MenuItemMoveRight(mnuGNMain.Handle, Help1.Command);
  MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);

  PostMessage(Handle, UM_SHOWPAGE, 0, 0);
  setActionStatus;
end;

procedure TfrmMainFrame.LastBroker1Click(Sender: TObject);
begin
  ShowBroker;
end;

procedure TfrmMainFrame.ac10Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(10);
end;

procedure TfrmMainFrame.ac12Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(12);
end;

procedure TfrmMainFrame.ac18Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(18);
end;

procedure TfrmMainFrame.ac8Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(8);
end;

procedure TfrmMainFrame.acAboutExecute(Sender: TObject);
begin
  inherited;
  ShowAbout;
end;

procedure TfrmMainFrame.acChangeLogExecute(Sender: TObject);
begin
  inherited;
  ReportBox(ChangeLog, 'Change Log', False);
end;

procedure TfrmMainFrame.acDebugLayoutExecute(Sender: TObject);
begin
  inherited;
  acDebugLayout.Checked := not acDebugLayout.Checked;

  SelectPatients1.Visible := not acDebugLayout.Checked;
  SelectPatients2.Visible := acDebugLayout.Checked;

  if assigned(frmGNEncounter) then
  begin
    frmGNEncounter.acDebugView.Checked := acDebugLayout.Checked;
    frmGNEncounter.acSelectPatients.Visible := acDebugLayout.Checked;
    if acDebugLayout.Checked then
      frmGNEncounter.setLayout('DEBUG')
    else
      frmGNEncounter.setLayout('');
  end;

  if assigned(frmGNPtSel) then
  begin
    if acDebugLayout.Checked then
      frmGNPtSel.setLayout('DEBUG')
    else
      frmGNPtSel.setLayout('');
  end;

  sbMain.Visible := acDebugLayout.Checked;
  acNoteCreate.Visible := not acDebugLayout.Checked;

  if acDebugLayout.Checked then
  begin
    pnlToolbar.Align := alTop;
    bvlTool.Align := alTop;
    Caption := 'Group Notes/Encounters';
  end
  else
  begin
    pnlToolbar.Align := alBottom;
    bvlTool.Align := alBottom;
    Caption := TX_IN_USE + MixedCase(User.Name) + '  (' +
      RPCBrokerV.Server + ')';
  end;

  acTopToolbar.Checked := acDebugLayout.Checked;
  pnlToolbar.Visible := not acDebugLayout.Checked;

  setActionStatus;

  MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);

  width := width + 1;
  Application.ProcessMessages;
  width := width - 1;

end;

procedure TfrmMainFrame.acExitGNExecute(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmMainFrame.acHelpPositionExecute(Sender: TObject);
begin
  inherited;
  acHelpPosition.Checked := not acHelpPosition.Checked;
  if acHelpPosition.Checked then
  begin
    MenuItemMoveRight(mnuGNMain.Handle, Help1.Command);
    acHelpPosition.Enabled := False;
  end;
//  MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);
end;

procedure TfrmMainFrame.acLastRPCExecute(Sender: TObject);
begin
  inherited;
  ShowBroker;
end;

procedure TfrmMainFrame.acNewGroupNoteExecute(Sender: TObject);
begin
  if assigned(frmGNEncounter) then
    frmGNEncounter.DoStartOver;
end;

procedure TfrmMainFrame.acNoteCreateExecute(Sender: TObject);
begin
  if GNPtList.Count < 1 then
    MessageDlg(TXT_NOSELECT, mtWarning, [mbOK], 0)
  else if acDebugLayout.Checked and assigned(frmGNPtSel) and not frmGNPtSel.isComplete
  then
    MessageDlg(TXT_NOENCOUNTER, mtWarning, [mbOK], 0)
  else
  begin
    if assigned(frmGNPtSel) then
      frmGNPtSel.setEncounter;

    if assigned(frmGNEncounter) then
      frmGNEncounter._PtList := GNPtList;

    SwitchTo(frmGNEncounter);
    StartOver := False;

    if acDebugLayout.Checked then
      frmGNEncounter.setLayout('DEBUG')
    else
      frmGNEncounter.setLayout('');
  end;
end;

procedure TfrmMainFrame.acPtSelectorExecute(Sender: TObject);
begin
  with frmGNEncounter do
  begin
    if GroupEdit then
      SelectedPatient := ''
    else
    begin
      if lstPatients.ItemIndex > -1 then
        SelectedPatient :=
          TPatient(lstPatients.Items.Objects[lstPatients.ItemIndex]).DFN;
    end;
    tbAllPatients.Down := False;
    GroupEdit := False;
  end;
  SwitchTo(frmGNPtSel);
end;

procedure TfrmMainFrame.acShowDisabledExecute(Sender: TObject);
begin
  inherited;
  acShowDisabled.Checked := not acShowDisabled.Checked;
  setActionStatus;
end;

procedure TfrmMainFrame.ac14Execute(Sender: TObject);
begin
  inherited;
  ChangeFont(14);
end;

procedure TfrmMainFrame.acTopToolbarExecute(Sender: TObject);
begin
  inherited;
  acTopToolbar.Checked := not acTopToolbar.Checked;
  if acTopToolbar.Checked then
  begin
    pnlToolbar.Align := alTop;
    bvlTool.Align := alTop;
  end
  else
  begin
    pnlToolbar.Align := alBottom;
    bvlTool.Align := alBottom;
  end;
end;

procedure TfrmMainFrame.ChangeFont(aNewFontSize: Integer);
var
  i: Integer;
  xScale, yScale: Real;

  procedure getScale(aSize: Integer; var X, Y: Real);
  begin
    X := TextWidthByFont(Font.Handle,
      'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz') / 52;
    Y := getMainFormTextHeight;

    Font.Size := aSize;

    X := (TextWidthByFont(Font.Handle,
      'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz') / 52) / X;
    Y := getMainFormTextHeight / Y;

    X := width * X;
    Y := height * Y;
  end;

begin
  getScale(aNewFontSize, xScale, yScale);

  Repaint;

  if assigned(frmGNPtSel) then
    frmGNPtSel.SetFontSize(aNewFontSize);
  if assigned(frmGNEncounter) then
    frmGNEncounter.SetFontSize(aNewFontSize);

  pnlToolbar.height := 22 + // default margins for panel and buttons
    getMainFormTextHeight;

  ac8.Checked := aNewFontSize = 8;
  ac10.Checked := aNewFontSize = 10;
  ac12.Checked := aNewFontSize = 12;
  ac14.Checked := aNewFontSize = 14;
  ac18.Checked := aNewFontSize = 18;

  for i := 0 to pnlToolbar.ControlCount - 1 do
    if (pnlToolbar.Controls[i] is TBitBtn) and
      (TBitBtn(pnlToolbar.Controls[i]).Tag = 0) then
      adjustBitBtn(TBitBtn(pnlToolbar.Controls[i]));

  AdjustFormSize(self, round(xScale), round(yScale));

  adjustFormPosition(self);

  setLogFontSize(aNewFontSize);
end;

procedure TfrmMainFrame.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FClosing := True;
  try
    ShutDownTimeout;
  except
    on E: exception do
      InfoBox(E.Message, 'Error', MB_OK);
  end;

  try
    CleanPtList(GNPtList);
  except
    on E: exception do
      ShowMessage(E.Message);
  end;

  SaveUserBounds(self);
  CloseFromMain := True;

  RPCLogSaveAll;

end;

procedure TfrmMainFrame.FormResize(Sender: TObject);
begin
  sbMain.Panels[1].width := 24 + Canvas.TextWidth(sbMain.Panels[1].Text);
  sbMain.Panels[2].width := 24 + Canvas.TextWidth(sbMain.Panels[2].Text);
  sbMain.Panels[0].width := sbMain.width - sbMain.Panels[1].width -
    sbMain.Panels[2].width;
  self.Repaint;
end;

procedure TfrmMainFrame.FormShow(Sender: TObject);
begin
  inherited;
  if FindCmdLineSwitch('AAVIEW') then
    begin
      if assigned(frmGNPtSel) and
        (frmGNPtSel.PatientsCount < 1) then
          postMessage(handle,UM_GNSELECTPATIENT,0,0);
    end;
  MenuItemMoveRight(mnuGNMain.Handle, Debug1.Command);
end;

procedure TfrmMainFrame.UMShowPage(var Message: TMessage);
begin
  if FLastPage <> nil then
    FLastPage.DisplayPage;
end;

procedure TfrmMainFrame.WindowClose1Execute(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmMainFrame.WMSetFocus(var Message: TMessage);
begin
  if (FLastPage <> nil) and (not(csDestroying in FLastPage.ComponentState)) and
    FLastPage.Visible then
    FLastPage.FocusFirstControl;
end;

procedure TfrmMainFrame.Contents1Click(Sender: TObject);
var
  RC: Integer;
  X, AFile, Param: String;
begin
  RC := 0;
  X := Contents1.Hint;
  AFile := Piece(X, ' ', 1);
  Param := Copy(X, Length(AFile) + 1, Length(X));
  try
    RC := ShellExecute(Handle, 'open', PChar(AFile), PChar(Param), '',
      SW_NORMAL);
  except
    on E: exception do
      if RC < 32 then
        InfoBox('Error opening help file' + CRLF + CRLF + E.Message + CRLF +
          '(RC = ' + IntToStr(RC) + ')', 'Error', MB_OK);
  end;
end;

procedure TfrmMainFrame.timeOutAction;
begin
  Close;
end;

procedure TfrmMainFrame.setActionStatus;
begin
  acPtSelector.Enabled := (FLastPage <> frmGNPtSel);
  acNewGroupNote.Enabled := (FLastPage <> frmGNPtSel);
  acNoteCreate.Enabled := ((FLastPage = frmGNPtSel) and (GNPtList.Count > 0));
  acPtSelector.Visible := (acPtSelector.Enabled or acShowDisabled.Checked)
    and not acDebugLayout.Checked;
  acNewGroupNote.Visible := (acNewGroupNote.Enabled or acShowDisabled.Checked)
    and not acDebugLayout.Checked;
  acNoteCreate.Visible := not acDebugLayout.Checked and
    (acNoteCreate.Enabled or acShowDisabled.Checked);
end;

procedure TfrmMainFrame._UM_GNSELECT(var Message: TMessage);
begin
  setActionStatus;
  if assigned(frmGNPtSel) then
    frmGNPtSel.setActionStatus;
end;

procedure TfrmMainFrame._UM_GNSELECTPatient(var Message: TMessage);
begin
  if assigned(frmGNEncounter) then
    frmGNEncounter.acSelectPatients.Execute;
end;

procedure TfrmMainFrame._UM_GNDEBUG(var Message: TMessage);
begin
  if assigned(frmEncounterFrame) then
    with frmEncounterFrame do
    begin
      mmLog.Visible := Message.WParam = 1;
      if mmLog.Visible then
        tabControl.Top := mmLog.height;
    end;
  Application.ProcessMessages;
end;

{$IFDEF DEBUG_AA}

function getParam(aKey:String;aDefault: String = ''):String;
var
  i: Integer;
  Param: String;
begin
  Result := aDefault;
  for I := 1 to ParamCount do
  begin
    Param := ParamStr(I);
    if copy(Param,1,Length(aKey)) = aKey then
      begin
        Result := piece(Param,'=',2);
        Exit;
      end;
  end;
end;

initialization
  _AV :=  getParam('/AV=','');
{$ENDIF}

end.
