unit fGN_GroupEncounter;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, fBase508Form, Vcl.StdCtrls, ORDtTm,
  ORCtrls, Vcl.ExtCtrls, VA508AccessibilityManager, System.UITypes;

type
  TfrmGN_GroupEncounter = class(TfrmBase508Form)
    pnlEncounterGroupData: TPanel;
    Label3: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    cboPtProvider: TORComboBox;
    cboNewVisit: TORComboBox;
    dtVisit: TORDateBox;
    procedure cboPtProviderNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure cboNewVisitNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure dtVisitChange(Sender: TObject);
    procedure cboNewVisitExit(Sender: TObject);
    procedure cboNewVisitChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure setEncounter;
    procedure Init;
    function getHeight: Integer;
    function isComplete: Boolean;
  end;

implementation

{$R *.dfm}

uses
  rCore, uCore, rPCE;

procedure TfrmGN_GroupEncounter.cboNewVisitChange(Sender: TObject);
begin
  inherited;
  { if not IsValidLocation(cboNewVisit.ItemIEN) then
    begin
    ShowMessage('Invalid location for Group Notes.');
    cboNewVisit.ItemIndex := -1;
    Exit;
    end; }
end;

procedure TfrmGN_GroupEncounter.cboNewVisitExit(Sender: TObject);
begin
  inherited;
  if cboNewVisit.ItemIEN < 1 then
    Exit;
  { if not IsValidLocation(cboNewVisit.ItemIEN) then
    begin
    ShowMessage('Invalid location for Group Notes.');
    cboNewVisit.ItemIndex := -1;
    cboNewVisit.SetFocus;
    end; }
end;

procedure TfrmGN_GroupEncounter.cboNewVisitNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  inherited;
  cboNewVisit.ForDataUse(SubSetOfNewLocs(StartFrom, Direction));
end;

procedure TfrmGN_GroupEncounter.cboPtProviderNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
begin
  inherited;
  cboPtProvider.ForDataUse(SubSetOfProviders(StartFrom, Direction));
end;

procedure TfrmGN_GroupEncounter.dtVisitChange(Sender: TObject);
begin
  inherited;
  if dtVisit.FMDateTime > FMNow then
  begin
    MessageDlg('Future date/time is not allowed', mtWarning, [mbOK], 0);
    dtVisit.FMDateTime := FMNow;
  end;
end;

procedure TfrmGN_GroupEncounter.FormCreate(Sender: TObject);
begin
  inherited;
  Hide;
end;

procedure TfrmGN_GroupEncounter.setEncounter;
begin
  if trim(cboNewVisit.Text) = '' then
    cboNewVisit.ItemIndex := -1;
  if (cboNewVisit.ItemIndex > -1) then
  begin
    Encounter.Location := cboNewVisit.ItemIEN;
    Encounter.LocationName := cboNewVisit.Text;
    Encounter.VisitCategory := GetVisitCat('A', Encounter.Location, False);
  end
  else
  begin
    Encounter.Location := 0;
    Encounter.LocationName := '';
  end;
  if dtVisit.FMDateTime > 0 then
    Encounter.DateTime := dtVisit.FMDateTime;
  if cboPtProvider.ItemIEN > 0 then
  begin
    Encounter.Provider := cboPtProvider.ItemIEN;
    { $ IFDEF GROUPNOTES }
    { $ ELSE }
    // Encounter.ProviderName := cboPtProvider.Text;
    { $ ENDIF }
  end;
end;

procedure TfrmGN_GroupEncounter.Init;
begin
  cboNewVisit.LongList := True;
  cboNewVisit.InitLongList('');
  if (Encounter.Location > 0) then
    cboNewVisit.SelectByIEN(Encounter.Location);

  cboPtProvider.LongList := True;
  cboPtProvider.InitLongList(Encounter.ProviderName);
  cboPtProvider.SelectByIEN(Encounter.Provider);

  dtVisit.FMDateTime := FMNow;
end;

function TfrmGN_GroupEncounter.getHeight: Integer;
var
  c: TControl;
  ii, i: Integer;
begin
  ii := 0;
  for i := 0 to pnlEncounterGroupData.ControlCount - 1 do
  begin
    c := TControl(pnlEncounterGroupData.Controls[i]);
    if c.Name = '' then
      Continue;
    ii := ii + c.Height + c.Margins.Top + c.Margins.Bottom;
  end;
  ii := ii + pnlEncounterGroupData.Margins.Top +
    pnlEncounterGroupData.Margins.Bottom;
  Result := ii + 6;
end;

function TfrmGN_GroupEncounter.isComplete: Boolean;
begin
  setEncounter;
  Result := (Encounter.Location > 0) and (Encounter.Provider > 0) and
    (Encounter.DateTime > 0);
end;

end.
