unit fGN_Debug;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, fBase508Form, VA508AccessibilityManager,
  Vcl.StdCtrls, Vcl.ComCtrls, Vcl.ExtCtrls, oGN_PtData, uCore, System.Actions,
  Vcl.ActnList, Vcl.Buttons;

type
  TfrmGN_Debug = class(TfrmBase508Form)
    pnlCanvas: TPanel;
    splDebug: TSplitter;
    tv: TTreeView;
    pnlTools: TPanel;
    sb: TStatusBar;
    pnlLeft: TPanel;
    Panel1: TPanel;
    pnlDetails: TPanel;
    edTarget: TEdit;
    ActionList1: TActionList;
    acAllTypes: TAction;
    mmDetails: TMemo;
    lblItem: TLabel;
    Label1: TLabel;
    procedure tvChange(Sender: TObject; Node: TTreeNode);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure edTargetKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    { Private declarations }
    indent, indentStep: String;
    _Ignore: Boolean;
    procedure LogClear;
    procedure UpdateDebugInfo(aPatientData: TPatientData); overload;
    procedure UpdateDebugInfo(anEncounter: TEncounter); overload;
    // procedure AddPatientToTree(aTree:TTreeView;aPatient:TPatient;aRoot:TTreeNode = nil);
    procedure doTVChange(Node: TTreeNode);
    procedure doTargetFind(aTarget: String);
    procedure setTypeNode(aNode: TTreeNode; aName, aTypeName: String);
    procedure addStartLine(aLine: String);
    procedure addEndLine(aLine: String);

  public
    { Public declarations }
    procedure LogUpdate(aText: String);
    procedure UpdateDebugInfo(aName: String; aPatientData: TPatientData;
      anEncounter: TEncounter; aClear: Boolean = TRUE); overload;
    function GetPatientData(APatient: TPatient): TPatientData; overload;
    function GetPatientData(APatientDFN: String): TPatientData; overload;
    procedure populatePtList(aList: TList);
  end;

var
  frmGN_Debug: TfrmGN_Debug;

procedure ShowDebug;
procedure CreateDebug;

implementation

uses
  uPCE, ORFn, rGN_Core, rTIU, uGN_Utils, System.RTTI, fEncounterFrame;

const
  CRLF = #13#10;

{$R *.dfm}

procedure CreateDebug;
begin
  if not assigned(frmGN_Debug) then
    Application.CreateForm(TfrmGN_Debug, frmGN_Debug);
end;

procedure ShowDebug;
begin
  if not assigned(frmGN_Debug) then
    CreateDebug;
  if assigned(frmGN_Debug) then
    frmGN_Debug.Show;
end;

/// /////////////////////////////////////////////////////////////////////////////

procedure TfrmGN_Debug.tvChange(Sender: TObject; Node: TTreeNode);
begin
  if _Ignore then
    exit;
  doTVChange(Node);
end;

procedure TfrmGN_Debug.addStartLine(aLine: String);
begin
  mmDetails.Lines.Add(indent + aLine + '  -- begin --');
  indent := indent + indentStep;
end;

procedure TfrmGN_Debug.addEndLine(aLine: String);
begin
  indent := copy(indent, 1, Length(indent) - Length(indentStep));
  mmDetails.Lines.Add(indent + aLine + '  --  end  --');
end;

procedure TfrmGN_Debug.doTVChange(Node: TTreeNode);
var
  ddd: TObject;
  // pd: TPatientData;

const
  fmtNameValue = '%-25.25s %s';
  fmtNameClassValue = '%-25.25s (%-25.25s) %s';

  function getPatientText(aPt: TPatient): String;
  begin
    Result := 'Name: ' + Char(VK_TAB) + aPt.Name + CRLF + 'DFN: ' + Char(VK_TAB)
      + aPt.DFN + CRLF + 'ICN: ' + Char(VK_TAB) + aPt.ICN + CRLF + 'SSN: ' +
      Char(VK_TAB) + aPt.SSN + CRLF + 'Age: ' + Char(VK_TAB) + IntToStr(aPt.Age)
      + CRLF + 'Sex: ' + Char(VK_TAB) + aPt.Sex + CRLF;
  end;

  function getEncounterText(anEnc: TEncounter): String;
  var
    s: String;
  begin
    Result := 'Date and Time: ' + Char(VK_TAB) +
      FormatFMDateTime('mm/dd/yyyy hh:nn', anEnc.DateTime) + CRLF +
      'Location Name: ' + Char(VK_TAB) + anEnc.LocationName + CRLF +
      'Location ID:   ' + Char(VK_TAB) + IntToStr(anEnc.Location) + CRLF +
      'Location Text: ' + Char(VK_TAB) + anEnc.LocationText + CRLF +
      'Visit Str:     ' + Char(VK_TAB) + anEnc.VisitStr + CRLF +
      'Visit Category:' + Char(VK_TAB) + anEnc.VisitCategory + CRLF;

    if anEnc.Provider > 0 then
      s := getExternalName(IntToStr(anEnc.Provider), '200')
    else
      s := ' ';
    Result := Result + 'Provider Name: ' + Char(VK_TAB) + s + CRLF +
      'Provider ID:   ' + Char(VK_TAB) + IntToStr(anEnc.Provider);
  end;

  function getSigners(aNoteIEN: Int64): String;
  var
    sl: TStrings;
  begin
    if aNoteIEN < 1 then
    begin
      Result := 'Note is not defined';
    end
    else
    begin
      sl := GetCurrentSigners(aNoteIEN);
      if assigned(sl) then
      begin
        Result := 'Signers: ' + CRLF + CRLF + sl.Text;
      end
      else
        Result := 'No signers found';
    end;
  end;

  procedure WriteObjectRTTI(anObj: TObject);
  var
    aClassName:String;
    _Obj: TObject;
    aContext: TRttiContext;
    aType: TRttiType;
    aField: TRttiField;
  begin
    if anObj = nil then
      exit;
    if anObj.ClassType = nil then
      exit;

    if anObj is TStringList then
      begin
        for aClassName in TStringList(anObj) do
          mmDetails.Lines.Add(indent + aClassName);
        exit;
      end;

    try
      aType := aContext.GetType(anObj.ClassType);
      for aField in aType.GetFields do
        if aField.FieldType.IsInstance then
        begin
          _Obj := nil;
//          addStartLine(aField.Name;
          try
            _Obj := aField.GetValue(anObj).AsObject;
            if assigned(_Obj) then
              aClassName := ' ('+_Obj.ClassName+ ')'
            else
              aClassName := '';
            addStartLine(aField.Name + aClassName);
            WriteObjectRTTI(_Obj);
            addEndLine(aField.Name + aClassName);
          except
            on E: Exception do
              if assigned(_Obj) then
                mmDetails.Lines.Add(_Obj.ClassName + CRLF + E.Message);
          end;
//          addEndLine(aField.Name);
        end
        else
          mmDetails.Lines.Add(indent + Format(fmtNameValue,
            [aField.Name, aField.GetValue(anObj).ToString]));
    except
      on E: Exception do
      begin
        mmDetails.Lines.Add('ClassName <' + anObj.ClassType.ClassName + '>');
        mmDetails.Text := mmDetails.Text + CRLF + E.Message;
      end;
    end;
  end;

begin
  inherited;
  mmDetails.Clear;
  lblItem.Caption := Node.Text;

  if Node.Data = nil then
    doTargetFind(Node.Text)
  else
  begin
    ddd := TObject(Node.Data);
    {
    if ddd is TPatient then
      mmDetails.Text := getPatientText(TPatient(ddd))
    else if ddd is TPatientData then
    begin
      pd := TPatientData(ddd);
      if Node.Text = 'PCEData' then
        mmDetails.Text := PCEDataToString(pd.PCEData)
      else if Node.Text = 'PtNote' then
        mmDetails.Text := EditNoteRecToStr(pd.PtNote)
      else if Node.Text = 'COSIGNERS' then
        mmDetails.Text := getSigners(pd.PtNote.NoteIEN);
    end
    else if ddd is TEncounter then
      mmDetails.Text := getEncounterText(TEncounter(ddd))
    else
    }
    WriteObjectRTTI(ddd);
  end;
end;

procedure TfrmGN_Debug.edTargetKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_RETURN then
  begin
    Key := 0;
    doTargetFind(edTarget.Text);
  end;
end;

procedure TfrmGN_Debug.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  Hide;
  Action := caNone;
end;

procedure TfrmGN_Debug.FormCreate(Sender: TObject);
begin
  inherited;
  indent := '';
  indentStep := '  ';
end;

procedure TfrmGN_Debug.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_ESCAPE then
    begin
      Key := 0;
      Hide;
    end;
end;

{ $ IFDEF DEBUG }
procedure TfrmGN_Debug.LogUpdate(aText: string);
begin
  mmDetails.Lines.Text := mmDetails.Lines.Text + aText + CRLF;
end;

procedure TfrmGN_Debug.LogClear;
begin
  mmDetails.Lines.Clear;
end;

procedure TfrmGN_Debug.UpdateDebugInfo(aPatientData: TPatientData);
begin
  if assigned(aPatientData) then
  begin
    lblItem.Caption := aPatientData.Patient.Name;
    LogUpdate(EditNoteRecToStr(aPatientData.PtNote) + CRLF);
    LogUpdate(PCEDataToString(aPatientData.PCEData) + CRLF);
  end
  else
    LogUpdate('Patient Data not assigned' + CRLF);
end;

procedure TfrmGN_Debug.UpdateDebugInfo(anEncounter: TEncounter);
begin
  LogUpdate(EncounterToStr(anEncounter) + CRLF);
end;

procedure TfrmGN_Debug.UpdateDebugInfo(aName: String;
  aPatientData: TPatientData; anEncounter: TEncounter; aClear: Boolean = TRUE);
begin
  if aClear then
    LogClear;
  mmDetails.Text := aName;
  UpdateDebugInfo(aPatientData);
  UpdateDebugInfo(anEncounter);
end;
{ $ ENDIF }

function TfrmGN_Debug.GetPatientData(APatient: TPatient): TPatientData;
begin
  Result := nil;
  if assigned(APatient) then
    Result := GetPatientData(APatient.DFN);
end;

function TfrmGN_Debug.GetPatientData(APatientDFN: String): TPatientData;
var
  i: integer;
begin
  Result := nil;
  for i := 0 to GNPtList.Count - 1 do
  begin
    if (TPatientData(GNPtList.Items[i]).Patient.DFN = APatientDFN) then
    begin
      Result := TPatientData(GNPtList.Items[i]);
      break; // assuming there are no duplicates
    end;
  end;
end;

{
  procedure TfrmGN_Debug.AddPatientToTree(aTree:TTreeView;aPatient:TPatient;aRoot:TTreeNode = nil);
  var
  tn: TTreeNode;

  procedure setPatientNode(aTree:TTreeView;aNode:TTreeNode);
  var
  tn: TTreeNode;
  pt: TPatient;
  ptd: TPatientData;
  begin
  if TObject(aNode.Data) is TPatient then
  begin
  pt := TPatient(aNode.Data);
  ptd := GetPatientData(pt);

  tn := tv.Items.AddChild(aNode,'PtNote');
  tn.Data := ptd;
  tn := tv.Items.AddChild(aNode,'PCEData');
  tn.Data := ptd;
  tn := tv.Items.AddChild(aNode,'SIGNATURE');
  tn.Data := ptd;
  tn := tv.Items.AddChild(aNode,'COSIGNERS');
  tn.Data := ptd;
  end;
  end;

  begin
  tn := tv.Items.AddChild(nil,aPatient.Name);
  tn.Data := aPatient;
  setPatientNode(tv,tn);
  end;
}

procedure TfrmGN_Debug.populatePtList(aList: TList);
var
  ptListNode,
  Node: TTreeNode;
  i: integer;
  APatient: TPatient;

  procedure AddObjectRTTI(anObj: TObject; aNode: TTreeNode);
  var
    _Obj: TObject;
    aContext: TRttiContext;
    aType: TRttiType;
    aField: TRttiField;
    tn: TTreeNode;
  begin
    if anObj = nil then
      exit;
    if anObj.ClassType = nil then
      exit;
    try
      aType := aContext.GetType(anObj.ClassType);
      for aField in aType.GetFields do
        if aField.FieldType.IsInstance then
        begin
          _Obj := nil;
          try
            _Obj := aField.GetValue(anObj).AsObject;
            tn := tv.Items.AddChildObject(aNode, aField.Name, _Obj);

            AddObjectRTTI(_Obj, tn);
          except
            on E: Exception do
              if assigned(_Obj) then
                mmDetails.Lines.Add(_Obj.ClassName + CRLF + E.Message);
          end;
        end;
    except
      on E: Exception do
        mmDetails.Lines.Add(CRLF + 'ClassName <' + anObj.ClassType.ClassName +
          '>' + CRLF + E.Message);
    end;
  end;

begin
  tv.Items.Clear;
  tv.Items.AddObject(nil, 'ENCOUNTER', Encounter);
  tv.Items.AddObject(nil, 'SAVED ENCOUNTER', SavedEncounter);
  tv.Items.AddObject(nil, 'PATIENT', Patient);
  tv.Items.AddObject(nil, 'USER', User);
  tv.Items.AddObject(nil, 'CHANGES', Changes);
  tv.Items.AddObject(nil, 'REMOTE SITES', RemoteSites);
  tv.Items.AddObject(nil, 'BASEPCE', BasePCE);
  tv.Items.AddObject(nil, 'ENCOUNTER PCE DATA', uEncPCEData);

  if not assigned(aList) then
    exit;

   ptListNode := tv.Items.AddObject(nil, 'PATIENT LIST', aList);


  for i := 0 to aList.Count - 1 do
  begin
    APatient := TPatientData(aList.Items[i]).Patient;
    // addPatientToTree(tv,aPatient);  // debug tree support
    Node := tv.Items.AddChildObject(ptListNode, APatient.Name, APatient);
    AddObjectRTTI(APatient, Node);
  end;
end;

/// /////////////////////////////////////////////////////////////////////////////

procedure TfrmGN_Debug.doTargetFind(aTarget: String);
var
  aContext: TRttiContext;
  aType: TRttiType;
  aProperty: TRttiProperty;
  // tn: TTreeNode;
const
  fmtProperty = ' %-25.25s - %s';
begin
  LogClear;
  LogUpdate(aTarget + CRLF);
  aType := aContext.FindType(aTarget);
  if not assigned(aType) then
    exit;
  LogUpdate(aType.QualifiedName + CRLF);

  for aProperty in aType.GetProperties do
  begin
    LogUpdate(Format(fmtProperty, [aProperty.Name,
      aProperty.PropertyType.Name]));
    setTypeNode(nil, aProperty.Name, aProperty.PropertyType.Name);
  end;
end;

(*
  procedure TfrmGN_Debug.doGetTypes;
  var
  aContext: TRttiContext;
  theTypes: TArray<TRttiType>;
  aType: TRttiType;
  tn: TTreeNode;

  procedure addNode(aName:String);
  begin
  tn := tv.Items.AddChild(nil,aName);
  end;

  begin
  tv.Items.Clear;
  try
  theTypes := aContext.GetTypes;
  for aType in theTypes do
  addNode(aType.QualifiedName);
  finally

  end;
  end;
*)
procedure TfrmGN_Debug.setTypeNode(aNode: TTreeNode; aName, aTypeName: String);
var
  aContext: TRttiContext;
  aProperty: TRttiProperty;
  aType: TRttiType;
  tn: TTreeNode;
begin
  aType := aContext.FindType(aTypeName);
  if not assigned(aType) then
    exit;
  tn := tv.Items.AddChild(aNode, aName + ' (' + aTypeName + ')');
  for aProperty in aType.GetProperties do
    setTypeNode(tn, aProperty.Name, aProperty.PropertyType.Name);

end;

initialization

end.
