unit fGN_About;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, VA508AccessibilityManager, fBase508Form, Vcl.AppEvnts;

type
  TfrmAbout = class(TfrmBase508Form)
    pnlCanvas: TPanel;
    Image1: TImage;
    cmdOK: TButton;
    lblProductName: TStaticText;
    lblCompanyName: TStaticText;
    lblComments: TStaticText;
    lblCRC: TStaticText;
    lblLegalCopyright: TMemo;
    lblFileDescription: TStaticText;
    lblInternalName: TStaticText;
    lblOriginalFileName: TStaticText;
    pnlButton: TPanel;
    pnlBackground: TPanel;
    ae: TApplicationEvents;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure aeIdle(Sender: TObject; var Done: Boolean);
  private
    { Private declarations }
    fMode: String;
    procedure setMode(aMode: String);
  public
    { Public declarations }
    property Mode: String read fMode write setMode;
  end;

procedure ShowAbout;
procedure SplashAbout;
procedure SplashHide;

implementation

{$R *.DFM}

uses
  ORSystem, ORFn, VAUtils // ICD-10 Remediation
    , uGN_Utils;

var
  frmAbout: TfrmAbout;

procedure SplashHide;
begin
  if assigned(frmAbout) then
    frmAbout.Hide;
  Application.ProcessMessages;
end;

procedure SplashAbout;

begin
  if not assigned(frmAbout) then
    frmAbout := TfrmAbout.Create(Application); // show splash screen
  with frmAbout do
  begin
    Mode := 'SPLASH';
    Show;
    Refresh;
  end;
end;

procedure ShowAbout;
begin
  if not assigned(frmAbout) then
    frmAbout := TfrmAbout.Create(Application);
  try
    with frmAbout do
    begin
      Mode := 'ABOUT';
      ShowModal;
    end;
  finally
    frmAbout.Hide;
  end;
end;

procedure TfrmAbout.aeIdle(Sender: TObject; var Done: Boolean);
begin
  inherited;
  // ae.OnIdle := nil; //does not work if is hidden only once :(
  HideCaret(lblLegalCopyright.Handle);
end;

procedure TfrmAbout.FormCreate(Sender: TObject);
begin
  inherited;
  lblCompanyName.Caption := { 'Developed by the ' + } FileVersionValue
    (Application.ExeName, FILE_VER_COMPANYNAME);
  lblFileDescription.Caption := { 'Compiled: ' + } FileVersionValue
    (Application.ExeName, FILE_VER_FILEDESCRIPTION); // date
  // lblFileVersion.Caption        := FileVersionValue(Application.ExeName, FILE_VER_FILEVERSION);
  lblInternalName.Caption := FileVersionValue(Application.ExeName,
    FILE_VER_INTERNALNAME);
  lblLegalCopyright.Text := FileVersionValue(Application.ExeName,
    FILE_VER_LEGALCOPYRIGHT);
  lblOriginalFileName.Caption := FileVersionValue(Application.ExeName,
    FILE_VER_ORIGINALFILENAME); // patch
  lblProductName.Caption := FileVersionValue(Application.ExeName,
    FILE_VER_PRODUCTNAME);
  lblComments.Caption := FileVersionValue(Application.ExeName,
    FILE_VER_COMMENTS); // version comment
  lblCRC.Caption := 'CRC: ' + IntToHex(CRCForFile(Application.ExeName), 8);

{$IFDEF DEBUG}
  pnlButton.ShowCaption := True;
{$ENDIF}
  lblLegalCopyright.SelStart := Length(lblLegalCopyright.Text);
  lblLegalCopyright.SelLength := 0;
end;

procedure TfrmAbout.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_ESCAPE then
    Close;
end;

procedure TfrmAbout.setMode(aMode: string);
begin
  if aMode <> fMode then
  begin
    fMode := aMode;
    if fMode = 'SPLASH' then
    begin
      Height := Height - pnlButton.Height - getTitleHeight(self);
      lblLegalCopyright.Margins.Top := 20;
      lblLegalCopyright.Margins.Bottom := 20;
      BorderStyle := bsNone;
    end
    else
    begin
      Height := Height + pnlButton.Height + getTitleHeight(self);
      BorderStyle := bsSingle;
      lblLegalCopyright.Margins.Top := 8;
      lblLegalCopyright.Margins.Bottom := 8;
    end;
    pnlButton.Visible := fMode <> 'SPLASH';
  end;
end;

end.
