unit fSkinTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, ORCtrls, StdCtrls, ComCtrls, CheckLst, ExtCtrls, Buttons, uPCE, rPCE, ORFn,
  fPCELex, fPCEOther, rCore, fPCEBaseMain, VA508AccessibilityManager;

type
  TfrmSkinTests = class(TfrmPCEBaseMain)
    lblSkinResults: TLabel;
    lblDTRead: TLabel;
    lblReading: TLabel;
    lblDTGiven: TLabel;
    UpDnReading: TUpDown;
    EdtReading: TCaptionEdit;
    edtDtRead: TCaptionEdit;
    edtDTGiven: TCaptionEdit;
    cboSkinResults: TORComboBox;
    pnlReading: TPanel;
    procedure cboSkinResultsChange(Sender: TObject);
    procedure EdtReadingChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure UpDnReadingChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure lstCaptionListSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);

  private
    procedure setDetailsVisibility(aVisible:Boolean);
  protected
    procedure UpdateNewItemStr(var x: string); override;
    procedure UpdateControls; override;
  public
  end;

var
  frmSkinTests: TfrmSkinTests;

implementation

{$R *.DFM}

uses
  fEncounterFrame, VA508AccessibilityRouter;

procedure TfrmSkinTests.setDetailsVisibility(aVisible:Boolean);
begin
  EdtReading.Visible := aVisible;
  UpDnReading.Visible := aVisible;
  lblReading.Visible := aVisible;
end;

procedure TfrmSkinTests.cboSkinResultsChange(Sender: TObject);
var
  i: integer;
begin
  if (NotUpdating) and (cboSkinResults.Text <> '') then
  begin
    for i := 0 to lstCaptionList.Items.Count - 1 do
      if (lstCaptionList.Items[i].Selected) then
      begin
        TPCESkin(lstCaptionList.Objects[i]).Results := cboSkinResults.ItemID;
        setDetailsVisibility(UpperCase(cboSkinResults.Text) <> 'NO TAKE');
      end;
    GridChanged;
  end;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name:procedure TfrmSkinTests.EdtReadingChange(Sender: TObject);
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description:Change the reading assigned to the skin test.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmSkinTests.EdtReadingChange(Sender: TObject);
var
  x, i: integer;

begin
  if(NotUpdating) then
  begin
    x := StrToIntDef(EdtReading.Text, 0);
    for i := 0 to lstCaptionList.Items.Count-1 do
      if(lstCaptionList.Items[i].Selected) then
        TPCESkin(lstCaptionList.Objects[i]).Reading := x;

    GridChanged;
  end;
end;

procedure TfrmSkinTests.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_SkinNm;
  FPCEListCodesProc := ListSkinCodes;
  FPCEItemClass := TPCESkin;
  FPCECode := 'SK';
  PCELoadORCombo(cboSkinResults);
end;

procedure TfrmSkinTests.lstCaptionListSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  inherited;
  setDetailsVisibility(UpperCase(cboSkinResults.Text) <> 'NO TAKE');
end;

procedure TfrmSkinTests.UpdateNewItemStr(var x: string);
begin
  SetPiece(x, U, pnumSkinResults, NoPCEValue);
  SetPiece(x, U, pnumSkinReading, '0');
//  SetPiece(x, U, pnumSkinDTRead);
//  SetPiece(x, U, pnumSkinDTGiven);
end;

procedure TfrmSkinTests.UpdateControls;
var
  ok, First: boolean;
  SameRes, SameRead: boolean;
  i: integer;
  Res: string;
  Read: integer;
  Obj: TPCESkin;

begin
  inherited;
  if(NotUpdating) then
  begin
    BeginUpdate;
    try
      ok := (lstCaptionList.SelCount > 0);
      lblSkinResults.Enabled := ok;
      lblReading.Enabled := ok;
      cboSkinResults.Enabled := ok;
      EdtReading.Enabled := ok;
      UpDnReading.Enabled := ok;
      if(ok) then
      begin
        First := TRUE;
        SameRes := TRUE;
        SameRead := TRUE;
        Res := NoPCEValue;
        Read := 0;
       for i := 0 to lstCaptionList.Items.Count-1 do
        begin
          if lstCaptionList.Items[i].Selected then
          begin
            Obj := TPCESkin(lstCaptionList.Objects[i]);
            if(First) then
            begin
              First := FALSE;
              Res := Obj.Results;
              Read := Obj.Reading;
            end
            else
            begin
              if(SameRes) then
                SameRes := (Res = Obj.Results);
              if(SameRead) then
                SameRead := (Read = Obj.Reading);
            end;
          end;
        end;

        if(SameRes) then
          cboSkinResults.SelectByID(Res)
        else
          cboSkinResults.Text := '';
        if(SameRead) then
        begin
          UpDnReading.Position := Read;
          EdtReading.Text := IntToStr(Read);
          EdtReading.SelStart := length(EdtReading.Text);
        end
        else
        begin
          UpDnReading.Position := 0;
          EdtReading.Text := '';
        end;
      end
      else
      begin
        cboSkinResults.Text := '';
        EdtReading.Text := '';
      end;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmSkinTests.UpDnReadingChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  inherited;
  if(UpDnReading.Position = 0) then
    EdtReadingChange(Sender);
end;

initialization
  SpecifyFormIsNotADialog(TfrmSkinTests);

end.

