unit fEncounterFrame;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Tabs, ComCtrls, ExtCtrls, Menus, StdCtrls, Buttons, fPCEBase,
  fVisitType, fDiagnoses, fProcedure, fImmunization, fSkinTest, fPatientEd,
  fHealthFactor, fExam, uPCE, rPCE, rTIU, ORCtrls, ORFn
{ $ IFDEF GROUPNOTES}
{ $ ELSE}
//  , fEncVitals, rvitals
{ $ ENDIF}
  , fBase508Form,
  VA508AccessibilityManager, uGN_Const;

const
  //tab names
  CT_VisitNm = '&Visit Type';
  CT_DiagNm  = '&Diagnoses';
  CT_ProcNm  = '&Procedures';
  CT_ImmNm   = '&Immunizations';
  CT_SkinNm  = '&Skin Tests';
  CT_PedNm   = 'Patient &Ed';
  CT_HlthNm  = '&Health Factors';
  CT_XamNm   = 'E&xams';
  CT_VitNm   = 'Vit&als';
  CT_GAFNm   = '&GAF';

  NUM_TABS       = 3;
  TAG_VTYPE      = 10;
  TAG_DIAG       = 20;
  TAG_PROC       = 30;
  TAG_IMMUNIZ    = 40;
  TAG_SKIN       = 50;
  TAG_PED        = 60;
  TAG_HF         = 70;
  TAG_XAM        = 80;
  TAG_TRT        = 90;

  TX_NOSECTION = '-1^No sections found';
  TX_PROV_REQ = 'A primary encounter provider must be selected ' + CRLF +
                'before encounter data can be saved.' + CRLF + CRLF +
                'Select the Primary Encounter Provider on the VISIT TYPE tab.' + CRLF +
                'Otherwise, press <Cancel> to quit without saving data.';

  TC_PROV_REQ = 'Missing Primary Provider for Encounter';

type
  TfrmEncounterFrame = class(TfrmBase508Form)
    StatusBar1: TStatusBar;
    pnlPage: TPanel;
    Bevel1: TBevel;
    TabControl: TTabControl;
    mmLog: TMemo;
    ckbDebugInfo: TCheckBox;
    splDebug: TSplitter;

    procedure tabPageChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormResize(Sender: TObject);
    procedure SectionClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure TabControlChange(Sender: TObject);
    procedure TabControlChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    procedure FormShow(Sender: TObject);
    procedure TabControlEnter(Sender: TObject);
    procedure ckbDebugInfoClick(Sender: TObject);

  private
{ $ IFDEF DEBUG}
    fDebugPCE: TPCEData;
{ $ ENDIF}
    FAutoSave: boolean;
//    FSaveNeeded: boolean;
    FChangeSource: Integer;
    FCancel:  Boolean; //Indicates the cancel button has been pressed;
    FAbort: boolean; // indicates that neither OK or Cancel has been pressed
    FormList: TStringList;  //Holds the types of any forms that will be used
                            //in the frame.  They must be available at compile time
    FLastPage: TfrmPCEBase;
    FGiveMultiTabMessage: boolean;
    procedure SynchPCEData;
    procedure SwitchToPage(NewForm: TfrmPCEBase);   //was tfrmPage

    function FormListContains(item: string): Boolean;
    procedure SendData;
    procedure UpdateEncounter(PCE: TPCEData);
    procedure SetFormFonts;

    procedure doCreateForms(aLocation: Integer);
    function pageByName(aName:String): TfrmPCEBase;

  public
    procedure SelectTab(NewTabName: string);
    property ChangeSource:    Integer read FChangeSource;
    property Forms:           tstringlist read FormList;
    property Cancel:          Boolean read FCancel write FCancel;
    property Abort:          Boolean read FAbort write FAbort;

    procedure _UM_GN_ENCUPDATE(var Message: TMessage); message UM_GN_ENCUPDATE;

  end;

var
  frmEncounterFrame: TfrmEncounterFrame;
  uSCCond:              TSCConditions;
  uVisitType:           TPCEProc;       // contains info for visit type page
  uEncPCEData: TPCEData;
  uProviders: TPCEProviderList;

// Returns true if PCE data still needs to be saved - vitals/gaf are always saved
function UpdatePCE(PCEData: TPCEData; SaveOnExit: boolean = TRUE): boolean;

implementation

uses
  uCore,
  fGAF, uConst,
  rCore, fPCEProvider, rMisc, VA508AccessibilityRouter, VAUtils
  , fEncVitals,rGN_Core, oGN_PTData, uGN_Utils, uGN_RPCLog;

{$R *.DFM}

{///////////////////////////////////////////////////////////////////////////////
//Name: function TfrmEncounterFrame.FormListContains(item: string): Boolean;
//Created: 12/06/98
//By: Robert Bott
//Location: ISL
//Description: Returns a boolean value indicating if a given string exists in
// the formlist.
///////////////////////////////////////////////////////////////////////////////}
function TfrmEncounterFrame.FormListContains(item: string): Boolean;
begin
  result := false;
  if (FormList.IndexOf(item) <> -1 ) then
    result := true;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name: TfrmEncounterFrame.SwitchToPage(NewForm: tfrmPCEBase);
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Brings the selected page to the front for display.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmEncounterFrame.SwitchToPage(NewForm: tfrmPCEBase);// was TfrmPage);
{ unmerge/merge menus, bring page to top of z-order, call form-specific OnDisplay code }
begin
  if (NewForm = nil) or (FLastPage = NewForm) then Exit;
  if Assigned(FLastPage) then
    FLastPage.Hide;
  FLastPage := NewForm;
//  KeyPreview := (NewForm = frmEncVitals);
  NewForm.DisplayPage;  // this calls BringToFront for the form
{ $ IFDEF GROUPNOTES}
  NewForm.Show;
{ $ ENDIF}
end;

procedure TfrmEncounterFrame.tabPageChange(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
{ switches to form linked to NewTab }
begin
  SwitchToPage(pageByName(TabControl.Tabs[NewTab]));
end;

{ Resize and Font-Change procedures --------------------------------------------------------- }
procedure TfrmEncounterFrame.FormResize(Sender: TObject);
begin
  self.repaint;
end;

function UpdatePCE(PCEData: TPCEData; SaveOnExit: Boolean = TRUE): Boolean;
var
  AUser: string;

begin
  frmEncounterFrame := TfrmEncounterFrame.Create(Application);
  try
    frmEncounterFrame.FAutoSave := SaveOnExit;

    uEncPCEData := PCEData;
    if (uEncPCEData.Empty and ((uEncPCEData.Location = 0) or
      (uEncPCEData.VisitDateTime = 0)) and (not Encounter.NeedVisit)) then
      uEncPCEData.UseEncounter := TRUE;
    frmEncounterFrame.Caption := 'Encounter Form for ' +
      ExternalName(uEncPCEData.Location, 44) + '  (' +
      FormatFMDateTime('mmm dd,yyyy@hh:nn', uEncPCEData.VisitDateTime) + ')';

    uProviders.Assign(uEncPCEData.Providers);
    SetDefaultProvider(uProviders, uEncPCEData);
    AUser := IntToStr(uProviders.PendingIEN(False));
    if (AUser <> '0') and (uProviders.IndexOfProvider(AUser) < 0) and
      AutoCheckout(uEncPCEData.Location) then
      uProviders.AddProvider(AUser, uProviders.PendingName(False), False);

    { $ IFDEF GROUPNOTES }
    frmEncounterFrame.doCreateForms(PCEData.Location);
    { $ ELSE }
    // frmEncounterFrame.CreateChildForms(frmEncounterFrame, PCEData.Location);
    { $ ENDIF }
    SetFormPosition(frmEncounterFrame);
    ResizeAnchoredFormToFont(frmEncounterFrame);
    // SetFormPosition(frmEncounterFrame);

    with frmEncounterFrame do
    begin
      SetRPCEncLocation(PCEData.Location);
      SynchPCEData;
      TabControl.Tabindex := 0;
      TabControlChange(TabControl);

      ShowModal;
      Result := (not FCancel);
    end;
  finally
    frmEncounterFrame.Free;  // v22.11 (JD and SM)
    // frmEncounterFrame.Release;
    // frmEncounterFrame := nil; // access violation source?  removed 7/28/03 RV
  end;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name: TfrmEncounterFrame.SectionClick(Sender: TObject);
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Call the procedure apropriate for the selected tab
  /////////////////////////////////////////////////////////////////////////////// }
procedure TfrmEncounterFrame.SectionClick(Sender: TObject);
begin
  with Sender as TListBox do
    case Tag of
      TAG_VTYPE:
        if FormListContains(CT_VisitNm) then
        begin
          with frmVisitType do
            lstVTypeSectionClick(Sender);
        end;
    end;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name: procedure TfrmEncounterFrame.SynchPCEData;
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Synchronize any existing PCE data with what is displayed in the form.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmEncounterFrame.SynchPCEData;

  procedure InitList(AListBox: TORListBox);
  var
    DoClick: Boolean;

  begin
    with AListBox do
    begin
      DoClick := TRUE;
      case Tag of
        TAG_VTYPE:
          begin
            if FormListContains(CT_VisitNm) then
              ListVisitTypeSections(Items);
            DoClick := AutoSelectVisit(PCERPCEncLocation);
          end;
      end;
      if Items.Count > 0 then
      begin
        if DoClick then
        begin
          ItemIndex := 0;
          SectionClick(AListBox);
        end;
      end
      else
        Items.Add(TX_NOSECTION);
    end;
  end;

begin
  if FormListContains(CT_VisitNm) then
  with frmVisitType do
    begin
      InitList(frmVisitType.lstVTypeSection);                     // set up Visit Type page
      ListSCDisabilities(memSCDisplay.Lines);
      uSCCond := EligbleConditions;
      frmVisitType.fraVisitRelated.InitAllow(uSCCond);
    end;
  with uEncPCEData do                               // load any existing data from PCEData
  begin
    if FormListContains(CT_VisitNm) then
      frmVisitType.fraVisitRelated.InitRelated(uEncPCEData);
    if FormListContains(CT_DiagNm) then
      frmDiagnoses.InitTab(CopyDiagnoses, ListDiagnosisSections);
    if FormListContains(CT_ProcNm) then
      frmProcedures.InitTab(CopyProcedures, ListProcedureSections);
    if FormListContains(CT_ImmNm) then
      frmImmunizations.InitTab(CopyImmunizations,ListImmunizSections);
    if FormListContains(CT_SkinNm) then
      frmSkinTests.InitTab(CopySkinTests, ListSkinSections);
    if FormListContains(CT_PedNm) then
      frmPatientEd.InitTab(CopyPatientEds, ListPatientSections);
    if FormListContains(CT_HlthNm) then
      frmHealthFactors.InitTab(CopyHealthFactors, ListHealthSections);
    if FormListContains(CT_XamNm) then
      frmExams.InitTab(CopyExams, ListExamsSections);
    uVisitType.Assign(VisitType);
    if FormListContains(CT_VisitNm) then
    with frmVisitType do
    begin
      MatchVType;
    end;
  end;
end;


{///////////////////////////////////////////////////////////////////////////////
//Name: procedure TfrmEncounterFrame.FormDestroy(Sender: TObject);
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Free up objects in memory when destroying form.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmEncounterFrame.FormDestroy(Sender: TObject);
var
  i: integer;

begin
  inherited;
  for i := ComponentCount-1 downto 0 do
    if(Components[i] is TForm) then
      TForm(Components[i]).Free;

  formlist.clear;
  KillObj(@uProviders);
  uVisitType.Free;
  Formlist.free;
{ $ IFDEF DEBUG}
  fDebugPCE.Free;
{ $ ENDIF}
end;


{///////////////////////////////////////////////////////////////////////////////
//Name: procedure TfrmEncounterFrame.FormCreate(Sender: TObject);
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Create instances of the objects needed.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmEncounterFrame.FormCreate(Sender: TObject);
begin
  uProviders := TPCEProviderList.Create;
  uVisitType := TPCEProc.create;
  FormList := TStringList.create;
  fCancel := False;
  FAbort := TRUE;
  SetFormFonts;
  FGiveMultiTabMessage := ScreenReaderSystemActive;
{ $ IFDEF DEBUG}
  fDebugPCE := TPCEData.Create;
{ $ ENDIF}
  ckbDebugInfo.Visible := HasSecurityKey(GN_GUI_SECURITY_KEY)
{$IFDEF DEBUG} or TRUE {$ENDIF}
      ;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name: procedure TfrmEncounterFrame.SendData;
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Send Data back to the M side sor storing.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmEncounterFrame.SendData;
//send PCE data to the RPC
var
{ $ IFDEF GROUPNOTES}
{ $ ELSE}
//  StoreMessage: string;
{ $ ENDIF}
  ptDFN: String;
  i: Integer;
  GAFScore: integer;
  GAFDate: TFMDateTime;
  GAFStaff: Int64;
  PatientData: TPatientData;

begin
  inherited;
  // do validation for vitals & anything else here
{ $ IFDEF GROUPNOTES}
{ $ ELSE}
(*
  //process vitals
  if FormListContains(CT_VitNm) then
  begin
    with frmEncVitals do
    if HasData then
    begin
      if AssignVitals then
      begin
        StoreMessage := ValAndStoreVitals(frmEncVitals.VitalNew);
        if (Storemessage <> 'True') then
        begin
          ShowMsg(storemessage);
//        exit;
        end;
      end;
    end;
  end;
*)
{ $ ENDIF}

  if(FormListContains(CT_GAFNm)) then
  begin
    frmGAF.GetGAFScore(GAFScore, GAFDate, GAFStaff);
    if(GAFScore > 0) then
      SaveGAFScore(GAFScore, GAFDate, GAFStaff);
  end;

  //PCE
  UpdateEncounter(uEncPCEData);

  if GroupEdit then
    begin
      for i := 0 to GNPtList.Count - 1 do
      begin
        PatientData := TPatientData(GNPtList[i]);
        uEncPCEData.CopyPCEData(PatientData.PCEData);
        PtDFN := PatientData.Patient.DFN;
{$IFDEF DEBUG}
        addLogLine(PCEDataToString(PatientData.PCEData),'Encounter data for '+ptDFN);
{$ENDIF}
        PatientData.PCEData.Save(ptDFN);
      end;
    end
    else
      uEncPCEData.Save;
  Close;
end;

{///////////////////////////////////////////////////////////////////////////////
//Name: procedure TfrmEncounterFrame.FormCloseQuery(Sender: TObject;
//Created: Jan 1999
//By: Robert Bott
//Location: ISL
//Description: Check to see if the Cancel button was pressed, if not, call
// procedure to send the data to the server.
///////////////////////////////////////////////////////////////////////////////}
procedure TfrmEncounterFrame.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);

const
  TXT_SAVECHANGES = 'Save Changes?';

var
  TmpPCEData: TPCEData;
  ask, ChangeOK: boolean;

begin
  CanClose := True;
  if(FAbort) then
    FCancel := (InfoBox(TXT_SAVECHANGES, TXT_SAVECHANGES, MB_YESNO) = ID_NO);
  if FCancel then Exit;  //*KCM*

  if(uProviders.PrimaryIdx >= 0) then
    ask := TRUE
  else
  begin
    TmpPCEData := TPCEData.Create;
    try
      uEncPCEData.CopyPCEData(TmpPCEData);
      UpdateEncounter(TmpPCEData);
      ask := TmpPCEData.NeedProviderInfo;
    finally
      TmpPCEData.Free;
    end;
  end;
  if ask and (NoPrimaryPCEProvider(uProviders, uEncPCEData)) then
  begin
    InfoBox(TX_PROV_REQ, TC_PROV_REQ, MB_OK or MB_ICONWARNING);
    CanClose := False;
    Exit;
  end;

  uVisitType.Provider := uProviders.PrimaryIEN;  {RV - v20.1}

{ $ IFDEF GROUPNOTES}
{ $ ELSE}
//  if FormListContains(CT_VitNm) then
//    CanClose := frmEncVitals.OK2SaveVitals;
{ $ ENDIF}
  if CanClose and FormListContains(CT_ProcNm) then
    begin
      CanClose := frmProcedures.OK2SaveProcedures;
      if not CanClose then
        begin
          tabPageChange(Self, FormList.IndexOf(CT_ProcNm), ChangeOK);
{ $ IFDEF GROUPNOTES}
          SwitchToPage(pageByName(CT_ProcNm));
{ $ ELSE}
//          SwitchToPage(PageIDToForm(CT_PROCEDURES));
{ $ ENDIF}
          TabControl.TabIndex := FormList.IndexOf(CT_ProcNm);
        end;
    end;

  if CanClose then SendData;  //*KCM*

end;

procedure TfrmEncounterFrame.TabControlChange(Sender: TObject);
begin
//must switch based on caption, as all tabs may not be present.
  if (sender as tTabControl).tabindex = -1 then exit;

  if TabControl.CanFocus and Assigned(FLastPage) and not TabControl.Focused then
    TabControl.SetFocus;  //CQ: 14845

   SwitchToPage(pageByName(TabControl.Tabs[TabControl.TabIndex]));
end;

procedure TfrmEncounterFrame.TabControlChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  if(assigned(FLastPage)) then
    FLastPage.AllowTabChange(AllowChange);
end;

procedure TfrmEncounterFrame.UpdateEncounter(PCE: TPCEData);
begin
  with PCE do
  begin
    if FormListContains(CT_VisitNm) then
    begin
      VisitType := uVisitType;
      frmVisitType.fraVisitRelated.GetRelated(uEncPCEData);
      Providers.Merge(uProviders);
    end;
    //DNS   BELLC
    if FormListContains(CT_DiagNm) then
      SetDiagnoses(frmDiagnoses.lstCaptionList.ItemsStrings);
    if FormListContains(CT_ProcNm) then
     SetProcedures(frmProcedures.lstCaptionList.ItemsStrings);
    if FormListContains(CT_ImmNm) then
       SetImmunizations(frmImmunizations.lstCaptionList.ItemsStrings);
    if FormListContains(CT_SkinNm) then
       SetSkinTests(frmSkinTests.lstCaptionList.ItemsStrings);
    if FormListContains(CT_PedNm) then
      SetPatientEds(frmPatientEd.lstCaptionList.ItemsStrings);
    if FormListContains(CT_HlthNm) then
      SetHealthFactors(frmHealthFactors.lstCaptionList.ItemsStrings);
    if FormListContains(CT_XamNm) then
      SetExams(frmExams.lstCaptionList.ItemsStrings);

    if GroupEdit then
      CopyPCEData(BasePCE);
  end;
end;

procedure TfrmEncounterFrame.SelectTab(NewTabName: string);
var
  AllowChange: boolean;
begin
  AllowChange := True;
  tabControl.TabIndex := FormList.IndexOf(NewTabName);
  tabPageChange(Self, tabControl.TabIndex, AllowChange);
end;

procedure TfrmEncounterFrame.TabControlEnter(Sender: TObject);
begin
  if FGiveMultiTabMessage then // CQ#15483
  begin
    FGiveMultiTabMessage := FALSE;
    GetScreenReader.Speak('Multi tab form');
  end;
end;

procedure TfrmEncounterFrame.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  CanChange: boolean;
begin
  inherited;
  if (Key = VK_ESCAPE) then
  begin
    Key := 0;
    FLastPage.btnCancel.Click;
  end
  else if Key = VK_TAB then
  begin
    if ssCtrl in Shift then
    begin
      CanChange := True;
      if Assigned(TabControl.OnChanging) then
        TabControl.OnChanging(TabControl, CanChange);
      if CanChange then
      begin
        if ssShift in Shift then
        begin
          if TabControl.TabIndex < 1 then
            TabControl.TabIndex := TabControl.Tabs.Count -1
          else
            TabControl.TabIndex := TabControl.TabIndex - 1;
        end
        else
          TabControl.TabIndex := (TabControl.TabIndex + 1) mod TabControl.Tabs.Count;
        if Assigned(TabControl.OnChange) then
          TabControl.OnChange(TabControl);
      end;
      Key := 0;
    end;
  end;
end;

procedure TfrmEncounterFrame.SetFormFonts;
var
  i: Integer;
  NewFontSize: integer;
begin
  NewFontSize := MainFontsize;
  for i  := 0 to FormList.Count - 1 do
    if assigned(FormList.Objects[i]) and (FormList.Objects[i] is TfrmPCEBase) then
      TfrmPCEBase(FormList.Objects[i]).Font.Size := NewFontSize;
end;

procedure TfrmEncounterFrame.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SaveUserBounds(Self);
end;

procedure TfrmEncounterFrame.FormCanResize(Sender: TObject;
  var NewWidth, NewHeight: Integer; var Resize: Boolean);
begin
  // CQ4740
  if NewWidth < 200 then
  begin
    NewWidth := 200;
    Resize := False;
  end;
end;

procedure TfrmEncounterFrame.FormShow(Sender: TObject);
begin
  inherited;
  if TabControl.CanFocus and Assigned(FLastPage) and not TabControl.Focused then
    TabControl.SetFocus;
end;

procedure TfrmEncounterFrame._UM_GN_ENCUPDATE(var Message: TMessage);
{ $ IFDEF DEBUG}
var
  i: integer;
  sl: TSTringList;
  s, ss: String;
begin;
  UpdateEncounter(fDebugPCE);
  mmLog.Clear;
  mmLog.Lines.Add(FormatDateTime('-- mm/dd/yyyy hh:nn:ss --', Now));
  mmLog.Lines.Add('-------------------------');
  mmLog.Lines.Text := mmLog.Lines.Text + CRLF +
    PCEDataToString(fDebugPCE);
  i := 1;
  while i <= mmLog.Lines.Count - 1 do
    if Trim(mmLog.Lines[i]) = '' then
      mmLog.Lines.Delete(i)
    else
      inc(i);
  mmLog.Lines.Add('-------------------------');
  sl := fDebugPCE.getPCEDataList;
  for s in sl do
    begin
      ss := StringReplace(s,#0,'#0',[rfReplaceAll]);
      mmLog.Lines.Add(ss);
    end;
  sl.Free;
{ $ ELSE}
//begin
{ $ ENDIF}
end;

procedure TfrmEncounterFrame.ckbDebugInfoClick(Sender: TObject);
begin
  inherited;
//  ckbDebugInfo.Checked := not ckbDebugInfo.Checked;
  mmLog.Visible := ckbDebugInfo.Checked;
  splDebug.Visible := ckbDebugInfo.Checked;
  splDebug.Top := mmLog.Height;
end;


procedure TfrmEncounterFrame.doCreateForms(aLocation: Integer);
var
  j: Integer;
  s: string;
begin
  FormList.Clear;

  frmVisitType  := TfrmVisitType.CreateLinked(pnlPage);
  frmDiagnoses  := TfrmDiagnoses.CreateLinked(pnlPage);
  frmProcedures := TfrmProcedures.CreateLinked(pnlPage);
  if not GroupEdit then
    frmEncVitals := TfrmEncVitals.CreateLinked(pnlPage);
  frmImmunizations := TfrmImmunizations.CreateLinked(pnlPage);
  if not GroupEdit then
    frmSkinTests := TfrmSkinTests.CreateLinked(pnlPage);
  frmPatientEd := TfrmPatientEd.CreateLinked(pnlPage);
  frmHealthFactors := TfrmHEalthFactors.CreateLinked(pnlPage);
  if not GroupEdit then
    frmExams := TfrmExams.CreateLinked(pnlPage);
  if not GroupEdit then

{$IFDEF DEBUG} // testing appearance of the GAF form regardless of Location
{$ELSE}
    if MHClinic(aLocation) then
{$ENDIF}
      frmGAF := TfrmGAF.CreateLinked(pnlPage);

  FormList.AddObject(CT_VisitNm,frmVisitType);
  FormList.AddObject(CT_DiagNm,frmDiagnoses);
  FormList.AddObject(CT_ProcNm,frmProcedures);
  if not GroupEdit then
    FormList.AddObject(CT_VitNm,frmEncVitals);

  FormList.AddObject(CT_ImmNm,frmImmunizations);
  if not GroupEdit then
    FormList.AddObject(CT_SkinNm,frmSkinTests);
  FormList.AddObject(CT_PedNm,frmPatientEd);
  FormList.AddObject(CT_HlthNm,frmHealthFactors);
  if not GroupEdit then
    FormList.AddObject(CT_XamNm,frmExams);
  if not GroupEdit then
{$IFDEF DEBUG} // testing appearance of the GAF form regardless of Location
{$ELSE}
    if MHClinic(aLocation) then
{$ENDIF}
      FormList.AddObject(CT_GAFNm,frmGAF);

  frmVisitType.Visible := True;
  for j  := 1 to FormList.Count - 1 do
    TForm(FormList.Objects[j]).Visible := False;

  for s in FormList do
    tabControl.Tabs.Add(s);
end;

function TfrmEncounterFrame.pageByName(aName:String): TfrmPCEBase;
var
  i: integer;
begin
  Result := nil;
  i := FormList.IndexOf(aName);
  if i >=0 then
    Result := TfrmPCEBase(FormList.Objects[i]);
end;

end.
