unit fEncVitals;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, ORDtTm, StdCtrls, ORCtrls, ExtCtrls, Buttons,
  ORFn,
  rvitals, ComCtrls, ORNet,
  uVitals,
  VAUtils, TRPCB, VA508AccessibilityManager;

type
  TfrmEncVitals = class(TfrmPCEBase)
    lvVitals: TCaptionListView;
    btnEnterVitals: TButton;
    procedure cboHeightChange(Sender: TObject);
    procedure cboWeightChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lbllastClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    function HasData: Boolean;
    procedure cboPainChange(Sender: TObject);
    procedure btnEnterVitalsClick(Sender: TObject); //vitals lite
  private
    FDataLoaded: boolean;
    FChangingFocus: boolean;
    UvitalNew: TStringList;
    uVitalOld: TSTringList;
    procedure InitVitalPanel;
    procedure CheckVitalUnit;
    procedure LoadVitalView(VitalsList : TStringList); //Vitals Lite
    procedure LoadVitalsList;
  public
    function OK2SaveVitals: boolean;
    property VitalNew: TStringList read uVitalNew;
    property VitalOld: TStringList read uVitalOld;
  end;

var
  frmEncVitals: TfrmEncVitals;

implementation

{$R *.DFM}

uses UCore, rCore, rPCE, fPCELex, fPCEOther,
{ $ IFDEF GROUPNOTES}
{ $ ELSE}
//fVisit, fFrame,fVitals,
{ $ ENDIF}
fEncnt,
     fEncounterFrame, uInit, VA508AccessibilityRouter, System.UITypes, rMisc;

const
  TX_VDATE_REQ1 = 'Entered vitals information can not be saved without a Date.' + CRLF +
                  'Do you wish to use the encounter date of ';
  TX_VDATE_REQ2 = '?';
  TC_VDATE_REQ = 'Missing Vitals Entry Date';

  TX_KILLDATA = 'Discard entered vitals information?';

var
  UcboVitChanging:      Boolean = False;

function TfrmEncVitals.HasData: Boolean;
begin
  result := False;
end;

procedure TfrmEncVitals.InitVitalPanel;
begin
  {Use this area to read parameter for units and set apropriately
   after parameter is defined. in next version
  }
  UcboVitchanging := true; //prevents entering code in CheckVitalUnit

  UcboVitchanging := False; //prevents entering code in CheckVitalUnit

  if (UvitalOld.text = '') then
    GetLastVital(uVitalOld,Patient.DFN);
end;

procedure TfrmEncVitals.CheckVitalUnit;
var
  len,i: integer;
  found: boolean;
  comp: string; //substring for comparing
  temp: string;
begin
  if (UcboVitchanging = true) then exit;

  UcboVitChanging := true;
  try
    with ActiveCtrl as TComboBox do
    begin
       found := False;
       temp := text;
       while (found = false) and (Length(temp) > 0) do
       begin
          i := 0;
          while (found = false) and (length(items[i]) > 0) do
          begin
          len := length(temp);
          //match text to string
          comp := copy(items[i],0,len);
          if (CompareText(comp,temp) = 0) then
          begin
             found := true;
             Text := '';
             text := items[i];

          end;
          inc(i);
          end;
          if (found = false) then Delete(temp,1,1);
       end;
       if (found = False) then
       begin
          Text := '';
       end;
    end;
  finally
    UcboVitChanging := false;
  end;
end;

procedure TfrmEncVitals.cboHeightChange(Sender: TObject);
begin
  inherited;
  CheckVitalUnit;
end;

procedure TfrmEncVitals.cboWeightChange(Sender: TObject);
begin
  inherited;
  CheckVitalUnit;
end;

procedure TfrmEncVitals.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_VitNm;
  //uVisitType := TPCEProc.create;
  uVitalOld  := TStringList.create;
  uVitalNew  := TStringList.create;
end;

procedure TfrmEncVitals.FormDestroy(Sender: TObject);
begin
  //uVisitType.Free;
  uVitalOld.Free;
  uVitalNew.free;

{== Vitals Lite 2004-05-21 ===================================================}
  UnloadVitalsDLL;
{== Vitals Lite 2004-05-21 ===================================================}
  inherited;
end;

procedure TfrmEncVitals.lbllastClick(Sender: TObject);
begin
  inherited;
{ $ IFDEF GROUPNOTES}
{ $ ELSE}  //
{
  try
    frmEncVitals.Show;
  except
    with sender as TStaticText do
      SelectVital(self.Font.Size, tag);
  end; //end of try
}
{ $ ENDIF}
end;

procedure TfrmEncVitals.FormShow(Sender: TObject);
var
 tmpRtnRec: TDllRtnRec;
begin
  inherited;
  //Begin Vitals Lite
  {Visit is Assumed to Be selected when Opening Encounter Dialog}
  tmpRtnRec := LoadVitalsDLL;
  btnEnterVitals.Enabled := tmpRtnRec.Return_Type = DLL_Success; // AA 455

  case tmpRtnRec.Return_Type of
    DLL_Success: LoadVitalsList;
    DLL_Missing: TaskMessageDlg('File Missing or Invalid', tmpRtnRec.Return_Message,mtError,[mbok],0);
    DLL_VersionErr: TaskMessageDlg('Incorrect Version Found', tmpRtnRec.Return_Message,mtError,[mbok],0);
  end;
  //End Vitals Lite
//  frmEncVitals.caption := 'Vital entry for - '+ patient.name; {RAB 6/15/98}
  FormActivate(Sender);
end;

procedure TfrmEncVitals.FormActivate(Sender: TObject);
begin
  inherited;
  if(not FChangingFocus) and (not FDataLoaded) then
  begin
    FDataLoaded := TRUE;
    InitVitalPanel;
//    txtMeasTemp.setfocus;  //added 3/30/99 after changing tab order.
                         //The date is now first in tab order, but it shouldn't default there.
  end;
end;

procedure TfrmEncVitals.cboPainChange(Sender: TObject);
begin
  inherited;
  CheckVitalUnit;
end;

function TfrmEncVitals.OK2SaveVitals: boolean;
begin
  Result := TRUE;
end;


//Begin Vitals Lite
procedure TfrmEncVitals.LoadVitalView(VitalsList: TStringList);
var
  i : integer;
  curCol : TListColumn;
  curItem : TListItem;
  HeadingList,tmpList : TStringList;
begin
  HeadingList := TStringList.Create;
  tmpList := TStringList.Create;
  lvVitals.ShowColumnHeaders := false;                //CQ: 10069 - the column display becomes squished.
  lvVitals.Items.Clear;
  lvVitals.Columns.Clear;
  PiecesToList(VitalsList[0],U,HeadingList);
  for i := 0 to HeadingList.Count-1 do
  begin
    curCol := lvVitals.Columns.Add;
    curCol.Caption := HeadingList[i];
    curCol.AutoSize := true;
  end;
  for i := 1 to VitalsList.Count-1 do
  begin
    curItem := lvVitals.Items.Add;
    PiecesToList(VitalsList[i],U,tmpList);
    curItem.Caption := tmpList[0];
    tmpList.Delete(0);
    curItem.SubItems.Assign(tmpList);
  end;
  lvVitals.ShowColumnHeaders := true;                 //CQ: 10069 - the column display becomes squished.
  HeadingList.Free;
  tmpList.Free;
end;

procedure TfrmEncVitals.btnEnterVitalsClick(Sender: TObject);
var
  VLPtVitals : TGMV_VitalsEnterDLG;
  //GMV_FName : String;
  GMV_Fname: AnsiString;
begin
  inherited;
  if VitalsDLLHandle = 0 then Exit;//The DLL was initialized on Create, but just in case....
  GMV_FName := 'GMV_VitalsEnterDLG';
  @VLPtVitals := GetProcAddress(VitalsDLLHandle,PAnsiChar(GMV_FName));
  if assigned(VLPtVitals) then
  begin
    VLPtVitals(
      RPCBrokerV,
      Patient.DFN,
      IntToStr(uEncPCEData.Location),
      GMV_DEFAULT_TEMPLATE,
      GMV_APP_SIGNATURE,
      FMDateTimeToDateTime(uEncPCEData.DateTime),
      Patient.Name,
      Patient.SSN + '   ('+IntToStr(Patient.Age)+')'
//      frmFrame.lblPtSSN.Caption + '    ' + frmFrame.lblPtAge.Caption
    );
  end
  else
    MessageDLG('Unable to find function "'+string(GMV_FName)+'".',mtError,[mbok],0);
  @VLPtVitals := nil;
  LoadVitalsList;
end;

procedure TfrmEncVitals.LoadVitalsList;
var
  VitalsList : TStringList;
  VLPtVitals : TGMV_LatestVitalsList;
  //GMV_FName : String;
  GMV_FName: AnsiString;
begin
  if VitalsDLLHandle = 0 then Exit;//The DLL was initialized on Create, but just in case....
  GMV_FName := 'GMV_LatestVitalsList';
  @VLPtVitals := GetProcAddress(VitalsDLLHandle,PAnsiChar(GMV_FName));
  if assigned(VLPtVitals) then
  begin
    VitalsList := VLPtVitals(RPCBrokerV,Patient.DFN,U,false);
    if assigned(VitalsList) then
      LoadVitalView(VitalsList);
  end
  else
    MessageDLG('Can''t find function "'+string(GMV_FName)+'".',mtError,[mbok],0);
  @VLPtVitals := nil;
end;
//End Vitals Lite

initialization
  SpecifyFormIsNotADialog(TfrmEncVitals);

end.
