ORWPT2	;SLC/RBD - Other Patient Info Utilities ;09/26/17  09:40
	;;3.0;ORDER ENTRY/RESULTS REPORTING;**439**;Dec 17, 1997
	;
	; ICRs 1252 - Supported API call OUTPTPR^SDUTL3
	;      2028 - READ ACCESS ONLY TO PCE VISIT FILE
	;       covers $Ordering through "AET" index as well
	;       as the READing of the zero node.
	;     10061 - Supported API call INP^VADPT.
	;     10103 - Supported API call FMTE^XLFDT
	;
	Q
	;
IDINFO(REC,DFN)	; Return more identifying info for a patient
	; This RPC allows retrieval of the Inpatient Provider,
	; Primary Care Provider, Last Location Name & Last Visit
	; Date for a Patient.
	;
	; Input:
	;   DFN is the unique IEN into PATIENT file #2
	; Output:
	;   REC which is returned as Inpatient Provider ^
	;          Primary Care Provider ^ Last Location Name
	;          ^ Last Visit Date
	;
	N DELETED,RECPCE,VAIN,VDT,VSTINFO
	F RECPCE=1:1:4 S $P(REC,U,RECPCE)=""
	D INP^VADPT I $G(VAIN(2)) S $P(REC,U,1)=$P(VAIN(2),U,2)
	S $P(REC,U,2)=$P($$OUTPTPR^SDUTL3(DFN),U,2)
	S VDT=""
VDTLOOP	; Loop to next previous one if this one Deleted
	S VDT=$O(^AUPNVSIT("AET",DFN,VDT),-1)
	I VDT]"" D  G:DELETED VDTLOOP
	. S DELETED=$$DELETED(DFN,VDT) Q:DELETED
	. D LIST^ORQQVS(.VSTINFO,DFN,VDT,VDT,"")  ; retrieve the one visit record
	. I $G(VSTINFO(1))]"" D
	.. S $P(REC,U,3)=$P($P(VSTINFO(1),U,3),";",2)
	.. S $P(REC,U,4)=$$FMTE^XLFDT($P($P(VSTINFO(1),U,2),".",1))
	Q
	;
DELETED(DFN,VDT)	; Check if VISIT is Deleted
	N V0,VLOC,VETYP,VIEN
	S VLOC=$O(^AUPNVSIT("AET",DFN,VDT,"")) Q:VLOC="" 1
	S VETYP=$O(^AUPNVSIT("AET",DFN,VDT,VLOC,"")) Q:VETYP="" 1
	S VIEN=$O(^AUPNVSIT("AET",DFN,VDT,VLOC,VETYP,""))
	Q:VIEN="" 1 S V0=$G(^AUPNVSIT(VIEN,0)) Q:V0="" 1
	I $P(V0,U,11)=1 Q 1
	Q 0
	;
