﻿{ TODO -oChris Bell : Fix 508 imagelist }
unit fOCSession;

{ ------------------------------------------------------------------------------
  Update History

  2016-09-20: NSR#20101203 (Critical/Hight Order Check Display)
  ------------------------------------------------------------------------------- }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fOCMonograph,
  fAutoSz, StdCtrls, ORFn, uConst, ORCtrls, ExtCtrls, VA508AccessibilityManager,
  Grids, strUtils, uDlgComponents, VAUtils, VA508AccessibilityRouter,
  Vcl.ComCtrls, Winapi.RichEdit, ShellAPI, ORNet, rOCSession, Data.Bind.EngExt,
  Vcl.Bind.DBEngExt, Vcl.ImgList,

  fOMAction, VA508ImageListLabeler, Vcl.Menus, System.Actions, Vcl.ActnList,
  System.ImageList;

type
  TfrmOCSession = class(TfrmAutoSz)
    PnlBtn: TPanel;
    cmdContinue: TButton;
    btnReturn: TButton;
    PnlCtr: TPanel;
    PnlCtrBtm: TPanel;
    LblOverrideNum: TLabel;
    lblOverrideChecks: TVA508StaticText;
    PnlCtrLft: TPanel;
    pnlCtrRght: TPanel;
    lvOrders: TListView;
    lblInstr: TStaticText;
    Splitter1: TSplitter;
    lblOrdChk: TStaticText;
    rchOrdChk: TRichEdit;
    pnlReason: TPanel;
    StaticText3: TStaticText;
    cmbOverReason: TComboBox;
    pnlComment: TPanel;
    lblComment: TStaticText;
    memRmtCmt: TMemo;
    chkALL: TCheckBox;
    Panel1: TPanel;
    Splitter2: TSplitter;
    ImageList1: TImageList;
    ImageList2: TImageList;
    lblNote: TVA508StaticText;
    pnlOrdGrp: TGroupBox;
    pnlTop: TPanel;
    pnlLegend: TPanel;
    ListView1: TListView;
    pmLegend: TPopupMenu;
    pmShowLgnd: TMenuItem;
    VA508StatusImgLst: TVA508ImageListLabeler;
    VA508CheckBoxImgLst: TVA508ImageListLabeler;
    pnlList: TPanel;
    ckbLegend: TCheckBox;
    btnAllergy: TButton;
    pnlMonograph: TPanel;
    btnMonograph: TButton;
    pnlOrderChecks: TPanel;
    pnlOptions: TPanel;
    ActionList1: TActionList;
    acAllergyAssessment: TAction;
    acViewMonograph: TAction;
    procedure cmdAcceptOrdersClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure txtJustifyKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure cmdMonographClick(Sender: TObject);
    procedure PnlTopResize(Sender: TObject);
    procedure chkALLClick(Sender: TObject);
    procedure lvOrdersSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure memRmtCmtChange(Sender: TObject);
    procedure cmbOverReasonChange(Sender: TObject);
    procedure lvOrdersClick(Sender: TObject);
    procedure pmShowLgndClick(Sender: TObject);
    procedure ckbLegendClick(Sender: TObject);
    procedure acViewMonographExecute(Sender: TObject);
    procedure acAllergyAssessmentExecute(Sender: TObject);
    // procedure memNoteSetText(str: string);
  private
    FOrderList: array of TStringList;
    overrideRecord: TOrderRec;
    procedure UpdateStatusIcons();
    procedure AdjustSizes;
  end;

procedure ExecuteReleaseOrderChecks(SelectList: TList);
function ExecuteSessionOrderChecks(OrderLists: array of TStringList): Boolean;

const
  // Status Images
  Status_UnChk = 0;
  Status_Chk = 1;

  // State Images
  State_Alert = 0;
  State_Chk = 1;
  State_Cancel = 2;

  NonOrders: array [0 .. 1] of string = ('ALLGY', 'MONO');
  NO_REMOTE_COMMENTS = 'No Remote Comments found';
  REASON_REQUIRED_FOR_OVERRIDE =
    'Checks marked with *** require reason for override';

var
  CheckList1: TStringList;

implementation

{$R *.DFM}

uses rOrders, uCore, rMisc, fFrame, fAllgyAR, System.UITypes, uOrders;

{ TODO -oChris Bell : test non critical order checks }
{ Returns True if the Signature process should proceed.
  Clears OrderList If False. }
function ExecuteSessionOrderChecks(OrderLists: array of TStringList): Boolean;
var
  j, n: Integer;
  NewID, NxtID, OrderName: string;
  CheckList, DisplayTxt, LoadList: TStringList;
  frmOCSession: TfrmOCSession;

  TmpStr, LstStr: String;
  LstEnum: TStringsEnumerator;
  LstItem: TListItem;
  TheOrderRec: TOrderRec;

  procedure SetupAllgyAssesment();
  begin
    // *** The following 3 lines of code are for future use when an // NJC(NSR 20070920) 08/15
    // *** authorization parameter is implemented for Allergy access// NJC(NSR 20070920) 08/15
    // if sCallV('ORQQAE USER',[user.DUZ]) <> '1' then             // NJC(NSR 20070920) 08/15
    /// / frmOCAccept.AllergyAssessmentBtn.Visible  := false        // NJC(NSR 20070920) 08/15
    // frmOCSession.btnAllergy.Visible := false; // AA - updating the NJC code
    // else                                                        // NJC(NSR 20070920) 08/15
    frmOCSession.acAllergyAssessment.Enabled :=
      sCallV('ORQQAL LIST', [Patient.DFN]) = '^No Allergy Assessment';
{$IFDEF DEBUG_AA} // enabling for testing only
    frmOCSession.acAllergyAssessment.Enabled := true;
{$ENDIF}
  end;

begin
  Screen.Cursor := crHourGlass;
  Try
    Result := true; //was "false". RTC#412125
    CheckList := TStringList.Create;
    try
      StatusText('Order Checking...');

      LoadList := TStringList.Create;
      try
        // set up our "LoadList" which is used to gather the data
        for j := Low(OrderLists) to High(OrderLists) do
          LoadList.AddStrings(OrderLists[j]);

        if LoadList.Count > 0 then
          OrderChecksForSession(CheckList, LoadList);
      finally
        LoadList.Free;
      end;

      StatusText('');

      if CheckList.Count > 0 then
      begin
        Checklist1.Text := Checklist.Text;
        frmOCSession := TfrmOCSession.Create(Application);
        try
          Screen.Cursor := crHourGlass;
          try
            frmOCSession.AutoSizeDisabled := true;

            ResizeFormToFont(frmOCSession);

            NxtID := '';
            // Sort the list by ID
            SortByPiece(CheckList, U, 1);
            DisplayTxt := TStringList.Create;
            try
              // loop and build out the needed data
              LstEnum := CheckList.GetEnumerator;
              while LstEnum.MoveNext do
              begin
                TmpStr := '';
                LstStr := LstEnum.Current;
                // Grab the data
                NewID := Piece(LstStr, U, 1);
                // Look at the next ID to see if its a new record
                NxtID := Piece(LstEnum.Next, U, 1);
                // Add check type. 1=high 2=moderate 3=low
                SetPiece(TmpStr, U, 1, trim(Piece(LstStr, U, 3)));
                // Add display text
                SetPiece(TmpStr, U, 2, Piece(LstStr, U, 4));
                if (Piece(LstStr, U, 2) = '3') and (Piece(LstStr, U, 5) = '1')
                then
                begin
                  // Add collection for comment flag
                  SetPiece(TmpStr, U, 3, Piece(LstStr, U, 5));
                  // Add previous comment
                  SetPiece(TmpStr, U, 4, Piece(LstStr, U, 7));
                  // Add Override Reason //TDP - Added Override Reason
                  SetPiece(TmpStr, U, 5, Piece(LstStr, U, 8));
                end;
                // add the out put to our stringlist
                DisplayTxt.Add(TmpStr);
                // If order changes then lets build the panel
                if NewID <> NxtID then
                begin
                  OrderName := StringReplace(trim(TextForOrder(NewID)), #$D#$A,
                    ' -- ', [rfReplaceAll, rfIgnoreCase]);
                  LstItem := frmOCSession.lvOrders.Items.Add;
                  TheOrderRec := TOrderRec.Create(NewID, OrderName, DisplayTxt);
                  LstItem.Data := TheOrderRec;
                  LstItem.Caption := '';
                  LstItem.ImageIndex := -1;
                  LstItem.SubItems.Add('');
                  LstItem.StateIndex := 0;
                  if TheOrderRec.IsCritical then
                  begin
                    LstItem.SubItemImages[0] := State_Alert;
                    LstItem.SubItems.Add( { '*' + } OrderName);
                  end
                  else
                  begin
                    LstItem.SubItemImages[0] := -1;
                    LstItem.SubItems.Add(OrderName);
                  end;
                  DisplayTxt.Clear;
                end;
              end;

            finally
              DisplayTxt.Free;
            end;

            // set up frmOCSession.FOrderList which is used to keep track of what was removed
            SetLength(frmOCSession.FOrderList, 0);
            for j := Low(OrderLists) to High(OrderLists) do
            begin
              SetLength(frmOCSession.FOrderList,
                Length(frmOCSession.FOrderList) + 1);
              frmOCSession.FOrderList[High(frmOCSession.FOrderList)] :=
                OrderLists[j];
            end;

            MessageBeep(MB_ICONASTERISK);
            if frmOCSession.Visible then
              frmOCSession.SetFocus;

            // Make the call to set the allergry assesment up
            SetupAllgyAssesment;

            // Add the Monograph
            frmOCSession.acViewMonograph.Enabled := IsMonograph;
            // select the first order in the list
            frmOCSession.lvOrders.Items[0].Selected := true;

          finally
            Screen.Cursor := crDefault;
          end;

          frmOCSession.ShowModal;
          //TDP - Added mrCancel to behave like mrAbort in next two lines
          Result := (frmOCSession.ModalResult <> mrAbort) and (frmOCSession.ModalResult <> mrCancel);
          if (frmOCSession.ModalResult = mrAbort) or (frmOCSession.ModalResult = mrCancel) then
          begin
            for j := Low(OrderLists) to High(OrderLists) do
            begin
              for n := 0 to OrderLists[j].Count - 1 do
                UnlockOrder(Piece(OrderLists[j].Strings[n], U, 1));
              OrderLists[j].Clear;
            end;

            if Assigned(frmFrame) then
              frmFrame.SetActiveTab(CT_ORDERS);
          end;

          // clean up objects
          for LstItem in frmOCSession.lvOrders.Items do
            TOrderRec(LstItem.Data).Free;

          SetLength(frmOCSession.FOrderList, 0);
        finally
          frmOCSession.Free;
        end; { try }
      end; { if CheckList }
    finally
      CheckList.Free;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure ExecuteReleaseOrderChecks(SelectList: TList);
var
  i: Integer;
  AnOrder: TOrder;
  OrderIDList: TStringList;
begin
  OrderIDList := TStringList.Create;
  try
    for i := 0 to SelectList.Count - 1 do
    begin
      AnOrder := TOrder(SelectList.Items[i]);
      OrderIDList.Add(AnOrder.ID + '^^1'); // 3rd pce = 1 means releasing order
    end;
    if ExecuteSessionOrderChecks([OrderIDList]) then
    begin
      If OrderIDList.Count > 0 then
      begin
        for i := SelectList.Count - 1 downto 0 do
        begin
          AnOrder := TOrder(SelectList.Items[i]);
          if OrderIDList.IndexOf(AnOrder.ID + '^^1') < 0 then
          begin
            Changes.Remove(CH_ORD, AnOrder.ID);
            SelectList.Delete(i);
          end;
        end;
      end;
    end;
    if OrderIDList.Count < 1 then
      SelectList.Clear;
  finally
    OrderIDList.Free;
  end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure TfrmOCSession.chkALLClick(Sender: TObject);
var
  Li: TListItem;
begin

  { TODO -oChris Bell : make sure we dont cancel non orders }
  for Li in lvOrders.Items do
  begin
    if Assigned(Li.Data) then
    begin
      if AnsiIndexText(TOrderRec(Li.Data).OrderID, NonOrders) = -1 then
      begin
        Li.Checked := TCheckBox(Sender).Checked;
        TOrderRec(Li.Data).Canceled := TCheckBox(Sender).Checked;
        if Li.Checked Then
          Li.StateIndex := Status_Chk
        else
          Li.StateIndex := Status_UnChk;
      end;
    end;
  end;
  UpdateStatusIcons;
end;

procedure TfrmOCSession.ckbLegendClick(Sender: TObject);
begin
  inherited;
  pnlLegend.Visible := ckbLegend.Checked;
  pnlLegend.Invalidate;
end;

procedure TfrmOCSession.cmdAcceptOrdersClick(Sender: TObject);

  procedure RemoveCanceled();
  var
    X, y: Integer;
    lstItm: TListItem;
    TheRec: TOrderRec;
  begin
    for lstItm in lvOrders.Items do
    begin
      if Assigned(lstItm.Data) then
      begin
        TheRec := TOrderRec(lstItm.Data);

        if AnsiIndexText(TheRec.OrderID, NonOrders) > -1 then
          continue;

        if TheRec.Canceled then
        begin
          if DeleteCheckedOrder(TheRec.OrderID) then
          begin
            Changes.Remove(CH_ORD, TheRec.OrderID);

            for X := Low(FOrderList) to High(FOrderList) do
            begin
              for y := FOrderList[X].Count - 1 downto 0 do
                if Piece(FOrderList[X].Strings[y], U, 1) = TheRec.OrderID then
                  FOrderList[X].Delete(y);

            end;
          end;
        end;
      end;
    end;
  end;

  procedure ProcessChks();
  var
    AnOrderID, CommentStr, ReasonStr: String;
    CList, RList: TStringList;
    lstItm: TListItem;
    TheRec: TOrderRec;
  begin
    RList := TStringList.Create;
    CList := TStringList.Create;
    try

      for lstItm in lvOrders.Items do
      begin
        if Assigned(lstItm.Data) then
        begin
          TheRec := TOrderRec(lstItm.Data);

          if AnsiIndexText(TheRec.OrderID, NonOrders) > -1 then
            continue;

          if not TheRec.Canceled then
          begin
            if Not TheRec.IsCritical then
              ReasonStr := 'Not Critical'
            else
              ReasonStr := trim(TheRec.OverRideSel);

            CommentStr := trim(TheRec.CommentTxt.text);
            AnOrderID := TheRec.OrderID;

            RList.Add(AnOrderID + '^' + ReasonStr);
            CList.Add(AnOrderID + '^' + CommentStr);
          end;
        end;
      end;

      StatusText('Saving Order Check...');
      if CheckList1.Count > 0 then
        SaveMultiOrderChecksForSession(CheckList1, RList, CList);
      StatusText('');
    finally
      CList.Free;
      RList.Free;
    end;
  end;

  function ShowTaskMessage(MessageText: WideString;
    CancelItems, Allgy: Boolean): Boolean;
  begin
    Result := false;
{$WARN SYMBOL_PLATFORM OFF}
    with TTaskDialog.Create(self) do
      try
        Title := 'Confirm Changes';
        Caption := 'Pending Changes';
        text := MessageText;
        CommonButtons := [];
        with TTaskDialogButtonItem(Buttons.Add) do
        begin
          Caption := 'Yes';
          CommandLinkHint := 'Proceed and process these changes.';
          ModalResult := mrYes;
        end;
        with TTaskDialogButtonItem(Buttons.Add) do
        begin
          Caption := 'No';
          CommandLinkHint := 'Return to the previous screen.';
          ModalResult := mrNo;
        end;
        Flags := [tfUseCommandLinks, tfAllowDialogCancellation];
        MainIcon := tdiInformation;
        if Allgy and CancelItems then
        begin
          FooterText :=
            'Item(s) marked for cancel will be canceled and removed.' + #13#10 +
            'An allergy assesment will be filed.';
          FooterIcon := tdiWarning;
        end
        else if Allgy then
        begin
          FooterText := 'An allergy assessment will be filed.';
          FooterIcon := tdiInformation;
        end
        else if CancelItems then
        begin
          FooterText :=
            'Item(s) marked for cancel will be canceled and removed.';
          FooterIcon := tdiWarning;
        end;

        if Execute then // requires Runtime Themes to be selected for the project
          if ModalResult = mrYes then
            Result := true;
      finally
        Free;
      end
{$WARN SYMBOL_PLATFORM ON}
  end;

var
  lstItm: TListItem;
  ChangeLst, CancelLst: TStringList;
  TheRec: TOrderRec;
  ChangeStr: WideString;
  StrItm: String;
begin
  inherited;

  ChangeLst := TStringList.Create;
  CancelLst := TStringList.Create;
  Screen.Cursor := crHourGlass;
  try
    ChangeLst.Clear;
    for lstItm in lvOrders.Items do
    begin
      if Assigned(lstItm.Data) then
      begin
        TheRec := TOrderRec(lstItm.Data);
        if AnsiIndexText(TheRec.OrderID, NonOrders) > -1 then
          continue;

        if TheRec.Canceled then
          CancelLst.Add(MixedCase(TheRec.OrderName))
        else
          ChangeLst.Add(MixedCase(TheRec.OrderName))
      end;
    end;
    ChangeStr := '';

    if CancelLst.Count > 0 then
      ChangeStr := 'The following item(s) will be canceled:' + #13#10;
    for StrItm in CancelLst do
      ChangeStr := ChangeStr + StrItm + #13#10;

    if trim(ChangeStr) <> '' then
      ChangeStr := ChangeStr + #13#10;

    if ChangeLst.Count > 0 then
      ChangeStr := ChangeStr +
        'The following item(s) will be accepted:' + #13#10;
    for StrItm in ChangeLst do
      ChangeStr := ChangeStr + StrItm + #13#10;

    if trim(ChangeStr) <> '' then
      ChangeStr := ChangeStr + #13#10;
    if ShowTaskMessage(ChangeStr, (CancelLst.Count > 0),
      false { Assigned(FAllgyFrm) } )
    // commenting out fAllgyFrm infavor of button
    then
    begin
      // Cancel process
      if CancelLst.Count > 0 then
        RemoveCanceled;

      // build the save
      if ChangeLst.Count > 0 then
        ProcessChks;

      ModalResult := mrOk;
    end
    else
      ModalResult := mrNone;

  finally
    Screen.Cursor := crDefault;
    CancelLst.Free;
    ChangeLst.Free;
  end;

end;

procedure TfrmOCSession.cmdMonographClick(Sender: TObject);
var
  monoList: TStringList;
begin
  inherited;
  monoList := TStringList.Create;
  GetMonographList(monoList);
  ShowMonographs(monoList);
  monoList.Free;
end;

procedure TfrmOCSession.cmbOverReasonChange(Sender: TObject);
begin
  inherited;
  if Assigned(overrideRecord) then
  begin
    overrideRecord.OverRideSel := cmbOverReason.text;
    overrideRecord.IsComplete := (Length(trim(overrideRecord.OverRideSel)) > 4)
      and not ContainsUpCarretChar(overrideRecord.OverRideSel);
    UpdateStatusIcons;
  end;
end;

procedure TfrmOCSession.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  SaveUserBounds(self); // Save Position & Size of Form
  DeleteMonograph;
end;

procedure TfrmOCSession.FormShow(Sender: TObject);
begin
  inherited;
  SetFormPosition(self); // Get Saved Position & Size of Form
  // 508 Code here
  if ScreenReaderActive = true then
  begin
    lblInstr.TabStop := true;
    lblNote.TabStop := true;
    lblOverrideChecks.TabStop := true;
    lblInstr.SetFocus;
  end;

  rchOrdChk.AutoDetect := true;

  AdjustSizes;

  UpdateStatusIcons;

end;

procedure TfrmOCSession.lvOrdersClick(Sender: TObject);
var
  htst: THitTests;
  lvCurPos: TPoint;
  lstItm: TListItem;
begin

  inherited;
  lvCurPos := lvOrders.ScreenToClient(Mouse.CursorPos);
  htst := lvOrders.GetHitTestInfoAt(lvCurPos.X, lvCurPos.y);

  if htOnStateIcon in htst then
  begin
    lstItm := lvOrders.GetItemAt(lvCurPos.X, lvCurPos.y);
    if Assigned(lstItm) then
    begin
      if Assigned(lstItm.Data) then
      begin
        if AnsiIndexText(TOrderRec(lstItm.Data).OrderID, NonOrders) = -1 then
        begin
          Case lstItm.StateIndex of
            - 1:
              exit;
            Status_UnChk:
              begin
                lstItm.StateIndex := Status_Chk;
                lstItm.Checked := true;
                TOrderRec(lstItm.Data).Canceled := true;
              end;
            Status_Chk:
              begin
                lstItm.StateIndex := Status_UnChk;
                lstItm.Checked := false;
                TOrderRec(lstItm.Data).Canceled := false;
              end;
          End;
        end;
      end;
    end;
  end;
  UpdateStatusIcons;
end;

procedure TfrmOCSession.UpdateStatusIcons();
var
  lstItm: TListItem;
  AnyIncomplete: Boolean;
  ItemsRemaining: Integer;
begin
  AnyIncomplete := false;
  lvOrders.Items.BeginUpdate;
  ItemsRemaining := 0;
  for lstItm in lvOrders.Items do
  begin
    if lstItm.Checked then
      lstItm.SubItemImages[0] := State_Cancel
    else
    begin
      if Assigned(lstItm.Data) then
      begin
        if AnsiIndexText(TOrderRec(lstItm.Data).OrderID, NonOrders) = -1 then
        begin
          if TOrderRec(lstItm.Data).IsComplete then
            lstItm.SubItemImages[0] := State_Chk
          else
          begin
            if TOrderRec(lstItm.Data).IsCritical then
              lstItm.SubItemImages[0] := State_Alert
            else
              lstItm.SubItemImages[0] := -1;
            AnyIncomplete := true;
            if TOrderRec(lstItm.Data).IsCritical then
              Inc(ItemsRemaining);
          end;
        end;
      end;
    end;
  end;
  lvOrders.Items.EndUpdate;
  cmdContinue.Enabled := not AnyIncomplete;

  // Update remaining count
  LblOverrideNum.Caption := IntToStr(ItemsRemaining);
end;

procedure TfrmOCSession.lvOrdersSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
var
  i: Integer;
  cmbchange: boolean;
const
  fmtOrderTitle = 'Order Checks for: %s';
begin
  // Load the info
  if not Assigned(Item.Data) then
    exit;

  overrideRecord := TOrderRec(Item.Data);

  Panel1.BringToFront;
  // Populate the data
  rchOrdChk.Clear;
  rchOrdChk.Clear;
  memRmtCmt.Clear;
  pnlOrdGrp.Caption := Format(fmtOrderTitle, [overrideRecord.OrderName]);
  // Add the critical header if needed
  if overrideRecord.IsCritical then
  begin
    pnlReason.TabStop := false;
    cmbOverReason.Enabled := true;
    rchOrdChk.SelAttributes.Color := Get508CompliantColor(clRed);
    rchOrdChk.Lines.Add(REASON_REQUIRED_FOR_OVERRIDE);
    // '*Order Check Requires Reason for Override'});
  end
  else
  begin
    cmbOverReason.ItemIndex := -1;
    cmbOverReason.Enabled := false;
    pnlReason.TabStop := ScreenReaderActive;
    //TDP - If not Critical change status indicator to Check/Complete
    //TOrderRec(lvOrders.Items.Item[lvOrders.ItemIndex].Data).IsComplete := true;//.SubItemImages[0] := State_Chk;
    TOrderRec(Item.Data).IsComplete := true;
    UpdateStatusIcons;
  end;

  for i := 0 to overrideRecord.OrderCheckTxt.Count - 1 do
  begin
    rchOrdChk.SelAttributes.Color := Get508CompliantColor(clBlack);
    rchOrdChk.SelAttributes.Style := [fsBold];
    rchOrdChk.Lines.Add('(' + IntToStr(i + 1) + ' of ' +
      IntToStr(overrideRecord.OrderCheckTxt.Count) + ')  ');
    rchOrdChk.SelAttributes.Style := [];

    if Piece(overrideRecord.OrderCheckTxt.Strings[i], U, 1) = '1' then
      // High
      rchOrdChk.SelAttributes.Color := Get508CompliantColor(clBlue)
    else if Piece(overrideRecord.OrderCheckTxt.Strings[i], U, 1) = '2' then
      // Moderate
      rchOrdChk.SelAttributes.Color := Get508CompliantColor(clGreen)
    else
      // Low
      rchOrdChk.SelAttributes.Color := Get508CompliantColor(clBlack);

    rchOrdChk.Lines.Add(Piece(overrideRecord.OrderCheckTxt.Strings[i], U, 2));

    rchOrdChk.Lines.Add('');
  end;

  cmbOverReason.Items := overrideRecord.OverRideReasons;
  cmbOverReason.ItemIndex := -1;

  cmbchange := false;

  if overrideRecord.OverRideSel <> '' then
  begin
    for i := 0 to cmbOverReason.Items.Count - 1 do
      if cmbOverReason.Items.Strings[i] = overrideRecord.OverRideSel then
      begin
        cmbOverReason.ItemIndex := i;
        cmbchange := true;
        break;
      end;

    if cmbOverReason.ItemIndex = -1 then
    begin
      cmbOverReason.text := overrideRecord.OverRideSel;
      cmbchange := true;
    end;

    if cmbchange then cmbOverReasonChange(cmbOverReason);

  end;

  cmbOverReason.Enabled := overrideRecord.IsCritical;
  memRmtCmt.Lines := overrideRecord.CommentTxt;

  // AA: disabling changes color of the memRmtCmt. ReadOnly is enough
  // memRmtCmt.Enabled := overrideRecord.HaveComment;
  memRmtCmt.ReadOnly := not overrideRecord.HaveComment;
  if not overrideRecord.HaveComment then
  begin
    memRmtCmt.text := NO_REMOTE_COMMENTS;
    memRmtCmt.Color := clBtnFace;
  end
  else
    memRmtCmt.Color := clWindow;

  if ScreenReaderActive then
    pnlReason.TabStop := not memRmtCmt.Enabled;

  if not overrideRecord.IsCritical then
    overrideRecord.IsComplete := true;

end;

procedure TfrmOCSession.memRmtCmtChange(Sender: TObject);
begin
  inherited;
  if memRmtCmt.text = NO_REMOTE_COMMENTS then
    exit;
  if Assigned(overrideRecord) then
    overrideRecord.CommentTxt.Assign(memRmtCmt.Lines);
end;

procedure TfrmOCSession.PnlTopResize(Sender: TObject);
const
  RectBuffer = 150;
var
  ARect: TRect;
begin
  ARect := TRect.Create(lblInstr.Left, lblInstr.Top,
    lblInstr.Left + (lblInstr.Width - RectBuffer),
    lblInstr.Top + lblInstr.height);

  WrappedTextHeightByFont(self.Canvas, lblInstr.Font, lblInstr.Caption, ARect);

  if lblInstr.height <> ARect.Bottom then
    lblInstr.height := ARect.Bottom;

  inherited;
end;

procedure TfrmOCSession.pmShowLgndClick(Sender: TObject);
begin
  inherited;
  pmShowLgnd.Checked := not pmShowLgnd.Checked;
  pnlLegend.Visible := pmShowLgnd.Checked;
end;

procedure TfrmOCSession.txtJustifyKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  // GE CQ9540  activate Return key, behave as "Continue" buttom clicked.
  if Key = VK_RETURN then
    cmdAcceptOrdersClick(self);
end;

procedure TfrmOCSession.acAllergyAssessmentExecute(Sender: TObject);
begin
  inherited;
  fAllgyAR.EnterEditAllergy(0, true, false);
  // until the Allergy form is redesigned let's depend on the RPC results
{$IFDEF DEBUG_AA}
{$ELSE}
  acAllergyAssessment.Enabled := sCallV('ORQQAL LIST', [Patient.DFN])
    = '^No Allergy Assessment';
{$ENDIF}
end;

procedure TfrmOCSession.acViewMonographExecute(Sender: TObject);
var
  monoList: TStringList;
begin
  inherited;
  monoList := TStringList.Create;
  GetMonographList(monoList);
  ShowMonographs(monoList);
  monoList.Free;
end;

procedure TfrmOCSession.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if (Key = VK_F4) and (ssAlt in Shift) then
    Key := 0;
end;

procedure TfrmOCSession.AdjustSizes;
var
  i: Integer;
const
  iGap = 8;
begin
  chkALL.Width := Canvas.TextWidth(chkALL.Caption) + 2 * iGap + 8;
  ckbLegend.Left := chkALL.Left + chkALL.Width + iGap;
  ckbLegend.Width := Canvas.TextWidth(ckbLegend.Caption) + 2 * iGap;

  btnAllergy.Width := Canvas.TextWidth(btnAllergy.Caption) + 2 * iGap;

  btnMonograph.Left := btnAllergy.Left + btnAllergy.Width + iGap;
  btnMonograph.Width := Canvas.TextWidth(btnMonograph.Caption) + 2 * iGap;

  btnReturn.Width := Canvas.TextWidth(btnReturn.Caption) + 2 * iGap;
  btnReturn.Left := PnlBtn.Width - iGap - btnReturn.Width;

  cmdContinue.Width := Canvas.TextWidth(cmdContinue.Caption) + 2 * iGap;
  cmdContinue.Left := btnReturn.Left - iGap - cmdContinue.Width;

  i := Canvas.TextHeight(lblOverrideChecks.Caption) + iGap;
  lblOverrideChecks.height := i;
  PnlCtrBtm.height := i + iGap;

  i := i + iGap;

  btnReturn.height := i;
  btnAllergy.height := i;
  btnMonograph.height := i;
  cmdContinue.height := i;

  PnlBtn.height := i + iGap * 2;

end;

// TDP - Added init and final
initialization

  CheckList1 := TStringList.Create;

finalization

  CheckList1.Free;

end.
