unit fImmunization;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fPCEBase, StdCtrls, ORCtrls, CheckLst, ExtCtrls, Buttons, uPCE, rPCE, ORFn,
  fPCELex, fPCEOther, ComCtrls, fPCEBaseMain, VA508AccessibilityManager, fVimm, rvimm;

type
  TfrmImmunizations = class(TfrmPCEBaseMain)
    btnAdd: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure btnOtherClick(Sender: TObject);
    procedure btnOtherExit(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject); override;
    procedure btnCancelClick(Sender: TObject);
  private
  protected
    procedure UpdateNewItemStr(var x: string); override;
    procedure UpdateControls; override;
  public
    procedure FormatVimmInputs(Grid: boolean);
    procedure processVimm;
//    procedure ChangeProvider;
  end;

var
  frmImmunizations: TfrmImmunizations;

implementation

{$R *.DFM}

uses
  fEncounterFrame, VA508AccessibilityRouter, uCore;


procedure TfrmImmunizations.btnAddClick(Sender: TObject);
var
i: integer;
APCEItem: TPCEImm;
vimmData: TVimmResult;
begin
  inherited;
  FormatVimmInputs(false);
  uvimmInputs.DataList := TStringList.Create;
  try
    for i := 0 to lstCaptionList.Items.Count-1 do
      begin
        APCEItem := TPCEImm(lstCaptionList.Objects[i]);
        if not assigned(APCEItem) then continue;
        vimmData := findVimmResultsByDelimitedStr(APCEItem.delimitedStrTxt, APCEItem.delimitedStr1Txt,
                    APCEItem.delimitedStr2Txt);
        vimmData.documType := 'Administered';
        uVimmInputs.DataList.AddObject('DATA' + U + vimmData.id, vimmData);
      end;
    processVimm;
  finally
     clearResults;
     clearInputs;
  end;


end;

procedure TfrmImmunizations.FormatVimmInputs(Grid: boolean);
begin
    uvimmInputs.noGrid := grid;
    uvimmInputs.makeNote := false;
    uvimmInputs.collapseICE := true;
    uvimmInputs.canSaveData := false;
    uvimmInputs.patientName := patient.Name;
    uvimmInputs.patientIEN := patient.DFN;
    uvimmInputs.userName := user.Name;
    uvimmInputs.userIEN := user.DUZ;
    uVimmInputs.startInEditMode := false;
    uvimmInputs.encounterProviderName := encounter.ProviderName;
    uvimmInputs.encounterProviderIEN := encounter.Provider;
    uvimmInputs.encounterLocation := uEncPCEData.Location;
    uvimmInputs.encounterCategory := uEncPCEData.VisitCategory;
    uvimmInputs.dateEncounterDateTime := uEncPCEData.VisitDateTime;
    uvimmInputs.visitString := uEncPCEData.VisitString;
end;

procedure TfrmImmunizations.btnCancelClick(Sender: TObject);
begin
  inherited;
  clearResults;
  clearInputs;
end;

procedure TfrmImmunizations.btnOKClick(Sender: TObject);
begin
  inherited;
  clearResults;
  clearInputs;
end;

procedure TfrmImmunizations.btnOtherClick(Sender: TObject);
begin
//  inherited;
end;

procedure TfrmImmunizations.btnOtherExit(Sender: TObject);
begin
////  inherited;
end;

procedure TfrmImmunizations.FormCreate(Sender: TObject);
begin
  inherited;
  FTabName := CT_ImmNm;
  FPCEListCodesProc := ListImmunizCodes;
  FPCEItemClass := TPCEImm;
  FPCECode := 'IMM';
  self.btnRemove.Visible := false;
  self.btnSelectAll.Visible := false;
end;

procedure TfrmImmunizations.FormPaint(Sender: TObject);
begin
inherited;
//  if ckbContra.Focused = True then
//  begin
//    frmImmunizations.Canvas.Pen.Width := 1;
//    frmImmunizations.Canvas.Pen.Style := psDot;
//    frmImmunizations.Canvas.MoveTo(lblContra.Left - 2,lblContra.Top - 1);
//    frmImmunizations.Canvas.LineTo(lblContra.Left + lblContra.Width + 2,lblContra.Top - 1);
//    frmImmunizations.Canvas.LineTo(lblContra.Left + lblContra.Width + 2,lblContra.Top + lblContra.Height);
//    frmImmunizations.Canvas.LineTo(lblContra.Left - 2,lblContra.Top + lblContra.Height);
//    frmImmunizations.Canvas.LineTo(lblContra.Left - 2,lblContra.Top - 1);
//  end;
end;

procedure TfrmImmunizations.processVimm;
var
  resultList: TStringList;
  i: Integer;
  str: String;
  data: TVimmResult;
  imm: TPCEImm;

  procedure removeAll;
  var
  c: integer;
  begin
    for c := 0 to lstCaptionList.Items.Count-1 do
      lstCaptionList.Items[c].Selected  := true;
    btnRemoveClick(lstCaptionList);
  end;


begin
  resultList := TStringList.Create;
  str := '';
  try
    if performVimm(resultList, false) = false then
      Exit;
    removeAll;
    if resultList.Count > 0 then
    begin
      for i := 0 to resultList.Count - 1 do
      begin
        data := TVimmResult(resultList.Objects[i]);
        imm := TPCEImm.Create(data);
        lstCaptionList.AddObject(imm.Narrative, imm);
      end;
      lstCaptionList.Update;
    end;
  finally
    FreeAndNil(resultList);
  end;
end;

procedure TfrmImmunizations.UpdateNewItemStr(var x: string);
begin
  inherited;
  SetPiece(x, U, pnumImmSeries, NoPCEValue);
  SetPiece(x, U, pnumImmReaction, NoPCEValue);
  SetPiece(x, U, pnumImmRefused, '0');
  SetPiece(x, U, pnumImmContra, '0');
end;

procedure TfrmImmunizations.UpdateControls;
var
  ok, Contra, First: boolean;
  SameS, SameR, SameC: boolean;
  i: integer;
  Ser, React: string;
  Obj: TPCEImm;

begin
  inherited;
  if(NotUpdating) then
  begin
    BeginUpdate;
    try
      ok := (lstCaptionList.SelCount > 0);
      if(ok) then
      begin
        First := TRUE;
        SameS := TRUE;
        SameR := TRUE;
        SameC := TRUE;
        Contra := FALSE;
        Ser := NoPCEValue;
        React := NoPCEValue;
        for i := 0 to lstCaptionList.Items.Count-1 do
        begin
          if lstCaptionList.Items[i].Selected then
          begin
            Obj := TPCEImm(lstCaptionList.Objects[i]);
            if(First) then
            begin
              First := FALSE;
              Contra := Obj.Contraindicated;
              Ser := Obj.Series;
              React := Obj.Reaction;
            end
            else
            begin
              if(SameS) then
                SameS := (Ser = Obj.Series);
              if(SameR) then
                SameR := (React = Obj.Reaction);
              if(SameC) then
                SameC := (Contra = Obj.Contraindicated);
            end;
          end;
        end;
      end;
    finally
      EndUpdate;
    end;
  end;
end;

initialization
  SpecifyFormIsNotADialog(TfrmImmunizations);

end.
