/**
 * The package gov.va.med.mbac.vlh.impl contains the VistaLinkHelper Class,
 * which implements the IVistaLinkHelper interface.
 * 
 * Including the unit tests in the same package as the classes under test allows test cases access to
 * friendly and protected members, without breaking encapsulation.
 * 
 */
package gov.va.med.mbac.vlh.impl;

import static org.mockito.Mockito.mock;
import gov.va.med.mbac.vlh.common.IVistaLinkHelper;
import gov.va.med.mbac.vlh.impl.VistaLinkHelper;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcResponse;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;

/**
 * This is the TestVistaLinkHelper class, which generates mock objects and
 * allows test cases to raise exceptions to exercise all process paths during
 * unit testing.
 * 
 * @author PII
 * @version 1.0.0
 */

public class TestVistaLinkHelper extends VistaLinkHelper implements IVistaLinkHelper {

    public static final int INST_MAP_NOT_FOUND_EXCEPTION = 444;
    public static final int INST_MAP_NOT_INIT_EXCEPTION = 333;
    public static final int RESOURCE_EXCEPTION = 222;
    public static final int NAMING_EXCEPTION = 111;
    private RpcRequest mockedReq = null;
    private RpcResponse mockedResp = null;
    private VistaLinkConnection mockedVlc = null;
    private int connectionFailCondition = 0;

    /**
     * 
     */
    public TestVistaLinkHelper(InitialContext initialContext) {
	super(initialContext);
	this.mockedReq = mock(RpcRequest.class);
	this.mockedResp = mock(RpcResponse.class);
	this.mockedVlc = mock(VistaLinkConnection.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.mbac.vpls.dao.common.IVistaLinkHelper#getRpcRequest()
     */
    @Override
    public RpcRequest getRpcRequest() {
	return mockedReq;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.va.med.mbac.vpls.dao.common.IVistaLinkHelper#getConnection(java.lang.
     * String, java.lang.String)
     */
    @Override
    public VistaLinkConnection getConnection(String siteId, String duz) throws InstitutionMapNotInitializedException,
	    InstitutionMappingNotFoundException, NamingException, ResourceException {

	switch (this.connectionFailCondition) {

	case NAMING_EXCEPTION:
	    throw new NamingException("NAMES!");
	case RESOURCE_EXCEPTION:
	    throw new ResourceException("RESOURCE!");
	case INST_MAP_NOT_INIT_EXCEPTION:
	    throw new InstitutionMapNotInitializedException("Institutional Malfunction!");
	case INST_MAP_NOT_FOUND_EXCEPTION:
	    throw new InstitutionMappingNotFoundException("Institutional Map Missing.");

	}

	return this.mockedVlc;

    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * gov.va.med.mbac.vlh.impl.VistaLinkHelper#getAppProxyConnection(java.lang.
     * String, java.lang.String)
     */
    @Override
    public VistaLinkConnection getAppProxyConnection(String siteId, String appProxyName)
	    throws InstitutionMapNotInitializedException, InstitutionMappingNotFoundException, NamingException,
	    ResourceException {

	switch (this.connectionFailCondition) {

	case NAMING_EXCEPTION:
	    throw new NamingException("NAMES!");
	case RESOURCE_EXCEPTION:
	    throw new ResourceException("RESOURCE!");
	case INST_MAP_NOT_INIT_EXCEPTION:
	    throw new InstitutionMapNotInitializedException("Institutional Malfunction!");
	case INST_MAP_NOT_FOUND_EXCEPTION:
	    throw new InstitutionMappingNotFoundException("Institutional Map Missing.");

	}

	return this.mockedVlc;
    }

    /**
     * @return the mockedReq
     */
    public RpcRequest getMockedReq() {
	return mockedReq;
    }

    /**
     * @return the mockedResp
     */
    public RpcResponse getMockedResp() {
	return mockedResp;
    }

    /**
     * @param mockedReq
     *            the mockedReq to set
     */
    public void setMockedReq(RpcRequest mockedReq) {
	this.mockedReq = mockedReq;
    }

    /**
     * @param mockedResp
     *            the mockedResp to set
     */
    public void setMockedResp(RpcResponse mockedResp) {
	this.mockedResp = mockedResp;
    }

    /**
     * @param aCFC
     *            the connectionFailCondition to set
     */
    public void setConnectionFailCondition(int aCFC) {
	this.connectionFailCondition = aCFC;
    }

    /**
     * @return the mockedVlc
     */
    public VistaLinkConnection getMockedVlc() {
	return mockedVlc;
    }

    /**
     * @param mockedVlc
     *            the mockedVlc to set
     */
    public void setMockedVlc(VistaLinkConnection mockedVlc) {
	this.mockedVlc = mockedVlc;
    }

}
