/**
 * The package gov.va.med.mbac.vlh.impl contains the VistaLinkHelper Class,
 * which implements the IVistaLinkHelper interface.
 * 
 * Including the unit tests in the same package as the classes under test allows test cases access to
 * friendly and protected members, without breaking encapsulation.
 * 
 */
package gov.va.med.mbac.vlh.impl;

import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;

/**
 * This is the MockitoFactoryBean class, which generates mock objects in the
 * VistaLinkHelperTest Spring context (see vlhTestBeans.xml & vlhTestBeansNoReq.xml).
 * 
 * @author PII
 * @version 1.0.0
 */
public class MockitoFactoryBean<T> implements FactoryBean<T> {

	private Class<T> classToBeMocked;
	
	/**
	 * Creates a Mockito mock instance of the provided class.
	 * 
	 * @param classToBeMocked
	 */
	public MockitoFactoryBean(Class<T> classToBeMocked) {
		super();
		this.classToBeMocked = classToBeMocked;
	}

	/* (non-Javadoc)
	 * @see org.springframework.beans.factory.FactoryBean#getObject()
	 */
	@Override
	public T getObject() throws Exception {
		return Mockito.mock(classToBeMocked);
	}

	/* (non-Javadoc)
	 * @see org.springframework.beans.factory.FactoryBean#getObjectType()
	 */
	@Override
	public Class<?> getObjectType() {
		return classToBeMocked;
	}

	/* (non-Javadoc)
	 * @see org.springframework.beans.factory.FactoryBean#isSingleton()
	 */
	@Override
	public boolean isSingleton() {
		return true;
	}

}
