/**
 * The package gov.va.med.mbac.vlh.common contains the public Interface for
 * VistaLinkHelper.
 * 
 */
package gov.va.med.mbac.vlh.common;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import gov.va.med.vistalink.rpc.RpcRequest;

import javax.naming.NamingException;
import javax.resource.ResourceException;

import org.springframework.beans.BeansException;

/**
 * This is the interface for the VistaLinkHelper class, which helps preserve
 * coherence and single-responsibility for our DAO classes by handling
 * interactions with VistaLink on their behalf.
 * 
 * @author PII
 * @version 1.0.0
 */
public interface IVistaLinkHelper {
		
	/**
	 * @return RpcRequest
	 * @throws BeansException
	 */
	public abstract RpcRequest getRpcRequest() throws BeansException;

	/**
	 * @param siteId
	 * @param duz
	 * @return VistaLinkConnection
	 * @throws InstitutionMapNotInitializedException
	 * @throws InstitutionMappingNotFoundException
	 * @throws NamingException
	 * @throws ResourceException
	 */
	public abstract VistaLinkConnection getConnection(String siteId, String duz)
			throws InstitutionMapNotInitializedException,
			InstitutionMappingNotFoundException, NamingException,
			ResourceException;

	/**
	 * @param siteId
	 * @param appProxyName
	 * @return VistaLinkConnection
	 * @throws InstitutionMapNotInitializedException
	 * @throws InstitutionMappingNotFoundException
	 * @throws NamingException
	 * @throws ResourceException
	 */
	public abstract VistaLinkConnection getAppProxyConnection(String siteId, String appProxyName)
		throws InstitutionMapNotInitializedException,
		InstitutionMappingNotFoundException, NamingException,
		ResourceException;
	
}
