/**
 * The package gov.va.med.mbcp.champva.rest contains the RESTful Web Application & Resource classes for
 * retrieval of Code Results from the target VistA instance.
 * 
 */
package gov.va.med.mbcp.champva.rest;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.powermock.api.mockito.PowerMockito.verifyNew;
import static org.powermock.api.mockito.PowerMockito.whenNew;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.med.mbcp.champva.dao.common.IChampVAPayDAO;
import gov.va.med.mbcp.champva.dao.impl.ChampVAPayDAO;

/**
 * Test class for ChampVAResource initialization.
 * 
 * @author PII
 * @version 1.0.0
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest({ ChampVAResource.class })
public class ChampVAResourceInitializerTest {

    /**
     * Test method for
     * {@link gov.va.med.mbcp.champva.rest.ChampVAResource#ChampVAResource()} .
     */
    @Test
    public void testChampVAResource() {
	try {
	    ChampVAResource cr = new ChampVAResource();
	    assertNotNull("cr failed to initialize.", cr);
	} catch (BeansException e) {
	    fail("failed with BeansException: " + e.getMessage());
	}
    }

    /**
     * Test That Initializer calls new
     * ClassPathXmlApplicationContext("/champvaBeans.xml")
     * 
     */
    @Test
    public void testThatInitializerCallsNewClassPathXmlApplicationContext() {
	try {
	    ClassPathXmlApplicationContext mockedAppCtxt = mock(ClassPathXmlApplicationContext.class);
	    whenNew(ClassPathXmlApplicationContext.class).withAnyArguments().thenReturn(mockedAppCtxt);
	    new ChampVAResource();
	    verifyNew(ClassPathXmlApplicationContext.class, times(1)).withArguments("/champvaBeans.xml");
	} catch (BeansException e) {
	    fail("failed with BeansException: " + e.getMessage());
	} catch (Exception e) {
	    fail("failed with Exception: " + e.getMessage());
	}
    }

    /**
     * Test That Initializer Calls appContext.getBean("champVAPayDAO")
     * 
     */
    @Test
    public void testThatInitializerCallsAppContextGetBeanForChampVAPayDAO() {
	try {
	    ClassPathXmlApplicationContext mockedAppCtxt = mock(ClassPathXmlApplicationContext.class);
	    whenNew(ClassPathXmlApplicationContext.class).withAnyArguments().thenReturn(mockedAppCtxt);
	    IChampVAPayDAO mockedChampVAPayDAO = mock(ChampVAPayDAO.class);
	    when(mockedAppCtxt.getBean("champVAPayDAO")).thenReturn(mockedChampVAPayDAO);
	    new ChampVAResource();
	    verify(mockedAppCtxt, times(1)).getBean("champVAPayDAO");
	} catch (BeansException e) {
	    fail("failed with BeansException: " + e.getMessage());
	} catch (Exception e) {
	    fail("failed with Exception: " + e.getMessage());
	}
    }

    /**
     * Test That Initializer Calls appContext.getBean("objectMapper")
     * 
     */
    @Test
    public void testThatInitializerCallsAppContextGetBeanForObjectMapper() {
	try {
	    ClassPathXmlApplicationContext mockedAppCtxt = mock(ClassPathXmlApplicationContext.class);
	    whenNew(ClassPathXmlApplicationContext.class).withAnyArguments().thenReturn(mockedAppCtxt);
	    ObjectMapper mockedMapper = mock(ObjectMapper.class);
	    when(mockedAppCtxt.getBean("objectMapper")).thenReturn(mockedMapper);
	    new ChampVAResource();
	    verify(mockedAppCtxt, times(1)).getBean("objectMapper");
	} catch (BeansException e) {
	    fail("failed with BeansException: " + e.getMessage());
	} catch (Exception e) {
	    fail("failed with Exception: " + e.getMessage());
	}
    }

    /**
     * Test That Initializer Calls appContext.close()
     * 
     */
    @Test
    public void testThatInitializerCallsAppContextClose() {
	try {
	    ClassPathXmlApplicationContext mockedAppCtxt = mock(ClassPathXmlApplicationContext.class);
	    whenNew(ClassPathXmlApplicationContext.class).withAnyArguments().thenReturn(mockedAppCtxt);
	    new ChampVAResource();
	    verify(mockedAppCtxt, times(1)).close();
	} catch (BeansException e) {
	    fail("failed with BeansException: " + e.getMessage());
	} catch (Exception e) {
	    fail("failed with Exception: " + e.getMessage());
	}
    }

}
