/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;

/**
 * Unit Tests for the CodeResult Class
 * 
 * @author PII
 * @version 1.0.0
 */
public class CodeResultTest {
    
    private static final String YES_RESULT = "Yes";
    private static final String NO_RESULT = "No";
    private static final String COND_RESULT = "Yes^You need to say 'pretty please!'";

    private CodeResult mYesResult = null;
    private CodeResult mNoResult = null;
    private CodeResult mCondResult = null;
    
    /**
     * The setUp method, to be executed before each test and initialize the
     * CodeResults under test.
     * 
     * @throws java.lang.Exception - an Exception propagated during set up.
     */
    @Before
    public void setUp() throws Exception {
	mYesResult = new CodeResult(YES_RESULT);
	mNoResult = new CodeResult(NO_RESULT);
	mCondResult = new CodeResult(COND_RESULT);
    }

    /**
     * The tearDown method, to be executed after each test and dispose of the
     * CodeResults under test.
     * 
     * @throws java.lang.Exception - an Exception propagated during tear down.
     */
    @After
    public void tearDown() throws Exception {
	mYesResult = null;
	mNoResult = null;
	mCondResult = null;
    }

    /**
     * Test method for {@link gov.va.med.mbcp.champva.domain.impl.CodeResult#CodeResult()}.
     */
    @Test
    public void testCodeResult() {
	CodeResult emptyResult = new CodeResult();
        assertNotNull("Initialization failed using default constructor.", emptyResult);
    }

    /**
     * Test method for {@link gov.va.med.mbcp.champva.domain.impl.CodeResult#CodeResult(java.lang.String)}.
     */
    @Test
    public void testCodeResultString() {
        assertNotNull("Initialization failed using CodeResult(YES_RESULT).", mYesResult);
        assertNotNull("Initialization failed using CodeResult(NO_RESULT).", mNoResult);
        assertNotNull("Initialization failed using CodeResult(COND_RESULT).", mCondResult);
    }

    /**
     * Test method for {@link gov.va.med.mbcp.champva.domain.impl.CodeResult#getResult()}.
     */
    @Test
    public void testGetResult() {
	String pieces[] = COND_RESULT.split("\\^");
        assertEquals(YES_RESULT, mYesResult.getResult());
        assertEquals(NO_RESULT, mNoResult.getResult());
        assertEquals(pieces[0], mCondResult.getResult());
    }

    /**
     * Test method for {@link gov.va.med.mbcp.champva.domain.impl.CodeResult#getMessage()}.
     */
    @Test
    public void testGetMessage() {
	String pieces[] = COND_RESULT.split("\\^");
        assertEquals(null, mYesResult.getMessage());
        assertEquals(null, mNoResult.getMessage());
        assertEquals(pieces[1], mCondResult.getMessage());
    }

    /**
     * Test method for {@link gov.va.med.mbcp.champva.domain.impl.CodeResult#hashCode()}.
     */
    @Test
    public void testHashCode() {
	CodeResult dResult = new CodeResult();
	assertEquals(961, dResult.hashCode());
        assertEquals(89736, mYesResult.hashCode());
        assertEquals(3490, mNoResult.hashCode());
        assertEquals(1076945156, mCondResult.hashCode());
    }

    /**
     * Test method for {@link gov.va.med.mbcp.champva.domain.impl.CodeResult#equals(java.lang.Object)}.
     */
    @Test
    public void testEqualsObject() {
	CodeResult yesResult = new CodeResult(YES_RESULT);
	CodeResult noResult = new CodeResult(NO_RESULT);
	CodeResult condResult = new CodeResult(COND_RESULT);
	CodeResult dResult = new CodeResult();
	CodeResult eResult = new CodeResult();
	CodeResult fooResult = new CodeResult("Yes^FUBAR");
	ChampVAException ce = new ChampVAVLFaultException(new VistaLinkFaultException("Foobah!"));
	assertEquals(mYesResult, yesResult);
	assertEquals(mNoResult, noResult);
	assertEquals(mCondResult, condResult);
	assertEquals(mYesResult, mYesResult);
	assertEquals(dResult, eResult);
	assertNotEquals(yesResult, null);
	assertNotEquals(noResult, ce);
	assertNotEquals(noResult, condResult);
	assertNotEquals(condResult, fooResult);
	assertNotEquals(dResult, noResult);
	assertNotEquals(yesResult, noResult);
    }

}
