/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import static org.junit.Assert.assertEquals;

import javax.naming.NamingException;
import javax.resource.ResourceException;

import org.junit.Test;

import com.fasterxml.jackson.core.JsonGenerationException;

import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;

/**
 * Unit Tests for the ChampVAException Classes.
 * 
 * @author PII
 * @version 1.0.0
 */
public class ChampVAExceptionTest {

    /**
     * Test that a ChampVAVLFaultException returns the Error Code 100.
     */
    @Test
    public void testChampVAVLFaultException() {
	ChampVAException champVAException = new ChampVAVLFaultException(new VistaLinkFaultException("WOOT!"));
	assertEquals(ChampVAException.VISTALINK_FAULT_EXCEPTION, champVAException.getErrorCode());
    }

    /**
     * Test that a ChampVAFoundationsException returns the Error Code 200.
     */
    @Test
    public void testChampVAFoundationsException() {
	ChampVAException champVAException = new ChampVAFoundationsException(new FoundationsException("WOOT!"));
	assertEquals(ChampVAException.FOUNDATIONS_EXCEPTION, champVAException.getErrorCode());
    }

    /**
     * Test that a ChampVANamingException returns the Error Code 300.
     */
    @Test
    public void testChampVANamingException() {
	ChampVAException champVAException = new ChampVANamingException(new NamingException("WOOT!"));
	assertEquals(ChampVAException.NAMING_EXCEPTION, champVAException.getErrorCode());
    }

    /**
     * Test that a ChampVAResourceException returns the Error Code 400.
     */
    @Test
    public void testChampVAResourceException() {
	ChampVAException champVAException = new ChampVAResourceException(new ResourceException("WOOT!"));
	assertEquals(ChampVAException.RESOURCE_EXCEPTION, champVAException.getErrorCode());
    }

    /**
     * Test that a ChampVAJsonException returns the Error Code 500.
     */
    @Test
    public void testChampVAJsonException() {
	ChampVAException champVAException = new ChampVAJsonException(new JsonGenerationException("WOOT!"));
	assertEquals(ChampVAException.JSON_PROCESSING_EXCEPTION, champVAException.getErrorCode());
    }

}
