/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import gov.va.med.mbcp.champva.domain.common.ICodeResult;

/**
 * Class CodeResult is the Data Transfer Object for the CHAMPVA Pay Service
 * 
 * @author PII
 * @version 1.0.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CodeResult implements ICodeResult {
    
    private String result;
    private String message;

    public CodeResult() {
	super();
    }

    public CodeResult(String crString) {
	this();
	String pieces[] = crString.split("\\^");
	this.setResult(pieces[0]);
	if (pieces.length == 2) {
	    this.setMessage(pieces[1]);
	}
    }

    /* (non-Javadoc)
     * @see gov.va.med.mbcp.champva.domain.common.ICodeResult#getResult()
     */
    @Override
    public String getResult() {
	return result;
    }
    
    private void setResult(String result) {
	this.result = result;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mbcp.champva.domain.common.ICodeResult#getMessage()
     */
    @Override
    public String getMessage() {
	return message;
    }

    private void setMessage(String message) {
	this.message = message;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
	final int prime = 31;
	int result = 1;
	result = prime * result + ((message == null) ? 0 : message.hashCode());
	result = prime * result + ((this.result == null) ? 0 : this.result.hashCode());
	return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
	if (this == obj) {
	    return true;
	}
	if (obj == null) {
	    return false;
	}
	if (!(obj instanceof CodeResult)) {
	    return false;
	}
	CodeResult other = (CodeResult) obj;
	if (message == null) {
	    if (other.message != null) {
		return false;
	    }
	} else if (!message.equals(other.message)) {
	    return false;
	}
	if (result == null) {
	    if (other.result != null) {
		return false;
	    }
	} else if (!result.equals(other.result)) {
	    return false;
	}
	return true;
    }
}
