/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;

/**
 * ChampVAVLFaultException is the wrapper Exception used to handle
 * VistaLinkFaultExceptions propagated by VistaLink within the CHAMPVA Pay
 * Service.
 * 
 * @author PII
 * @version 1.0.0
 */
public class ChampVAVLFaultException extends ChampVAException {

    private static final long serialVersionUID = 967372738989967205L;

    /**
     * Constructor for the ChampVAVLFaultException.
     * 
     * @param vlfe
     *            - a VistalinkFaultException to be handled.
     */
    public ChampVAVLFaultException(VistaLinkFaultException vlfe) {
	super(vlfe);
	this.setErrorCode(VISTALINK_FAULT_EXCEPTION);
    }

}
