/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import javax.naming.NamingException;

/**
 * ChampVANamingException is the wrapper Exception used to handle
 * NamingExceptions propagated by VistaLink within the CHAMPVA Pay Service.
 * 
 * @author PII
 * @version 1.0.0
 */
public class ChampVANamingException extends ChampVAException {

    private static final long serialVersionUID = 8690116083424418041L;

    /**
     * Constructor for the ChampVANamingException
     * 
     * @param ne
     *            - a NamingException to be handled.
     */
    public ChampVANamingException(NamingException ne) {
	super(ne);
	this.setErrorCode(NAMING_EXCEPTION);
    }

}
