/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * ChampVAJsonException is the wrapper Exception used to handle
 * JsonProcessingExceptions propagated by Jackson within the CHAMPVA Pay
 * Service.
 * 
 * @author PII
 * @version 1.0.0
 */
public class ChampVAJsonException extends ChampVAException {

    private static final long serialVersionUID = -2188553694919344941L;

    /**
     * Constructor for the ChampVAJsonException.
     * 
     * @param jpe
     *            - a JsonProcessingException to be handled
     */
    public ChampVAJsonException(JsonProcessingException jpe) {
	super(jpe);
	this.setErrorCode(JSON_PROCESSING_EXCEPTION);
    }

}
