/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

import gov.va.med.exception.FoundationsException;

/**
 * ChampVAFoundationsException is the wrapper Exception used to handle
 * FoundationsExceptions propagated by VistaLink within the CHAMPVA Pay Service.
 * 
 * @author PII
 * @version 1.0.0
 */
public class ChampVAFoundationsException extends ChampVAException {

    private static final long serialVersionUID = 2364946861969856040L;

    /**
     * Constructor for the ChampVAFoundationsException.
     * 
     * @param fe
     *            - a FoundationsException to be handled
     */
    public ChampVAFoundationsException(FoundationsException fe) {
	super(fe);
	this.setErrorCode(FOUNDATIONS_EXCEPTION);
    }

}
